//------------------------------------------------------------
// Произвольные данные с привязкой ко времени
//------------------------------------------------------------
#ifndef RdsTimedObjectsH
#define RdsTimedObjectsH
#include <string.h> // Для NULL, memcpy и memmove

// Объект общего вида - предок
class rdsTGeneralTimedObject
{ public:
    double Time; // Время

    rdsTGeneralTimedObject(void)
      { };
    virtual ~rdsTGeneralTimedObject()
      { };
};
//---------------------------------------------------------------------------

// Массив
class rdsTGeneralTimedObjectsArray
{ protected:
    rdsTGeneralTimedObject **Items; // Массив указателей на элементы
    unsigned int Size;              // Отведенный размер
    unsigned int Step;              // Шаг увеличения размера
    unsigned int _Count;            // Число элементов

    // Элемент
    inline rdsTGeneralTimedObject *RawItemFAST(unsigned int i) const
      { return Items[i]; };
    inline rdsTGeneralTimedObject *RawItem(unsigned int i) const
      { return (i<_Count)?(Items[i]):NULL; };

    // Увеличить до заданного размера, не изменяя _Count
    void Grow(unsigned int size);
  public:
    // Макрос для генерации type Item(i) и ItemFAST(i)
    #define RDSTIMEDOBJECTARRAY_ITEM(type) \
        inline type *ItemFAST(unsigned int i) const { return reinterpret_cast<type*>(RawItemFAST(i)); }; \
        inline type *Item(unsigned int i) const  { return reinterpret_cast<type*>(RawItem(i)); };
    // Макрос для генерации type *Add(void)
    #define RDSTIMEDOBJECTARRAY_ADD(type) \
        inline type *Add(void) { type *i=new type(); AddDynamicallyCreated(i); return i; }; \
        inline type *Add(unsigned int &index) { type *i=new type(); index=AddDynamicallyCreated(i); return i; };

    // Число элементов
    inline unsigned int Count(void) const
      { return _Count; };

    // Установить шаг переотведения
    inline void SetStep(unsigned int step)
      { Step=(step>0)?step:1; };

    // Очистить, оставив массив (сбросив _Count)
    void ClearItems(void);
    // Очистить полностью
    void ClearAll(void);

    // Добавить динамически созданный элемент (вступает во владение)
    // Возвращает индекс добавленного
    unsigned int AddDynamicallyCreated(rdsTGeneralTimedObject *item);

    // Переставить элементы
    inline void ExchangeFast(unsigned int i,unsigned int j)
      { rdsTGeneralTimedObject *aux=Items[i]; Items[i]=Items[j]; Items[j]=aux;};
    inline void ExchangeCheckFast(unsigned int i,unsigned int j)
      { if(i!=j) ExchangeFast(i,j); };
    inline void Exchange(unsigned int i,unsigned int j)
      { if(i<_Count && j<_Count && i!=j)
          ExchangeFast(i,j);
      };

     // Сортировать по возрастанию времени
    void SortAsc(void);
    // Сортировать по убыванию времени
    void SortDesc(void);
    
    // Удалить элемент
    void Delete(unsigned int i);
    // Удалить все элементы до заданного индекса (не включая его)
    void DeleteBefore(unsigned int i);

    // Конструктор
    rdsTGeneralTimedObjectsArray(void){Items=NULL; Size=_Count=0; Step=10; };
    // Деструктор
    virtual ~rdsTGeneralTimedObjectsArray(){ ClearAll(); }
};
//---------------------------------------------------------------------------


#endif // ifndef RdsTimedObjectsH