//------------------------------------------------------------
// Произвольные данные с привязкой ко времени
//------------------------------------------------------------
#ifndef RdsTimedObjectsH
  #include <RdsMisc/RdsTimedObjects.h>
#endif


// Очистить, оставив массив (сбросив _Count)
void rdsTGeneralTimedObjectsArray::ClearItems(void)
{
  if(Items)
    { for(int i=0;i<_Count;i++)
        delete Items[i];
    }
  _Count=0;
}
//---------------------------------------------------------------------------

// Очистить полностью
void rdsTGeneralTimedObjectsArray::ClearAll(void)
{
  ClearItems();
  if(Items)
    { delete[] Items;
      Items=NULL;
    }
  Size=0;
}
//---------------------------------------------------------------------------

// Увеличить до заданного размера, не изменяя Count
void rdsTGeneralTimedObjectsArray::Grow(unsigned int size)
{
  if(size>=Size)
    { rdsTGeneralTimedObject **newitems=new rdsTGeneralTimedObject*[size];
      if(Items)
        { if(_Count) memcpy(newitems,Items,_Count*sizeof(rdsTGeneralTimedObject*));
          delete[] Items;
        }
      Items=newitems;
      Size=size;
    }
}
//---------------------------------------------------------------------------

// Добавить динамически созданный элемент (вступает во владение)
// Возвращает индекс добавленного
unsigned int rdsTGeneralTimedObjectsArray::AddDynamicallyCreated(rdsTGeneralTimedObject *item)
{ unsigned int ret=_Count;
  if(item)
    { if(_Count>=Size) // Нет места
        Grow(Size+Step);
      Items[_Count]=item;
      _Count++;
    }
  return ret;
}
//---------------------------------------------------------------------------

// Сортировать по возрастанию времени
void rdsTGeneralTimedObjectsArray::SortAsc(void)
{
  if(_Count<2)
    return;
  for(unsigned int i=0;i<_Count-1;i++)
    { unsigned int optind=i;
      double optTime=Items[optind]->Time;
      for(unsigned int j=i+1;j<_Count;j++)
        { // Сравниваем optind и j
          double curTime=Items[j]->Time;
          if(curTime<optTime)
            { optind=j;
              optTime=curTime;
            }
        }
      ExchangeCheckFast(optind,i);
    }
}
//---------------------------------------------------------------------------

// Сортировать по убыванию времени
void rdsTGeneralTimedObjectsArray::SortDesc(void)
{
  if(_Count<2)
    return;
  for(unsigned int i=0;i<_Count-1;i++)
    { unsigned int optind=i;
      double optTime=Items[optind]->Time;
      for(unsigned int j=i+1;j<_Count;j++)
        { // Сравниваем optind и j
          double curTime=Items[j]->Time;
          if(curTime>optTime)
            { optind=j;
              optTime=curTime;
            }
        }
      ExchangeCheckFast(optind,i);
    }
}
//---------------------------------------------------------------------------

// Удалить элемент
void rdsTGeneralTimedObjectsArray::Delete(unsigned int i)
{
  if(Items==NULL || i>=_Count)
    return;
  delete Items[i];
  if(i==_Count-1) // Последний элемент
    { _Count--;
      return;
    }
  memmove(Items+i,Items+i+1,(_Count-i-1)*sizeof(rdsTGeneralTimedObject*));
  _Count--;
}
//---------------------------------------------------------------------------

// Удалить все элементы до заданного индекса (не включая его)
void rdsTGeneralTimedObjectsArray::DeleteBefore(unsigned int i)
{
  if(Items==NULL || i==0)
    return;
  if(i>=_Count) // Все
    { ClearItems();
      return;
    }
  // Элемент i остается, все предыдущие удаляются
  for(int j=0;j<i;j++)
    delete Items[j];
  memmove(Items,Items+i,(_Count-i)*sizeof(rdsTGeneralTimedObject*));
  _Count-=i;
}
//---------------------------------------------------------------------------

