//------------------------------------------------------------
// Различные дополнительные функции
//------------------------------------------------------------
#ifndef RdsMiscH
  #include <RdsMisc/RdsMisc.h>
#endif

// Проверить наличие связи у входа блока с номером num
BOOL CheckBlockInputConnection(RDS_BHANDLE Block,int num)
{ RDS_CHANDLE c;                // Идентификатор связи
  RDS_POINTDESCRIPTION PtDescr; // Структура описания точки связи
  RDS_CONNDESCRIPTION CDescr;   // структура описания самой связи

  // Заполнение служебных полей структур их размерами
  PtDescr.servSize=sizeof(PtDescr);
  CDescr.servSize=sizeof(CDescr);

  // Перебор всех связей, подключенных к этому блоку
  c=NULL;
  for(;;)
    { // Найти связь, следующую за c, и заполнить структуру
      // описания точки соединения PtDescr
      c=rdsGetBlockLink(Block,c,TRUE,FALSE,&PtDescr);
      if(c==NULL) // Больше нет связей
        break;
      // Найдена очередная связь
      if(PtDescr.VarNum==num) // К нужной переменной
        { rdsGetConnDescription(c,&CDescr);
          if(CDescr.Active) // Не отключена пользователем
            return TRUE;
        }
    }
  return FALSE;
}
//------------------------------------------------------------
