//---------------------------------------------------------------------------
// Классы для логических типов в полуавтокомпилируемых блоках
//---------------------------------------------------------------------------
#ifndef L57Mk2LogicH
#define L57Mk2LogicH

// Для включения класса обычных логических нужно определить константу L57CLASSINC_BOOLEAN
// Для включения класса логических с тремя состояниями нужно определить константу L57CLASSINC_TRILOGIC

#ifdef L57CLASSINC_BOOLEAN
  //---------------------------------------------------------------------------
  // Класс-оболочка для логических значений
  //---------------------------------------------------------------------------
  #ifdef L57CLASSINC_TRILOGIC
    class L57_TriLogic;
  #endif
  class L57_Boolean
  { protected:
      int Value;
    public:
      int AsInt(void) const {return Value;};
      double AsDouble(void) const {return (double)Value;};
      operator int() const {return Value;};
      void SetAsDouble(double d);

      L57_Boolean &operator=(const L57_Boolean &v){Value=v.AsInt();return *this;};
      L57_Boolean &operator=(int i){Value=i;return *this;};
      L57_Boolean &operator=(double d){SetAsDouble(d);return *this;};

      L57_Boolean(void){Value=0;};
      L57_Boolean(int i){Value=i;};
      L57_Boolean(const L57_Boolean &val){Value=val.AsInt();};
      #ifdef L57CLASSINC_TRILOGIC
        L57_Boolean(const L57_TriLogic &val);
      #endif
  };
  double l57_AsDouble(const L57_Boolean &v){return v.AsDouble();};
  //---------------------------------------------------------------------------
#endif // #ifdef L57CLASSINC_BOOLEAN

#ifdef L57CLASSINC_TRILOGIC
  //---------------------------------------------------------------------------
  // Класс-оболочка для логических значений с тремя состояниями
  //---------------------------------------------------------------------------
  enum L57_TriLogicValues { l57Unknown, l57False, l57True };
  class L57_TriLogic
  { protected:
      L57_TriLogicValues Value;

      L57_TriLogic AndWith(const L57_TriLogic &v)const;
      L57_TriLogic OrWith(const L57_TriLogic &v)const;
      L57_TriLogic Not(void)const;

      void SetAsInt(int i); // int считается обычным логическим
      void SetAsDouble(double d); // doublе считается "тройным" логическим
    public:
      L57_TriLogicValues GetValue(void) const {return Value;};
      int AsInt(void)const;
      double AsDouble(void)const{return (double)AsInt();};

      operator double() const {return (double)AsInt();};


      L57_TriLogic &operator=(const L57_TriLogic &v){Value=v.GetValue();return *this;};
      L57_TriLogic &operator=(double d){SetAsDouble(d);return *this;};
      L57_TriLogic &operator=(L57_TriLogicValues i){Value=i;return *this;};

      // Классические операторы && и || нельзя использовать из-за того, что второй операнд не всегда вычисляется

      // Операция И (a&b, a*b)
      L57_TriLogic operator*(const L57_TriLogic &v)const{return AndWith(v);};
      L57_TriLogic operator*(L57_TriLogicValues v)const{return AndWith(L57_TriLogic(v));};
      L57_TriLogic operator*(double v)const{return AndWith(L57_TriLogic(v));};
      #ifdef L57CLASSINC_BOOLEAN
        L57_TriLogic operator*(const L57_Boolean &v)const{return AndWith(L57_TriLogic(v));};
      #endif

      L57_TriLogic operator&(const L57_TriLogic &v)const{return AndWith(v);};
      L57_TriLogic operator&(L57_TriLogicValues v)const{return AndWith(L57_TriLogic(v));};
      L57_TriLogic operator&(double v)const{return AndWith(L57_TriLogic(v));};
      #ifdef L57CLASSINC_BOOLEAN
        L57_TriLogic operator&(const L57_Boolean &v)const{return AndWith(L57_TriLogic(v));};
      #endif

      // Операция ИЛИ (a|b, a+b)
      L57_TriLogic operator+(const L57_TriLogic &v)const{return OrWith(v);};
      L57_TriLogic operator+(L57_TriLogicValues v)const{return OrWith(L57_TriLogic(v));};
      L57_TriLogic operator+(double v)const{return OrWith(L57_TriLogic(v));};
      #ifdef L57CLASSINC_BOOLEAN
        L57_TriLogic operator+(const L57_Boolean &v)const{return OrWith(L57_TriLogic(v));};
      #endif

      L57_TriLogic operator|(const L57_TriLogic &v)const{return OrWith(v);};
      L57_TriLogic operator|(L57_TriLogicValues v)const{return OrWith(L57_TriLogic(v));};
      L57_TriLogic operator|(double v)const{return OrWith(L57_TriLogic(v));};
      #ifdef L57CLASSINC_BOOLEAN
        L57_TriLogic operator|(const L57_Boolean &v)const{return OrWith(L57_TriLogic(v));};
      #endif

      // Операция НЕ (!a, ~a)
      L57_TriLogic operator!()const{return Not();};
      L57_TriLogic operator~()const{return Not();};

      // Операции сравнения
      int IsTrue(void){return Value==l57True;};
      int IsFalse(void){return Value==l57False;};
      int IsUnknown(void){return Value==l57Unknown;};

      L57_TriLogic(void){Value=l57Unknown;};
      L57_TriLogic(double d){SetAsDouble(d);};
      L57_TriLogic(L57_TriLogicValues i){Value=i;};
      L57_TriLogic(const L57_TriLogic &val){Value=val.GetValue();};
      #ifdef L57CLASSINC_BOOLEAN
        L57_TriLogic(const L57_Boolean &val){SetAsInt(val.AsInt());};
      #endif
  };
  double l57_AsDouble(const L57_TriLogic &v){return v.AsDouble();};
  #define L57_TRILOGIC_GENOP(type) L57_TriLogic operator&(type v,const L57_TriLogic &val){return val.operator&(v);}; \
                                   L57_TriLogic operator*(type v,const L57_TriLogic &val){return val.operator*(v);}; \
                                   L57_TriLogic operator+(type v,const L57_TriLogic &val){return val.operator+(v);}; \
                                   L57_TriLogic operator|(type v,const L57_TriLogic &val){return val.operator|(v);};
  L57_TRILOGIC_GENOP(double)
  #ifdef L57CLASSINC_BOOLEAN
    L57_TRILOGIC_GENOP(L57_Boolean)
  #endif
  #undef L57_TRILOGIC_GENOP
  //---------------------------------------------------------------------------
#endif // #ifdef L57CLASSINC_TRILOGIC

#endif // #ifndef L57Mk2LogicH
