//---------------------------------------------------------------------------
// Классы для логических типов в полуавтокомпилируемых блоках
//---------------------------------------------------------------------------
#ifndef L57Mk2LogicH
  #include <RdsL57Mk2/L57Mk2Logic.h>
#endif

//---------------------------------------------------------------------------
// Класс-оболочка для логических значений
//---------------------------------------------------------------------------
#ifdef L57CLASSINC_BOOLEAN
void L57_Boolean::SetAsDouble(double d)
{
  if(L57_IsError(d))
    Value=0;
  else
    Value=(d>0.5);
}
//---------------------------------------------------------------------------

  #ifdef L57CLASSINC_TRILOGIC
  L57_Boolean::L57_Boolean(const L57_TriLogic &val)
  {
    Value=(val.AsInt()==0)?0:1;
  }
  //---------------------------------------------------------------------------
  #endif //#ifdef L57CLASSINC_TRILOGIC

#endif // #ifdef L57CLASSINC_BOOLEAN






//---------------------------------------------------------------------------
// Класс-оболочка для логических значений с тремя состояниями
//---------------------------------------------------------------------------
#ifdef L57CLASSINC_TRILOGIC
int L57_TriLogic::AsInt(void)const
{
  switch(Value)
    { case l57False: return 0;
      case l57True:  return 1;
	  default: ; // Из-за бессмысленного предупреждения "enumeration value 'l57Unknown' not handled..."
    }
  return -1;
}
//---------------------------------------------------------------------------
void L57_TriLogic::SetAsInt(int i)
{
  switch(i)
    { case 0:  Value=l57False; break;
      case 1:  Value=l57True; break;
      default: Value=l57Unknown;
    }
}
//---------------------------------------------------------------------------
void L57_TriLogic::SetAsDouble(double d)
{
  if(d<-0.1)
    Value=l57Unknown;
  else if(d<0.1)
    Value=l57False;
  else
    Value=l57True;
}
//---------------------------------------------------------------------------
L57_TriLogic L57_TriLogic::AndWith(const L57_TriLogic &v)const
{
  if(Value==l57False || v.GetValue()==l57False)
    return L57_TriLogic(l57False);
  if(Value==l57Unknown || v.GetValue()==l57Unknown)
    return L57_TriLogic(l57Unknown);
  return L57_TriLogic(l57True);
}
//---------------------------------------------------------------------------
L57_TriLogic L57_TriLogic::OrWith(const L57_TriLogic &v)const
{
  if(Value==l57True || v.GetValue()==l57True)
    return L57_TriLogic(l57True);
  if(Value==l57Unknown || v.GetValue()==l57Unknown)
    return L57_TriLogic(l57Unknown);
  return L57_TriLogic(l57False);
}
//---------------------------------------------------------------------------
L57_TriLogic L57_TriLogic::Not(void)const
{ switch(Value)
    { case l57False: return L57_TriLogic(l57True);
      case l57True:  return L57_TriLogic(l57False);
	  default: ; // Из-за бессмысленного предупреждения "enumeration value 'l57Unknown' not handled..."
    }
  return L57_TriLogic(l57Unknown);
}
//---------------------------------------------------------------------------
#endif // #ifdef L57CLASSINC_TRILOGIC
