//---------------------------------------------------------------------------
// Детали встраиваемых функций для поддержки полуавтокомпилируемых блоков
// Версия 2
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Вычисление max / arg max
//---------------------------------------------------------------------------
#ifdef L57_ARGMAX_CALL
double l57_m_maxval=rdsbcppHugeDouble;
#ifndef L57_M_NOMAXARG
  double l57_m_maxarg=rdsbcppHugeDouble;
#endif
double l57_min,l57_max,l57_step;
// Вычисление числа точек с начальным шагом
int l57_count=L57_AdjustDiapAndStep(l57_min,l57_max,l57_step,
                                    L57_M_MIN,L57_M_MAX,L57_M_STEP);
int l57_final=l57_count-1;
double l57_v_prev,l57_v,l57_v_next;
double /*l57_a_prev,*/l57_a,l57_a_next;

#if defined(L57_M_ENDSTEP) || defined(L57_M_DELTA)
  double l57_cstep;
#endif

#ifdef L57_M_ENDSTEP
  BOOL l57_endstepok=(L57_M_ENDSTEP!=rdsbcppHugeDouble && L57_M_ENDSTEP>0.0);
#else
  BOOL l57_endstepok=FALSE;
#endif

#ifdef L57_M_DELTA
  int l57_cycles_in_df;
  double l57_oldmaxval;
#endif

// Первая точка
l57_a=l57_v=rdsbcppHugeDouble;
l57_a_next=L57_ValueInDiap(l57_min,l57_max,l57_step,0,l57_count);
l57_v_next=L57_ARGMAX_CALL(l57_a_next);

// Главный цикл перебора (с начальным шагом)
for(int l57_index=0;l57_index<l57_count;l57_index++)
  { BOOL l57_pointready;
    double l57_carg,l57_cval;
    // Предыдущая, текущая и следующая точки
    /*l57_a_prev=l57_a;*/ l57_v_prev=l57_v;
    l57_a=l57_a_next; l57_v=l57_v_next;
    if(l57_index==l57_final) // Правее точек нет
      l57_a_next=l57_v_next=rdsbcppHugeDouble;
    else
      { l57_a_next=L57_ValueInDiap(l57_min,l57_max,l57_step,l57_index+1,l57_count);
        l57_v_next=L57_ARGMAX_CALL(l57_a_next);
      }
    if(l57_v==rdsbcppHugeDouble) // Текущая точка не существует
      l57_pointready=FALSE;
    else
      l57_pointready=(l57_v_prev==rdsbcppHugeDouble || l57_v_prev<=l57_v) &&
                     (l57_v_next==rdsbcppHugeDouble || l57_v_next<=l57_v);
    if(!l57_pointready)
      continue;
    // Оба соседа текущей точки меньше ее
    l57_carg=l57_a; l57_cval=l57_v;
    #if defined(L57_M_ENDSTEP) || defined(L57_M_DELTA)
      // Уточнение
      l57_cstep=l57_step;
      #ifdef L57_M_DELTA
        l57_cycles_in_df=0;
      #endif
      for(int l57_totalitercount=0;l57_totalitercount<L57_M_MAXITER;l57_totalitercount++)
        { double l57_leftarg,l57_rightarg;
          BOOL l57_cand_ready=TRUE;
          // Проверяем условие конца уточнения
          #ifdef L57_M_ENDSTEP
            if(l57_endstepok && l57_cstep>L57_M_ENDSTEP)
              l57_cand_ready=FALSE;
          #endif
          #ifdef L57_M_DELTA
            if(l57_cycles_in_df<L57_M_ITERATIONS)
              { l57_cand_ready=FALSE;
                l57_oldmaxval=l57_cval;
              }
          #endif
          if(l57_cand_ready) // Условие окончания уточнения достигнуто
            break;
          // Уменьшаем шаг в два раза
          l57_cstep/=2;
          l57_leftarg=l57_carg-l57_cstep;
          l57_rightarg=l57_carg+l57_cstep;
          // Левая точка
          if(l57_leftarg>l57_min)
            { double l57_newval=L57_ARGMAX_CALL(l57_leftarg);
              if(l57_newval!=rdsbcppHugeDouble && l57_newval>l57_cval)
                { l57_cval=l57_newval; l57_carg=l57_leftarg; }
            }
          // Правая точка
          if(l57_rightarg<l57_max)
            { double l57_newval=L57_ARGMAX_CALL(l57_rightarg);
              if(l57_newval!=rdsbcppHugeDouble && l57_newval>l57_cval)
                { l57_cval=l57_newval; l57_carg=l57_rightarg; }
            }
          #ifdef L57_M_DELTA
            if(fabs(l57_cval-l57_oldmaxval)<L57_M_DELTA) // В трубке
              l57_cycles_in_df++;
            else // Вне трубки
              l57_cycles_in_df=0;
          #endif
        }
    #endif // #if defined(L57_M_ENDSTEP) || defined(L57_M_DELTA)
    // Уточненный (возможно) локальный максимум - в l57_carg,l57_cval
    if(l57_m_maxval==rdsbcppHugeDouble || l57_m_maxval<l57_cval)
      { l57_m_maxval=l57_cval;
		#ifndef L57_M_NOMAXARG
		  l57_m_maxarg=l57_carg;
		#endif
      }
  }

#endif // #ifdef L57_ARGMAX_CALL
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Вычисление производной
//---------------------------------------------------------------------------
#ifdef L57_DERIVATIVE_CALL
double l57_result=rdsbcppHugeDouble;
double left,right,halfstep;
#ifdef L57_M_MAXITER
  int l57_totalitercount=0;
#endif
#ifdef L57_M_DELTA
  int l57_cycles_in_df=0;
  double l57_oldval=rdsbcppHugeDouble;
#endif


// L57_M_STEP - шаг
// L57_M_DELTA - погрешность функции
// L57_M_ITERATIONS - число итераций в трубке погрешности
// L57_M_MAXITER - максимально допустимое число итераций
// L57_M_LIMIT - ограничение производной (если есть)
// L57_DERIVATIVE_CALL(delta) - вызов для вычисления функции, смещенной на delta по аргументу производной

// L57_M_STEP определено в любом случае
// L57_M_DELTA и L57_M_ITERATIONS будут определены если включено уточнение до погрешности
// L57_M_MAXITER будет определено, если включена проверка на максимальное число итераций
// L57_M_LIMIT будет определено, если включено ограничение производной

double l57_cstep=L57_M_STEP;

// Защита от плохого шага
if(l57_cstep==rdsbcppHugeDouble || l57_cstep<0.0)
  l57_cstep=0.0001;


#ifdef L57_M_DELTA
  //---------------- Есть уточнение ----------------

  for(;;)
    { // Вычисляем производную с шагом l57_cstep
      halfstep=l57_cstep/2.0;
      BOOL l57_point_ready=TRUE;

      left=L57_DERIVATIVE_CALL(-halfstep);
      if(left==rdsbcppHugeDouble)
        break;
      right=L57_DERIVATIVE_CALL(halfstep);
      if(right==rdsbcppHugeDouble)
        break;
      RDSBCPP_TRY
        { l57_result=(right-left)/l57_cstep; }
      RDSBCPP_CATCHALL
        {
          #ifdef L57_M_LIMIT
            l57_result=(right>left)?L57_M_LIMIT:(-L57_M_LIMIT);
          #else
            l57_result=rdsbcppHugeDouble;
          #endif
        }
      if(l57_result==rdsbcppHugeDouble)
        break;
      // Есть производная с шагом l57_cstep

      #ifdef L57_M_LIMIT
        if(fabs(l57_result)>L57_M_LIMIT)
          l57_result=(right>left)?L57_M_LIMIT:(-L57_M_LIMIT);
      #endif

      // Проверяем условие конца уточнения
      if(l57_oldval==rdsbcppHugeDouble) // Первый запуск
        l57_cycles_in_df=0;
      else if(fabs(l57_oldval-l57_result)<L57_M_DELTA) // В трубке
        l57_cycles_in_df++;
      else // Вне трубки
        l57_cycles_in_df=0;
      if(l57_cycles_in_df<L57_M_ITERATIONS)
        l57_point_ready=FALSE;

      if(l57_point_ready) // Условие окончания уточнения достигнуто
        break;

      // Условие не достигнуто
      l57_oldval=l57_result;
      #ifdef L57_M_MAXITER
        l57_totalitercount++;
        if(l57_totalitercount>L57_M_MAXITER) // Превысили допустимое число итераций
          break;
      #endif
      // Уменьшаем шаг в два раза
      l57_cstep=halfstep;
    } // for(;;)

#else // #ifdef L57_M_DELTA
  //--------- Нет уточнения - просто считаем -------

  halfstep=l57_cstep/2.0;
  left=L57_DERIVATIVE_CALL(-halfstep);
  right=L57_DERIVATIVE_CALL(halfstep);
  if(left!=rdsbcppHugeDouble && right!=rdsbcppHugeDouble)
    {
      RDSBCPP_TRY
        { l57_result=(right-left)/l57_cstep; }
      RDSBCPP_CATCHALL
        {
          #ifdef L57_M_LIMIT
            l57_result=(right>left)?L57_M_LIMIT:(-L57_M_LIMIT);
          #else
            l57_result=rdsbcppHugeDouble;
          #endif
        }
      #ifdef L57_M_LIMIT
        if(fabs(l57_result)>L57_M_LIMIT)
          l57_result=(right>left)?L57_M_LIMIT:(-L57_M_LIMIT);
      #endif
    }

#endif // #else #ifdef L57_M_DELTA


#endif // #ifdef L57_DERIVATIVE_CALL
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Вычисление интеграла
//---------------------------------------------------------------------------
#ifdef L57_INTEGRAL_CALL
double l57_result=rdsbcppHugeDouble;
double l57_min=L57_M_MIN,l57_max=L57_M_MAX,l57_step=L57_M_STEP;

// L57_M_MIN,L57_M_MAX - пределы интегрирования
// L57_M_STEP - шаг
// L57_INTEGRAL_CALL(x) - вызов для вычисления функции

if(l57_min!=rdsbcppHugeDouble && l57_max!=rdsbcppHugeDouble)
  { BOOL inverse=FALSE;
    double l57_diap,l57_arg,l57_v;
    int l57_count,l57_index;
    if(l57_max<l57_min)
      { l57_min=L57_M_MAX; l57_max=L57_M_MIN; inverse=TRUE; }
    l57_diap=l57_max-l57_min;
    // По заданному шагу определяем число точек в диапазоне
    if(l57_step==rdsbcppHugeDouble || l57_step<=0.0 || l57_step>=l57_diap)
      l57_count=2;
    else
      {
        RDSBCPP_TRY
          { l57_count=(int)ceil(l57_diap/l57_step);  }
        RDSBCPP_CATCHALL
          { l57_count=-1; }
        if(l57_count<2)
          l57_count=2;
      }
    // Теперь по числу точек вычисляем полушаг, с которым будем идти
    l57_count*=2; // 2*M
    l57_step=l57_diap/l57_count;
    // Идем по сетке
    l57_arg=l57_min;
    l57_index=0;
    l57_result=L57_INTEGRAL_CALL(l57_arg); // I
    if(l57_result!=rdsbcppHugeDouble)
      for(;;)
        { l57_arg+=l57_step;
          l57_v=L57_INTEGRAL_CALL(l57_arg);
          if(l57_v==rdsbcppHugeDouble)
            { l57_result=rdsbcppHugeDouble;
              break;
            }
          l57_result+=4.0*l57_v;
          l57_index+=2;
          if(l57_index>=l57_count)
            break;
          l57_arg+=l57_step;
          l57_v=L57_INTEGRAL_CALL(l57_arg);
          if(l57_v==rdsbcppHugeDouble)
            { l57_result=rdsbcppHugeDouble;
              break;
            }
          l57_result+=2.0*l57_v;
        }
    if(l57_result!=rdsbcppHugeDouble)
      { l57_result=(l57_result+L57_INTEGRAL_CALL(l57_max))*l57_step/3.0;
        if(inverse)
          l57_result=-l57_result;
      }
  } // if(l57_min!=rdsbcppHugeDouble && l57_max!=rdsbcppHugeDouble)
#endif // #ifdef L57_INTEGRAL_CALL

