//---------------------------------------------------------------------------
// Стандартные части модели ограничения для внешнего максимизатора
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Глобальные описания
//---------------------------------------------------------------------------
#ifdef L57MS_GLOBALS
#include <RdsL57/L57TextBasic.cpp>

//---------------------------------------------------------------------------
// Вспомогательный класс загрузки языка интерфейса одной группы
//---------------------------------------------------------------------------
class L57_HelperLanguageSimple
{ protected:
    RDS_HOBJECT Object;
    BOOL Loaded;
    char *binaryfilepath;
  public:
    inline BOOL IsLoaded(void){return Loaded;};
    inline BOOL HasFile(void){return binaryfilepath!=NULL;};
    inline BOOL HasNoFile(void){return binaryfilepath==NULL;};
    inline void Clear(void){rdsCommandObject(Object,RDS_UIMOD_CLEAR);Loaded=FALSE;};
    // Установить тип обработки строк (перед загрузкой данных)
    inline void SetCRLFCorrection(int c)
      { rdsSetObjectInt(Object,RDS_UIMOD_SETCRLFCORR,0,c);};
    // Загрузить группу из файла
    inline void LoadGroup(const char *groupname)
      { Clear(); Loaded=rdsUIMODLoadGroupA(Object,binaryfilepath,groupname);};
    // Загрузить только один объект из файла
    inline void LoadObject(const char *groupname,const char *objectname)
      { Clear(); Loaded=rdsUIMODLoadSingleObjectA(Object,binaryfilepath,groupname,objectname);};
    // Запомнить объект для дальнейшего обращения без имени
    inline void SetObject(const char *objname)
      { rdsSetObjectStrA(Object,RDS_UIMOD_SETOBJNAME,0,objname);};
    // Получить строку последнего объекта по идентификатору
    const char *GetString(int paramid,const char *defvalue)
     { const char *s=rdsUIMODGetParamStringA(Object,NULL,paramid,defvalue);  return s?s:defvalue; };
    // Получить строку заданного объекта по идентификатору
    inline const char *GetString(const char *objname,int paramid,const char *defvalue)
      { SetObject(objname); return GetString(paramid,defvalue); };
    const char *GetListString(int paramid,const char *defvalue)
     { const char *s=rdsUIMODGetParamListString(Object,NULL,paramid,defvalue);  return s?s:defvalue; };
    inline const char *GetListString(const char *objname,int paramid,const char *defvalue)
      { SetObject(objname); return GetListString(paramid,defvalue); };

    // Сообщение с переводом
    static int MessageBox(const char *Msg,const char *Capt,int Flags,const char *Object,const char *Category=NULL)
      { L57_HelperLanguageSimple data;
        if(Object==NULL || data.HasNoFile())
          return rdsMessageBoxA(Msg,Capt,Flags);
        data.SetCRLFCorrection(RDS_UIMOD_CRLF_LF);
        data.LoadObject(Category?Category:"Messages",Object);
        return rdsMessageBoxA(data.GetString(RDS_UIMOD_ANYPARAMID,Msg),Capt,Flags);
      };


    // Конструктор
    L57_HelperLanguageSimple(void)
      { const char *curlang=rdsGetUICurrentModA(RDS_UIMODC_LANGUAGE,NULL);
        if( (*curlang)!=0 ) // Язык не по умолчанию
          { /*binaryfilepath=rdsDynStrCatA("$RDS$\\" RDS_UIMODD_MODS "\\" RDS_UIMODC_LANGUAGE "\\",
                                        curlang,FALSE);
            rdsAddToDynStrA(&binaryfilepath,"\\Dll\\L57.bin",TRUE);
			*/
			binaryfilepath=rdsDynStrCopyA("$CURLANG$\\Dll\\L57.bin");
          }
        else
          binaryfilepath=NULL;

        Object=rdsUIMODCreate(); Loaded=FALSE;
      };
    // Деструктор
    ~L57_HelperLanguageSimple()
      { rdsDeleteObject(Object);
        rdsFree(binaryfilepath);
      };
};
// Идентификаторы стандартных параметров объектов
#define L57_LANG_CAPTION        1
#define L57_LANG_TEXT           2
#define L57_LANG_HINT           3
#define L57_LANG_FILTER         4
#define L57_LANG_TITLE          5
#define L57_LANG_STRING         6
#define L57_LANG_LIST           7
//---------------------------------------------------------------------------


#define L57_HELPUIFILE "$DOCLANG$\\Blocks\\L57.ui"
#define L57_HELPTOPIC  "L57_EcoMaxLim"

#ifdef RDS_BFM_SHOWEXAMPLE
  #define L57_EXAMPLEUIFILE "$SAMPLESLANG$\\L57\\L57.ui"
  #define L57_EXAMPLETOPIC  "L57_EcoMaxLim"
#endif

// Признак наличия файла справки
int L57_HelpState=0;
// Признак наличия файла примера
int L57_ExampleState=0;

class TL57TextFileEML : public TL57TextFileBasic
{ public:
    TL57TextString InputCode,OutputCode;

    // Разобрать скрытую секцию
    void ParseHiddenSection(TL57TextFileLine *line);
    // Записать скрытую секцию
    BOOL WriteHiddenSection(void);
    // Записать какую-то секцию и вернуть маркер ее конца
    BOOL WriteSection(int id,int *pendid);

    TL57TextFileEML(void):TL57TextFileBasic(){};
    virtual ~TL57TextFileEML(){};
};
//---------------------------------------------------------------------------

// Разобрать скрытую секцию
void TL57TextFileEML::ParseHiddenSection(TL57TextFileLine *line)
{ char *aux;

  InputCode.Clear();
  OutputCode.Clear();

  // Читаем функции
  for(TL57TextFileLine *l=line;l!=NULL;l=l->Next)
    { char *s=l->Line;
      if(!s)
        continue;
      if((*s)=='$') // Конец данных (начало следующей секции)
        break;
      switch(*s)
        { case '1': // Ограничения по входу
            aux=rdsProcessTextA(s+1,RDS_PT_STRINGTOTEXT,NULL);
            if(aux)
              { if(InputCode.IsNotEmpty())
                  InputCode.AddString("\n");
                InputCode.AddString(aux);
                rdsFree(aux);
              }
            break;
          case '2': // Ограничения по выходу
            aux=rdsProcessTextA(s+1,RDS_PT_STRINGTOTEXT,NULL);
            if(aux)
              { if(OutputCode.IsNotEmpty())
                  OutputCode.AddString("\n");
                OutputCode.AddString(aux);
                rdsFree(aux);
              }
            break;
        }

    }

}
//---------------------------------------------------------------------------

// Записать скрытую секцию
BOOL TL57TextFileEML::WriteHiddenSection(void)
{ TL57TextFileBasic splitter;
  BOOL ok=TRUE;
  char *aux;

  splitter.SplitText(InputCode.c_str());
  for(TL57TextFileLine *l=splitter.FirstLine;l!=NULL;l=l->Next)
    if(l->Line)
      { aux=rdsProcessText(l->Line,RDS_PT_TEXTTOSTRINGSL,NULL);
        if(aux)
          { ok=ok && WriteLine("1");
            ok=ok && WriteLine(aux,1);
            rdsFree(aux);
          }
      }

  splitter.SplitText(OutputCode.c_str());
  for(TL57TextFileLine *l=splitter.FirstLine;l!=NULL;l=l->Next)
    if(l->Line)
      { aux=rdsProcessText(l->Line,RDS_PT_TEXTTOSTRINGSL,NULL);
        if(aux)
          { ok=ok && WriteLine("2");
            ok=ok && WriteLine(aux,1);
            rdsFree(aux);
          }
      }

  return ok;
}
//---------------------------------------------------------------------------

// Записать какую-то секцию и вернуть маркер ее конца
BOOL TL57TextFileEML::WriteSection(int id,int *pendid)
{ TL57TextFileBasic splitter;
  BOOL ok=TRUE;

  switch(id)
    { case 1: // Начало функции ограничения по входам
        *pendid=2;
        splitter.SplitText(InputCode.c_str());
        for(TL57TextFileLine *l=splitter.FirstLine;l!=NULL;l=l->Next)
          if(l->Line)
            { ok=ok && WriteLine("  ");
              ok=ok && WriteLine(l->Line,1);
            }
        ok=ok && WriteLine("  ; /* */",1);
        break;

      case 3: // Начало функции ограничения по выходам
        *pendid=4;
        splitter.SplitText(OutputCode.c_str());
        for(TL57TextFileLine *l=splitter.FirstLine;l!=NULL;l=l->Next)
          if(l->Line)
            { ok=ok && WriteLine("  ");
              ok=ok && WriteLine(l->Line,1);
            }
        ok=ok && WriteLine("  ; /* */",1);
        break;
    }
  return ok;
}
//---------------------------------------------------------------------------

// Единый аргумент функции
class TL57TextEMLFuncArg
{ public:
    double _Crit;
    TL57TextDoubleArray X_Params;
    TL57TextDoubleArray A_Params;
    TL57TextFuncFArray Functions;

    TL57TextEMLFuncArg(void){_Crit=rdsbcppHugeDouble;};
};
//---------------------------------------------------------------------------

// Прототип функции вычисления входного ограничения - служебная (без перехвата исключений)
int _InFunc(const TL57TextEMLFuncArg &arguments);
// Прототип функции вычисления выходного ограничения - служебная (без перехвата исключений)
int _OutFunc(const TL57TextEMLFuncArg &arguments);
//-----------------------------------------------------------------------

// Функция вычисления входного ограничения с перехватом исключений
int InFunc(const TL57TextEMLFuncArg &arguments)
{ int ok=1;
  RDSBCPP_TRY
    { ok=_InFunc(arguments); }
  RDSBCPP_CATCHALL
    { ok=0; }
  return ok;
}
//-----------------------------------------------------------------------

// Функция вычисления выходного ограничения с перехватом исключений
int OutFunc(const TL57TextEMLFuncArg &arguments)
{ int ok=1;
  RDSBCPP_TRY
    { ok=_OutFunc(arguments); }
  RDSBCPP_CATCHALL
    { ok=0; }
  return ok;
}
//-----------------------------------------------------------------------

#endif // #ifdef L57MS_GLOBALS
//-----------------------------------------------------------------------



//---------------------------------------------------------------------------
// Настройки
//---------------------------------------------------------------------------
#ifdef L57MS_SETUP
TL57TextFileEML file;
RDS_HOBJECT win;
BOOL res;
L57_HelperLanguageSimple LangData;
LangData.LoadGroup("L57EcoMaxLim");

const char *caption=LangData.GetString("SetupWin",L57_LANG_CAPTION,
  "\xD0\x9E\xD0\xB3\xD1\x80\xD0\xB0\xD0\xBD\xD0\xB8\xD1\x87\xD0\xB5"
  "\xD0\xBD\xD0\xB8\xD1\x8F \xD0\xB4\xD0\xBB\xD1\x8F \xD0\xB2\xD0\xBD"
  "\xD0\xB5\xD1\x88\xD0\xBD\xD0\xB5\xD0\xB3\xD0\xBE \xD0\xBC\xD0\xB0"
  "\xD0\xBA\xD1\x81\xD0\xB8\xD0\xBC\xD0\xB8\xD0\xB7\xD0\xB0\xD1\x82"
  "\xD0\xBE\xD1\x80\xD0\xB0" /* "Ограничения для внешнего максимизатора" */);
const char *sourcecodelabel;
TL57TextFileBasic_ServMarker markers[]=
  {{"L57_ECOMAXLIM_INPUT_BEGIN_MARKER", 1,-1},
   {"L57_ECOMAXLIM_INPUT_END_MARKER",   2,-1},
   {"L57_ECOMAXLIM_OUTPUT_BEGIN_MARKER",3,-1},
   {"L57_ECOMAXLIM_OUTPUT_END_MARKER",  4,-1},
   {NULL,0,-1}
  };

RDS_PCOMPMODELDATA model=rdscompGetBlockModelData(rdsbcppBlockData->Block);

if(model==NULL)
  { rdsMessageBoxA(LangData.GetString("AutocompIsOffMsg",L57_LANG_TEXT,
                  "\xD0\x94\xD0\xBB\xD1\x8F \xD0\xB1\xD0\xBB\xD0\xBE\xD0\xBA\xD0\xB0 \xD0"
				  "\xBE\xD1\x82\xD0\xBA\xD0\xBB\xD1\x8E\xD1\x87\xD0\xB5\xD0\xBD\xD0\xB0 "
				  "\xD0\xB0\xD0\xB2\xD1\x82\xD0\xBE\xD0\xBC\xD0\xB0\xD1\x82\xD0\xB8\xD1"
				  "\x87\xD0\xB5\xD1\x81\xD0\xBA\xD0\xB0\xD1\x8F \xD0\xBA\xD0\xBE\xD0\xBC"
				  "\xD0\xBF\xD0\xB8\xD0\xBB\xD1\x8F\xD1\x86\xD0\xB8\xD1\x8F \xD0\xBC\xD0"
				  "\xBE\xD0\xB4\xD0\xB5\xD0\xBB\xD0\xB8. \xD0\x98\xD0\xB7\xD0\xBC\xD0\xB5"
				  "\xD0\xBD\xD0\xB5\xD0\xBD\xD0\xB8\xD0\xB5 \xD1\x84\xD1\x83\xD0\xBD\xD0"
				  "\xBA\xD1\x86\xD0\xB8\xD0\xB9 \xD0\xBE\xD0\xB3\xD1\x80\xD0\xB0\xD0\xBD"
				  "\xD0\xB8\xD1\x87\xD0\xB5\xD0\xBD\xD0\xB8\xD0\xB9 \xD0\xBF\xD1\x80\xD0\xB8 "
				  "\xD1\x8D\xD1\x82\xD0\xBE\xD0\xBC \xD0\xBD\xD0\xB5\xD0\xB2\xD0\xBE\xD0\xB7"
				  "\xD0\xBC\xD0\xBE\xD0\xB6\xD0\xBD\xD0\xBE." 
				  /* "Для блока отключена автоматическая компиляция модели. Изменение функций ограничений при этом невозможно." */
				  ),caption,MB_OK|MB_ICONWARNING);
    return;
  }

if(rdscompIsEditorOpen(model->Model))
    { L57_HelperLanguageSimple::MessageBox(
                    "\xD0\x94\xD0\xBB\xD1\x8F \xD0\xBD\xD0\xB0\xD1\x81\xD1\x82\xD1\x80\xD0"
					"\xBE\xD0\xB9\xD0\xBA\xD0\xB8 \xD1\x8D\xD1\x82\xD0\xBE\xD0\xB3\xD0\xBE "
					"\xD0\xB1\xD0\xBB\xD0\xBE\xD0\xBA\xD0\xB0 \xD0\xBD\xD0\xB5\xD0\xBE\xD0"
					"\xB1\xD1\x85\xD0\xBE\xD0\xB4\xD0\xB8\xD0\xBC\xD0\xBE \xD0\xB7\xD0\xB0"
					"\xD0\xBA\xD1\x80\xD1\x8B\xD1\x82\xD1\x8C \xD1\x80\xD0\xB5\xD0\xB4\xD0"
					"\xB0\xD0\xBA\xD1\x82\xD0\xBE\xD1\x80 \xD0\xB5\xD0\xB3\xD0\xBE \xD0\xBC"
					"\xD0\xBE\xD0\xB4\xD0\xB5\xD0\xBB\xD0\xB8. \xD0\x9F\xD0\xBE\xD0\xB6\xD0"
					"\xB0\xD0\xBB\xD1\x83\xD0\xB9\xD1\x81\xD1\x82\xD0\xB0, \xD0\xB7\xD0\xB0"
					"\xD0\xBA\xD1\x80\xD0\xBE\xD0\xB9\xD1\x82\xD0\xB5 \xD1\x80\xD0\xB5\xD0"
					"\xB4\xD0\xB0\xD0\xBA\xD1\x82\xD0\xBE\xD1\x80." 
					/* "Для настройки этого блока необходимо закрыть редактор его модели. Пожалуйста, закройте редактор." */,
					caption,MB_OK|MB_ICONWARNING,
                    "SemiAutoCloseEditorForSetup");
    rdscompOpenBlockModelEditor(rdsbcppBlockData->Block);
    return;
  }

win=rdsFORMCreateA(TRUE,600,-1,caption);
if(!win)
  return;

#ifdef L57_HELPUIFILE
  rdsFORMHelpButtonA(win,RDS_FORMHELP_UI|RDS_FORMHELP_CHECK,L57_HELPUIFILE,L57_HELPTOPIC);
#endif

// Чтение функций
file.ReadAndParseModel(rdsbcppBlockData->Block,markers,TRUE);

rdsFORMAddTab(win,1, LangData.GetString("Tab_InputLimits",L57_LANG_CAPTION,
  "\xD0\x9F\xD0\xBE \xD0\xB2\xD1\x85\xD0\xBE\xD0\xB4\xD1\x83" /* "По входу" */) );
rdsFORMAddEdit(win,1,1,RDS_FORMCTRL_MULTILINE,
  sourcecodelabel=LangData.GetString("E_LimitSourceCode",L57_LANG_CAPTION,
    "\xD0\x98\xD1\x81\xD1\x85\xD0\xBE\xD0\xB4\xD0\xBD\xD1\x8B\xD0\xB9 \xD1\x82"
	"\xD0\xB5\xD0\xBA\xD1\x81\xD1\x82 \xD1\x84\xD1\x83\xD0\xBD\xD0\xBA\xD1\x86"
	"\xD0\xB8\xD0\xB8 \xD0\xBE\xD0\xB3\xD1\x80\xD0\xB0\xD0\xBD\xD0\xB8\xD1\x87"
	"\xD0\xB5\xD0\xBD\xD0\xB8\xD1\x8F:" /* "Исходный текст функции ограничения:" */),
  80);
rdsSetObjectInt(win,1,RDS_FORMVAL_MLRETURNS,1);
rdsFORMSetMultilineHeight(win,1,4*24);
rdsSetObjectStr(win,1,RDS_FORMVAL_VALUE,file.InputCode.c_str());

rdsFORMAddEdit(win,1,100,RDS_FORMCTRL_MULTILABEL,
  LangData.GetString("L_InputLimitHelp",L57_LANG_CAPTION,
    "\xD0\x9D\xD0\xB5\xD0\xBE\xD0\xB1\xD1\x85\xD0\xBE\xD0\xB4\xD0\xB8\xD0\xBC\xD0\xBE "
	"\xD0\xB2\xD0\xB2\xD0\xB5\xD1\x81\xD1\x82\xD0\xB8 \xD0\xBE\xD0\xBF\xD0\xB5\xD1\x80"
	"\xD0\xB0\xD1\x82\xD0\xBE\xD1\x80(\xD1\x8B) \xD0\xBF\xD1\x80\xD0\xBE\xD0\xB2\xD0\xB5"
	"\xD1\x80\xD0\xBA\xD0\xB8 \xD0\xB4\xD0\xBE\xD0\xBF\xD1\x83\xD1\x81\xD1\x82\xD0\xB8\xD0"
	"\xBC\xD0\xBE\xD1\x81\xD1\x82\xD0\xB8 \xD0\xB2\xD1\x85\xD0\xBE\xD0\xB4\xD0\xBD\xD1"
	"\x8B\xD1\x85 \xD0\xBF\xD0\xB0\xD1\x80\xD0\xB0\xD0\xBC\xD0\xB5\xD1\x82\xD1\x80\xD0"
	"\xBE\xD0\xB2 \xD0\xB2 \xD1\x81\xD0\xB8\xD0\xBD\xD1\x82\xD0\xB0\xD0\xBA\xD1\x81\xD0"
	"\xB8\xD1\x81\xD0\xB5 \xD1\x8F\xD0\xB7\xD1\x8B\xD0\xBA\xD0\xB0 C. \xD0\x92\xD1\x85"
	"\xD0\xBE\xD0\xB4\xD0\xBD\xD1\x8B\xD0\xB5 \xD0\xBF\xD0\xB0\xD1\x80\xD0\xB0\xD0\xBC"
	"\xD0\xB5\xD1\x82\xD1\x80\xD1\x8B - \xD1\x8D\xD0\xBB\xD0\xB5\xD0\xBC\xD0\xB5\xD0\xBD"
	"\xD1\x82\xD1\x8B \xD0\xBC\xD0\xB0\xD1\x81\xD1\x81\xD0\xB8\xD0\xB2\xD0\xB0 \"X[...]\". "
	"\xD0\x95\xD1\x81\xD0\xBB\xD0\xB8 \xD1\x81\xD0\xBE\xD1\x87\xD0\xB5\xD1\x82\xD0\xB0"
	"\xD0\xBD\xD0\xB8\xD0\xB5 \xD0\xBF\xD0\xB0\xD1\x80\xD0\xB0\xD0\xBC\xD0\xB5\xD1\x82"
	"\xD1\x80\xD0\xBE\xD0\xB2 \xD0\xB4\xD0\xBE\xD0\xBF\xD1\x83\xD1\x81\xD1\x82\xD0\xB8"
	"\xD0\xBC\xD0\xBE, \xD0\xBD\xD1\x83\xD0\xB6\xD0\xBD\xD0\xBE \xD0\xBB\xD0\xB8\xD0\xB1"
	"\xD0\xBE \xD0\xBF\xD1\x80\xD0\xB8\xD1\x81\xD0\xB2\xD0\xBE\xD0\xB8\xD1\x82\xD1\x8C "
	"\xD0\xBD\xD0\xB5\xD0\xBD\xD1\x83\xD0\xBB\xD0\xB5\xD0\xB2\xD0\xBE\xD0\xB5 \xD0\xB7\xD0"
	"\xBD\xD0\xB0\xD1\x87\xD0\xB5\xD0\xBD\xD0\xB8\xD0\xB5 \xD0\xBF\xD0\xB5\xD1\x80\xD0\xB5"
	"\xD0\xBC\xD0\xB5\xD0\xBD\xD0\xBD\xD0\xBE\xD0\xB9 \"ok\", \xD0\xBB\xD0\xB8\xD0\xB1\xD0"
	"\xBE \xD0\xB2\xD0\xB5\xD1\x80\xD0\xBD\xD1\x83\xD1\x82\xD1\x8C \xD0\xBD\xD0\xB5\xD0"
	"\xBD\xD1\x83\xD0\xBB\xD0\xB5\xD0\xB2\xD0\xBE\xD0\xB5 \xD0\xB7\xD0\xBD\xD0\xB0\xD1\x87"
	"\xD0\xB5\xD0\xBD\xD0\xB8\xD0\xB5 \xD0\xBE\xD0\xBF\xD0\xB5\xD1\x80\xD0\xB0\xD1\x82\xD0"
	"\xBE\xD1\x80\xD0\xBE\xD0\xBC return. \xD0\x94\xD0\xBB\xD1\x8F \xD0\xBD\xD0\xB5\xD0\xB4"
	"\xD0\xBE\xD0\xBF\xD1\x83\xD1\x81\xD1\x82\xD0\xB8\xD0\xBC\xD0\xBE\xD0\xB3\xD0\xBE \xD1"
	"\x81\xD0\xBE\xD1\x87\xD0\xB5\xD1\x82\xD0\xB0\xD0\xBD\xD0\xB8\xD1\x8F \xD0\xBF\xD0\xB0"
	"\xD1\x80\xD0\xB0\xD0\xBC\xD0\xB5\xD1\x82\xD1\x80\xD0\xBE\xD0\xB2 \xD0\xBF\xD1\x80\xD0"
	"\xB8\xD1\x81\xD0\xB2\xD0\xB0\xD0\xB8\xD0\xB2\xD0\xB0\xD0\xB5\xD1\x82\xD1\x81\xD1\x8F "
	"\xD0\xB8\xD0\xBB\xD0\xB8 \xD0\xB2\xD0\xBE\xD0\xB7\xD0\xB2\xD1\x80\xD0\xB0\xD1\x89\xD0\xB0"
	"\xD0\xB5\xD1\x82\xD1\x81\xD1\x8F \xD0\xBD\xD0\xBE\xD0\xBB\xD1\x8C." 
	/* "Необходимо ввести оператор(ы) проверки допустимости входных параметров в синтаксисе языка C. 
	Входные параметры - элементы массива \"X[...]\". Если сочетание параметров допустимо, нужно 
	либо присвоить ненулевое значение переменной \"ok\", либо вернуть ненулевое значение оператором 
	return. Для недопустимого сочетания параметров присваивается или возвращается ноль." */),
  0);
rdsSetObjectInt(win,100,RDS_FORMVAL_MLHEIGHT,100);
rdsSetObjectInt(win,100,RDS_FORMVAL_MLABELBEVEL,1);

rdsFORMAddTab(win,2, LangData.GetString("Tab_OutputLimits",L57_LANG_CAPTION,
  "\xD0\x9F\xD0\xBE \xD0\xB2\xD1\x8B\xD1\x85\xD0\xBE\xD0\xB4\xD1\x83" /* "По выходу" */) );
rdsFORMAddEdit(win,2,2,RDS_FORMCTRL_MULTILINE,sourcecodelabel,80);
rdsSetObjectInt(win,2,RDS_FORMVAL_MLRETURNS,1);
rdsFORMSetMultilineHeight(win,2,4*24);
rdsSetObjectStr(win,2,RDS_FORMVAL_VALUE,file.OutputCode.c_str());

rdsFORMAddEdit(win,2,200,RDS_FORMCTRL_MULTILABEL,
  LangData.GetString("L_OutputLimitHelp",L57_LANG_CAPTION,
    "\xD0\x9D\xD0\xB5\xD0\xBE\xD0\xB1\xD1\x85\xD0\xBE\xD0\xB4\xD0\xB8\xD0\xBC\xD0\xBE \xD0\xB2\xD0"
	"\xB2\xD0\xB5\xD1\x81\xD1\x82\xD0\xB8 \xD0\xBE\xD0\xBF\xD0\xB5\xD1\x80\xD0\xB0\xD1\x82\xD0\xBE"
	"\xD1\x80(\xD1\x8B) \xD0\xBF\xD1\x80\xD0\xBE\xD0\xB2\xD0\xB5\xD1\x80\xD0\xBA\xD0\xB8 \xD0\xB4"
	"\xD0\xBE\xD0\xBF\xD1\x83\xD1\x81\xD1\x82\xD0\xB8\xD0\xBC\xD0\xBE\xD1\x81\xD1\x82\xD0\xB8 \xD0"
	"\xB7\xD0\xBD\xD0\xB0\xD1\x87\xD0\xB5\xD0\xBD\xD0\xB8\xD1\x8F \xD0\xBC\xD0\xB0\xD0\xBA\xD1\x81"
	"\xD0\xB8\xD0\xBC\xD0\xB8\xD0\xB7\xD0\xB8\xD1\x80\xD1\x83\xD0\xB5\xD0\xBC\xD0\xBE\xD0\xB9 \xD0"
	"\xB2\xD0\xB5\xD0\xBB\xD0\xB8\xD1\x87\xD0\xB8\xD0\xBD\xD1\x8B \"Crit\" \xD0\xB2 \xD1\x81\xD0\xB8"
	"\xD0\xBD\xD1\x82\xD0\xB0\xD0\xBA\xD1\x81\xD0\xB8\xD1\x81\xD0\xB5 \xD1\x8F\xD0\xB7\xD1\x8B\xD0"
	"\xBA\xD0\xB0 C. \xD0\x95\xD1\x81\xD0\xBB\xD0\xB8 \xD0\xB7\xD0\xBD\xD0\xB0\xD1\x87\xD0\xB5\xD0"
	"\xBD\xD0\xB8\xD0\xB5 \xD0\xB4\xD0\xBE\xD0\xBF\xD1\x83\xD1\x81\xD1\x82\xD0\xB8\xD0\xBC\xD0\xBE, "
	"\xD0\xBD\xD1\x83\xD0\xB6\xD0\xBD\xD0\xBE \xD0\xBB\xD0\xB8\xD0\xB1\xD0\xBE \xD0\xBF\xD1\x80\xD0"
	"\xB8\xD1\x81\xD0\xB2\xD0\xBE\xD0\xB8\xD1\x82\xD1\x8C \xD0\xBD\xD0\xB5\xD0\xBD\xD1\x83\xD0\xBB"
	"\xD0\xB5\xD0\xB2\xD0\xBE\xD0\xB5 \xD0\xB7\xD0\xBD\xD0\xB0\xD1\x87\xD0\xB5\xD0\xBD\xD0\xB8\xD0"
	"\xB5 \xD0\xBF\xD0\xB5\xD1\x80\xD0\xB5\xD0\xBC\xD0\xB5\xD0\xBD\xD0\xBD\xD0\xBE\xD0\xB9 \"ok\", "
	"\xD0\xBB\xD0\xB8\xD0\xB1\xD0\xBE \xD0\xB2\xD0\xB5\xD1\x80\xD0\xBD\xD1\x83\xD1\x82\xD1\x8C \xD0"
	"\xBD\xD0\xB5\xD0\xBD\xD1\x83\xD0\xBB\xD0\xB5\xD0\xB2\xD0\xBE\xD0\xB5 \xD0\xB7\xD0\xBD\xD0\xB0\xD1"
	"\x87\xD0\xB5\xD0\xBD\xD0\xB8\xD0\xB5 \xD0\xBE\xD0\xBF\xD0\xB5\xD1\x80\xD0\xB0\xD1\x82\xD0\xBE\xD1"
	"\x80\xD0\xBE\xD0\xBC return. \xD0\x94\xD0\xBB\xD1\x8F \xD0\xBD\xD0\xB5\xD0\xB4\xD0\xBE\xD0\xBF\xD1"
	"\x83\xD1\x81\xD1\x82\xD0\xB8\xD0\xBC\xD0\xBE\xD0\xB3\xD0\xBE \xD0\xB7\xD0\xBD\xD0\xB0\xD1\x87\xD0"
	"\xB5\xD0\xBD\xD0\xB8\xD1\x8F \xD0\xBF\xD1\x80\xD0\xB8\xD1\x81\xD0\xB2\xD0\xB0\xD0\xB8\xD0\xB2\xD0"
	"\xB0\xD0\xB5\xD1\x82\xD1\x81\xD1\x8F \xD0\xB8\xD0\xBB\xD0\xB8 \xD0\xB2\xD0\xBE\xD0\xB7\xD0\xB2\xD1"
	"\x80\xD0\xB0\xD1\x89\xD0\xB0\xD0\xB5\xD1\x82\xD1\x81\xD1\x8F \xD0\xBD\xD0\xBE\xD0\xBB\xD1\x8C." 
	/* "Необходимо ввести оператор(ы) проверки допустимости значения максимизируемой величины \"Crit\" 
	в синтаксисе языка C. Если значение допустимо, нужно либо присвоить ненулевое значение переменной \"ok\", 
	либо вернуть ненулевое значение оператором return. Для недопустимого значения присваивается или 
	возвращается ноль." */),
  0);
rdsSetObjectInt(win,200,RDS_FORMVAL_MLHEIGHT,100);
rdsSetObjectInt(win,200,RDS_FORMVAL_MLABELBEVEL,1);

res=rdsFORMShowModalServ(win,NULL);

if(res)
  { char *in_code=rdsGetObjectStr(win,1,RDS_FORMVAL_VALUE);
    char *out_code=rdsGetObjectStr(win,2,RDS_FORMVAL_VALUE);
    file.InputCode.Assign(in_code);
    file.OutputCode.Assign(out_code);
    file.SaveFileToModel(rdsbcppBlockData->Block,L57_BAK);
  }

rdsDeleteObject(win);
Result=res?1:0;

#endif // #ifdef L57MS_SETUP
//-----------------------------------------------------------------------



//---------------------------------------------------------------------------
// Описания в классе
//---------------------------------------------------------------------------
#ifdef L57MS_CLASS
TL57TextEMLFuncArg Arguments;

#endif // #ifdef L57MS_CLASS
//-----------------------------------------------------------------------


//---------------------------------------------------------------------------
// Модель
//---------------------------------------------------------------------------
#ifdef L57MS_MODEL
// Исходно запрещаем работу всех выходов
Ready=Crit_Out_Ready=crit_out_en=0;
y_enabled=0;
Crit_Out=rdsbcppHugeDouble; // Для отладки

if(func_chg) // Изменились функции
  { BOOL FuncsChanged=FALSE;
    func_chg=0;
    int n=F.Size();
    // Проверяем, какие именно
    if(n!=FS.Size())
      { FS.Resize(n,TRUE);
        FuncsChanged=TRUE;
      }
    for(int i=0;i<n;i++)
      { rdsbcstMDouble Fi=F[i],FSi=FS[i];
        if(TL57TextFuncFArray::IsBadMatrix(&Fi)) // Нет новых данных на F[i]
          continue;
        // Данные есть, но новые ли?
        if(TL57TextFuncFArray::CompareMatr(&Fi,&FSi))
          { // Такие уже есть
            Fi.Resize(2,2);
            TL57TextFuncFArray::SetBadMatrix(&Fi);
            continue;
          }
        // Новые данные
        FuncsChanged=TRUE;
        rdsExchangeVarArrays(Fi.GetPtr(),FSi.GetPtr());
        Fi.Resize(2,2);
        TL57TextFuncFArray::SetBadMatrix(&Fi);
      }
    if(FuncsChanged)
      { //test=GetTickCount();
        Arguments.Functions.Realloc(n);
        for(int i=0;i<n;i++)
		  { rdsbcstMDouble FSi=FS[i];
	        Arguments.Functions[i].Setup(&FSi);
	      }
      }
  }

// Параметры
if(A.IsEmpty())
  Arguments.A_Params.Setup(NULL);
else
  Arguments.A_Params.Setup(A.GetBuffer(),A.Size());

if(X.IsEmpty())
  Arguments.X_Params.Setup(NULL);
else
  Arguments.X_Params.Setup(X.GetBuffer(),X.Size());

// Параметры
if(x_chg)
  { // Поступили новые параметры
    x_chg=0;
    Arguments._Crit=rdsbcppHugeDouble;
    if(InFunc(Arguments))
      { // OK
        Y=X;
        y_enabled=1;
        Ready=1;
      }
    else
      { // Плохие аргументы
        Crit_Out=rdsbcppHugeDouble;
        Crit_Out_Ready=crit_out_en=1;
        Ready=1;
      }
    /*
    if(CritInReady)
      { static int nn=10;
        nn--;
        if(!nn)
          rdsStopCalc();
        rdsMessageBox("InReady","",MB_OK);
      }
    */
    Crit_In_Ready=crit_in_chg=0;
    return;
  }

if(Crit_In_Ready)
  { // Поступил новый критерий
    Crit_In_Ready=crit_in_chg=0;
    Arguments._Crit=Crit_In;
    if(OutFunc(Arguments)) // OK
      Crit_Out=Crit_In;
    else // Ошибка
      Crit_Out=rdsbcppHugeDouble;
    Crit_Out_Ready=crit_out_en=1;
    Ready=1;
  }

#endif // #ifdef L57MS_MODEL
//-----------------------------------------------------------------------



//---------------------------------------------------------------------------
// Режим моделирования
//---------------------------------------------------------------------------
#ifdef L57MS_CALCMODE

#endif // #ifdef L57MS_CALCMODE
//-----------------------------------------------------------------------


//---------------------------------------------------------------------------
// Запуск расчета
//---------------------------------------------------------------------------
#ifdef L57MS_START

#endif // #ifdef L57MS_START
//-----------------------------------------------------------------------

//---------------------------------------------------------------------------
// Вызов контекстного меню
//---------------------------------------------------------------------------
#ifdef L57MS_POPUP

  #ifdef L57_HELPUIFILE
    if(L57_HelpUIFileExists(L57_HELPUIFILE,&L57_HelpState))
	  rdsbcppBlockData->Flags|=RDS_BLOCKHASHELP;
  #endif

  #ifdef L57_EXAMPLEUIFILE
    if(L57_HelpUIFileExists(L57_EXAMPLEUIFILE,&L57_ExampleState))
	  rdsbcppBlockData->Flags|=RDS_BLOCKHASEXAMPLE;
  #endif


#endif // #ifdef L57MS_POPUP
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Прочие события
//---------------------------------------------------------------------------
#ifdef L57MS_OTHER

  #if defined(L57_HELPUIFILE) || defined(L57_EXAMPLEUIFILE)
    switch(CallMode)
      {
        #ifdef L57_HELPUIFILE
        case RDS_BFM_HELP:
          if(L57_HelpUIFileExists(L57_HELPUIFILE,&L57_HelpState))
            { rdsShowHelp(L57_HELPUIFILE,L57_HELPTOPIC,FALSE);
              Result=1;
            }
          break;
        #endif

        #ifdef L57_EXAMPLEUIFILE
        case RDS_BFM_SHOWEXAMPLE:
          if(L57_HelpUIFileExists(L57_EXAMPLEUIFILE,&L57_ExampleState))
            { rdsShowHelp(L57_EXAMPLEUIFILE,L57_EXAMPLETOPIC,FALSE);
              Result=1;
            }
          break;
        #endif
      }
  #endif

#endif // #ifdef L57MS_OTHER
//---------------------------------------------------------------------------

