//---------------------------------------------------------------------------
// Набор макросов для доступа к интерфейсным функциям RDS из DLL
//---------------------------------------------------------------------------
#ifndef RdsFuncH
#define RdsFuncH

#ifndef RdsDefH
  // Для нормальной компиляции необходимы описания из RdsDef.h
  #include "RdsDef.h"
#endif

//===================================================================================
// Набор глобальных указателей на интерфейсные функции и функция для получения этих
// указателей.
// Компилируется ТОЛЬКО если ПЕРЕД директивой #include "RdsFunc.h" есть описание вида
//     #define RDS_SERV_FUNC_BODY FuncName
// где FuncName - имя генерируемой функции получения указателей.
// Этот набор может быть включен ТОЛЬКО В ОДИН файл проекта, т.е. только в одном файле
// перед #include "RdsFunc.h" может находиться #define RDS_SERV_FUNC_BODY.
// Старый макрос RDS_INTFUNCACCESS нельзя использовать из-за ограничения на развернутый текст
// макроопределения в 4096 байт.
// Пример использования
//    ------- Главный файл проекта -------
//    #define RDS_SERV_FUNC_BODY MyGetService
//    #include "RdsFunc.h"  // Здесь будет вставлено тело функции BOOL MyGetService(void)
//    ......
//    int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
//    {
//      if(reason==DLL_PROCESS_ATTACH)
//        {
//          if(!MyGetService())
//            MessageBoxW(NULL,L"Ошибка доступа к сервисным функциям",L"DLL",MB_OK | MB_ICONERROR);
//        }
//      return 1;
//    }
//    ......
//    ------- Другие файлы проекта -------
//    #include "RdsFunc.h"
//    ......
// Перед RdsFunc.h также необходимо включить файл, отвечающий за описания типов и
// прототипы функций Windows API (в частности, типа BOOL и функции GetModuleHandle).
// Для Borland C++ подойдет "windows.h".
//---------------------------------------------------------------------------
//===================================================================================
#ifndef RDS_NOVERSIONDEFINES
  // Стандартное сообщение об ошибке при отсутствии доступа к сервисным функциям
  #define RDS_SERV_ERROR_TEXTW L"Эти модели могут использоваться только с версией RDS не ниже " RDS_STRVERSIONW L"\n" \
                               L"These models need RDS " RDS_STRVERSIONW L" or newer"
  #define RDS_SERV_ERROR_TEXTA "These models need RDS " RDS_STRVERSIONA " or newer"
  #define RDS_SERV_ERROR_MSGW { if(rdsIncompatibleDll) rdsIncompatibleDll(); MessageBoxW(NULL,RDS_SERV_ERROR_TEXTW,NULL,MB_OK | MB_ICONERROR); }
  #define RDS_SERV_ERROR_MSGA { if(rdsIncompatibleDll) rdsIncompatibleDll(); MessageBoxA(NULL,RDS_SERV_ERROR_TEXTA,NULL,MB_OK | MB_ICONERROR); }
#endif
//===================================================================================
#ifdef RDS_SERV_FUNC_BODY
  // Вспомогательный макрос, объявляющий переменную-указатель
  #define _RDS_AUX_FUNC(name,type) type name;

  // Описания переменных-указателей на функции
  // Global function vars - autogenerated (begin)
  _RDS_AUX_FUNC(rdsServiceVersion,RDS_IV)
  _RDS_AUX_FUNC(rdsCallerThreadType,RDS_IV)
  _RDS_AUX_FUNC(rdsGetTopWindowBlock,RDS_BhV)
  _RDS_AUX_FUNC(rdsGetBlockDescription,RDS_IBhBd)
  _RDS_AUX_FUNC(rdsGetAppWindowHandle,RDS_HwV)
  _RDS_AUX_FUNC(rdsGetMainWindow,RDS_HwV)
  _RDS_AUX_FUNC(rdsGetFirstBlock,RDS_BhBhIBd)
  _RDS_AUX_FUNC(rdsGetNextBlock,RDS_BhBhIBd)
  _RDS_AUX_FUNC(rdsGetConnDescription,RDS_IChCd)
  _RDS_AUX_FUNC(rdsGetFirstConn,RDS_ChBhICd)
  _RDS_AUX_FUNC(rdsGetNextConn,RDS_ChChICd)
  _RDS_AUX_FUNC(rdsGetPointDescription,RDS_IChIPd)
  _RDS_AUX_FUNC(rdsGetSystemPathA,RDS_SI)
  _RDS_AUX_FUNC(rdsGetSystemPathW,RDS_WsI)
  _RDS_AUX_FUNC(rdsRemoteControllerCallA,RDS_IIS)
  _RDS_AUX_FUNC(rdsRemoteControllerCallW,RDS_IIWs)
  _RDS_AUX_FUNC(rdsRemoteReplyA,RDS_VS)
  _RDS_AUX_FUNC(rdsRemoteReplyW,RDS_VWs)
  _RDS_AUX_FUNC(rdsReportTextLoadErrorA,RDS_VS)
  _RDS_AUX_FUNC(rdsReportTextLoadErrorW,RDS_VWs)
  _RDS_AUX_FUNC(rdsSetHintTextA,RDS_VS)
  _RDS_AUX_FUNC(rdsSetHintTextW,RDS_VWs)
  _RDS_AUX_FUNC(rdsGetRemoteControllerNameA,RDS_SV)
  _RDS_AUX_FUNC(rdsGetRemoteControllerNameW,RDS_WsV)
  _RDS_AUX_FUNC(rdsWriteBlockData,RDS_BpVI)
  _RDS_AUX_FUNC(rdsReadBlockData,RDS_BpVI)
  _RDS_AUX_FUNC(rdsWriteBlockDataTextA,RDS_VSB)
  _RDS_AUX_FUNC(rdsWriteBlockDataTextW,RDS_VWsB)
  _RDS_AUX_FUNC(rdsSetDebugTextA,RDS_VSB)
  _RDS_AUX_FUNC(rdsSetDebugTextW,RDS_VWsB)
  _RDS_AUX_FUNC(rdsXGSetPenStyle,RDS_VIIICrI)
  _RDS_AUX_FUNC(rdsXGSetBrushStyle,RDS_VIICr)
  _RDS_AUX_FUNC(rdsXGSetFontA,RDS_VISICrIIBBBB)
  _RDS_AUX_FUNC(rdsXGSetFontW,RDS_VIWsICrIIBBBB)
  _RDS_AUX_FUNC(rdsWriteFontTextA,RDS_VISICrIIBBBB)
  _RDS_AUX_FUNC(rdsWriteFontTextW,RDS_VIWsICrIIBBBB)
  _RDS_AUX_FUNC(rdsXGSetLogFontA,RDS_VpLfCr)
  _RDS_AUX_FUNC(rdsXGSetLogFontW,RDS_VpLfwCr)
  _RDS_AUX_FUNC(rdsXGGetTextSizeA,RDS_VSpIpI)
  _RDS_AUX_FUNC(rdsXGGetTextSizeW,RDS_VWspIpI)
  _RDS_AUX_FUNC(rdsXGRectangle,RDS_VIIII)
  _RDS_AUX_FUNC(rdsXGInvertRect,RDS_VIIII)
  _RDS_AUX_FUNC(rdsXGEllipse,RDS_VIIII)
  _RDS_AUX_FUNC(rdsXGArc,RDS_VIIIIIIII)
  _RDS_AUX_FUNC(rdsXGPie,RDS_VIIIIIIII)
  _RDS_AUX_FUNC(rdsXGChord,RDS_VIIIIIIII)
  _RDS_AUX_FUNC(rdsXGTextOutA,RDS_VIIS)
  _RDS_AUX_FUNC(rdsXGTextOutW,RDS_VIIWs)
  _RDS_AUX_FUNC(rdsXGTextRectA,RDS_VIISpR)
  _RDS_AUX_FUNC(rdsXGTextRectW,RDS_VIIWspR)
  _RDS_AUX_FUNC(rdsSetBlockTimer,RDS_ThThDwDwB)
  _RDS_AUX_FUNC(rdsGetCustomColors,RDS_pCrV)
  _RDS_AUX_FUNC(rdsCallColorDialog,RDS_BpCr)
  _RDS_AUX_FUNC(rdsGetEditorParameters,RDS_BBhEd)
  _RDS_AUX_FUNC(rdsGetBlockTimerDescr,RDS_BThTd)
  _RDS_AUX_FUNC(rdsDeleteBlockTimer,RDS_VTh)
  _RDS_AUX_FUNC(rdsStopBlockTimer,RDS_VTh)
  _RDS_AUX_FUNC(rdsRestartBlockTimer,RDS_VThDw)
  _RDS_AUX_FUNC(rdsXGMoveTo,RDS_VII)
  _RDS_AUX_FUNC(rdsXGLineTo,RDS_VII)
  _RDS_AUX_FUNC(rdsGetTextWordA,RDS_SSpSpCB)
  _RDS_AUX_FUNC(rdsGetTextWordW,RDS_WsSpSpCB)
  _RDS_AUX_FUNC(rdsWriteLineStyleText,RDS_VIB)
  _RDS_AUX_FUNC(rdsWriteWordValueTextA,RDS_VSI)
  _RDS_AUX_FUNC(rdsWriteWordValueTextW,RDS_VWsI)
  _RDS_AUX_FUNC(rdsWriteColorTextA,RDS_VSCrB)
  _RDS_AUX_FUNC(rdsWriteColorTextW,RDS_VWsCrB)
  _RDS_AUX_FUNC(rdsReadColorText,RDS_CrSpS)
  _RDS_AUX_FUNC(rdsReadFontTextA,RDS_BSpSSIpIpCrpIpIpBpBpBpB)
  _RDS_AUX_FUNC(rdsReadFontTextW,RDS_BSpSWsIpIpCrpIpIpBpBpBpB)
  _RDS_AUX_FUNC(rdsXGGetVisibleRect,RDS_VpR)
  _RDS_AUX_FUNC(rdsXGSetClipRect,RDS_VpR)
  _RDS_AUX_FUNC(rdsWriteWordStringTextA,RDS_VSS)
  _RDS_AUX_FUNC(rdsWriteWordStringTextW,RDS_VWsWs)
  _RDS_AUX_FUNC(rdsXGDrawBlockPicture,RDS_VIIDDDB)
  _RDS_AUX_FUNC(rdsXGTriangle,RDS_VIIIIII)
  _RDS_AUX_FUNC(rdsXGPolygon,RDS_VpPI)
  _RDS_AUX_FUNC(rdsXGFontSizeToHeight,RDS_II)
  _RDS_AUX_FUNC(rdsCheckBlockFunctionSupport,RDS_BBhI)
  _RDS_AUX_FUNC(rdsCallBlockFunction,RDS_IBhIpV)
  _RDS_AUX_FUNC(rdsBroadcastFunctionCallsEx,RDS_IBhIpVDw)
  _RDS_AUX_FUNC(rdsBroadcastFunctionCalls,RDS_VBhIpVB)
  _RDS_AUX_FUNC(rdsGetConnAppearance,RDS_VChCa)
  _RDS_AUX_FUNC(rdsSetConnAppearance,RDS_VChCa)
  _RDS_AUX_FUNC(rdsGetConnStyleAppearanceA,RDS_BSCa)
  _RDS_AUX_FUNC(rdsGetConnStyleAppearanceW,RDS_BWsCa)
  _RDS_AUX_FUNC(rdsSystemInEditMode,RDS_BV)
  _RDS_AUX_FUNC(rdsGetBlockLink,RDS_ChBhChBBPd)
  _RDS_AUX_FUNC(rdsCreateDynamicVarA,RDS_pVISSBS)
  _RDS_AUX_FUNC(rdsCreateDynamicVarW,RDS_pVIWsWsBWs)
  _RDS_AUX_FUNC(rdsCreateAndSubscribeDVA,RDS_DvISSBS)
  _RDS_AUX_FUNC(rdsCreateAndSubscribeDVW,RDS_DvIWsWsBWs)
  _RDS_AUX_FUNC(rdsDeleteDynamicVarA,RDS_BIS)
  _RDS_AUX_FUNC(rdsDeleteDynamicVarW,RDS_BIWs)
  _RDS_AUX_FUNC(rdsSubscribeToDynamicVarA,RDS_DvISSB)
  _RDS_AUX_FUNC(rdsSubscribeToDynamicVarW,RDS_DvIWsWsB)
  _RDS_AUX_FUNC(rdsUnsubscribeFromDynamicVar,RDS_VDv)
  _RDS_AUX_FUNC(rdsGetChildBlockByNameA,RDS_BhBhSBd)
  _RDS_AUX_FUNC(rdsGetChildBlockByNameW,RDS_BhBhWsBd)
  _RDS_AUX_FUNC(rdsGetIOBlockByVarNameA,RDS_BhBhSBd)
  _RDS_AUX_FUNC(rdsGetIOBlockByVarNameW,RDS_BhBhWsBd)
  _RDS_AUX_FUNC(rdsGetRootSystem,RDS_BhBd)
  _RDS_AUX_FUNC(rdsGetIOBlockLink,RDS_ChBhChPd)
  _RDS_AUX_FUNC(rdsRefreshBlockWindows,RDS_VBhB)
  _RDS_AUX_FUNC(rdsCountBlocks,RDS_IBhIB)
  _RDS_AUX_FUNC(rdsSetBlockCommentA,RDS_VBhS)
  _RDS_AUX_FUNC(rdsSetBlockCommentW,RDS_VBhWs)
  _RDS_AUX_FUNC(rdsSetModifiedFlag,RDS_VB)
  _RDS_AUX_FUNC(rdsOpenSystemWindow,RDS_VBh)
  _RDS_AUX_FUNC(rdsCloseSystemWindow,RDS_VBh)
  _RDS_AUX_FUNC(rdsScrollWindowToBlock,RDS_VBh)
  _RDS_AUX_FUNC(rdsAltConnAppearanceOp,RDS_IChIICa)
  _RDS_AUX_FUNC(rdsGetLayerConfigNameA,RDS_SBhI)
  _RDS_AUX_FUNC(rdsGetLayerConfigNameW,RDS_WsBhI)
  _RDS_AUX_FUNC(rdsGetLayerNameA,RDS_SBhI)
  _RDS_AUX_FUNC(rdsGetLayerNameW,RDS_WsBhI)
  _RDS_AUX_FUNC(rdsSetCurLayerConfig,RDS_BBhI)
  _RDS_AUX_FUNC(rdsSetCurLayerConfigByNameA,RDS_BBhS)
  _RDS_AUX_FUNC(rdsSetCurLayerConfigByNameW,RDS_BBhWs)
  _RDS_AUX_FUNC(rdsEnableWindowRefresh,RDS_VBhBB)
  _RDS_AUX_FUNC(rdsStopCalc,RDS_VV)
  _RDS_AUX_FUNC(rdsGetVarArrayParams,RDS_pVpVpIpI)
  _RDS_AUX_FUNC(rdsGetVarArrayAccessData,RDS_BpVAd)
  _RDS_AUX_FUNC(rdsResizeVarArray,RDS_BpVIIBAd)
  _RDS_AUX_FUNC(rdsEnumBlocks,RDS_BhBhIBCbpV)
  _RDS_AUX_FUNC(rdsGetPictureObjectId,RDS_IIIB)
  _RDS_AUX_FUNC(rdsSaveSystemState,RDS_IBhIBCb2)
  _RDS_AUX_FUNC(rdsLoadSystemState,RDS_BICb2)
  _RDS_AUX_FUNC(rdsGetScreenCoords,RDS_BBhIIpIpI)
  _RDS_AUX_FUNC(rdsLockBlockData,RDS_VV)
  _RDS_AUX_FUNC(rdsUnlockBlockData,RDS_VV)
  _RDS_AUX_FUNC(rdsBlockDataSyncCall,RDS_ICb4pV)
  _RDS_AUX_FUNC(rdsRegisterFunctionA,RDS_IS)
  _RDS_AUX_FUNC(rdsRegisterFunctionW,RDS_IWs)
  _RDS_AUX_FUNC(rdsActivateOutputConnections,RDS_VBhB)
  _RDS_AUX_FUNC(rdsSelectBlock,RDS_VBhBB)
  _RDS_AUX_FUNC(rdsCalcProcessIsRunning,RDS_BV)
  _RDS_AUX_FUNC(rdsEnumConnectedBlocks,RDS_BhBhDwCb1pV)
  _RDS_AUX_FUNC(rdsWriteHexText,RDS_VpVII)
  _RDS_AUX_FUNC(rdsReadHexText,RDS_ISpSpVI)
  _RDS_AUX_FUNC(rdsGetCmdParamCount,RDS_IV)
  _RDS_AUX_FUNC(rdsGetCmdParamA,RDS_SIB)
  _RDS_AUX_FUNC(rdsGetCmdParamW,RDS_WsIB)
  _RDS_AUX_FUNC(rdsFindCmdParamA,RDS_ISB)
  _RDS_AUX_FUNC(rdsFindCmdParamW,RDS_IWsB)
  _RDS_AUX_FUNC(rdsRegisterMenuItemA,RDS_MhSDwIDwII)
  _RDS_AUX_FUNC(rdsRegisterMenuItemW,RDS_MhWsDwIDwII)
  _RDS_AUX_FUNC(rdsEnableMenuItem,RDS_VMhBB)
  _RDS_AUX_FUNC(rdsUnregisterMenuItem,RDS_VMh)
  _RDS_AUX_FUNC(rdsFree,RDS_VpcV)
  _RDS_AUX_FUNC(rdsAllocate,RDS_pVDw)
  _RDS_AUX_FUNC(rdsCreateFullBlockNameStringA,RDS_SBhpI)
  _RDS_AUX_FUNC(rdsCreateFullBlockNameStringW,RDS_WsBhpI)
  _RDS_AUX_FUNC(rdsBlockByFullNameA,RDS_BhSBd)
  _RDS_AUX_FUNC(rdsBlockByFullNameW,RDS_BhWsBd)
  _RDS_AUX_FUNC(rdsParentIsRoot,RDS_BBh)
  _RDS_AUX_FUNC(rdsHasRemoteController,RDS_BV)
  _RDS_AUX_FUNC(rdsDeleteBlock,RDS_VBh)
  _RDS_AUX_FUNC(rdsDeleteConnection,RDS_VCh)
  _RDS_AUX_FUNC(rdsCreateBlockFromFileA,RDS_BhSBhIIBd)
  _RDS_AUX_FUNC(rdsCreateBlockFromFileW,RDS_BhWsBhIIBd)
  _RDS_AUX_FUNC(rdsDuplicateBlock,RDS_BhBhBhIIBd)
  _RDS_AUX_FUNC(rdsGetBlockVar,RDS_VhBhiVd)
  _RDS_AUX_FUNC(rdsFindBlockVarA,RDS_VhBhSBVd)
  _RDS_AUX_FUNC(rdsFindBlockVarW,RDS_VhBhWsBVd)
  _RDS_AUX_FUNC(rdsCECreateEditor,RDS_HoV)
  _RDS_AUX_FUNC(rdsDeleteObject,RDS_VHo)
  _RDS_AUX_FUNC(rdsCECreateConnBus,RDS_ChHoBhIpI)
  _RDS_AUX_FUNC(rdsCEEditConnBus,RDS_BHoChpI)
  _RDS_AUX_FUNC(rdsCEAddInternalPoint,RDS_IHoII)
  _RDS_AUX_FUNC(rdsCEAddBlockPointA,RDS_IHoBhSIIB)
  _RDS_AUX_FUNC(rdsCEAddBlockPointW,RDS_IHoBhWsIIB)
  _RDS_AUX_FUNC(rdsCEAddBusPointA,RDS_IHoChSBIIB)
  _RDS_AUX_FUNC(rdsCEAddBusPointW,RDS_IHoChWsBIIB)
  _RDS_AUX_FUNC(rdsCEAddLine,RDS_IHoII)
  _RDS_AUX_FUNC(rdsCEAddBezier,RDS_IHoIIIIII)
  _RDS_AUX_FUNC(rdsGetBlockDimensions,RDS_BBhBrB)
  _RDS_AUX_FUNC(rdsBCLCreateList,RDS_HoBhDwB)
  _RDS_AUX_FUNC(rdsGetObjectArray,RDS_pVHoIIpI)
  _RDS_AUX_FUNC(rdsMoveBlock,RDS_VBhII)
  _RDS_AUX_FUNC(rdsSetSystemUpdate,RDS_VB)
  _RDS_AUX_FUNC(rdsdebugBlockInfoA,RDS_VBhSS)
  _RDS_AUX_FUNC(rdsdebugBlockInfoW,RDS_VBhWsWs)
  _RDS_AUX_FUNC(rdsGetLineDescription,RDS_BChILdPdPd)
  _RDS_AUX_FUNC(rdsFindNextConnectedLine,RDS_IChIILdpI)
  _RDS_AUX_FUNC(rdsScrollWindowToRect,RDS_VBhIIIIB)
  _RDS_AUX_FUNC(rdsCheckRectVisibility,RDS_BBhIIII)
  _RDS_AUX_FUNC(rdsCalcProcessNeverStarted,RDS_BV)
  _RDS_AUX_FUNC(rdsCheckSystemWindow,RDS_BBh)
  _RDS_AUX_FUNC(rdscompSetModelFunctionA,RDS_VMhSS)
  _RDS_AUX_FUNC(rdscompSetModelFunctionW,RDS_VMhWsWs)
  _RDS_AUX_FUNC(rdsDeleteDVByLink,RDS_BDv)
  _RDS_AUX_FUNC(rdsCopyVarArray,RDS_BpVpV)
  _RDS_AUX_FUNC(rdsVSCreateEditor,RDS_HoV)
  _RDS_AUX_FUNC(rdsVSInstallStruct,RDS_BHopI)
  _RDS_AUX_FUNC(rdsVSAddVarA,RDS_IHoISCSDwIS)
  _RDS_AUX_FUNC(rdsVSAddVarW,RDS_IHoIWsCWsDwIWs)
  _RDS_AUX_FUNC(rdsSetObjectStrA,RDS_VHoIIS)
  _RDS_AUX_FUNC(rdsSetObjectStrW,RDS_VHoIIWs)
  _RDS_AUX_FUNC(rdsVSApplyToBlock,RDS_BHoBhpI)
  _RDS_AUX_FUNC(rdsVSAddAutoConnA,RDS_IHoSS)
  _RDS_AUX_FUNC(rdsVSAddAutoConnW,RDS_IHoWsWs)
  _RDS_AUX_FUNC(rdsCommandObjectEx,RDS_BHoIIpI)
  _RDS_AUX_FUNC(rdsCommandObject,RDS_BHoI)
  _RDS_AUX_FUNC(rdsGetVarField,RDS_VhVhiVd)
  _RDS_AUX_FUNC(rdsFindStructVarA,RDS_VhSVd)
  _RDS_AUX_FUNC(rdsFindStructVarW,RDS_VhWsVd)
  _RDS_AUX_FUNC(rdsVSGetVarDescription,RDS_BHoIVd)
  _RDS_AUX_FUNC(rdsVSExecuteEditorA,RDS_BHoBDwIS)
  _RDS_AUX_FUNC(rdsVSExecuteEditorW,RDS_BHoBDwIWs)
  _RDS_AUX_FUNC(rdsGetObjectInt,RDS_IHoII)
  _RDS_AUX_FUNC(rdsGetObjectStrA,RDS_SHoII)
  _RDS_AUX_FUNC(rdsGetObjectStrW,RDS_WsHoII)
  _RDS_AUX_FUNC(rdsSetObjectInt,RDS_VHoIII)
  _RDS_AUX_FUNC(rdsCreateVarDescriptionStringA,RDS_SVhBIpI)
  _RDS_AUX_FUNC(rdsCreateVarDescriptionStringW,RDS_WsVhBIpI)
  _RDS_AUX_FUNC(rdsVSAddVarByDescrA,RDS_IHoIS)
  _RDS_AUX_FUNC(rdsVSAddVarByDescrW,RDS_IHoIWs)
  _RDS_AUX_FUNC(rdsVSCreateByDescrA,RDS_BHoS)
  _RDS_AUX_FUNC(rdsVSCreateByDescrW,RDS_BHoWs)
  _RDS_AUX_FUNC(rdsVSAddTypeRenameA,RDS_IHoSS)
  _RDS_AUX_FUNC(rdsVSAddTypeRenameW,RDS_IHoWsWs)
  _RDS_AUX_FUNC(rdscompGetModelData,RDS_MdChI)
  _RDS_AUX_FUNC(rdsApplicationIsActive,RDS_BV)
  _RDS_AUX_FUNC(rdsRegisterWindowA,RDS_BHwSHbHiS)
  _RDS_AUX_FUNC(rdsRegisterWindowW,RDS_BHwWsHbHiWs)
  _RDS_AUX_FUNC(rdsUnregisterWindow,RDS_VHw)
  _RDS_AUX_FUNC(rdsRegWinActivateNotify,RDS_VHw)
  _RDS_AUX_FUNC(rdsVSFindAutoConnA,RDS_SHoS)
  _RDS_AUX_FUNC(rdsVSFindAutoConnW,RDS_WsHoWs)
  _RDS_AUX_FUNC(rdscompGetModelBlock,RDS_BhMhIBd)
  _RDS_AUX_FUNC(rdsVSAddVarRenameA,RDS_IHoSS)
  _RDS_AUX_FUNC(rdsVSAddVarRenameW,RDS_IHoWsWs)
  _RDS_AUX_FUNC(rdsGetStructVar,RDS_VhIVd)
  _RDS_AUX_FUNC(rdsGetSystemInt,RDS_II)
  _RDS_AUX_FUNC(rdsVSUsesStructTypeA,RDS_BHoS)
  _RDS_AUX_FUNC(rdsVSUsesStructTypeW,RDS_BHoWs)
  _RDS_AUX_FUNC(rdsVarUsesStructTypeA,RDS_BVhS)
  _RDS_AUX_FUNC(rdsVarUsesStructTypeW,RDS_BVhWs)
  _RDS_AUX_FUNC(rdscompRenameModelA,RDS_BChSSB)
  _RDS_AUX_FUNC(rdscompRenameModelW,RDS_BChWsWsB)
  _RDS_AUX_FUNC(rdscompGetModelDataByNameA,RDS_MdChS)
  _RDS_AUX_FUNC(rdscompGetModelDataByNameW,RDS_MdChWs)
  _RDS_AUX_FUNC(rdscompCompileModel,RDS_BMhB)
  _RDS_AUX_FUNC(rdscompReturnModelNameA,RDS_VS)
  _RDS_AUX_FUNC(rdscompReturnModelNameW,RDS_VWs)
  _RDS_AUX_FUNC(rdsGetFullFilePathA,RDS_SSSpI)
  _RDS_AUX_FUNC(rdsGetFullFilePathW,RDS_WsWsWspI)
  _RDS_AUX_FUNC(rdsGetRelFilePathA,RDS_SSSpI)
  _RDS_AUX_FUNC(rdsGetRelFilePathW,RDS_WsWsWspI)
  _RDS_AUX_FUNC(rdsExecutePrintDialog,RDS_VBh)
  _RDS_AUX_FUNC(rdsChangeRegWinTitleA,RDS_VHwS)
  _RDS_AUX_FUNC(rdsChangeRegWinTitleW,RDS_VHwWs)
  _RDS_AUX_FUNC(rdsBCLAddBlock,RDS_IHoBhB)
  _RDS_AUX_FUNC(rdsBCLAddConn,RDS_IHoChB)
  _RDS_AUX_FUNC(rdsBCLExecuteGroupSetDialogA,RDS_VHoDwSB)
  _RDS_AUX_FUNC(rdsBCLExecuteGroupSetDialogW,RDS_VHoDwWsB)
  _RDS_AUX_FUNC(rdsIsRoot,RDS_BBh)
  _RDS_AUX_FUNC(rdsMessageBoxA,RDS_ISSI)
  _RDS_AUX_FUNC(rdsMessageBoxW,RDS_IWsWsI)
  _RDS_AUX_FUNC(rdscompReturnModelNameLabelA,RDS_VS)
  _RDS_AUX_FUNC(rdscompReturnModelNameLabelW,RDS_VWs)
  _RDS_AUX_FUNC(rdscompSetAltModelNameA,RDS_VMhS)
  _RDS_AUX_FUNC(rdscompSetAltModelNameW,RDS_VMhWs)
  _RDS_AUX_FUNC(rdsSTRCreateTextReader,RDS_HoB)
  _RDS_AUX_FUNC(rdsSTRAddKeywordA,RDS_IHoSI)
  _RDS_AUX_FUNC(rdsSTRAddKeywordW,RDS_IHoWsI)
  _RDS_AUX_FUNC(rdsSTRAddKeywordsArrayA,RDS_BHopSII)
  _RDS_AUX_FUNC(rdsSTRAddKeywordsArrayW,RDS_BHopWsII)
  _RDS_AUX_FUNC(rdsSTRGetWordA,RDS_IHopSpSpCB)
  _RDS_AUX_FUNC(rdsSTRGetWordW,RDS_IHopWspWsWsB)
  _RDS_AUX_FUNC(rdsWriteWordDoubleTextA,RDS_VSD)
  _RDS_AUX_FUNC(rdsWriteWordDoubleTextW,RDS_VWsD)
  _RDS_AUX_FUNC(rdsReadLineStyleText,RDS_ISpS)
  _RDS_AUX_FUNC(rdsSetBlockVarDefValueStrA,RDS_BBhIS)
  _RDS_AUX_FUNC(rdsSetBlockVarDefValueStrW,RDS_BBhIWs)
  _RDS_AUX_FUNC(rdsGetBlockVarDefValueStrA,RDS_SBhIpI)
  _RDS_AUX_FUNC(rdsGetBlockVarDefValueStrW,RDS_WsBhIpI)
  _RDS_AUX_FUNC(rdsRunWithoutEvents,RDS_BB)
  _RDS_AUX_FUNC(rdsXGFillRect,RDS_VIIII)
  _RDS_AUX_FUNC(rdsXGPolyline,RDS_VpPI)
  _RDS_AUX_FUNC(rdsXGRoundRect,RDS_VIIIIII)
  _RDS_AUX_FUNC(rdsSetPointPosition,RDS_BChIIIDw)
  _RDS_AUX_FUNC(rdsGetParentBlock,RDS_BhBhBd)
  _RDS_AUX_FUNC(rdsRenameBlockA,RDS_BBhSBd)
  _RDS_AUX_FUNC(rdsRenameBlockW,RDS_BBhWsBd)
  _RDS_AUX_FUNC(rdsVSGetVarDefValueStrA,RDS_SHoIpI)
  _RDS_AUX_FUNC(rdsVSGetVarDefValueStrW,RDS_WsHoIpI)
  _RDS_AUX_FUNC(rdsSetZoomPercent,RDS_VBhIII)
  _RDS_AUX_FUNC(rdsChangeMenuItemA,RDS_BMhSDwIDwII)
  _RDS_AUX_FUNC(rdsChangeMenuItemW,RDS_BMhWsDwIDwII)
  _RDS_AUX_FUNC(rdsResetSystemState,RDS_VBh)
  _RDS_AUX_FUNC(rdsINICreateTextHolder,RDS_HoB)
  _RDS_AUX_FUNC(rdsSetObjectDouble,RDS_VHoIID)
  _RDS_AUX_FUNC(rdsGetObjectDouble,RDS_DHoII)
  _RDS_AUX_FUNC(rdsINIOpenSectionA,RDS_BHoS)
  _RDS_AUX_FUNC(rdsINIOpenSectionW,RDS_BHoWs)
  _RDS_AUX_FUNC(rdsINIWriteIntA,RDS_VHoSI)
  _RDS_AUX_FUNC(rdsINIWriteIntW,RDS_VHoWsI)
  _RDS_AUX_FUNC(rdsINIReadIntA,RDS_IHoSI)
  _RDS_AUX_FUNC(rdsINIReadIntW,RDS_IHoWsI)
  _RDS_AUX_FUNC(rdsINIWriteDoubleA,RDS_VHoSD)
  _RDS_AUX_FUNC(rdsINIWriteDoubleW,RDS_VHoWsD)
  _RDS_AUX_FUNC(rdsINIReadDoubleA,RDS_DHoSD)
  _RDS_AUX_FUNC(rdsINIReadDoubleW,RDS_DHoWsD)
  _RDS_AUX_FUNC(rdsINIWriteStringA,RDS_VHoSS)
  _RDS_AUX_FUNC(rdsINIWriteStringW,RDS_VHoWsWs)
  _RDS_AUX_FUNC(rdsINIReadStringA,RDS_SHoSSpI)
  _RDS_AUX_FUNC(rdsINIReadStringW,RDS_WsHoWsWspI)
  _RDS_AUX_FUNC(rdscompAttachDifferentModelA,RDS_VSS)
  _RDS_AUX_FUNC(rdscompAttachDifferentModelW,RDS_VWsWs)
  _RDS_AUX_FUNC(rdscompSetBlockModelA,RDS_IBhSSSS)
  _RDS_AUX_FUNC(rdscompSetBlockModelW,RDS_IBhWsWsWsWs)
  _RDS_AUX_FUNC(rdscompGetBlockModelData,RDS_MdBh)
  _RDS_AUX_FUNC(rdscompOpenBlockModelEditor,RDS_IBh)
  _RDS_AUX_FUNC(rdsGetEditorWindowFlags,RDS_DwBh)
  _RDS_AUX_FUNC(rdsSetEditorWindowFlags,RDS_VBhDwDw)
  _RDS_AUX_FUNC(rdsEnumConnectedBlocksByVar,RDS_BhBhIDwCb1pV)
  _RDS_AUX_FUNC(rdsFORMCreateA,RDS_HoBIIS)
  _RDS_AUX_FUNC(rdsFORMCreateW,RDS_HoBIIWs)
  _RDS_AUX_FUNC(rdsFORMAddTabA,RDS_VHoIS)
  _RDS_AUX_FUNC(rdsFORMAddTabW,RDS_VHoIWs)
  _RDS_AUX_FUNC(rdsFORMAddEditA,RDS_VHoIIDwSI)
  _RDS_AUX_FUNC(rdsFORMAddEditW,RDS_VHoIIDwWsI)
  _RDS_AUX_FUNC(rdsProcessTextA,RDS_SSIpI)
  _RDS_AUX_FUNC(rdsProcessTextW,RDS_WsWsIpI)
  _RDS_AUX_FUNC(rdsSetBlockSetupFuncNameA,RDS_VBhS)
  _RDS_AUX_FUNC(rdsSetBlockSetupFuncNameW,RDS_VBhWs)
  _RDS_AUX_FUNC(rdsDynStrCatA,RDS_SSSB)
  _RDS_AUX_FUNC(rdsDynStrCatW,RDS_WsWsWsB)
  _RDS_AUX_FUNC(rdsIsValidVarNameA,RDS_BSI)
  _RDS_AUX_FUNC(rdsIsValidVarNameW,RDS_BWsI)
  _RDS_AUX_FUNC(rdsRegisterFuncProvider,RDS_IIB)
  _RDS_AUX_FUNC(rdsUnregisterFuncProvider,RDS_BI)
  _RDS_AUX_FUNC(rdsSubscribeToFuncProvider,RDS_BFl)
  _RDS_AUX_FUNC(rdsUnsubscribeFromFuncProvider,RDS_VI)
  _RDS_AUX_FUNC(rdsStartCalc,RDS_VV)
  _RDS_AUX_FUNC(rdsFORMShowModalEx,RDS_BHoCb3)
  _RDS_AUX_FUNC(rdsGetHugeDouble,RDS_BpD)
  _RDS_AUX_FUNC(rdsSetBlockFlags,RDS_VBhDwDw)
  _RDS_AUX_FUNC(rdsSetBlockVarFlags,RDS_BBhIDwDw)
  _RDS_AUX_FUNC(rdsShowBlockPanelTabA,RDS_VIS)
  _RDS_AUX_FUNC(rdsShowBlockPanelTabW,RDS_VIWs)
  _RDS_AUX_FUNC(rdsSetBlockAltNameTextA,RDS_VBhSI)
  _RDS_AUX_FUNC(rdsSetBlockAltNameTextW,RDS_VBhWsI)
  _RDS_AUX_FUNC(rdsExecuteCommandA,RDS_VIDwSS)
  _RDS_AUX_FUNC(rdsExecuteCommandW,RDS_VIDwWsWs)
  _RDS_AUX_FUNC(rdsSetSystemWindowRect,RDS_VBhIIIIB)
  _RDS_AUX_FUNC(rdsRegisterContextMenuItemA,RDS_MhSII)
  _RDS_AUX_FUNC(rdsRegisterContextMenuItemW,RDS_MhWsII)
  _RDS_AUX_FUNC(rdsEnableCommandQueue,RDS_VB)
  _RDS_AUX_FUNC(rdsSetSystemWindowCaptionA,RDS_VBhSB)
  _RDS_AUX_FUNC(rdsSetSystemWindowCaptionW,RDS_VBhWsB)
  _RDS_AUX_FUNC(rdsCopyRuntimeType,RDS_BpVpV)
  _RDS_AUX_FUNC(rdsClearRuntimeType,RDS_VpV)
  _RDS_AUX_FUNC(rdsPBARCreateA,RDS_HoIS)
  _RDS_AUX_FUNC(rdsPBARCreateW,RDS_HoIWs)
  _RDS_AUX_FUNC(rdsInputStringA,RDS_SSSSI)
  _RDS_AUX_FUNC(rdsInputStringW,RDS_WsWsWsWsI)
  _RDS_AUX_FUNC(rdsUnlockAndCall,RDS_BCb4pVI)
  _RDS_AUX_FUNC(rdsGetRemoteControllerStringA,RDS_SI)
  _RDS_AUX_FUNC(rdsGetRemoteControllerStringW,RDS_WsI)
  _RDS_AUX_FUNC(rdsGetRuntimeTypeDataA,RDS_pVpVpS)
  _RDS_AUX_FUNC(rdsGetRuntimeTypeDataW,RDS_pVpVpWs)
  _RDS_AUX_FUNC(rdsShowMainWindow,RDS_VB)
  _RDS_AUX_FUNC(rdsMainWindowVisible,RDS_BV)
  _RDS_AUX_FUNC(rdsAdditionalContextMenuItemA,RDS_VSBII)
  _RDS_AUX_FUNC(rdsAdditionalContextMenuItemW,RDS_VWsBII)
  _RDS_AUX_FUNC(rdsGetBlockFlags,RDS_DwBh)
  _RDS_AUX_FUNC(rdsSetRuntimeTypeA,RDS_pVpVS)
  _RDS_AUX_FUNC(rdsSetRuntimeTypeW,RDS_pVpVWs)
  _RDS_AUX_FUNC(rdsBringAppToFront,RDS_VV)
  _RDS_AUX_FUNC(rdsBlockModalWinOpen,RDS_VBh)
  _RDS_AUX_FUNC(rdsBlockModalWinClose,RDS_VBh)
  _RDS_AUX_FUNC(rdsModalWindowMustClose,RDS_BV)
  _RDS_AUX_FUNC(rdsExecMenuItem,RDS_VBhII)
  _RDS_AUX_FUNC(rdsGetLayerIdA,RDS_IBhS)
  _RDS_AUX_FUNC(rdsGetLayerIdW,RDS_IBhWs)
  _RDS_AUX_FUNC(rdsAddLayerA,RDS_IBhS)
  _RDS_AUX_FUNC(rdsAddLayerW,RDS_IBhWs)
  _RDS_AUX_FUNC(rdsSetBlockLayer,RDS_BBhI)
  _RDS_AUX_FUNC(rdsGetAppInstance,RDS_HiV)
  _RDS_AUX_FUNC(rdsModalWindowExists,RDS_BV)
  _RDS_AUX_FUNC(rdsEnumDynVarSubscribers,RDS_BhDvCb5pV)
  _RDS_AUX_FUNC(rdsNotifyDynVarSubscribers,RDS_VDv)
  _RDS_AUX_FUNC(rdsCancelPaste,RDS_VV)
  _RDS_AUX_FUNC(rdsdebugLogStringA,RDS_BSSB)
  _RDS_AUX_FUNC(rdsdebugLogStringW,RDS_BWsWsB)
  _RDS_AUX_FUNC(rdsGetObjectDoubleP,RDS_VHoIIpD)
  _RDS_AUX_FUNC(rdsINIReadDoublePA,RDS_VHoSDpD)
  _RDS_AUX_FUNC(rdsINIReadDoublePW,RDS_VHoWsDpD)
  _RDS_AUX_FUNC(rdsNetServerA,RDS_IISB)
  _RDS_AUX_FUNC(rdsNetServerW,RDS_IIWsB)
  _RDS_AUX_FUNC(rdsNetConnectA,RDS_ISISB)
  _RDS_AUX_FUNC(rdsNetConnectW,RDS_IWsIWsB)
  _RDS_AUX_FUNC(rdsNetCloseConnection,RDS_VI)
  _RDS_AUX_FUNC(rdsNetBroadcastDataA,RDS_BIDwISpVDw)
  _RDS_AUX_FUNC(rdsNetBroadcastDataW,RDS_BIDwIWspVDw)
  _RDS_AUX_FUNC(rdsNetSendDataA,RDS_BIDwISpVDwNsNb)
  _RDS_AUX_FUNC(rdsNetSendDataW,RDS_BIDwIWspVDwNsNb)
  _RDS_AUX_FUNC(rdsBlockVarToMem,RDS_pVBhIBpI)
  _RDS_AUX_FUNC(rdsBlockVarFromMem,RDS_BBhIpVI)
  _RDS_AUX_FUNC(rdsXGDrawStdIcon,RDS_VIIDw)
  _RDS_AUX_FUNC(rdsXGGetStdIconSize,RDS_BDwpIpI)
  _RDS_AUX_FUNC(rdsBlockMessageBoxA,RDS_IBhSSI)
  _RDS_AUX_FUNC(rdsBlockMessageBoxW,RDS_IBhWsWsI)
  _RDS_AUX_FUNC(rdsFORMShowModalServ,RDS_BHoCb6)
  _RDS_AUX_FUNC(rdsCallBlockFunctionDelayed,RDS_VBhIpVDw)
  _RDS_AUX_FUNC(rdsBroadcastFuncCallsDelayed,RDS_VBhIpVDwDw)
  _RDS_AUX_FUNC(rdsFORMEnableSidePanel,RDS_VHoII)
  _RDS_AUX_FUNC(rdsSetExclusiveCalc,RDS_BBhB)
  _RDS_AUX_FUNC(rdsListVarTypesA,RDS_SDwS)
  _RDS_AUX_FUNC(rdsListVarTypesW,RDS_WsDwWs)
  _RDS_AUX_FUNC(rdsCreateVarTypeTextA,RDS_SVh)
  _RDS_AUX_FUNC(rdsCreateVarTypeTextW,RDS_WsVh)
  _RDS_AUX_FUNC(rdsVSAddVarByTypeTextA,RDS_IHoISSDwS)
  _RDS_AUX_FUNC(rdsVSAddVarByTypeTextW,RDS_IHoIWsWsDwWs)
  _RDS_AUX_FUNC(rdsCopyVarGeneral,RDS_BVhpVVhpV)
  _RDS_AUX_FUNC(rdsSetBlockVarDefValueByCur,RDS_BBhI)
  _RDS_AUX_FUNC(rdsGetBlockVarBase,RDS_pVBhIpI)
  _RDS_AUX_FUNC(rdsVSCreateFromBlock,RDS_VHoBhB)
  _RDS_AUX_FUNC(rdsAtoIA,RDS_ISpI)
  _RDS_AUX_FUNC(rdsAtoIW,RDS_IWspI)
  _RDS_AUX_FUNC(rdsItoAA,RDS_SIII)
  _RDS_AUX_FUNC(rdsItoAW,RDS_WsIII)
  _RDS_AUX_FUNC(rdsAtoDA,RDS_VSpD)
  _RDS_AUX_FUNC(rdsAtoDW,RDS_VWspD)
  _RDS_AUX_FUNC(rdsDtoAA,RDS_SDIpI)
  _RDS_AUX_FUNC(rdsDtoAW,RDS_WsDIpI)
  _RDS_AUX_FUNC(rdsSetBlockModelA,RDS_BBhSS)
  _RDS_AUX_FUNC(rdsSetBlockModelW,RDS_BBhWsWs)
  _RDS_AUX_FUNC(rdsSetSystemInt,RDS_VII)
  _RDS_AUX_FUNC(rdsBEUCreate,RDS_HoBh)
  _RDS_AUX_FUNC(rdsXGSetPixel,RDS_VII)
  _RDS_AUX_FUNC(rdsGetMouseObjectId,RDS_IMd)
  _RDS_AUX_FUNC(rdsOpenSystemWindowEx,RDS_VBhBIIII)
  _RDS_AUX_FUNC(rdsSetSystemWindowBounds,RDS_VBhBIIII)
  _RDS_AUX_FUNC(rdsVarArrayIndexCheckA,RDS_BpVIIDwSS)
  _RDS_AUX_FUNC(rdsVarArrayIndexCheckW,RDS_BpVIIDwWsWs)
  _RDS_AUX_FUNC(rdsBadSystemTime,RDS_BV)
  _RDS_AUX_FUNC(rdsExecutesRemoteOpsSetA,RDS_VSB)
  _RDS_AUX_FUNC(rdsExecutesRemoteOpsSetW,RDS_VWsB)
  _RDS_AUX_FUNC(rdsSetLayerPosition,RDS_BBhIIII)
  _RDS_AUX_FUNC(rdsGetLayerParams,RDS_BBhIIpBpBpB)
  _RDS_AUX_FUNC(rdsSetLayerParams,RDS_BBhIIBBB)
  _RDS_AUX_FUNC(rdsSetBlockRect,RDS_VBhIIII)
  _RDS_AUX_FUNC(rdsGetConnDimensions,RDS_BChBrB)
  _RDS_AUX_FUNC(rdsSetConnLayer,RDS_BChI)
  _RDS_AUX_FUNC(rdsUpdateExtIdsRange,RDS_VV)
  _RDS_AUX_FUNC(rdsBlockOrConnByExtId,RDS_BBhDwFbei)
  _RDS_AUX_FUNC(rdsPANCreateA,RDS_HoIIIIIIS)
  _RDS_AUX_FUNC(rdsPANCreateW,RDS_HoIIIIIIWs)
  _RDS_AUX_FUNC(rdsPANGetDescr,RDS_BHoPnd)
  _RDS_AUX_FUNC(rdsGetEditorFontA,RDS_BBhIpLfDwpI)
  _RDS_AUX_FUNC(rdsGetEditorFontW,RDS_BBhIpLfwDwpI)
  _RDS_AUX_FUNC(rdsXGSetFontByParStrA,RDS_VpFsD)
  _RDS_AUX_FUNC(rdsXGSetFontByParStrW,RDS_VpFsD)
  _RDS_AUX_FUNC(rdsFontTextToStruct,RDS_BSpSpFs)
  _RDS_AUX_FUNC(rdsStructToFontTextA,RDS_SpFspI)
  _RDS_AUX_FUNC(rdsStructToFontTextW,RDS_WspFspI)
  _RDS_AUX_FUNC(rdsAddToDynStrA,RDS_VpSSB)
  _RDS_AUX_FUNC(rdsAddToDynStrW,RDS_VpWsWsB)
  _RDS_AUX_FUNC(rdsForceBlockRedraw,RDS_VBh)
  _RDS_AUX_FUNC(rdsRegisterContextMenuItemExA,RDS_MhSDwII)
  _RDS_AUX_FUNC(rdsRegisterContextMenuItemExW,RDS_MhWsDwII)
  _RDS_AUX_FUNC(rdsSetMenuItemOptions,RDS_VMhDw)
  _RDS_AUX_FUNC(rdsAdditionalContextMenuItemExA,RDS_VSDwII)
  _RDS_AUX_FUNC(rdsAdditionalContextMenuItemExW,RDS_VWsDwII)
  _RDS_AUX_FUNC(rdsQueueCallBlockFunction,RDS_VBhIpVDwDw)
  _RDS_AUX_FUNC(rdsGetBlockDimensionsEx,RDS_BBhBrDw)
  _RDS_AUX_FUNC(rdsDeleteSystemState,RDS_VI)
  _RDS_AUX_FUNC(rdsVSSetVarFlags,RDS_VHoIDwDw)
  _RDS_AUX_FUNC(rdsMakeUniqueBlockNameA,RDS_SBhS)
  _RDS_AUX_FUNC(rdsMakeUniqueBlockNameW,RDS_WsBhWs)
  _RDS_AUX_FUNC(rdsCSVCreate,RDS_HoV)
  _RDS_AUX_FUNC(rdsCSVSetItemA,RDS_VHoIIS)
  _RDS_AUX_FUNC(rdsCSVSetItemW,RDS_VHoIIWs)
  _RDS_AUX_FUNC(rdsCSVGetItemA,RDS_SHoII)
  _RDS_AUX_FUNC(rdsCSVGetItemW,RDS_WsHoII)
  _RDS_AUX_FUNC(rdsStringReplaceA,RDS_SSpSpSIDw)
  _RDS_AUX_FUNC(rdsStringReplaceW,RDS_WsWspWspWsIDw)
  _RDS_AUX_FUNC(rdsDynStrCopyA,RDS_SS)
  _RDS_AUX_FUNC(rdsDynStrCopyW,RDS_WsWs)
  _RDS_AUX_FUNC(rdsCallFileDialogA,RDS_SSDwSSS)
  _RDS_AUX_FUNC(rdsCallFileDialogW,RDS_WsWsDwWsWsWs)
  _RDS_AUX_FUNC(rdsCallDirDialogA,RDS_SSSB)
  _RDS_AUX_FUNC(rdsCallDirDialogW,RDS_WsWsWsB)
  _RDS_AUX_FUNC(rdsTransformFileNameA,RDS_SSDwSpI)
  _RDS_AUX_FUNC(rdsTransformFileNameW,RDS_WsWsDwWspI)
  _RDS_AUX_FUNC(rdsTMPCreateFileSet,RDS_IV)
  _RDS_AUX_FUNC(rdsTMPDeleteFileSet,RDS_VI)
  _RDS_AUX_FUNC(rdsTMPCreateEmptyFileA,RDS_SIS)
  _RDS_AUX_FUNC(rdsTMPCreateEmptyFileW,RDS_WsIWs)
  _RDS_AUX_FUNC(rdsTMPDeleteFileA,RDS_VS)
  _RDS_AUX_FUNC(rdsTMPDeleteFileW,RDS_VWs)
  _RDS_AUX_FUNC(rdsTMPRememberFileNameA,RDS_SIS)
  _RDS_AUX_FUNC(rdsTMPRememberFileNameW,RDS_WsIWs)
  _RDS_AUX_FUNC(rdsGetLayerIdInConfig,RDS_IBhII)
  _RDS_AUX_FUNC(rdsGetTextWordDynA,RDS_SSpSpCB)
  _RDS_AUX_FUNC(rdsGetTextWordDynW,RDS_WsSpSpCB)
  _RDS_AUX_FUNC(rdsCEAddChannelA,RDS_BHoSCSI)
  _RDS_AUX_FUNC(rdsCEAddChannelW,RDS_BHoWsCWsI)
  _RDS_AUX_FUNC(rdsReportToolInfoA,RDS_VS)
  _RDS_AUX_FUNC(rdsReportToolInfoW,RDS_VWs)
  _RDS_AUX_FUNC(rdsSetToolTimer,RDS_VDw)
  _RDS_AUX_FUNC(rdsExecToolA,RDS_IDwSSIS)
  _RDS_AUX_FUNC(rdsExecToolW,RDS_IDwWsWsIWs)
  _RDS_AUX_FUNC(rdsSaveSystemBitmapA,RDS_BS1d)
  _RDS_AUX_FUNC(rdsSaveSystemBitmapW,RDS_BS1d)
  _RDS_AUX_FUNC(rdsPictureObjectDimensions,RDS_BIDwBr)
  _RDS_AUX_FUNC(rdsSuspendCalc,RDS_BBhB)
  _RDS_AUX_FUNC(rdsServiceVersionDate,RDS_DwV)
  _RDS_AUX_FUNC(rdsReportVersion,RDS_VIDw)
  _RDS_AUX_FUNC(rdsVSCompare,RDS_BHoHoDw)
  _RDS_AUX_FUNC(rdsGetBlockVarTypeStringA,RDS_SBh)
  _RDS_AUX_FUNC(rdsGetBlockVarTypeStringW,RDS_WsBh)
  _RDS_AUX_FUNC(rdsBLOBStartWrite,RDS_VIIB)
  _RDS_AUX_FUNC(rdsBLOBWrite,RDS_BpVI)
  _RDS_AUX_FUNC(rdsBLOBEndWrite,RDS_VV)
  _RDS_AUX_FUNC(rdsBLOBStartRead,RDS_BII)
  _RDS_AUX_FUNC(rdsBLOBRead,RDS_BpVI)
  _RDS_AUX_FUNC(rdsBLOBEndRead,RDS_VV)
  _RDS_AUX_FUNC(rdsGetIOBlockByVarNum,RDS_BhBhIBd)
  _RDS_AUX_FUNC(rdsSetEditorWorkspace,RDS_BBhII)
  _RDS_AUX_FUNC(rdsShowHelpA,RDS_ISSB)
  _RDS_AUX_FUNC(rdsShowHelpW,RDS_IWsWsB)
  _RDS_AUX_FUNC(rdsShowHelpFileA,RDS_ISSB)
  _RDS_AUX_FUNC(rdsShowHelpFileW,RDS_IWsWsB)
  _RDS_AUX_FUNC(rdsRegisterConnExtParamNameA,RDS_IS)
  _RDS_AUX_FUNC(rdsRegisterConnExtParamNameW,RDS_IWs)
  _RDS_AUX_FUNC(rdsGetConnExtParamsCount,RDS_ICh)
  _RDS_AUX_FUNC(rdsGetConnExtParamByNumA,RDS_IChIpSpIpIpDpS)
  _RDS_AUX_FUNC(rdsGetConnExtParamByNumW,RDS_IChIpWspIpIpDpWs)
  _RDS_AUX_FUNC(rdsGetConnExtParamByIdA,RDS_IChIpIpDpS)
  _RDS_AUX_FUNC(rdsGetConnExtParamByIdW,RDS_IChIpIpDpWs)
  _RDS_AUX_FUNC(rdsSetConnExtParamByIdA,RDS_BChIIIDS)
  _RDS_AUX_FUNC(rdsSetConnExtParamByIdW,RDS_BChIIIDWs)
  _RDS_AUX_FUNC(rdsConnSetupMenuNameA,RDS_VS)
  _RDS_AUX_FUNC(rdsConnSetupMenuNameW,RDS_VWs)
  _RDS_AUX_FUNC(rdsEnumDynVarsA,RDS_IBhDwCb7pV)
  _RDS_AUX_FUNC(rdsEnumDynVarsW,RDS_IBhDwCb7wpV)
  _RDS_AUX_FUNC(rdsGetConnExtParamByNumExA,RDS_IChIpSpIpIpDpSpDw)
  _RDS_AUX_FUNC(rdsGetConnExtParamByNumExW,RDS_IChIpWspIpIpDpWspDw)
  _RDS_AUX_FUNC(rdsGetConnExtParamByIdExA,RDS_IChIpIpDpSpDw)
  _RDS_AUX_FUNC(rdsGetConnExtParamByIdExW,RDS_IChIpIpDpWspDw)
  _RDS_AUX_FUNC(rdsSetConnExtParamByIdExA,RDS_BChIIIDSDw)
  _RDS_AUX_FUNC(rdsSetConnExtParamByIdExW,RDS_BChIIIDWsDw)
  _RDS_AUX_FUNC(rdsCallSaveAsDialog,RDS_BV)
  _RDS_AUX_FUNC(rdsSetObjectPtrA,RDS_VHoISpV)
  _RDS_AUX_FUNC(rdsSetObjectPtrW,RDS_VHoIWspV)
  _RDS_AUX_FUNC(rdsGetObjectPtrA,RDS_pVHoIpS)
  _RDS_AUX_FUNC(rdsGetObjectPtrW,RDS_pVHoIpWs)
  _RDS_AUX_FUNC(rdsExchangeVarArrays,RDS_BpVpV)
  _RDS_AUX_FUNC(rdsGetVarArrayElementType,RDS_IpV)
  _RDS_AUX_FUNC(rdsCopySelectedToMem,RDS_pVBhpIDw)
  _RDS_AUX_FUNC(rdsSelectConn,RDS_VChBB)
  _RDS_AUX_FUNC(rdsSelectAll,RDS_VBhBB)
  _RDS_AUX_FUNC(rdsPasteFromMem,RDS_BBhpVIDw)
  _RDS_AUX_FUNC(rdsDeleteSelected,RDS_VBhB)
  _RDS_AUX_FUNC(rdsCEUCreate,RDS_HoCh)
  _RDS_AUX_FUNC(rdsSubscribeToContentChange,RDS_VB)
  _RDS_AUX_FUNC(rdsUnsubscribeFromContentChange,RDS_VV)
  _RDS_AUX_FUNC(rdsSetSysModifiedFlag,RDS_VBhB)
  _RDS_AUX_FUNC(rdsTMPForgetFileNameA,RDS_BIS)
  _RDS_AUX_FUNC(rdsTMPForgetFileNameW,RDS_BIWs)
  _RDS_AUX_FUNC(rdscompGetModelModuleData,RDS_CdCh)
  _RDS_AUX_FUNC(rdscompIsEditorOpen,RDS_BMh)
  _RDS_AUX_FUNC(rdsExclusiveFileOpA,RDS_VSDw)
  _RDS_AUX_FUNC(rdsExclusiveFileOpW,RDS_VWsDw)
  _RDS_AUX_FUNC(rdsInfoMessageA,RDS_VSS)
  _RDS_AUX_FUNC(rdsInfoMessageW,RDS_VWsWs)
  _RDS_AUX_FUNC(rdscompCompileAll,RDS_BB)
  _RDS_AUX_FUNC(rdsVSCreateAutoConnsByDescrA,RDS_BHoS)
  _RDS_AUX_FUNC(rdsVSCreateAutoConnsByDescrW,RDS_BHoWs)
  _RDS_AUX_FUNC(rdscompLibraryOperation,RDS_BLop)
  _RDS_AUX_FUNC(rdsStoreTempGlobalA,RDS_VSSISpVDw)
  _RDS_AUX_FUNC(rdsStoreTempGlobalW,RDS_VWsWsIWspVDw)
  _RDS_AUX_FUNC(rdsReadTempGlobalA,RDS_BSSpIpSppVpDw)
  _RDS_AUX_FUNC(rdsReadTempGlobalW,RDS_BWsWspIpWsppVpDw)
  _RDS_AUX_FUNC(rdsDeleteConnExtParamById,RDS_BChI)
  _RDS_AUX_FUNC(rdsExecToolExtA,RDS_IDwSSS2)
  _RDS_AUX_FUNC(rdsExecToolExtW,RDS_IDwWsWsS2)
  _RDS_AUX_FUNC(rdsClearExecToolExtResults,RDS_VS2)
  _RDS_AUX_FUNC(rdsCountSelectedObjects,RDS_BBhpIpI)
  _RDS_AUX_FUNC(rdsFORMHelpButtonA,RDS_VHoDwSS)
  _RDS_AUX_FUNC(rdsFORMHelpButtonW,RDS_VHoDwWsWs)
  _RDS_AUX_FUNC(rdsRegisterUserNameSetA,RDS_IS)
  _RDS_AUX_FUNC(rdsRegisterUserNameSetW,RDS_IWs)
  _RDS_AUX_FUNC(rdsRegisterUserNameA,RDS_IIS)
  _RDS_AUX_FUNC(rdsRegisterUserNameW,RDS_IIWs)
  _RDS_AUX_FUNC(rdsGetRegisteredUserNameA,RDS_SII)
  _RDS_AUX_FUNC(rdsGetRegisteredUserNameW,RDS_WsII)
  _RDS_AUX_FUNC(rdsGetBlockVarOffset,RDS_IBhIpI)
  _RDS_AUX_FUNC(rdsRegisterGlobalIntVarA,RDS_pIS)
  _RDS_AUX_FUNC(rdsRegisterGlobalIntVarW,RDS_pIWs)
  _RDS_AUX_FUNC(rdscompForceModelNextCompile,RDS_VMhB)
  _RDS_AUX_FUNC(rdsDoInitialCalc,RDS_VBhDw)
  _RDS_AUX_FUNC(rdsShiftBakFileChainA,RDS_BSIS)
  _RDS_AUX_FUNC(rdsShiftBakFileChainW,RDS_BWsIWs)
  _RDS_AUX_FUNC(rdsGetBlockTextRectParams,RDS_BBhpBtrpFs)
  _RDS_AUX_FUNC(rdsSetBlockTextRectParamsA,RDS_BBhpBtrpFsDw)
  _RDS_AUX_FUNC(rdsSetBlockTextRectParamsW,RDS_BBhpBtrpFsDw)
  _RDS_AUX_FUNC(rdsINTCreate,RDS_HoB)
  _RDS_AUX_FUNC(rdsSCEUCreate,RDS_HoBh)
  _RDS_AUX_FUNC(rdsSCEUSaveBlock,RDS_VHoBhDw)
  _RDS_AUX_FUNC(rdsSCEUSaveConn,RDS_VHoChDw)
  _RDS_AUX_FUNC(rdsExecToolDelayedA,RDS_VDwSSS)
  _RDS_AUX_FUNC(rdsExecToolDelayedW,RDS_VDwWsWsWs)
  _RDS_AUX_FUNC(rdsLockDrawUpdates,RDS_BBhDw)
  _RDS_AUX_FUNC(rdsXGDrawBitmap,RDS_VIIHb)
  _RDS_AUX_FUNC(rdsGetEditorWinAndScroll,RDS_BBhpIpIpIpIpIpI)
  _RDS_AUX_FUNC(rdsGBLCreateA,RDS_HoS)
  _RDS_AUX_FUNC(rdsGBLCreateW,RDS_HoWs)
  _RDS_AUX_FUNC(rdsGBLBlockOp,RDS_VHoBhDw)
  _RDS_AUX_FUNC(rdsGBLGetBlock,RDS_BhHoI)
  _RDS_AUX_FUNC(rdsGBLBroadcastFunctionCalls,RDS_IHoIpVDw)
  _RDS_AUX_FUNC(rdsXGDrawStdIconDC,RDS_VDcIIDw)
  _RDS_AUX_FUNC(rdsInvalidateSystemWindows,RDS_VBhB)
  _RDS_AUX_FUNC(rdsSaveBlockToFileA,RDS_BBhSDwS)
  _RDS_AUX_FUNC(rdsSaveBlockToFileW,RDS_BBhWsDwWs)
  _RDS_AUX_FUNC(rdsSetBlockOrder,RDS_BhIBh)
  _RDS_AUX_FUNC(rdsSetConnOrder,RDS_ChICh)
  _RDS_AUX_FUNC(rdsSetConnTextA,RDS_BChDwSIBII)
  _RDS_AUX_FUNC(rdsSetConnTextW,RDS_BChDwWsIBII)
  _RDS_AUX_FUNC(rdscompCompileBlockModelDelayed,RDS_VBhB)
  _RDS_AUX_FUNC(rdsFileExistsA,RDS_BSSpSpI)
  _RDS_AUX_FUNC(rdsFileExistsW,RDS_BWsWspWspI)
  _RDS_AUX_FUNC(rdsBlockStateToBuffer,RDS_pVBhpDw)
  _RDS_AUX_FUNC(rdsBlockStateFromBuffer,RDS_BBhpVDw)
  _RDS_AUX_FUNC(rdsCreateSharedMemPlainA,RDS_SmISDw)
  _RDS_AUX_FUNC(rdsCreateSharedMemPlainW,RDS_SmIWsDw)
  _RDS_AUX_FUNC(rdsCreateSharedMemVarA,RDS_SmISS)
  _RDS_AUX_FUNC(rdsCreateSharedMemVarW,RDS_SmIWsWs)
  _RDS_AUX_FUNC(rdsDeleteSharedMem,RDS_VSm)
  _RDS_AUX_FUNC(rdsNotifySharedMemUsers,RDS_VSm)
  _RDS_AUX_FUNC(rdsEnumSharedMemUsers,RDS_BhSmCb8pV)
  _RDS_AUX_FUNC(rdsTranslateParameterA,RDS_SSIISpI)
  _RDS_AUX_FUNC(rdsTranslateParameterW,RDS_WsWsIIWspI)
  _RDS_AUX_FUNC(rdsTranslateTextA,RDS_SSIpI)
  _RDS_AUX_FUNC(rdsTranslateTextW,RDS_WsWsIpI)
  _RDS_AUX_FUNC(rdsSetConnTextExA,RDS_BChDwSIBIIB)
  _RDS_AUX_FUNC(rdsSetConnTextExW,RDS_BChDwWsIBIIB)
  _RDS_AUX_FUNC(rdsGetLayerConfigId,RDS_DwBhI)
  _RDS_AUX_FUNC(rdsGetLayerConfigNumById,RDS_IBhDw)
  _RDS_AUX_FUNC(rdsFORMTBLSetStrA,RDS_VHoIIIS)
  _RDS_AUX_FUNC(rdsFORMTBLSetStrW,RDS_VHoIIIWs)
  _RDS_AUX_FUNC(rdsFORMTBLGetStrA,RDS_SHoIIIpB)
  _RDS_AUX_FUNC(rdsFORMTBLGetStrW,RDS_WsHoIIIpB)
  _RDS_AUX_FUNC(rdsFORMTBLSetHeaderA,RDS_VHoIISDwI)
  _RDS_AUX_FUNC(rdsFORMTBLSetHeaderW,RDS_VHoIIWsDwI)
  _RDS_AUX_FUNC(rdsFORMTBLSetInt,RDS_VHoIIII)
  _RDS_AUX_FUNC(rdsFORMTBLGetInt,RDS_IHoIIIpB)
  _RDS_AUX_FUNC(rdsFORMTBLSetDouble,RDS_VHoIIID)
  _RDS_AUX_FUNC(rdsFORMTBLGetDouble,RDS_DHoIIIpB)
  _RDS_AUX_FUNC(rdsFORMTBLGetDoubleP,RDS_BHoIIIpD)
  _RDS_AUX_FUNC(rdsFORMTBLMoveLine,RDS_BHoIII)
  _RDS_AUX_FUNC(rdsCreateSystemA,RDS_BhBhSIIBhDw)
  _RDS_AUX_FUNC(rdsCreateSystemW,RDS_BhBhWsIIBhDw)
  _RDS_AUX_FUNC(rdsNetListServerChannelsA,RDS_SI)
  _RDS_AUX_FUNC(rdsNetListServerChannelsW,RDS_WsI)
  _RDS_AUX_FUNC(rdsNetListChannelsA,RDS_SSI)
  _RDS_AUX_FUNC(rdsNetListChannelsW,RDS_WsWsI)
  _RDS_AUX_FUNC(rdsCreateBlockA,RDS_BhBhISII)
  _RDS_AUX_FUNC(rdsCreateBlockW,RDS_BhBhIWsII)
  _RDS_AUX_FUNC(rdsCESetInternalPoint,RDS_IHoIII)
  _RDS_AUX_FUNC(rdsCESetBlockPointA,RDS_IHoIBhSIIDwII)
  _RDS_AUX_FUNC(rdsCESetBlockPointW,RDS_IHoIBhWsIIDwII)
  _RDS_AUX_FUNC(rdsCESetBusPointA,RDS_IHoIChSBIIDwII)
  _RDS_AUX_FUNC(rdsCESetBusPointW,RDS_IHoIChWsBIIDwII)
  _RDS_AUX_FUNC(rdsCESetLine,RDS_IHoIII)
  _RDS_AUX_FUNC(rdsCESetBezier,RDS_IHoIIIIIII)
  _RDS_AUX_FUNC(rdsCEReadConnBus,RDS_BHoCh)
  _RDS_AUX_FUNC(rdsCEGetPointDescription,RDS_BHoIPd)
  _RDS_AUX_FUNC(rdsCEGetLineDescription,RDS_BHoILd)
  // 1.0.494
  _RDS_AUX_FUNC(rdsEnumConnectedBuses,RDS_ChChDwCb9pV)
  _RDS_AUX_FUNC(rdsBusChannelNameByNumA,RDS_SChI)
  _RDS_AUX_FUNC(rdsBusChannelNameByNumW,RDS_WsChI)
  _RDS_AUX_FUNC(rdsEnumBusLinks,RDS_ChChIDwCb10pV)
  // 1.0.496
  _RDS_AUX_FUNC(rdsGetBusChannelParamsA,RDS_BChIpSpCpSpDwpIpS)
  _RDS_AUX_FUNC(rdsGetBusChannelParamsW,RDS_BChIpWspCpWspDwpIpWs)
  _RDS_AUX_FUNC(rdsGetSystemPtr,RDS_pVIIpV)
  // 1.0.497
  _RDS_AUX_FUNC(rdsCompareVarGeneral,RDS_BVhpVVhpVD)
  _RDS_AUX_FUNC(rdsEnumExternalDynVarsA,RDS_IBhDwCb7pV)
  _RDS_AUX_FUNC(rdsEnumExternalDynVarsW,RDS_IBhDwCb7wpV)
  // 1.0.498
  _RDS_AUX_FUNC(rdsEnumDynVarsExA,RDS_IBhDwCb11pV)
  _RDS_AUX_FUNC(rdsEnumDynVarsExW,RDS_IBhDwCb11wpV)
  _RDS_AUX_FUNC(rdsEnumExternalDynVarsExA,RDS_IBhDwCb11pV)
  _RDS_AUX_FUNC(rdsEnumExternalDynVarsExW,RDS_IBhDwCb11wpV)
  _RDS_AUX_FUNC(rdsGetVarParamsA,RDS_BVhpSpCpSpDwpIpS)
  _RDS_AUX_FUNC(rdsGetVarParamsW,RDS_BVhpWspCpWspDwpIpWs)
  _RDS_AUX_FUNC(rdsVarTypeTextByParamsA,RDS_SCSDwI)
  _RDS_AUX_FUNC(rdsVarTypeTextByParamsW,RDS_WsCWsDwI)
  _RDS_AUX_FUNC(rdsVarParamsByTypeTextA,RDS_BSpCpSpDwpI)
  _RDS_AUX_FUNC(rdsVarParamsByTypeTextW,RDS_BWspCpWspDwpI)
  _RDS_AUX_FUNC(rdsBlockVarCompareMem,RDS_BBhIpVID)
  // 1.0.499
  _RDS_AUX_FUNC(rdsFORMTBLSetColTextListA,RDS_VHoIIS)
  _RDS_AUX_FUNC(rdsFORMTBLSetColTextListW,RDS_VHoIIWs)
  _RDS_AUX_FUNC(rdsFORMTBLSetColDefValueA,RDS_VHoIIS)
  _RDS_AUX_FUNC(rdsFORMTBLSetColDefValueW,RDS_VHoIIWs)
  // 1.0.500
  _RDS_AUX_FUNC(rdsFORMTBLSetServFunc,RDS_VHoICb6)
  // 1.0.504
  _RDS_AUX_FUNC(rdsCWCreateA,RDS_HoBhSIICwDw)
  _RDS_AUX_FUNC(rdsCWCreateW,RDS_HoBhWsIICwDw)
  // 1.0.505
  _RDS_AUX_FUNC(rdsCWGetParameters,RDS_BHoCw)
  _RDS_AUX_FUNC(rdsCWCreateCopyA,RDS_HoBhSIIDwHo)
  _RDS_AUX_FUNC(rdsCWCreateCopyW,RDS_HoBhWsIIDwHo)
  // 1.0.508
  _RDS_AUX_FUNC(rdsCWTranslateChanges,RDS_BHoHo)
  // 1.0.511
  _RDS_AUX_FUNC(rdsForceDirectoriesA,RDS_BSDw)
  _RDS_AUX_FUNC(rdsForceDirectoriesW,RDS_BWsDw)
  // 1.0.512
  _RDS_AUX_FUNC(rdsResetAllBlockSignals,RDS_VBhI)
  // 1.0.514
  _RDS_AUX_FUNC(rdsGetUICurrentModA,RDS_SSFt)
  _RDS_AUX_FUNC(rdsGetUICurrentModW,RDS_WsWsFt)
  _RDS_AUX_FUNC(rdsUIMODCreate,RDS_HoV)
  _RDS_AUX_FUNC(rdsUIMODLoadGroupA,RDS_BHoSS)
  _RDS_AUX_FUNC(rdsUIMODLoadGroupW,RDS_BHoWsWs)
  _RDS_AUX_FUNC(rdsUIMODGetParamStringA,RDS_SHoSIS)
  _RDS_AUX_FUNC(rdsUIMODGetParamStringW,RDS_WsHoWsIWs)
  _RDS_AUX_FUNC(rdsUIMODGetParamStrByNumA,RDS_SHoSIpIS)
  _RDS_AUX_FUNC(rdsUIMODGetParamStrByNumW,RDS_WsHoWsIpIWs)
  _RDS_AUX_FUNC(rdsGetUIModsListA,RDS_SS)
  _RDS_AUX_FUNC(rdsGetUIModsListW,RDS_WsWs)
  _RDS_AUX_FUNC(rdsUIMODGetParamStrByNameA,RDS_SHoSSS)
  _RDS_AUX_FUNC(rdsUIMODGetParamStrByNameW,RDS_WsHoWsWsWs)
  _RDS_AUX_FUNC(rdsUIMODSetParamStrByNameA,RDS_VHoSSS)
  _RDS_AUX_FUNC(rdsUIMODSetParamStrByNameW,RDS_VHoWsWsWs)
  // 1.0.516
  _RDS_AUX_FUNC(rdsBMPCreateA,RDS_HoS)
  _RDS_AUX_FUNC(rdsBMPCreateW,RDS_HoWs)
  _RDS_AUX_FUNC(rdsBMPDraw,RDS_VHoII)
  _RDS_AUX_FUNC(rdsBMPStretchDraw,RDS_VHoIIII)
  // 1.0.519
  _RDS_AUX_FUNC(rdsUIMODLoadSingleObjectA,RDS_BHoSSS)
  _RDS_AUX_FUNC(rdsUIMODLoadSingleObjectW,RDS_BHoWsWsWs)
  _RDS_AUX_FUNC(rdsUIMODGetParamListStringA,RDS_SHoSIS)
  _RDS_AUX_FUNC(rdsUIMODGetParamListStringW,RDS_WsHoWsIWs)
  // 1.0.520
  _RDS_AUX_FUNC(rdsThisIsDebugVersion,RDS_VV)
  // 1.0.538
  _RDS_AUX_FUNC(rdsVSCreateFromConnA,RDS_VHoChS)
  _RDS_AUX_FUNC(rdsVSCreateFromConnW,RDS_VHoChWs)
  // 1.0.542
  _RDS_AUX_FUNC(rdsSGPRegisterNameA,RDS_IS)
  _RDS_AUX_FUNC(rdsSGPRegisterNameW,RDS_IWs)
  _RDS_AUX_FUNC(rdsSGPSetDataA,RDS_BSgp)
  _RDS_AUX_FUNC(rdsSGPSetDataW,RDS_BSgp)
  _RDS_AUX_FUNC(rdsSGPGetDataA,RDS_BSgp)
  _RDS_AUX_FUNC(rdsSGPGetDataW,RDS_BSgp)
  _RDS_AUX_FUNC(rdsSGPDelete,RDS_BI)
  _RDS_AUX_FUNC(rdsSGPGetDataByNum,RDS_BISgp)
  // 1.0.544
  _RDS_AUX_FUNC(rdsAtoDwA,RDS_DwSpI)
  _RDS_AUX_FUNC(rdsAtoDwW,RDS_DwWspI)
  _RDS_AUX_FUNC(rdsDwtoAA,RDS_SDwII)
  _RDS_AUX_FUNC(rdsDwtoAW,RDS_WsDwII)
  // 1.0.545
  _RDS_AUX_FUNC(rdsRegisterFuncCallMenuItemA,RDS_ISDwIDwII)
  _RDS_AUX_FUNC(rdsRegisterFuncCallMenuItemW,RDS_IWsDwIDwII)
  _RDS_AUX_FUNC(rdsUnregisterFuncCallMenuItem,RDS_BI)
  _RDS_AUX_FUNC(rdsChangeFuncCallMenuItemA,RDS_BISDwIDw)
  _RDS_AUX_FUNC(rdsChangeFuncCallMenuItemW,RDS_BIWsDwIDw)
  _RDS_AUX_FUNC(rdsSetFuncCallMenuItemFlags,RDS_VIDw)
  _RDS_AUX_FUNC(rdsIncompatibleDll,RDS_VV)
  // 1.0.546
  _RDS_AUX_FUNC(rdsNetGetServerConnectionData,RDS_IIIINgsc)
  _RDS_AUX_FUNC(rdsNetGetServerStationConnIndex,RDS_IINsNgsc)
  // 1.0.552
  _RDS_AUX_FUNC(rdsGetBlockClass,RDS_IBhI)
  _RDS_AUX_FUNC(rdsGetConnectionClass,RDS_IChI)
  _RDS_AUX_FUNC(rdsGetObjectClassNameA,RDS_SI)
  _RDS_AUX_FUNC(rdsGetObjectClassNameW,RDS_WsI)
  _RDS_AUX_FUNC(rdsIsClassVisible,RDS_BBhII)
  _RDS_AUX_FUNC(rdsGetConnectionFlags,RDS_DwCh)
  _RDS_AUX_FUNC(rdsSetConnectionFlags,RDS_VChDwDw)
  // 1.0.553
  _RDS_AUX_FUNC(rdsSearchConnErrors,RDS_BChBhB)
  // 1.0.554
  _RDS_AUX_FUNC(rdsSortVarArray,RDS_VpVIDw)
  // 1.0.558
  _RDS_AUX_FUNC(rdsSetZoomPercentDbl,RDS_VBhDII)
  // 1.0.561
  _RDS_AUX_FUNC(rdsBringAppToFrontEx,RDS_VI)
  // 1.0.563
  _RDS_AUX_FUNC(rdsShowSeeAlsoExamplesA,RDS_ISSB)
  _RDS_AUX_FUNC(rdsShowSeeAlsoExamplesW,RDS_IWsWsB)
  // 1.0.566
  _RDS_AUX_FUNC(rdsCanEditSystem,RDS_BBh)
  // 1.0.568
  _RDS_AUX_FUNC(rdsFORMMakeSearchA,RDS_VHoBIS)
  _RDS_AUX_FUNC(rdsFORMMakeSearchW,RDS_VHoBIWs)
  _RDS_AUX_FUNC(rdsFORMAddSearchResultA,RDS_VHoSS)
  _RDS_AUX_FUNC(rdsFORMAddSearchResultW,RDS_VHoWsWs)
  _RDS_AUX_FUNC(rdsFORMGetSearchResultA,RDS_BHoIpSpS)
  _RDS_AUX_FUNC(rdsFORMGetSearchResultW,RDS_BHoIpWspWs)
  // 1.0.571
  _RDS_AUX_FUNC(rdsBMPCreateExA,RDS_HoSIII)
  _RDS_AUX_FUNC(rdsBMPCreateExW,RDS_HoWsIII)
  // 1.0.572
  _RDS_AUX_FUNC(rdsFORMTBLExchangeLines,RDS_BHoIII)
  // 1.0.584
  _RDS_AUX_FUNC(rdsGetObjectClassId,RDS_II)
  _RDS_AUX_FUNC(rdsBlockBelongsToClass,RDS_BBhI)
  _RDS_AUX_FUNC(rdsConnBelongsToClass,RDS_BChI)
  // 1.0.585
  _RDS_AUX_FUNC(rdsVSExecuteEditorExA,RDS_BHoBDwISCb12Cb12)
  _RDS_AUX_FUNC(rdsVSExecuteEditorExW,RDS_BHoBDwIWsCb12wCb12w)
  _RDS_AUX_FUNC(rdsPICCreate,RDS_HoBh)
  _RDS_AUX_FUNC(rdsVarToMem,RDS_pVVhpVBpI)
  _RDS_AUX_FUNC(rdsVarFromMem,RDS_BVhpVpVI)
  // 1.0.586
  _RDS_AUX_FUNC(rdsVSGetVarParamsA,RDS_BHoIpSpCpSpDwpIpS)
  _RDS_AUX_FUNC(rdsVSGetVarParamsW,RDS_BHoIpWspCpWspDwpIpWs)
  _RDS_AUX_FUNC(rdsCreateVarTypeStringA,RDS_SVh)
  _RDS_AUX_FUNC(rdsCreateVarTypeStringW,RDS_WsVh)
  _RDS_AUX_FUNC(rdsFindBlockVarIndexA,RDS_IBhSVdpI)
  _RDS_AUX_FUNC(rdsFindBlockVarIndexW,RDS_IBhWsVdpI)
  _RDS_AUX_FUNC(rdsMatchesMaskA,RDS_BSSB)
  _RDS_AUX_FUNC(rdsMatchesMaskW,RDS_BWsWsB)
  // 1.0.587
  _RDS_AUX_FUNC(rdsGetBlockConnPoint,RDS_ChBhIBBPd)
  _RDS_AUX_FUNC(rdsIsHugeDoubleSafe,RDS_BpD)
  // 1.0.589
  _RDS_AUX_FUNC(rdsVarArrayOp,RDS_BpVpVIIIII)
  // 1.0.597
  _RDS_AUX_FUNC(rdsIsValidVarNameRemA,RDS_BSIB)
  _RDS_AUX_FUNC(rdsIsValidVarNameRemW,RDS_BWsIB)
  // 1.0.602
  _RDS_AUX_FUNC(rdsConsoleWindowOpA,RDS_HwIIS)
  _RDS_AUX_FUNC(rdsConsoleWindowOpW,RDS_HwIIWs)
  // 1.0.603
  _RDS_AUX_FUNC(rdsVNCreateNameValidatorA,RDS_HoDwS)
  _RDS_AUX_FUNC(rdsVNCreateNameValidatorW,RDS_HoDwWs)
  _RDS_AUX_FUNC(rdsVNCheckA,RDS_IHoS)
  _RDS_AUX_FUNC(rdsVNCheckW,RDS_IHoWs)
  _RDS_AUX_FUNC(rdsVNValidateA,RDS_SHoSpI)
  _RDS_AUX_FUNC(rdsVNValidateW,RDS_WsHoWspI)
  _RDS_AUX_FUNC(rdsGetObjectPtrCheckA,RDS_pVHoIS)
  _RDS_AUX_FUNC(rdsGetObjectPtrCheckW,RDS_pVHoIWs)
  _RDS_AUX_FUNC(rdsVSApplyVarRenames,RDS_BHoBh)
  _RDS_AUX_FUNC(rdsGetBlockType,RDS_IBh)
  _RDS_AUX_FUNC(rdsGetExtId,RDS_DwBhCh)
  // 1.0.604
  _RDS_AUX_FUNC(rdsFORMTBLSortTable,RDS_IHoIBpIII)
  _RDS_AUX_FUNC(rdsBCLGetBlockIndex,RDS_IHoBh)
  _RDS_AUX_FUNC(rdsBCLGetConnIndex,RDS_IHoCh)
  // 1.0.605
  _RDS_AUX_FUNC(rdsMUOCreate,RDS_HoV)
  _RDS_AUX_FUNC(rdsMUOBlockOp,RDS_VHoIBhDw)
  _RDS_AUX_FUNC(rdsMUOConnOp,RDS_VHoIChDw)
  // 1.0.606
  _RDS_AUX_FUNC(rdsBCLRemoveBlock,RDS_IHoBh)
  _RDS_AUX_FUNC(rdsBCLRemoveConn,RDS_IHoCh)
  // 1.0.607
  _RDS_AUX_FUNC(rdsSetBlockClass,RDS_VBhII)
  _RDS_AUX_FUNC(rdsSetConnectionClass,RDS_VChII)
  // 1.0.609
  _RDS_AUX_FUNC(rdsScrollWindowToRectEx,RDS_VBhIIIIDw)
  // 1.0.610
  _RDS_AUX_FUNC(rdsINFOCreate,RDS_HoV)
  _RDS_AUX_FUNC(rdsINFOSetSize,RDS_VHoII)
  _RDS_AUX_FUNC(rdsINFOSetPos,RDS_VHoBIIII)
  _RDS_AUX_FUNC(rdsINFOSetRelPosBySys,RDS_VHoBhII)
  _RDS_AUX_FUNC(rdsINFOSetRelPosPrimary,RDS_VHoII)
  // 1.0.613
  _RDS_AUX_FUNC(rdsSaveWindowConfigA,RDS_VS3)
  _RDS_AUX_FUNC(rdsSaveWindowConfigW,RDS_VS3)
  // 1.0.625
  _RDS_AUX_FUNC(rdsAuxThreadStart,RDS_ThCb13Cb13pV)
  _RDS_AUX_FUNC(rdsAuxThreadSync,RDS_VThCb14pV)
  _RDS_AUX_FUNC(rdsAuxThreadAskStop,RDS_VTh)
  _RDS_AUX_FUNC(rdsFORMSetMainButtonsA,RDS_VHoISB)
  _RDS_AUX_FUNC(rdsFORMSetMainButtonsW,RDS_VHoIWsB)
  // 1.0.626
  _RDS_AUX_FUNC(rdsBMPCreateManual,RDS_HoII)
  _RDS_AUX_FUNC(rdsBMPManualDraw,RDS_VHoCb15pV)
  // 2.0.0
  _RDS_AUX_FUNC(rdsUTF16toUTF8,RDS_SWsB)
  _RDS_AUX_FUNC(rdsUTF8toUTF16,RDS_WsSB)
  _RDS_AUX_FUNC(rdscompLinkAvailableModuleA,RDS_BS)
  _RDS_AUX_FUNC(rdscompLinkAvailableModuleW,RDS_BWs)
  _RDS_AUX_FUNC(rdscompLinkModuleAllowed,RDS_BV)
  _RDS_AUX_FUNC(rdscompSetModelFunctionExA,RDS_VMhISS)
  _RDS_AUX_FUNC(rdscompSetModelFunctionExW,RDS_VMhIWsWs)
  _RDS_AUX_FUNC(rdsGetEnvironmentVariableA,RDS_SS)
  _RDS_AUX_FUNC(rdsGetEnvironmentVariableW,RDS_WsWs)
  _RDS_AUX_FUNC(rdsSetEnvironmentVariableA,RDS_SSSB)
  _RDS_AUX_FUNC(rdsSetEnvironmentVariableW,RDS_WsWsWsB)
  _RDS_AUX_FUNC(rdsInitExecToolExtData,RDS_VS2)
  _RDS_AUX_FUNC(rdscompTestCompileA,RDS_BSSSpSpSpS)
  _RDS_AUX_FUNC(rdscompTestCompileW,RDS_BWsWsWspWspWspWs)
  _RDS_AUX_FUNC(rdscompTestCompReturnStringA,RDS_VIS)
  _RDS_AUX_FUNC(rdscompTestCompReturnStringW,RDS_VIWs)
  _RDS_AUX_FUNC(rdsStrLenA,RDS_DwS)
  _RDS_AUX_FUNC(rdsStrLenW,RDS_DwWs)
  _RDS_AUX_FUNC(rdsIsUTF8Text,RDS_BSDw)
  _RDS_AUX_FUNC(rdsGetFlag,RDS_BDwDw)
  _RDS_AUX_FUNC(rdsSetFlag,RDS_DwDwDwB)
  _RDS_AUX_FUNC(rdsSetFlagP,RDS_VpDwDwB)
  _RDS_AUX_FUNC(rdsTMPCreateEmptyFileAnyExtA,RDS_SIS)
  _RDS_AUX_FUNC(rdsTMPCreateEmptyFileAnyExtW,RDS_WsIWs)
  // 2.0.1
  _RDS_AUX_FUNC(rdsGetVarArrayItemAddr,RDS_pVpVIBpI)
  _RDS_AUX_FUNC(rdsGetVarMatrItemAddr,RDS_pVpVIIBpI)
  // 2.0.2
  _RDS_AUX_FUNC(rdsSetBlockModelKeepDataA,RDS_BBhSS)
  _RDS_AUX_FUNC(rdsSetBlockModelKeepDataW,RDS_BBhWsWs)
  // 2.0.9
  _RDS_AUX_FUNC(rdsXGDrawStdIconOnBlock,RDS_VBhIIDwII)
  // 2.0.11
  _RDS_AUX_FUNC(rdsCompareVarArray,RDS_BpVpVD)
  _RDS_AUX_FUNC(rdsCallConnectedBlocksFunction,RDS_VBhIDwIpV)
  // 2.0.13
  _RDS_AUX_FUNC(rdsExecuteBlockSetup,RDS_VBh)
  _RDS_AUX_FUNC(rdsBCLListConnectedBlocksByVar,RDS_IHoBhIDw)
  _RDS_AUX_FUNC(rdsFindDataSourceBlock,RDS_BhBhIPd)
  // 2.0.14
  _RDS_AUX_FUNC(rdsXGCalcBlockPointCoords,RDS_VIIpIpI)
  // 2.0.16
  _RDS_AUX_FUNC(rdsCountSimpleSourceBlocks,RDS_IBhI)
  _RDS_AUX_FUNC(rdsCountSimpleSourceBlocksN,RDS_IBhpII)
  // 2.0.17
  _RDS_AUX_FUNC(rdsCountSimpleDestBlocks,RDS_IBhI)
  _RDS_AUX_FUNC(rdsCountSimpleDestBlocksN,RDS_IBhpII)
  // 2.0.20
  _RDS_AUX_FUNC(rdsGetCallerBlock,RDS_BhBd)
  _RDS_AUX_FUNC(rdsSubscribeToFuncProviderSameSystem,RDS_BFl)
  _RDS_AUX_FUNC(rdsBlockHookAdd,RDS_BhookICb16pVDw)
  _RDS_AUX_FUNC(rdsBlockHookChange,RDS_BBhookCb16pVDw)
  _RDS_AUX_FUNC(rdsBlockHookDelete,RDS_VBhook)
  _RDS_AUX_FUNC(rdsCallFontDialog,RDS_BpFs)
  _RDS_AUX_FUNC(rdsCallFontDialogEx,RDS_BpFsDwCr)
  // Global function vars - autogenerated (end)

  #undef _RDS_AUX_FUNC
// Функция получения указателей
BOOL RDS_SERV_FUNC_BODY(void)
  { HMODULE exe=GetModuleHandle(NULL);
    BOOL ok=TRUE;
    // Вспомогательный макрос, связывающий функцию с указателем
    #define _RDS_AUX_FUNC(var,type,name) ok=((var=(type)GetProcAddress(exe,name))!=NULL)&&ok;

    // Присвоение указателей переменным
    // Get functions by name - autogenerated (begin)
    _RDS_AUX_FUNC(rdsServiceVersion,RDS_IV,"rdsServiceVersion")
    _RDS_AUX_FUNC(rdsCallerThreadType,RDS_IV,"rdsCallerThreadType")
    _RDS_AUX_FUNC(rdsGetTopWindowBlock,RDS_BhV,"rdsGetTopWindowBlock")
    _RDS_AUX_FUNC(rdsGetBlockDescription,RDS_IBhBd,"rdsGetBlockDescription")
    _RDS_AUX_FUNC(rdsGetAppWindowHandle,RDS_HwV,"rdsGetAppWindowHandle")
    _RDS_AUX_FUNC(rdsGetMainWindow,RDS_HwV,"rdsGetMainWindow")
    _RDS_AUX_FUNC(rdsGetFirstBlock,RDS_BhBhIBd,"rdsGetFirstBlock")
    _RDS_AUX_FUNC(rdsGetNextBlock,RDS_BhBhIBd,"rdsGetNextBlock")
    _RDS_AUX_FUNC(rdsGetConnDescription,RDS_IChCd,"rdsGetConnDescription")
    _RDS_AUX_FUNC(rdsGetFirstConn,RDS_ChBhICd,"rdsGetFirstConn")
    _RDS_AUX_FUNC(rdsGetNextConn,RDS_ChChICd,"rdsGetNextConn")
    _RDS_AUX_FUNC(rdsGetPointDescription,RDS_IChIPd,"rdsGetPointDescription")
    _RDS_AUX_FUNC(rdsGetSystemPathA,RDS_SI,"rdsGetSystemPathA")
    _RDS_AUX_FUNC(rdsGetSystemPathW,RDS_WsI,"rdsGetSystemPathW")
    _RDS_AUX_FUNC(rdsRemoteControllerCallA,RDS_IIS,"rdsRemoteControllerCallA")
    _RDS_AUX_FUNC(rdsRemoteControllerCallW,RDS_IIWs,"rdsRemoteControllerCallW")
    _RDS_AUX_FUNC(rdsRemoteReplyA,RDS_VS,"rdsRemoteReplyA")
    _RDS_AUX_FUNC(rdsRemoteReplyW,RDS_VWs,"rdsRemoteReplyW")
    _RDS_AUX_FUNC(rdsReportTextLoadErrorA,RDS_VS,"rdsReportTextLoadErrorA")
    _RDS_AUX_FUNC(rdsReportTextLoadErrorW,RDS_VWs,"rdsReportTextLoadErrorW")
    _RDS_AUX_FUNC(rdsSetHintTextA,RDS_VS,"rdsSetHintTextA")
    _RDS_AUX_FUNC(rdsSetHintTextW,RDS_VWs,"rdsSetHintTextW")
    _RDS_AUX_FUNC(rdsGetRemoteControllerNameA,RDS_SV,"rdsGetRemoteControllerNameA")
    _RDS_AUX_FUNC(rdsGetRemoteControllerNameW,RDS_WsV,"rdsGetRemoteControllerNameW")
    _RDS_AUX_FUNC(rdsWriteBlockData,RDS_BpVI,"rdsWriteBlockData")
    _RDS_AUX_FUNC(rdsReadBlockData,RDS_BpVI,"rdsReadBlockData")
    _RDS_AUX_FUNC(rdsWriteBlockDataTextA,RDS_VSB,"rdsWriteBlockDataTextA")
    _RDS_AUX_FUNC(rdsWriteBlockDataTextW,RDS_VWsB,"rdsWriteBlockDataTextW")
    _RDS_AUX_FUNC(rdsSetDebugTextA,RDS_VSB,"rdsSetDebugTextA")
    _RDS_AUX_FUNC(rdsSetDebugTextW,RDS_VWsB,"rdsSetDebugTextW")
    _RDS_AUX_FUNC(rdsXGSetPenStyle,RDS_VIIICrI,"rdsXGSetPenStyle")
    _RDS_AUX_FUNC(rdsXGSetBrushStyle,RDS_VIICr,"rdsXGSetBrushStyle")
    _RDS_AUX_FUNC(rdsXGSetFontA,RDS_VISICrIIBBBB,"rdsXGSetFontA")
    _RDS_AUX_FUNC(rdsXGSetFontW,RDS_VIWsICrIIBBBB,"rdsXGSetFontW")
    _RDS_AUX_FUNC(rdsWriteFontTextA,RDS_VISICrIIBBBB,"rdsWriteFontTextA")
    _RDS_AUX_FUNC(rdsWriteFontTextW,RDS_VIWsICrIIBBBB,"rdsWriteFontTextW")
    _RDS_AUX_FUNC(rdsXGSetLogFontA,RDS_VpLfCr,"rdsXGSetLogFontA")
    _RDS_AUX_FUNC(rdsXGSetLogFontW,RDS_VpLfwCr,"rdsXGSetLogFontW")
    _RDS_AUX_FUNC(rdsXGGetTextSizeA,RDS_VSpIpI,"rdsXGGetTextSizeA")
    _RDS_AUX_FUNC(rdsXGGetTextSizeW,RDS_VWspIpI,"rdsXGGetTextSizeW")
    _RDS_AUX_FUNC(rdsXGRectangle,RDS_VIIII,"rdsXGRectangle")
    _RDS_AUX_FUNC(rdsXGInvertRect,RDS_VIIII,"rdsXGInvertRect")
    _RDS_AUX_FUNC(rdsXGEllipse,RDS_VIIII,"rdsXGEllipse")
    _RDS_AUX_FUNC(rdsXGArc,RDS_VIIIIIIII,"rdsXGArc")
    _RDS_AUX_FUNC(rdsXGPie,RDS_VIIIIIIII,"rdsXGPie")
    _RDS_AUX_FUNC(rdsXGChord,RDS_VIIIIIIII,"rdsXGChord")
    _RDS_AUX_FUNC(rdsXGTextOutA,RDS_VIIS,"rdsXGTextOutA")
    _RDS_AUX_FUNC(rdsXGTextOutW,RDS_VIIWs,"rdsXGTextOutW")
    _RDS_AUX_FUNC(rdsXGTextRectA,RDS_VIISpR,"rdsXGTextRectA")
    _RDS_AUX_FUNC(rdsXGTextRectW,RDS_VIIWspR,"rdsXGTextRectW")
    _RDS_AUX_FUNC(rdsSetBlockTimer,RDS_ThThDwDwB,"rdsSetBlockTimer")
    _RDS_AUX_FUNC(rdsGetCustomColors,RDS_pCrV,"rdsGetCustomColors")
    _RDS_AUX_FUNC(rdsCallColorDialog,RDS_BpCr,"rdsCallColorDialog")
    _RDS_AUX_FUNC(rdsGetEditorParameters,RDS_BBhEd,"rdsGetEditorParameters")
    _RDS_AUX_FUNC(rdsGetBlockTimerDescr,RDS_BThTd,"rdsGetBlockTimerDescr")
    _RDS_AUX_FUNC(rdsDeleteBlockTimer,RDS_VTh,"rdsDeleteBlockTimer")
    _RDS_AUX_FUNC(rdsStopBlockTimer,RDS_VTh,"rdsStopBlockTimer")
    _RDS_AUX_FUNC(rdsRestartBlockTimer,RDS_VThDw,"rdsRestartBlockTimer")
    _RDS_AUX_FUNC(rdsXGMoveTo,RDS_VII,"rdsXGMoveTo")
    _RDS_AUX_FUNC(rdsXGLineTo,RDS_VII,"rdsXGLineTo")
    _RDS_AUX_FUNC(rdsGetTextWordA,RDS_SSpSpCB,"rdsGetTextWordA")
    _RDS_AUX_FUNC(rdsGetTextWordW,RDS_WsSpSpCB,"rdsGetTextWordW")
    _RDS_AUX_FUNC(rdsWriteLineStyleText,RDS_VIB,"rdsWriteLineStyleText")
    _RDS_AUX_FUNC(rdsWriteWordValueTextA,RDS_VSI,"rdsWriteWordValueTextA")
    _RDS_AUX_FUNC(rdsWriteWordValueTextW,RDS_VWsI,"rdsWriteWordValueTextW")
    _RDS_AUX_FUNC(rdsWriteColorTextA,RDS_VSCrB,"rdsWriteColorTextA")
    _RDS_AUX_FUNC(rdsWriteColorTextW,RDS_VWsCrB,"rdsWriteColorTextW")
    _RDS_AUX_FUNC(rdsReadColorText,RDS_CrSpS,"rdsReadColorText")
    _RDS_AUX_FUNC(rdsReadFontTextA,RDS_BSpSSIpIpCrpIpIpBpBpBpB,"rdsReadFontTextA")
    _RDS_AUX_FUNC(rdsReadFontTextW,RDS_BSpSWsIpIpCrpIpIpBpBpBpB,"rdsReadFontTextW")
    _RDS_AUX_FUNC(rdsXGGetVisibleRect,RDS_VpR,"rdsXGGetVisibleRect")
    _RDS_AUX_FUNC(rdsXGSetClipRect,RDS_VpR,"rdsXGSetClipRect")
    _RDS_AUX_FUNC(rdsWriteWordStringTextA,RDS_VSS,"rdsWriteWordStringTextA")
    _RDS_AUX_FUNC(rdsWriteWordStringTextW,RDS_VWsWs,"rdsWriteWordStringTextW")
    _RDS_AUX_FUNC(rdsXGDrawBlockPicture,RDS_VIIDDDB,"rdsXGDrawBlockPicture")
    _RDS_AUX_FUNC(rdsXGTriangle,RDS_VIIIIII,"rdsXGTriangle")
    _RDS_AUX_FUNC(rdsXGPolygon,RDS_VpPI,"rdsXGPolygon")
    _RDS_AUX_FUNC(rdsXGFontSizeToHeight,RDS_II,"rdsXGFontSizeToHeight")
    _RDS_AUX_FUNC(rdsCheckBlockFunctionSupport,RDS_BBhI,"rdsCheckBlockFunctionSupport")
    _RDS_AUX_FUNC(rdsCallBlockFunction,RDS_IBhIpV,"rdsCallBlockFunction")
    _RDS_AUX_FUNC(rdsBroadcastFunctionCallsEx,RDS_IBhIpVDw,"rdsBroadcastFunctionCallsEx")
    _RDS_AUX_FUNC(rdsBroadcastFunctionCalls,RDS_VBhIpVB,"rdsBroadcastFunctionCalls")
    _RDS_AUX_FUNC(rdsGetConnAppearance,RDS_VChCa,"rdsGetConnAppearance")
    _RDS_AUX_FUNC(rdsSetConnAppearance,RDS_VChCa,"rdsSetConnAppearance")
    _RDS_AUX_FUNC(rdsGetConnStyleAppearanceA,RDS_BSCa,"rdsGetConnStyleAppearanceA")
    _RDS_AUX_FUNC(rdsGetConnStyleAppearanceW,RDS_BWsCa,"rdsGetConnStyleAppearanceW")
    _RDS_AUX_FUNC(rdsSystemInEditMode,RDS_BV,"rdsSystemInEditMode")
    _RDS_AUX_FUNC(rdsGetBlockLink,RDS_ChBhChBBPd,"rdsGetBlockLink")
    _RDS_AUX_FUNC(rdsCreateDynamicVarA,RDS_pVISSBS,"rdsCreateDynamicVarA")
    _RDS_AUX_FUNC(rdsCreateDynamicVarW,RDS_pVIWsWsBWs,"rdsCreateDynamicVarW")
    _RDS_AUX_FUNC(rdsCreateAndSubscribeDVA,RDS_DvISSBS,"rdsCreateAndSubscribeDVA")
    _RDS_AUX_FUNC(rdsCreateAndSubscribeDVW,RDS_DvIWsWsBWs,"rdsCreateAndSubscribeDVW")
    _RDS_AUX_FUNC(rdsDeleteDynamicVarA,RDS_BIS,"rdsDeleteDynamicVarA")
    _RDS_AUX_FUNC(rdsDeleteDynamicVarW,RDS_BIWs,"rdsDeleteDynamicVarW")
    _RDS_AUX_FUNC(rdsSubscribeToDynamicVarA,RDS_DvISSB,"rdsSubscribeToDynamicVarA")
    _RDS_AUX_FUNC(rdsSubscribeToDynamicVarW,RDS_DvIWsWsB,"rdsSubscribeToDynamicVarW")
    _RDS_AUX_FUNC(rdsUnsubscribeFromDynamicVar,RDS_VDv,"rdsUnsubscribeFromDynamicVar")
    _RDS_AUX_FUNC(rdsGetChildBlockByNameA,RDS_BhBhSBd,"rdsGetChildBlockByNameA")
    _RDS_AUX_FUNC(rdsGetChildBlockByNameW,RDS_BhBhWsBd,"rdsGetChildBlockByNameW")
    _RDS_AUX_FUNC(rdsGetIOBlockByVarNameA,RDS_BhBhSBd,"rdsGetIOBlockByVarNameA")
    _RDS_AUX_FUNC(rdsGetIOBlockByVarNameW,RDS_BhBhWsBd,"rdsGetIOBlockByVarNameW")
    _RDS_AUX_FUNC(rdsGetRootSystem,RDS_BhBd,"rdsGetRootSystem")
    _RDS_AUX_FUNC(rdsGetIOBlockLink,RDS_ChBhChPd,"rdsGetIOBlockLink")
    _RDS_AUX_FUNC(rdsRefreshBlockWindows,RDS_VBhB,"rdsRefreshBlockWindows")
    _RDS_AUX_FUNC(rdsCountBlocks,RDS_IBhIB,"rdsCountBlocks")
    _RDS_AUX_FUNC(rdsSetBlockCommentA,RDS_VBhS,"rdsSetBlockCommentA")
    _RDS_AUX_FUNC(rdsSetBlockCommentW,RDS_VBhWs,"rdsSetBlockCommentW")
    _RDS_AUX_FUNC(rdsSetModifiedFlag,RDS_VB,"rdsSetModifiedFlag")
    _RDS_AUX_FUNC(rdsOpenSystemWindow,RDS_VBh,"rdsOpenSystemWindow")
    _RDS_AUX_FUNC(rdsCloseSystemWindow,RDS_VBh,"rdsCloseSystemWindow")
    _RDS_AUX_FUNC(rdsScrollWindowToBlock,RDS_VBh,"rdsScrollWindowToBlock")
    _RDS_AUX_FUNC(rdsAltConnAppearanceOp,RDS_IChIICa,"rdsAltConnAppearanceOp")
    _RDS_AUX_FUNC(rdsGetLayerConfigNameA,RDS_SBhI,"rdsGetLayerConfigNameA")
    _RDS_AUX_FUNC(rdsGetLayerConfigNameW,RDS_WsBhI,"rdsGetLayerConfigNameW")
    _RDS_AUX_FUNC(rdsGetLayerNameA,RDS_SBhI,"rdsGetLayerNameA")
    _RDS_AUX_FUNC(rdsGetLayerNameW,RDS_WsBhI,"rdsGetLayerNameW")
    _RDS_AUX_FUNC(rdsSetCurLayerConfig,RDS_BBhI,"rdsSetCurLayerConfig")
    _RDS_AUX_FUNC(rdsSetCurLayerConfigByNameA,RDS_BBhS,"rdsSetCurLayerConfigByNameA")
    _RDS_AUX_FUNC(rdsSetCurLayerConfigByNameW,RDS_BBhWs,"rdsSetCurLayerConfigByNameW")
    _RDS_AUX_FUNC(rdsEnableWindowRefresh,RDS_VBhBB,"rdsEnableWindowRefresh")
    _RDS_AUX_FUNC(rdsStopCalc,RDS_VV,"rdsStopCalc")
    _RDS_AUX_FUNC(rdsGetVarArrayParams,RDS_pVpVpIpI,"rdsGetVarArrayParams")
    _RDS_AUX_FUNC(rdsGetVarArrayAccessData,RDS_BpVAd,"rdsGetVarArrayAccessData")
    _RDS_AUX_FUNC(rdsResizeVarArray,RDS_BpVIIBAd,"rdsResizeVarArray")
    _RDS_AUX_FUNC(rdsEnumBlocks,RDS_BhBhIBCbpV,"rdsEnumBlocks")
    _RDS_AUX_FUNC(rdsGetPictureObjectId,RDS_IIIB,"rdsGetPictureObjectId")
    _RDS_AUX_FUNC(rdsSaveSystemState,RDS_IBhIBCb2,"rdsSaveSystemState")
    _RDS_AUX_FUNC(rdsLoadSystemState,RDS_BICb2,"rdsLoadSystemState")
    _RDS_AUX_FUNC(rdsGetScreenCoords,RDS_BBhIIpIpI,"rdsGetScreenCoords")
    _RDS_AUX_FUNC(rdsLockBlockData,RDS_VV,"rdsLockBlockData")
    _RDS_AUX_FUNC(rdsUnlockBlockData,RDS_VV,"rdsUnlockBlockData")
    _RDS_AUX_FUNC(rdsBlockDataSyncCall,RDS_ICb4pV,"rdsBlockDataSyncCall")
    _RDS_AUX_FUNC(rdsRegisterFunctionA,RDS_IS,"rdsRegisterFunctionA")
    _RDS_AUX_FUNC(rdsRegisterFunctionW,RDS_IWs,"rdsRegisterFunctionW")
    _RDS_AUX_FUNC(rdsActivateOutputConnections,RDS_VBhB,"rdsActivateOutputConnections")
    _RDS_AUX_FUNC(rdsSelectBlock,RDS_VBhBB,"rdsSelectBlock")
    _RDS_AUX_FUNC(rdsCalcProcessIsRunning,RDS_BV,"rdsCalcProcessIsRunning")
    _RDS_AUX_FUNC(rdsEnumConnectedBlocks,RDS_BhBhDwCb1pV,"rdsEnumConnectedBlocks")
    _RDS_AUX_FUNC(rdsWriteHexText,RDS_VpVII,"rdsWriteHexText")
    _RDS_AUX_FUNC(rdsReadHexText,RDS_ISpSpVI,"rdsReadHexText")
    _RDS_AUX_FUNC(rdsGetCmdParamCount,RDS_IV,"rdsGetCmdParamCount")
    _RDS_AUX_FUNC(rdsGetCmdParamA,RDS_SIB,"rdsGetCmdParamA")
    _RDS_AUX_FUNC(rdsGetCmdParamW,RDS_WsIB,"rdsGetCmdParamW")
    _RDS_AUX_FUNC(rdsFindCmdParamA,RDS_ISB,"rdsFindCmdParamA")
    _RDS_AUX_FUNC(rdsFindCmdParamW,RDS_IWsB,"rdsFindCmdParamW")
    _RDS_AUX_FUNC(rdsRegisterMenuItemA,RDS_MhSDwIDwII,"rdsRegisterMenuItemA")
    _RDS_AUX_FUNC(rdsRegisterMenuItemW,RDS_MhWsDwIDwII,"rdsRegisterMenuItemW")
    _RDS_AUX_FUNC(rdsEnableMenuItem,RDS_VMhBB,"rdsEnableMenuItem")
    _RDS_AUX_FUNC(rdsUnregisterMenuItem,RDS_VMh,"rdsUnregisterMenuItem")
    _RDS_AUX_FUNC(rdsFree,RDS_VpcV,"rdsFree")
    _RDS_AUX_FUNC(rdsAllocate,RDS_pVDw,"rdsAllocate")
    _RDS_AUX_FUNC(rdsCreateFullBlockNameStringA,RDS_SBhpI,"rdsCreateFullBlockNameStringA")
    _RDS_AUX_FUNC(rdsCreateFullBlockNameStringW,RDS_WsBhpI,"rdsCreateFullBlockNameStringW")
    _RDS_AUX_FUNC(rdsBlockByFullNameA,RDS_BhSBd,"rdsBlockByFullNameA")
    _RDS_AUX_FUNC(rdsBlockByFullNameW,RDS_BhWsBd,"rdsBlockByFullNameW")
    _RDS_AUX_FUNC(rdsParentIsRoot,RDS_BBh,"rdsParentIsRoot")
    _RDS_AUX_FUNC(rdsHasRemoteController,RDS_BV,"rdsHasRemoteController")
    _RDS_AUX_FUNC(rdsDeleteBlock,RDS_VBh,"rdsDeleteBlock")
    _RDS_AUX_FUNC(rdsDeleteConnection,RDS_VCh,"rdsDeleteConnection")
    _RDS_AUX_FUNC(rdsCreateBlockFromFileA,RDS_BhSBhIIBd,"rdsCreateBlockFromFileA")
    _RDS_AUX_FUNC(rdsCreateBlockFromFileW,RDS_BhWsBhIIBd,"rdsCreateBlockFromFileW")
    _RDS_AUX_FUNC(rdsDuplicateBlock,RDS_BhBhBhIIBd,"rdsDuplicateBlock")
    _RDS_AUX_FUNC(rdsGetBlockVar,RDS_VhBhiVd,"rdsGetBlockVar")
    _RDS_AUX_FUNC(rdsFindBlockVarA,RDS_VhBhSBVd,"rdsFindBlockVarA")
    _RDS_AUX_FUNC(rdsFindBlockVarW,RDS_VhBhWsBVd,"rdsFindBlockVarW")
    _RDS_AUX_FUNC(rdsCECreateEditor,RDS_HoV,"rdsCECreateEditor")
    _RDS_AUX_FUNC(rdsDeleteObject,RDS_VHo,"rdsDeleteObject")
    _RDS_AUX_FUNC(rdsCECreateConnBus,RDS_ChHoBhIpI,"rdsCECreateConnBus")
    _RDS_AUX_FUNC(rdsCEEditConnBus,RDS_BHoChpI,"rdsCEEditConnBus")
    _RDS_AUX_FUNC(rdsCEAddInternalPoint,RDS_IHoII,"rdsCEAddInternalPoint")
    _RDS_AUX_FUNC(rdsCEAddBlockPointA,RDS_IHoBhSIIB,"rdsCEAddBlockPointA")
    _RDS_AUX_FUNC(rdsCEAddBlockPointW,RDS_IHoBhWsIIB,"rdsCEAddBlockPointW")
    _RDS_AUX_FUNC(rdsCEAddBusPointA,RDS_IHoChSBIIB,"rdsCEAddBusPointA")
    _RDS_AUX_FUNC(rdsCEAddBusPointW,RDS_IHoChWsBIIB,"rdsCEAddBusPointW")
    _RDS_AUX_FUNC(rdsCEAddLine,RDS_IHoII,"rdsCEAddLine")
    _RDS_AUX_FUNC(rdsCEAddBezier,RDS_IHoIIIIII,"rdsCEAddBezier")
    _RDS_AUX_FUNC(rdsGetBlockDimensions,RDS_BBhBrB,"rdsGetBlockDimensions")
    _RDS_AUX_FUNC(rdsBCLCreateList,RDS_HoBhDwB,"rdsBCLCreateList")
    _RDS_AUX_FUNC(rdsGetObjectArray,RDS_pVHoIIpI,"rdsGetObjectArray")
    _RDS_AUX_FUNC(rdsMoveBlock,RDS_VBhII,"rdsMoveBlock")
    _RDS_AUX_FUNC(rdsSetSystemUpdate,RDS_VB,"rdsSetSystemUpdate")
    _RDS_AUX_FUNC(rdsdebugBlockInfoA,RDS_VBhSS,"rdsdebugBlockInfoA")
    _RDS_AUX_FUNC(rdsdebugBlockInfoW,RDS_VBhWsWs,"rdsdebugBlockInfoW")
    _RDS_AUX_FUNC(rdsGetLineDescription,RDS_BChILdPdPd,"rdsGetLineDescription")
    _RDS_AUX_FUNC(rdsFindNextConnectedLine,RDS_IChIILdpI,"rdsFindNextConnectedLine")
    _RDS_AUX_FUNC(rdsScrollWindowToRect,RDS_VBhIIIIB,"rdsScrollWindowToRect")
    _RDS_AUX_FUNC(rdsCheckRectVisibility,RDS_BBhIIII,"rdsCheckRectVisibility")
    _RDS_AUX_FUNC(rdsCalcProcessNeverStarted,RDS_BV,"rdsCalcProcessNeverStarted")
    _RDS_AUX_FUNC(rdsCheckSystemWindow,RDS_BBh,"rdsCheckSystemWindow")
    _RDS_AUX_FUNC(rdscompSetModelFunctionA,RDS_VMhSS,"rdscompSetModelFunctionA")
    _RDS_AUX_FUNC(rdscompSetModelFunctionW,RDS_VMhWsWs,"rdscompSetModelFunctionW")
    _RDS_AUX_FUNC(rdsDeleteDVByLink,RDS_BDv,"rdsDeleteDVByLink")
    _RDS_AUX_FUNC(rdsCopyVarArray,RDS_BpVpV,"rdsCopyVarArray")
    _RDS_AUX_FUNC(rdsVSCreateEditor,RDS_HoV,"rdsVSCreateEditor")
    _RDS_AUX_FUNC(rdsVSInstallStruct,RDS_BHopI,"rdsVSInstallStruct")
    _RDS_AUX_FUNC(rdsVSAddVarA,RDS_IHoISCSDwIS,"rdsVSAddVarA")
    _RDS_AUX_FUNC(rdsVSAddVarW,RDS_IHoIWsCWsDwIWs,"rdsVSAddVarW")
    _RDS_AUX_FUNC(rdsSetObjectStrA,RDS_VHoIIS,"rdsSetObjectStrA")
    _RDS_AUX_FUNC(rdsSetObjectStrW,RDS_VHoIIWs,"rdsSetObjectStrW")
    _RDS_AUX_FUNC(rdsVSApplyToBlock,RDS_BHoBhpI,"rdsVSApplyToBlock")
    _RDS_AUX_FUNC(rdsVSAddAutoConnA,RDS_IHoSS,"rdsVSAddAutoConnA")
    _RDS_AUX_FUNC(rdsVSAddAutoConnW,RDS_IHoWsWs,"rdsVSAddAutoConnW")
    _RDS_AUX_FUNC(rdsCommandObjectEx,RDS_BHoIIpI,"rdsCommandObjectEx")
    _RDS_AUX_FUNC(rdsCommandObject,RDS_BHoI,"rdsCommandObject")
    _RDS_AUX_FUNC(rdsGetVarField,RDS_VhVhiVd,"rdsGetVarField")
    _RDS_AUX_FUNC(rdsFindStructVarA,RDS_VhSVd,"rdsFindStructVarA")
    _RDS_AUX_FUNC(rdsFindStructVarW,RDS_VhWsVd,"rdsFindStructVarW")
    _RDS_AUX_FUNC(rdsVSGetVarDescription,RDS_BHoIVd,"rdsVSGetVarDescription")
    _RDS_AUX_FUNC(rdsVSExecuteEditorA,RDS_BHoBDwIS,"rdsVSExecuteEditorA")
    _RDS_AUX_FUNC(rdsVSExecuteEditorW,RDS_BHoBDwIWs,"rdsVSExecuteEditorW")
    _RDS_AUX_FUNC(rdsGetObjectInt,RDS_IHoII,"rdsGetObjectInt")
    _RDS_AUX_FUNC(rdsGetObjectStrA,RDS_SHoII,"rdsGetObjectStrA")
    _RDS_AUX_FUNC(rdsGetObjectStrW,RDS_WsHoII,"rdsGetObjectStrW")
    _RDS_AUX_FUNC(rdsSetObjectInt,RDS_VHoIII,"rdsSetObjectInt")
    _RDS_AUX_FUNC(rdsCreateVarDescriptionStringA,RDS_SVhBIpI,"rdsCreateVarDescriptionStringA")
    _RDS_AUX_FUNC(rdsCreateVarDescriptionStringW,RDS_WsVhBIpI,"rdsCreateVarDescriptionStringW")
    _RDS_AUX_FUNC(rdsVSAddVarByDescrA,RDS_IHoIS,"rdsVSAddVarByDescrA")
    _RDS_AUX_FUNC(rdsVSAddVarByDescrW,RDS_IHoIWs,"rdsVSAddVarByDescrW")
    _RDS_AUX_FUNC(rdsVSCreateByDescrA,RDS_BHoS,"rdsVSCreateByDescrA")
    _RDS_AUX_FUNC(rdsVSCreateByDescrW,RDS_BHoWs,"rdsVSCreateByDescrW")
    _RDS_AUX_FUNC(rdsVSAddTypeRenameA,RDS_IHoSS,"rdsVSAddTypeRenameA")
    _RDS_AUX_FUNC(rdsVSAddTypeRenameW,RDS_IHoWsWs,"rdsVSAddTypeRenameW")
    _RDS_AUX_FUNC(rdscompGetModelData,RDS_MdChI,"rdscompGetModelData")
    _RDS_AUX_FUNC(rdsApplicationIsActive,RDS_BV,"rdsApplicationIsActive")
    _RDS_AUX_FUNC(rdsRegisterWindowA,RDS_BHwSHbHiS,"rdsRegisterWindowA")
    _RDS_AUX_FUNC(rdsRegisterWindowW,RDS_BHwWsHbHiWs,"rdsRegisterWindowW")
    _RDS_AUX_FUNC(rdsUnregisterWindow,RDS_VHw,"rdsUnregisterWindow")
    _RDS_AUX_FUNC(rdsRegWinActivateNotify,RDS_VHw,"rdsRegWinActivateNotify")
    _RDS_AUX_FUNC(rdsVSFindAutoConnA,RDS_SHoS,"rdsVSFindAutoConnA")
    _RDS_AUX_FUNC(rdsVSFindAutoConnW,RDS_WsHoWs,"rdsVSFindAutoConnW")
    _RDS_AUX_FUNC(rdscompGetModelBlock,RDS_BhMhIBd,"rdscompGetModelBlock")
    _RDS_AUX_FUNC(rdsVSAddVarRenameA,RDS_IHoSS,"rdsVSAddVarRenameA")
    _RDS_AUX_FUNC(rdsVSAddVarRenameW,RDS_IHoWsWs,"rdsVSAddVarRenameW")
    _RDS_AUX_FUNC(rdsGetStructVar,RDS_VhIVd,"rdsGetStructVar")
    _RDS_AUX_FUNC(rdsGetSystemInt,RDS_II,"rdsGetSystemInt")
    _RDS_AUX_FUNC(rdsVSUsesStructTypeA,RDS_BHoS,"rdsVSUsesStructTypeA")
    _RDS_AUX_FUNC(rdsVSUsesStructTypeW,RDS_BHoWs,"rdsVSUsesStructTypeW")
    _RDS_AUX_FUNC(rdsVarUsesStructTypeA,RDS_BVhS,"rdsVarUsesStructTypeA")
    _RDS_AUX_FUNC(rdsVarUsesStructTypeW,RDS_BVhWs,"rdsVarUsesStructTypeW")
    _RDS_AUX_FUNC(rdscompRenameModelA,RDS_BChSSB,"rdscompRenameModelA")
    _RDS_AUX_FUNC(rdscompRenameModelW,RDS_BChWsWsB,"rdscompRenameModelW")
    _RDS_AUX_FUNC(rdscompGetModelDataByNameA,RDS_MdChS,"rdscompGetModelDataByNameA")
    _RDS_AUX_FUNC(rdscompGetModelDataByNameW,RDS_MdChWs,"rdscompGetModelDataByNameW")
    _RDS_AUX_FUNC(rdscompCompileModel,RDS_BMhB,"rdscompCompileModel")
    _RDS_AUX_FUNC(rdscompReturnModelNameA,RDS_VS,"rdscompReturnModelNameA")
    _RDS_AUX_FUNC(rdscompReturnModelNameW,RDS_VWs,"rdscompReturnModelNameW")
    _RDS_AUX_FUNC(rdsGetFullFilePathA,RDS_SSSpI,"rdsGetFullFilePathA")
    _RDS_AUX_FUNC(rdsGetFullFilePathW,RDS_WsWsWspI,"rdsGetFullFilePathW")
    _RDS_AUX_FUNC(rdsGetRelFilePathA,RDS_SSSpI,"rdsGetRelFilePathA")
    _RDS_AUX_FUNC(rdsGetRelFilePathW,RDS_WsWsWspI,"rdsGetRelFilePathW")
    _RDS_AUX_FUNC(rdsExecutePrintDialog,RDS_VBh,"rdsExecutePrintDialog")
    _RDS_AUX_FUNC(rdsChangeRegWinTitleA,RDS_VHwS,"rdsChangeRegWinTitleA")
    _RDS_AUX_FUNC(rdsChangeRegWinTitleW,RDS_VHwWs,"rdsChangeRegWinTitleW")
    _RDS_AUX_FUNC(rdsBCLAddBlock,RDS_IHoBhB,"rdsBCLAddBlock")
    _RDS_AUX_FUNC(rdsBCLAddConn,RDS_IHoChB,"rdsBCLAddConn")
    _RDS_AUX_FUNC(rdsBCLExecuteGroupSetDialogA,RDS_VHoDwSB,"rdsBCLExecuteGroupSetDialogA")
    _RDS_AUX_FUNC(rdsBCLExecuteGroupSetDialogW,RDS_VHoDwWsB,"rdsBCLExecuteGroupSetDialogW")
    _RDS_AUX_FUNC(rdsIsRoot,RDS_BBh,"rdsIsRoot")
    _RDS_AUX_FUNC(rdsMessageBoxA,RDS_ISSI,"rdsMessageBoxA")
    _RDS_AUX_FUNC(rdsMessageBoxW,RDS_IWsWsI,"rdsMessageBoxW")
    _RDS_AUX_FUNC(rdscompReturnModelNameLabelA,RDS_VS,"rdscompReturnModelNameLabelA")
    _RDS_AUX_FUNC(rdscompReturnModelNameLabelW,RDS_VWs,"rdscompReturnModelNameLabelW")
    _RDS_AUX_FUNC(rdscompSetAltModelNameA,RDS_VMhS,"rdscompSetAltModelNameA")
    _RDS_AUX_FUNC(rdscompSetAltModelNameW,RDS_VMhWs,"rdscompSetAltModelNameW")
    _RDS_AUX_FUNC(rdsSTRCreateTextReader,RDS_HoB,"rdsSTRCreateTextReader")
    _RDS_AUX_FUNC(rdsSTRAddKeywordA,RDS_IHoSI,"rdsSTRAddKeywordA")
    _RDS_AUX_FUNC(rdsSTRAddKeywordW,RDS_IHoWsI,"rdsSTRAddKeywordW")
    _RDS_AUX_FUNC(rdsSTRAddKeywordsArrayA,RDS_BHopSII,"rdsSTRAddKeywordsArrayA")
    _RDS_AUX_FUNC(rdsSTRAddKeywordsArrayW,RDS_BHopWsII,"rdsSTRAddKeywordsArrayW")
    _RDS_AUX_FUNC(rdsSTRGetWordA,RDS_IHopSpSpCB,"rdsSTRGetWordA")
    _RDS_AUX_FUNC(rdsSTRGetWordW,RDS_IHopWspWsWsB,"rdsSTRGetWordW")
    _RDS_AUX_FUNC(rdsWriteWordDoubleTextA,RDS_VSD,"rdsWriteWordDoubleTextA")
    _RDS_AUX_FUNC(rdsWriteWordDoubleTextW,RDS_VWsD,"rdsWriteWordDoubleTextW")
    _RDS_AUX_FUNC(rdsReadLineStyleText,RDS_ISpS,"rdsReadLineStyleText")
    _RDS_AUX_FUNC(rdsSetBlockVarDefValueStrA,RDS_BBhIS,"rdsSetBlockVarDefValueStrA")
    _RDS_AUX_FUNC(rdsSetBlockVarDefValueStrW,RDS_BBhIWs,"rdsSetBlockVarDefValueStrW")
    _RDS_AUX_FUNC(rdsGetBlockVarDefValueStrA,RDS_SBhIpI,"rdsGetBlockVarDefValueStrA")
    _RDS_AUX_FUNC(rdsGetBlockVarDefValueStrW,RDS_WsBhIpI,"rdsGetBlockVarDefValueStrW")
    _RDS_AUX_FUNC(rdsRunWithoutEvents,RDS_BB,"rdsRunWithoutEvents")
    _RDS_AUX_FUNC(rdsXGFillRect,RDS_VIIII,"rdsXGFillRect")
    _RDS_AUX_FUNC(rdsXGPolyline,RDS_VpPI,"rdsXGPolyline")
    _RDS_AUX_FUNC(rdsXGRoundRect,RDS_VIIIIII,"rdsXGRoundRect")
    _RDS_AUX_FUNC(rdsSetPointPosition,RDS_BChIIIDw,"rdsSetPointPosition")
    _RDS_AUX_FUNC(rdsGetParentBlock,RDS_BhBhBd,"rdsGetParentBlock")
    _RDS_AUX_FUNC(rdsRenameBlockA,RDS_BBhSBd,"rdsRenameBlockA")
    _RDS_AUX_FUNC(rdsRenameBlockW,RDS_BBhWsBd,"rdsRenameBlockW")
    _RDS_AUX_FUNC(rdsVSGetVarDefValueStrA,RDS_SHoIpI,"rdsVSGetVarDefValueStrA")
    _RDS_AUX_FUNC(rdsVSGetVarDefValueStrW,RDS_WsHoIpI,"rdsVSGetVarDefValueStrW")
    _RDS_AUX_FUNC(rdsSetZoomPercent,RDS_VBhIII,"rdsSetZoomPercent")
    _RDS_AUX_FUNC(rdsChangeMenuItemA,RDS_BMhSDwIDwII,"rdsChangeMenuItemA")
    _RDS_AUX_FUNC(rdsChangeMenuItemW,RDS_BMhWsDwIDwII,"rdsChangeMenuItemW")
    _RDS_AUX_FUNC(rdsResetSystemState,RDS_VBh,"rdsResetSystemState")
    _RDS_AUX_FUNC(rdsINICreateTextHolder,RDS_HoB,"rdsINICreateTextHolder")
    _RDS_AUX_FUNC(rdsSetObjectDouble,RDS_VHoIID,"rdsSetObjectDouble")
    _RDS_AUX_FUNC(rdsGetObjectDouble,RDS_DHoII,"rdsGetObjectDouble")
    _RDS_AUX_FUNC(rdsINIOpenSectionA,RDS_BHoS,"rdsINIOpenSectionA")
    _RDS_AUX_FUNC(rdsINIOpenSectionW,RDS_BHoWs,"rdsINIOpenSectionW")
    _RDS_AUX_FUNC(rdsINIWriteIntA,RDS_VHoSI,"rdsINIWriteIntA")
    _RDS_AUX_FUNC(rdsINIWriteIntW,RDS_VHoWsI,"rdsINIWriteIntW")
    _RDS_AUX_FUNC(rdsINIReadIntA,RDS_IHoSI,"rdsINIReadIntA")
    _RDS_AUX_FUNC(rdsINIReadIntW,RDS_IHoWsI,"rdsINIReadIntW")
    _RDS_AUX_FUNC(rdsINIWriteDoubleA,RDS_VHoSD,"rdsINIWriteDoubleA")
    _RDS_AUX_FUNC(rdsINIWriteDoubleW,RDS_VHoWsD,"rdsINIWriteDoubleW")
    _RDS_AUX_FUNC(rdsINIReadDoubleA,RDS_DHoSD,"rdsINIReadDoubleA")
    _RDS_AUX_FUNC(rdsINIReadDoubleW,RDS_DHoWsD,"rdsINIReadDoubleW")
    _RDS_AUX_FUNC(rdsINIWriteStringA,RDS_VHoSS,"rdsINIWriteStringA")
    _RDS_AUX_FUNC(rdsINIWriteStringW,RDS_VHoWsWs,"rdsINIWriteStringW")
    _RDS_AUX_FUNC(rdsINIReadStringA,RDS_SHoSSpI,"rdsINIReadStringA")
    _RDS_AUX_FUNC(rdsINIReadStringW,RDS_WsHoWsWspI,"rdsINIReadStringW")
    _RDS_AUX_FUNC(rdscompAttachDifferentModelA,RDS_VSS,"rdscompAttachDifferentModelA")
    _RDS_AUX_FUNC(rdscompAttachDifferentModelW,RDS_VWsWs,"rdscompAttachDifferentModelW")
    _RDS_AUX_FUNC(rdscompSetBlockModelA,RDS_IBhSSSS,"rdscompSetBlockModelA")
    _RDS_AUX_FUNC(rdscompSetBlockModelW,RDS_IBhWsWsWsWs,"rdscompSetBlockModelW")
    _RDS_AUX_FUNC(rdscompGetBlockModelData,RDS_MdBh,"rdscompGetBlockModelData")
    _RDS_AUX_FUNC(rdscompOpenBlockModelEditor,RDS_IBh,"rdscompOpenBlockModelEditor")
    _RDS_AUX_FUNC(rdsGetEditorWindowFlags,RDS_DwBh,"rdsGetEditorWindowFlags")
    _RDS_AUX_FUNC(rdsSetEditorWindowFlags,RDS_VBhDwDw,"rdsSetEditorWindowFlags")
    _RDS_AUX_FUNC(rdsEnumConnectedBlocksByVar,RDS_BhBhIDwCb1pV,"rdsEnumConnectedBlocksByVar")
    _RDS_AUX_FUNC(rdsFORMCreateA,RDS_HoBIIS,"rdsFORMCreateA")
    _RDS_AUX_FUNC(rdsFORMCreateW,RDS_HoBIIWs,"rdsFORMCreateW")
    _RDS_AUX_FUNC(rdsFORMAddTabA,RDS_VHoIS,"rdsFORMAddTabA")
    _RDS_AUX_FUNC(rdsFORMAddTabW,RDS_VHoIWs,"rdsFORMAddTabW")
    _RDS_AUX_FUNC(rdsFORMAddEditA,RDS_VHoIIDwSI,"rdsFORMAddEditA")
    _RDS_AUX_FUNC(rdsFORMAddEditW,RDS_VHoIIDwWsI,"rdsFORMAddEditW")
    _RDS_AUX_FUNC(rdsProcessTextA,RDS_SSIpI,"rdsProcessTextA")
    _RDS_AUX_FUNC(rdsProcessTextW,RDS_WsWsIpI,"rdsProcessTextW")
    _RDS_AUX_FUNC(rdsSetBlockSetupFuncNameA,RDS_VBhS,"rdsSetBlockSetupFuncNameA")
    _RDS_AUX_FUNC(rdsSetBlockSetupFuncNameW,RDS_VBhWs,"rdsSetBlockSetupFuncNameW")
    _RDS_AUX_FUNC(rdsDynStrCatA,RDS_SSSB,"rdsDynStrCatA")
    _RDS_AUX_FUNC(rdsDynStrCatW,RDS_WsWsWsB,"rdsDynStrCatW")
    _RDS_AUX_FUNC(rdsIsValidVarNameA,RDS_BSI,"rdsIsValidVarNameA")
    _RDS_AUX_FUNC(rdsIsValidVarNameW,RDS_BWsI,"rdsIsValidVarNameW")
    _RDS_AUX_FUNC(rdsRegisterFuncProvider,RDS_IIB,"rdsRegisterFuncProvider")
    _RDS_AUX_FUNC(rdsUnregisterFuncProvider,RDS_BI,"rdsUnregisterFuncProvider")
    _RDS_AUX_FUNC(rdsSubscribeToFuncProvider,RDS_BFl,"rdsSubscribeToFuncProvider")
    _RDS_AUX_FUNC(rdsUnsubscribeFromFuncProvider,RDS_VI,"rdsUnsubscribeFromFuncProvider")
    _RDS_AUX_FUNC(rdsStartCalc,RDS_VV,"rdsStartCalc")
    _RDS_AUX_FUNC(rdsFORMShowModalEx,RDS_BHoCb3,"rdsFORMShowModalEx")
    _RDS_AUX_FUNC(rdsGetHugeDouble,RDS_BpD,"rdsGetHugeDouble")
    _RDS_AUX_FUNC(rdsSetBlockFlags,RDS_VBhDwDw,"rdsSetBlockFlags")
    _RDS_AUX_FUNC(rdsSetBlockVarFlags,RDS_BBhIDwDw,"rdsSetBlockVarFlags")
    _RDS_AUX_FUNC(rdsShowBlockPanelTabA,RDS_VIS,"rdsShowBlockPanelTabA")
    _RDS_AUX_FUNC(rdsShowBlockPanelTabW,RDS_VIWs,"rdsShowBlockPanelTabW")
    _RDS_AUX_FUNC(rdsSetBlockAltNameTextA,RDS_VBhSI,"rdsSetBlockAltNameTextA")
    _RDS_AUX_FUNC(rdsSetBlockAltNameTextW,RDS_VBhWsI,"rdsSetBlockAltNameTextW")
    _RDS_AUX_FUNC(rdsExecuteCommandA,RDS_VIDwSS,"rdsExecuteCommandA")
    _RDS_AUX_FUNC(rdsExecuteCommandW,RDS_VIDwWsWs,"rdsExecuteCommandW")
    _RDS_AUX_FUNC(rdsSetSystemWindowRect,RDS_VBhIIIIB,"rdsSetSystemWindowRect")
    _RDS_AUX_FUNC(rdsRegisterContextMenuItemA,RDS_MhSII,"rdsRegisterContextMenuItemA")
    _RDS_AUX_FUNC(rdsRegisterContextMenuItemW,RDS_MhWsII,"rdsRegisterContextMenuItemW")
    _RDS_AUX_FUNC(rdsEnableCommandQueue,RDS_VB,"rdsEnableCommandQueue")
    _RDS_AUX_FUNC(rdsSetSystemWindowCaptionA,RDS_VBhSB,"rdsSetSystemWindowCaptionA")
    _RDS_AUX_FUNC(rdsSetSystemWindowCaptionW,RDS_VBhWsB,"rdsSetSystemWindowCaptionW")
    _RDS_AUX_FUNC(rdsCopyRuntimeType,RDS_BpVpV,"rdsCopyRuntimeType")
    _RDS_AUX_FUNC(rdsClearRuntimeType,RDS_VpV,"rdsClearRuntimeType")
    _RDS_AUX_FUNC(rdsPBARCreateA,RDS_HoIS,"rdsPBARCreateA")
    _RDS_AUX_FUNC(rdsPBARCreateW,RDS_HoIWs,"rdsPBARCreateW")
    _RDS_AUX_FUNC(rdsInputStringA,RDS_SSSSI,"rdsInputStringA")
    _RDS_AUX_FUNC(rdsInputStringW,RDS_WsWsWsWsI,"rdsInputStringW")
    _RDS_AUX_FUNC(rdsUnlockAndCall,RDS_BCb4pVI,"rdsUnlockAndCall")
    _RDS_AUX_FUNC(rdsGetRemoteControllerStringA,RDS_SI,"rdsGetRemoteControllerStringA")
    _RDS_AUX_FUNC(rdsGetRemoteControllerStringW,RDS_WsI,"rdsGetRemoteControllerStringW")
    _RDS_AUX_FUNC(rdsGetRuntimeTypeDataA,RDS_pVpVpS,"rdsGetRuntimeTypeDataA")
    _RDS_AUX_FUNC(rdsGetRuntimeTypeDataW,RDS_pVpVpWs,"rdsGetRuntimeTypeDataW")
    _RDS_AUX_FUNC(rdsShowMainWindow,RDS_VB,"rdsShowMainWindow")
    _RDS_AUX_FUNC(rdsMainWindowVisible,RDS_BV,"rdsMainWindowVisible")
    _RDS_AUX_FUNC(rdsAdditionalContextMenuItemA,RDS_VSBII,"rdsAdditionalContextMenuItemA")
    _RDS_AUX_FUNC(rdsAdditionalContextMenuItemW,RDS_VWsBII,"rdsAdditionalContextMenuItemW")
    _RDS_AUX_FUNC(rdsGetBlockFlags,RDS_DwBh,"rdsGetBlockFlags")
    _RDS_AUX_FUNC(rdsSetRuntimeTypeA,RDS_pVpVS,"rdsSetRuntimeTypeA")
    _RDS_AUX_FUNC(rdsSetRuntimeTypeW,RDS_pVpVWs,"rdsSetRuntimeTypeW")
    _RDS_AUX_FUNC(rdsBringAppToFront,RDS_VV,"rdsBringAppToFront")
    _RDS_AUX_FUNC(rdsBlockModalWinOpen,RDS_VBh,"rdsBlockModalWinOpen")
    _RDS_AUX_FUNC(rdsBlockModalWinClose,RDS_VBh,"rdsBlockModalWinClose")
    _RDS_AUX_FUNC(rdsModalWindowMustClose,RDS_BV,"rdsModalWindowMustClose")
    _RDS_AUX_FUNC(rdsExecMenuItem,RDS_VBhII,"rdsExecMenuItem")
    _RDS_AUX_FUNC(rdsGetLayerIdA,RDS_IBhS,"rdsGetLayerIdA")
    _RDS_AUX_FUNC(rdsGetLayerIdW,RDS_IBhWs,"rdsGetLayerIdW")
    _RDS_AUX_FUNC(rdsAddLayerA,RDS_IBhS,"rdsAddLayerA")
    _RDS_AUX_FUNC(rdsAddLayerW,RDS_IBhWs,"rdsAddLayerW")
    _RDS_AUX_FUNC(rdsSetBlockLayer,RDS_BBhI,"rdsSetBlockLayer")
    _RDS_AUX_FUNC(rdsGetAppInstance,RDS_HiV,"rdsGetAppInstance")
    _RDS_AUX_FUNC(rdsModalWindowExists,RDS_BV,"rdsModalWindowExists")
    _RDS_AUX_FUNC(rdsEnumDynVarSubscribers,RDS_BhDvCb5pV,"rdsEnumDynVarSubscribers")
    _RDS_AUX_FUNC(rdsNotifyDynVarSubscribers,RDS_VDv,"rdsNotifyDynVarSubscribers")
    _RDS_AUX_FUNC(rdsCancelPaste,RDS_VV,"rdsCancelPaste")
    _RDS_AUX_FUNC(rdsdebugLogStringA,RDS_BSSB,"rdsdebugLogStringA")
    _RDS_AUX_FUNC(rdsdebugLogStringW,RDS_BWsWsB,"rdsdebugLogStringW")
    _RDS_AUX_FUNC(rdsGetObjectDoubleP,RDS_VHoIIpD,"rdsGetObjectDoubleP")
    _RDS_AUX_FUNC(rdsINIReadDoublePA,RDS_VHoSDpD,"rdsINIReadDoublePA")
    _RDS_AUX_FUNC(rdsINIReadDoublePW,RDS_VHoWsDpD,"rdsINIReadDoublePW")
    _RDS_AUX_FUNC(rdsNetServerA,RDS_IISB,"rdsNetServerA")
    _RDS_AUX_FUNC(rdsNetServerW,RDS_IIWsB,"rdsNetServerW")
    _RDS_AUX_FUNC(rdsNetConnectA,RDS_ISISB,"rdsNetConnectA")
    _RDS_AUX_FUNC(rdsNetConnectW,RDS_IWsIWsB,"rdsNetConnectW")
    _RDS_AUX_FUNC(rdsNetCloseConnection,RDS_VI,"rdsNetCloseConnection")
    _RDS_AUX_FUNC(rdsNetBroadcastDataA,RDS_BIDwISpVDw,"rdsNetBroadcastDataA")
    _RDS_AUX_FUNC(rdsNetBroadcastDataW,RDS_BIDwIWspVDw,"rdsNetBroadcastDataW")
    _RDS_AUX_FUNC(rdsNetSendDataA,RDS_BIDwISpVDwNsNb,"rdsNetSendDataA")
    _RDS_AUX_FUNC(rdsNetSendDataW,RDS_BIDwIWspVDwNsNb,"rdsNetSendDataW")
    _RDS_AUX_FUNC(rdsBlockVarToMem,RDS_pVBhIBpI,"rdsBlockVarToMem")
    _RDS_AUX_FUNC(rdsBlockVarFromMem,RDS_BBhIpVI,"rdsBlockVarFromMem")
    _RDS_AUX_FUNC(rdsXGDrawStdIcon,RDS_VIIDw,"rdsXGDrawStdIcon")
    _RDS_AUX_FUNC(rdsXGGetStdIconSize,RDS_BDwpIpI,"rdsXGGetStdIconSize")
    _RDS_AUX_FUNC(rdsBlockMessageBoxA,RDS_IBhSSI,"rdsBlockMessageBoxA")
    _RDS_AUX_FUNC(rdsBlockMessageBoxW,RDS_IBhWsWsI,"rdsBlockMessageBoxW")
    _RDS_AUX_FUNC(rdsFORMShowModalServ,RDS_BHoCb6,"rdsFORMShowModalServ")
    _RDS_AUX_FUNC(rdsCallBlockFunctionDelayed,RDS_VBhIpVDw,"rdsCallBlockFunctionDelayed")
    _RDS_AUX_FUNC(rdsBroadcastFuncCallsDelayed,RDS_VBhIpVDwDw,"rdsBroadcastFuncCallsDelayed")
    _RDS_AUX_FUNC(rdsFORMEnableSidePanel,RDS_VHoII,"rdsFORMEnableSidePanel")
    _RDS_AUX_FUNC(rdsSetExclusiveCalc,RDS_BBhB,"rdsSetExclusiveCalc")
    _RDS_AUX_FUNC(rdsListVarTypesA,RDS_SDwS,"rdsListVarTypesA")
    _RDS_AUX_FUNC(rdsListVarTypesW,RDS_WsDwWs,"rdsListVarTypesW")
    _RDS_AUX_FUNC(rdsCreateVarTypeTextA,RDS_SVh,"rdsCreateVarTypeTextA")
    _RDS_AUX_FUNC(rdsCreateVarTypeTextW,RDS_WsVh,"rdsCreateVarTypeTextW")
    _RDS_AUX_FUNC(rdsVSAddVarByTypeTextA,RDS_IHoISSDwS,"rdsVSAddVarByTypeTextA")
    _RDS_AUX_FUNC(rdsVSAddVarByTypeTextW,RDS_IHoIWsWsDwWs,"rdsVSAddVarByTypeTextW")
    _RDS_AUX_FUNC(rdsCopyVarGeneral,RDS_BVhpVVhpV,"rdsCopyVarGeneral")
    _RDS_AUX_FUNC(rdsSetBlockVarDefValueByCur,RDS_BBhI,"rdsSetBlockVarDefValueByCur")
    _RDS_AUX_FUNC(rdsGetBlockVarBase,RDS_pVBhIpI,"rdsGetBlockVarBase")
    _RDS_AUX_FUNC(rdsVSCreateFromBlock,RDS_VHoBhB,"rdsVSCreateFromBlock")
    _RDS_AUX_FUNC(rdsAtoIA,RDS_ISpI,"rdsAtoIA")
    _RDS_AUX_FUNC(rdsAtoIW,RDS_IWspI,"rdsAtoIW")
    _RDS_AUX_FUNC(rdsItoAA,RDS_SIII,"rdsItoAA")
    _RDS_AUX_FUNC(rdsItoAW,RDS_WsIII,"rdsItoAW")
    _RDS_AUX_FUNC(rdsAtoDA,RDS_VSpD,"rdsAtoDA")
    _RDS_AUX_FUNC(rdsAtoDW,RDS_VWspD,"rdsAtoDW")
    _RDS_AUX_FUNC(rdsDtoAA,RDS_SDIpI,"rdsDtoAA")
    _RDS_AUX_FUNC(rdsDtoAW,RDS_WsDIpI,"rdsDtoAW")
    _RDS_AUX_FUNC(rdsSetBlockModelA,RDS_BBhSS,"rdsSetBlockModelA")
    _RDS_AUX_FUNC(rdsSetBlockModelW,RDS_BBhWsWs,"rdsSetBlockModelW")
    _RDS_AUX_FUNC(rdsSetSystemInt,RDS_VII,"rdsSetSystemInt")
    _RDS_AUX_FUNC(rdsBEUCreate,RDS_HoBh,"rdsBEUCreate")
    _RDS_AUX_FUNC(rdsXGSetPixel,RDS_VII,"rdsXGSetPixel")
    _RDS_AUX_FUNC(rdsGetMouseObjectId,RDS_IMd,"rdsGetMouseObjectId")
    _RDS_AUX_FUNC(rdsOpenSystemWindowEx,RDS_VBhBIIII,"rdsOpenSystemWindowEx")
    _RDS_AUX_FUNC(rdsSetSystemWindowBounds,RDS_VBhBIIII,"rdsSetSystemWindowBounds")
    _RDS_AUX_FUNC(rdsVarArrayIndexCheckA,RDS_BpVIIDwSS,"rdsVarArrayIndexCheckA")
    _RDS_AUX_FUNC(rdsVarArrayIndexCheckW,RDS_BpVIIDwWsWs,"rdsVarArrayIndexCheckW")
    _RDS_AUX_FUNC(rdsBadSystemTime,RDS_BV,"rdsBadSystemTime")
    _RDS_AUX_FUNC(rdsExecutesRemoteOpsSetA,RDS_VSB,"rdsExecutesRemoteOpsSetA")
    _RDS_AUX_FUNC(rdsExecutesRemoteOpsSetW,RDS_VWsB,"rdsExecutesRemoteOpsSetW")
    _RDS_AUX_FUNC(rdsSetLayerPosition,RDS_BBhIIII,"rdsSetLayerPosition")
    _RDS_AUX_FUNC(rdsGetLayerParams,RDS_BBhIIpBpBpB,"rdsGetLayerParams")
    _RDS_AUX_FUNC(rdsSetLayerParams,RDS_BBhIIBBB,"rdsSetLayerParams")
    _RDS_AUX_FUNC(rdsSetBlockRect,RDS_VBhIIII,"rdsSetBlockRect")
    _RDS_AUX_FUNC(rdsGetConnDimensions,RDS_BChBrB,"rdsGetConnDimensions")
    _RDS_AUX_FUNC(rdsSetConnLayer,RDS_BChI,"rdsSetConnLayer")
    _RDS_AUX_FUNC(rdsUpdateExtIdsRange,RDS_VV,"rdsUpdateExtIdsRange")
    _RDS_AUX_FUNC(rdsBlockOrConnByExtId,RDS_BBhDwFbei,"rdsBlockOrConnByExtId")
    _RDS_AUX_FUNC(rdsPANCreateA,RDS_HoIIIIIIS,"rdsPANCreateA")
    _RDS_AUX_FUNC(rdsPANCreateW,RDS_HoIIIIIIWs,"rdsPANCreateW")
    _RDS_AUX_FUNC(rdsPANGetDescr,RDS_BHoPnd,"rdsPANGetDescr")
    _RDS_AUX_FUNC(rdsGetEditorFontA,RDS_BBhIpLfDwpI,"rdsGetEditorFontA")
    _RDS_AUX_FUNC(rdsGetEditorFontW,RDS_BBhIpLfwDwpI,"rdsGetEditorFontW")
    _RDS_AUX_FUNC(rdsXGSetFontByParStrA,RDS_VpFsD,"rdsXGSetFontByParStrA")
    _RDS_AUX_FUNC(rdsXGSetFontByParStrW,RDS_VpFsD,"rdsXGSetFontByParStrW")
    _RDS_AUX_FUNC(rdsFontTextToStruct,RDS_BSpSpFs,"rdsFontTextToStruct")
    _RDS_AUX_FUNC(rdsStructToFontTextA,RDS_SpFspI,"rdsStructToFontTextA")
    _RDS_AUX_FUNC(rdsStructToFontTextW,RDS_WspFspI,"rdsStructToFontTextW")
    _RDS_AUX_FUNC(rdsAddToDynStrA,RDS_VpSSB,"rdsAddToDynStrA")
    _RDS_AUX_FUNC(rdsAddToDynStrW,RDS_VpWsWsB,"rdsAddToDynStrW")
    _RDS_AUX_FUNC(rdsForceBlockRedraw,RDS_VBh,"rdsForceBlockRedraw")
    _RDS_AUX_FUNC(rdsRegisterContextMenuItemExA,RDS_MhSDwII,"rdsRegisterContextMenuItemExA")
    _RDS_AUX_FUNC(rdsRegisterContextMenuItemExW,RDS_MhWsDwII,"rdsRegisterContextMenuItemExW")
    _RDS_AUX_FUNC(rdsSetMenuItemOptions,RDS_VMhDw,"rdsSetMenuItemOptions")
    _RDS_AUX_FUNC(rdsAdditionalContextMenuItemExA,RDS_VSDwII,"rdsAdditionalContextMenuItemExA")
    _RDS_AUX_FUNC(rdsAdditionalContextMenuItemExW,RDS_VWsDwII,"rdsAdditionalContextMenuItemExW")
    _RDS_AUX_FUNC(rdsQueueCallBlockFunction,RDS_VBhIpVDwDw,"rdsQueueCallBlockFunction")
    _RDS_AUX_FUNC(rdsGetBlockDimensionsEx,RDS_BBhBrDw,"rdsGetBlockDimensionsEx")
    _RDS_AUX_FUNC(rdsDeleteSystemState,RDS_VI,"rdsDeleteSystemState")
    _RDS_AUX_FUNC(rdsVSSetVarFlags,RDS_VHoIDwDw,"rdsVSSetVarFlags")
    _RDS_AUX_FUNC(rdsMakeUniqueBlockNameA,RDS_SBhS,"rdsMakeUniqueBlockNameA")
    _RDS_AUX_FUNC(rdsMakeUniqueBlockNameW,RDS_WsBhWs,"rdsMakeUniqueBlockNameW")
    _RDS_AUX_FUNC(rdsCSVCreate,RDS_HoV,"rdsCSVCreate")
    _RDS_AUX_FUNC(rdsCSVSetItemA,RDS_VHoIIS,"rdsCSVSetItemA")
    _RDS_AUX_FUNC(rdsCSVSetItemW,RDS_VHoIIWs,"rdsCSVSetItemW")
    _RDS_AUX_FUNC(rdsCSVGetItemA,RDS_SHoII,"rdsCSVGetItemA")
    _RDS_AUX_FUNC(rdsCSVGetItemW,RDS_WsHoII,"rdsCSVGetItemW")
    _RDS_AUX_FUNC(rdsStringReplaceA,RDS_SSpSpSIDw,"rdsStringReplaceA")
    _RDS_AUX_FUNC(rdsStringReplaceW,RDS_WsWspWspWsIDw,"rdsStringReplaceW")
    _RDS_AUX_FUNC(rdsDynStrCopyA,RDS_SS,"rdsDynStrCopyA")
    _RDS_AUX_FUNC(rdsDynStrCopyW,RDS_WsWs,"rdsDynStrCopyW")
    _RDS_AUX_FUNC(rdsCallFileDialogA,RDS_SSDwSSS,"rdsCallFileDialogA")
    _RDS_AUX_FUNC(rdsCallFileDialogW,RDS_WsWsDwWsWsWs,"rdsCallFileDialogW")
    _RDS_AUX_FUNC(rdsCallDirDialogA,RDS_SSSB,"rdsCallDirDialogA")
    _RDS_AUX_FUNC(rdsCallDirDialogW,RDS_WsWsWsB,"rdsCallDirDialogW")
    _RDS_AUX_FUNC(rdsTransformFileNameA,RDS_SSDwSpI,"rdsTransformFileNameA")
    _RDS_AUX_FUNC(rdsTransformFileNameW,RDS_WsWsDwWspI,"rdsTransformFileNameW")
    _RDS_AUX_FUNC(rdsTMPCreateFileSet,RDS_IV,"rdsTMPCreateFileSet")
    _RDS_AUX_FUNC(rdsTMPDeleteFileSet,RDS_VI,"rdsTMPDeleteFileSet")
    _RDS_AUX_FUNC(rdsTMPCreateEmptyFileA,RDS_SIS,"rdsTMPCreateEmptyFileA")
    _RDS_AUX_FUNC(rdsTMPCreateEmptyFileW,RDS_WsIWs,"rdsTMPCreateEmptyFileW")
    _RDS_AUX_FUNC(rdsTMPDeleteFileA,RDS_VS,"rdsTMPDeleteFileA")
    _RDS_AUX_FUNC(rdsTMPDeleteFileW,RDS_VWs,"rdsTMPDeleteFileW")
    _RDS_AUX_FUNC(rdsTMPRememberFileNameA,RDS_SIS,"rdsTMPRememberFileNameA")
    _RDS_AUX_FUNC(rdsTMPRememberFileNameW,RDS_WsIWs,"rdsTMPRememberFileNameW")
    _RDS_AUX_FUNC(rdsGetLayerIdInConfig,RDS_IBhII,"rdsGetLayerIdInConfig")
    _RDS_AUX_FUNC(rdsGetTextWordDynA,RDS_SSpSpCB,"rdsGetTextWordDynA")
    _RDS_AUX_FUNC(rdsGetTextWordDynW,RDS_WsSpSpCB,"rdsGetTextWordDynW")
    _RDS_AUX_FUNC(rdsCEAddChannelA,RDS_BHoSCSI,"rdsCEAddChannelA")
    _RDS_AUX_FUNC(rdsCEAddChannelW,RDS_BHoWsCWsI,"rdsCEAddChannelW")
    _RDS_AUX_FUNC(rdsReportToolInfoA,RDS_VS,"rdsReportToolInfoA")
    _RDS_AUX_FUNC(rdsReportToolInfoW,RDS_VWs,"rdsReportToolInfoW")
    _RDS_AUX_FUNC(rdsSetToolTimer,RDS_VDw,"rdsSetToolTimer")
    _RDS_AUX_FUNC(rdsExecToolA,RDS_IDwSSIS,"rdsExecToolA")
    _RDS_AUX_FUNC(rdsExecToolW,RDS_IDwWsWsIWs,"rdsExecToolW")
    _RDS_AUX_FUNC(rdsSaveSystemBitmapA,RDS_BS1d,"rdsSaveSystemBitmapA")
    _RDS_AUX_FUNC(rdsSaveSystemBitmapW,RDS_BS1d,"rdsSaveSystemBitmapW")
    _RDS_AUX_FUNC(rdsPictureObjectDimensions,RDS_BIDwBr,"rdsPictureObjectDimensions")
    _RDS_AUX_FUNC(rdsSuspendCalc,RDS_BBhB,"rdsSuspendCalc")
    _RDS_AUX_FUNC(rdsServiceVersionDate,RDS_DwV,"rdsServiceVersionDate")
    _RDS_AUX_FUNC(rdsReportVersion,RDS_VIDw,"rdsReportVersion")
    _RDS_AUX_FUNC(rdsVSCompare,RDS_BHoHoDw,"rdsVSCompare")
    _RDS_AUX_FUNC(rdsGetBlockVarTypeStringA,RDS_SBh,"rdsGetBlockVarTypeStringA")
    _RDS_AUX_FUNC(rdsGetBlockVarTypeStringW,RDS_WsBh,"rdsGetBlockVarTypeStringW")
    _RDS_AUX_FUNC(rdsBLOBStartWrite,RDS_VIIB,"rdsBLOBStartWrite")
    _RDS_AUX_FUNC(rdsBLOBWrite,RDS_BpVI,"rdsBLOBWrite")
    _RDS_AUX_FUNC(rdsBLOBEndWrite,RDS_VV,"rdsBLOBEndWrite")
    _RDS_AUX_FUNC(rdsBLOBStartRead,RDS_BII,"rdsBLOBStartRead")
    _RDS_AUX_FUNC(rdsBLOBRead,RDS_BpVI,"rdsBLOBRead")
    _RDS_AUX_FUNC(rdsBLOBEndRead,RDS_VV,"rdsBLOBEndRead")
    _RDS_AUX_FUNC(rdsGetIOBlockByVarNum,RDS_BhBhIBd,"rdsGetIOBlockByVarNum")
    _RDS_AUX_FUNC(rdsSetEditorWorkspace,RDS_BBhII,"rdsSetEditorWorkspace")
    _RDS_AUX_FUNC(rdsShowHelpA,RDS_ISSB,"rdsShowHelpA")
    _RDS_AUX_FUNC(rdsShowHelpW,RDS_IWsWsB,"rdsShowHelpW")
    _RDS_AUX_FUNC(rdsShowHelpFileA,RDS_ISSB,"rdsShowHelpFileA")
    _RDS_AUX_FUNC(rdsShowHelpFileW,RDS_IWsWsB,"rdsShowHelpFileW")
    _RDS_AUX_FUNC(rdsRegisterConnExtParamNameA,RDS_IS,"rdsRegisterConnExtParamNameA")
    _RDS_AUX_FUNC(rdsRegisterConnExtParamNameW,RDS_IWs,"rdsRegisterConnExtParamNameW")
    _RDS_AUX_FUNC(rdsGetConnExtParamsCount,RDS_ICh,"rdsGetConnExtParamsCount")
    _RDS_AUX_FUNC(rdsGetConnExtParamByNumA,RDS_IChIpSpIpIpDpS,"rdsGetConnExtParamByNumA")
    _RDS_AUX_FUNC(rdsGetConnExtParamByNumW,RDS_IChIpWspIpIpDpWs,"rdsGetConnExtParamByNumW")
    _RDS_AUX_FUNC(rdsGetConnExtParamByIdA,RDS_IChIpIpDpS,"rdsGetConnExtParamByIdA")
    _RDS_AUX_FUNC(rdsGetConnExtParamByIdW,RDS_IChIpIpDpWs,"rdsGetConnExtParamByIdW")
    _RDS_AUX_FUNC(rdsSetConnExtParamByIdA,RDS_BChIIIDS,"rdsSetConnExtParamByIdA")
    _RDS_AUX_FUNC(rdsSetConnExtParamByIdW,RDS_BChIIIDWs,"rdsSetConnExtParamByIdW")
    _RDS_AUX_FUNC(rdsConnSetupMenuNameA,RDS_VS,"rdsConnSetupMenuNameA")
    _RDS_AUX_FUNC(rdsConnSetupMenuNameW,RDS_VWs,"rdsConnSetupMenuNameW")
    _RDS_AUX_FUNC(rdsEnumDynVarsA,RDS_IBhDwCb7pV,"rdsEnumDynVarsA")
    _RDS_AUX_FUNC(rdsEnumDynVarsW,RDS_IBhDwCb7wpV,"rdsEnumDynVarsW")
    _RDS_AUX_FUNC(rdsGetConnExtParamByNumExA,RDS_IChIpSpIpIpDpSpDw,"rdsGetConnExtParamByNumExA")
    _RDS_AUX_FUNC(rdsGetConnExtParamByNumExW,RDS_IChIpWspIpIpDpWspDw,"rdsGetConnExtParamByNumExW")
    _RDS_AUX_FUNC(rdsGetConnExtParamByIdExA,RDS_IChIpIpDpSpDw,"rdsGetConnExtParamByIdExA")
    _RDS_AUX_FUNC(rdsGetConnExtParamByIdExW,RDS_IChIpIpDpWspDw,"rdsGetConnExtParamByIdExW")
    _RDS_AUX_FUNC(rdsSetConnExtParamByIdExA,RDS_BChIIIDSDw,"rdsSetConnExtParamByIdExA")
    _RDS_AUX_FUNC(rdsSetConnExtParamByIdExW,RDS_BChIIIDWsDw,"rdsSetConnExtParamByIdExW")
    _RDS_AUX_FUNC(rdsCallSaveAsDialog,RDS_BV,"rdsCallSaveAsDialog")
    _RDS_AUX_FUNC(rdsSetObjectPtrA,RDS_VHoISpV,"rdsSetObjectPtrA")
    _RDS_AUX_FUNC(rdsSetObjectPtrW,RDS_VHoIWspV,"rdsSetObjectPtrW")
    _RDS_AUX_FUNC(rdsGetObjectPtrA,RDS_pVHoIpS,"rdsGetObjectPtrA")
    _RDS_AUX_FUNC(rdsGetObjectPtrW,RDS_pVHoIpWs,"rdsGetObjectPtrW")
    _RDS_AUX_FUNC(rdsExchangeVarArrays,RDS_BpVpV,"rdsExchangeVarArrays")
    _RDS_AUX_FUNC(rdsGetVarArrayElementType,RDS_IpV,"rdsGetVarArrayElementType")
    _RDS_AUX_FUNC(rdsCopySelectedToMem,RDS_pVBhpIDw,"rdsCopySelectedToMem")
    _RDS_AUX_FUNC(rdsSelectConn,RDS_VChBB,"rdsSelectConn")
    _RDS_AUX_FUNC(rdsSelectAll,RDS_VBhBB,"rdsSelectAll")
    _RDS_AUX_FUNC(rdsPasteFromMem,RDS_BBhpVIDw,"rdsPasteFromMem")
    _RDS_AUX_FUNC(rdsDeleteSelected,RDS_VBhB,"rdsDeleteSelected")
    _RDS_AUX_FUNC(rdsCEUCreate,RDS_HoCh,"rdsCEUCreate")
    _RDS_AUX_FUNC(rdsSubscribeToContentChange,RDS_VB,"rdsSubscribeToContentChange")
    _RDS_AUX_FUNC(rdsUnsubscribeFromContentChange,RDS_VV,"rdsUnsubscribeFromContentChange")
    _RDS_AUX_FUNC(rdsSetSysModifiedFlag,RDS_VBhB,"rdsSetSysModifiedFlag")
    _RDS_AUX_FUNC(rdsTMPForgetFileNameA,RDS_BIS,"rdsTMPForgetFileNameA")
    _RDS_AUX_FUNC(rdsTMPForgetFileNameW,RDS_BIWs,"rdsTMPForgetFileNameW")
    _RDS_AUX_FUNC(rdscompGetModelModuleData,RDS_CdCh,"rdscompGetModelModuleData")
    _RDS_AUX_FUNC(rdscompIsEditorOpen,RDS_BMh,"rdscompIsEditorOpen")
    _RDS_AUX_FUNC(rdsExclusiveFileOpA,RDS_VSDw,"rdsExclusiveFileOpA")
    _RDS_AUX_FUNC(rdsExclusiveFileOpW,RDS_VWsDw,"rdsExclusiveFileOpW")
    _RDS_AUX_FUNC(rdsInfoMessageA,RDS_VSS,"rdsInfoMessageA")
    _RDS_AUX_FUNC(rdsInfoMessageW,RDS_VWsWs,"rdsInfoMessageW")
    _RDS_AUX_FUNC(rdscompCompileAll,RDS_BB,"rdscompCompileAll")
    _RDS_AUX_FUNC(rdsVSCreateAutoConnsByDescrA,RDS_BHoS,"rdsVSCreateAutoConnsByDescrA")
    _RDS_AUX_FUNC(rdsVSCreateAutoConnsByDescrW,RDS_BHoWs,"rdsVSCreateAutoConnsByDescrW")
    _RDS_AUX_FUNC(rdscompLibraryOperation,RDS_BLop,"rdscompLibraryOperation")
    _RDS_AUX_FUNC(rdsStoreTempGlobalA,RDS_VSSISpVDw,"rdsStoreTempGlobalA")
    _RDS_AUX_FUNC(rdsStoreTempGlobalW,RDS_VWsWsIWspVDw,"rdsStoreTempGlobalW")
    _RDS_AUX_FUNC(rdsReadTempGlobalA,RDS_BSSpIpSppVpDw,"rdsReadTempGlobalA")
    _RDS_AUX_FUNC(rdsReadTempGlobalW,RDS_BWsWspIpWsppVpDw,"rdsReadTempGlobalW")
    _RDS_AUX_FUNC(rdsDeleteConnExtParamById,RDS_BChI,"rdsDeleteConnExtParamById")
    _RDS_AUX_FUNC(rdsExecToolExtA,RDS_IDwSSS2,"rdsExecToolExtA")
    _RDS_AUX_FUNC(rdsExecToolExtW,RDS_IDwWsWsS2,"rdsExecToolExtW")
    _RDS_AUX_FUNC(rdsClearExecToolExtResults,RDS_VS2,"rdsClearExecToolExtResults")
    _RDS_AUX_FUNC(rdsCountSelectedObjects,RDS_BBhpIpI,"rdsCountSelectedObjects")
    _RDS_AUX_FUNC(rdsFORMHelpButtonA,RDS_VHoDwSS,"rdsFORMHelpButtonA")
    _RDS_AUX_FUNC(rdsFORMHelpButtonW,RDS_VHoDwWsWs,"rdsFORMHelpButtonW")
    _RDS_AUX_FUNC(rdsRegisterUserNameSetA,RDS_IS,"rdsRegisterUserNameSetA")
    _RDS_AUX_FUNC(rdsRegisterUserNameSetW,RDS_IWs,"rdsRegisterUserNameSetW")
    _RDS_AUX_FUNC(rdsRegisterUserNameA,RDS_IIS,"rdsRegisterUserNameA")
    _RDS_AUX_FUNC(rdsRegisterUserNameW,RDS_IIWs,"rdsRegisterUserNameW")
    _RDS_AUX_FUNC(rdsGetRegisteredUserNameA,RDS_SII,"rdsGetRegisteredUserNameA")
    _RDS_AUX_FUNC(rdsGetRegisteredUserNameW,RDS_WsII,"rdsGetRegisteredUserNameW")
    _RDS_AUX_FUNC(rdsGetBlockVarOffset,RDS_IBhIpI,"rdsGetBlockVarOffset")
    _RDS_AUX_FUNC(rdsRegisterGlobalIntVarA,RDS_pIS,"rdsRegisterGlobalIntVarA")
    _RDS_AUX_FUNC(rdsRegisterGlobalIntVarW,RDS_pIWs,"rdsRegisterGlobalIntVarW")
    _RDS_AUX_FUNC(rdscompForceModelNextCompile,RDS_VMhB,"rdscompForceModelNextCompile")
    _RDS_AUX_FUNC(rdsDoInitialCalc,RDS_VBhDw,"rdsDoInitialCalc")
    _RDS_AUX_FUNC(rdsShiftBakFileChainA,RDS_BSIS,"rdsShiftBakFileChainA")
    _RDS_AUX_FUNC(rdsShiftBakFileChainW,RDS_BWsIWs,"rdsShiftBakFileChainW")
    _RDS_AUX_FUNC(rdsGetBlockTextRectParams,RDS_BBhpBtrpFs,"rdsGetBlockTextRectParams")
    _RDS_AUX_FUNC(rdsSetBlockTextRectParamsA,RDS_BBhpBtrpFsDw,"rdsSetBlockTextRectParamsA")
    _RDS_AUX_FUNC(rdsSetBlockTextRectParamsW,RDS_BBhpBtrpFsDw,"rdsSetBlockTextRectParamsW")
    _RDS_AUX_FUNC(rdsINTCreate,RDS_HoB,"rdsINTCreate")
    _RDS_AUX_FUNC(rdsSCEUCreate,RDS_HoBh,"rdsSCEUCreate")
    _RDS_AUX_FUNC(rdsSCEUSaveBlock,RDS_VHoBhDw,"rdsSCEUSaveBlock")
    _RDS_AUX_FUNC(rdsSCEUSaveConn,RDS_VHoChDw,"rdsSCEUSaveConn")
    _RDS_AUX_FUNC(rdsExecToolDelayedA,RDS_VDwSSS,"rdsExecToolDelayedA")
    _RDS_AUX_FUNC(rdsExecToolDelayedW,RDS_VDwWsWsWs,"rdsExecToolDelayedW")
    _RDS_AUX_FUNC(rdsLockDrawUpdates,RDS_BBhDw,"rdsLockDrawUpdates")
    _RDS_AUX_FUNC(rdsXGDrawBitmap,RDS_VIIHb,"rdsXGDrawBitmap")
    _RDS_AUX_FUNC(rdsGetEditorWinAndScroll,RDS_BBhpIpIpIpIpIpI,"rdsGetEditorWinAndScroll")
    _RDS_AUX_FUNC(rdsGBLCreateA,RDS_HoS,"rdsGBLCreateA")
    _RDS_AUX_FUNC(rdsGBLCreateW,RDS_HoWs,"rdsGBLCreateW")
    _RDS_AUX_FUNC(rdsGBLBlockOp,RDS_VHoBhDw,"rdsGBLBlockOp")
    _RDS_AUX_FUNC(rdsGBLGetBlock,RDS_BhHoI,"rdsGBLGetBlock")
    _RDS_AUX_FUNC(rdsGBLBroadcastFunctionCalls,RDS_IHoIpVDw,"rdsGBLBroadcastFunctionCalls")
    _RDS_AUX_FUNC(rdsXGDrawStdIconDC,RDS_VDcIIDw,"rdsXGDrawStdIconDC")
    _RDS_AUX_FUNC(rdsInvalidateSystemWindows,RDS_VBhB,"rdsInvalidateSystemWindows")
    _RDS_AUX_FUNC(rdsSaveBlockToFileA,RDS_BBhSDwS,"rdsSaveBlockToFileA")
    _RDS_AUX_FUNC(rdsSaveBlockToFileW,RDS_BBhWsDwWs,"rdsSaveBlockToFileW")
    _RDS_AUX_FUNC(rdsSetBlockOrder,RDS_BhIBh,"rdsSetBlockOrder")
    _RDS_AUX_FUNC(rdsSetConnOrder,RDS_ChICh,"rdsSetConnOrder")
    _RDS_AUX_FUNC(rdsSetConnTextA,RDS_BChDwSIBII,"rdsSetConnTextA")
    _RDS_AUX_FUNC(rdsSetConnTextW,RDS_BChDwWsIBII,"rdsSetConnTextW")
    _RDS_AUX_FUNC(rdscompCompileBlockModelDelayed,RDS_VBhB,"rdscompCompileBlockModelDelayed")
    _RDS_AUX_FUNC(rdsFileExistsA,RDS_BSSpSpI,"rdsFileExistsA")
    _RDS_AUX_FUNC(rdsFileExistsW,RDS_BWsWspWspI,"rdsFileExistsW")
    _RDS_AUX_FUNC(rdsBlockStateToBuffer,RDS_pVBhpDw,"rdsBlockStateToBuffer")
    _RDS_AUX_FUNC(rdsBlockStateFromBuffer,RDS_BBhpVDw,"rdsBlockStateFromBuffer")
    _RDS_AUX_FUNC(rdsCreateSharedMemPlainA,RDS_SmISDw,"rdsCreateSharedMemPlainA")
    _RDS_AUX_FUNC(rdsCreateSharedMemPlainW,RDS_SmIWsDw,"rdsCreateSharedMemPlainW")
    _RDS_AUX_FUNC(rdsCreateSharedMemVarA,RDS_SmISS,"rdsCreateSharedMemVarA")
    _RDS_AUX_FUNC(rdsCreateSharedMemVarW,RDS_SmIWsWs,"rdsCreateSharedMemVarW")
    _RDS_AUX_FUNC(rdsDeleteSharedMem,RDS_VSm,"rdsDeleteSharedMem")
    _RDS_AUX_FUNC(rdsNotifySharedMemUsers,RDS_VSm,"rdsNotifySharedMemUsers")
    _RDS_AUX_FUNC(rdsEnumSharedMemUsers,RDS_BhSmCb8pV,"rdsEnumSharedMemUsers")
    _RDS_AUX_FUNC(rdsTranslateParameterA,RDS_SSIISpI,"rdsTranslateParameterA")
    _RDS_AUX_FUNC(rdsTranslateParameterW,RDS_WsWsIIWspI,"rdsTranslateParameterW")
    _RDS_AUX_FUNC(rdsTranslateTextA,RDS_SSIpI,"rdsTranslateTextA")
    _RDS_AUX_FUNC(rdsTranslateTextW,RDS_WsWsIpI,"rdsTranslateTextW")
    _RDS_AUX_FUNC(rdsSetConnTextExA,RDS_BChDwSIBIIB,"rdsSetConnTextExA")
    _RDS_AUX_FUNC(rdsSetConnTextExW,RDS_BChDwWsIBIIB,"rdsSetConnTextExW")
    _RDS_AUX_FUNC(rdsGetLayerConfigId,RDS_DwBhI,"rdsGetLayerConfigId")
    _RDS_AUX_FUNC(rdsGetLayerConfigNumById,RDS_IBhDw,"rdsGetLayerConfigNumById")
    _RDS_AUX_FUNC(rdsFORMTBLSetStrA,RDS_VHoIIIS,"rdsFORMTBLSetStrA")
    _RDS_AUX_FUNC(rdsFORMTBLSetStrW,RDS_VHoIIIWs,"rdsFORMTBLSetStrW")
    _RDS_AUX_FUNC(rdsFORMTBLGetStrA,RDS_SHoIIIpB,"rdsFORMTBLGetStrA")
    _RDS_AUX_FUNC(rdsFORMTBLGetStrW,RDS_WsHoIIIpB,"rdsFORMTBLGetStrW")
    _RDS_AUX_FUNC(rdsFORMTBLSetHeaderA,RDS_VHoIISDwI,"rdsFORMTBLSetHeaderA")
    _RDS_AUX_FUNC(rdsFORMTBLSetHeaderW,RDS_VHoIIWsDwI,"rdsFORMTBLSetHeaderW")
    _RDS_AUX_FUNC(rdsFORMTBLSetInt,RDS_VHoIIII,"rdsFORMTBLSetInt")
    _RDS_AUX_FUNC(rdsFORMTBLGetInt,RDS_IHoIIIpB,"rdsFORMTBLGetInt")
    _RDS_AUX_FUNC(rdsFORMTBLSetDouble,RDS_VHoIIID,"rdsFORMTBLSetDouble")
    _RDS_AUX_FUNC(rdsFORMTBLGetDouble,RDS_DHoIIIpB,"rdsFORMTBLGetDouble")
    _RDS_AUX_FUNC(rdsFORMTBLGetDoubleP,RDS_BHoIIIpD,"rdsFORMTBLGetDoubleP")
    _RDS_AUX_FUNC(rdsFORMTBLMoveLine,RDS_BHoIII,"rdsFORMTBLMoveLine")
    _RDS_AUX_FUNC(rdsCreateSystemA,RDS_BhBhSIIBhDw,"rdsCreateSystemA")
    _RDS_AUX_FUNC(rdsCreateSystemW,RDS_BhBhWsIIBhDw,"rdsCreateSystemW")
    _RDS_AUX_FUNC(rdsNetListServerChannelsA,RDS_SI,"rdsNetListServerChannelsA")
    _RDS_AUX_FUNC(rdsNetListServerChannelsW,RDS_WsI,"rdsNetListServerChannelsW")
    _RDS_AUX_FUNC(rdsNetListChannelsA,RDS_SSI,"rdsNetListChannelsA")
    _RDS_AUX_FUNC(rdsNetListChannelsW,RDS_WsWsI,"rdsNetListChannelsW")
    _RDS_AUX_FUNC(rdsCreateBlockA,RDS_BhBhISII,"rdsCreateBlockA")
    _RDS_AUX_FUNC(rdsCreateBlockW,RDS_BhBhIWsII,"rdsCreateBlockW")
    _RDS_AUX_FUNC(rdsCESetInternalPoint,RDS_IHoIII,"rdsCESetInternalPoint")
    _RDS_AUX_FUNC(rdsCESetBlockPointA,RDS_IHoIBhSIIDwII,"rdsCESetBlockPointA")
    _RDS_AUX_FUNC(rdsCESetBlockPointW,RDS_IHoIBhWsIIDwII,"rdsCESetBlockPointW")
    _RDS_AUX_FUNC(rdsCESetBusPointA,RDS_IHoIChSBIIDwII,"rdsCESetBusPointA")
    _RDS_AUX_FUNC(rdsCESetBusPointW,RDS_IHoIChWsBIIDwII,"rdsCESetBusPointW")
    _RDS_AUX_FUNC(rdsCESetLine,RDS_IHoIII,"rdsCESetLine")
    _RDS_AUX_FUNC(rdsCESetBezier,RDS_IHoIIIIIII,"rdsCESetBezier")
    _RDS_AUX_FUNC(rdsCEReadConnBus,RDS_BHoCh,"rdsCEReadConnBus")
    _RDS_AUX_FUNC(rdsCEGetPointDescription,RDS_BHoIPd,"rdsCEGetPointDescription")
    _RDS_AUX_FUNC(rdsCEGetLineDescription,RDS_BHoILd,"rdsCEGetLineDescription")
    // 1.0.494
    _RDS_AUX_FUNC(rdsEnumConnectedBuses,RDS_ChChDwCb9pV,"rdsEnumConnectedBuses")
    _RDS_AUX_FUNC(rdsBusChannelNameByNumA,RDS_SChI,"rdsBusChannelNameByNumA")
    _RDS_AUX_FUNC(rdsBusChannelNameByNumW,RDS_WsChI,"rdsBusChannelNameByNumW")
    _RDS_AUX_FUNC(rdsEnumBusLinks,RDS_ChChIDwCb10pV,"rdsEnumBusLinks")
    // 1.0.496
    _RDS_AUX_FUNC(rdsGetBusChannelParamsA,RDS_BChIpSpCpSpDwpIpS,"rdsGetBusChannelParamsA")
    _RDS_AUX_FUNC(rdsGetBusChannelParamsW,RDS_BChIpWspCpWspDwpIpWs,"rdsGetBusChannelParamsW")
    _RDS_AUX_FUNC(rdsGetSystemPtr,RDS_pVIIpV,"rdsGetSystemPtr")
    // 1.0.497
    _RDS_AUX_FUNC(rdsCompareVarGeneral,RDS_BVhpVVhpVD,"rdsCompareVarGeneral")
    _RDS_AUX_FUNC(rdsEnumExternalDynVarsA,RDS_IBhDwCb7pV,"rdsEnumExternalDynVarsA")
    _RDS_AUX_FUNC(rdsEnumExternalDynVarsW,RDS_IBhDwCb7wpV,"rdsEnumExternalDynVarsW")
    // 1.0.498
    _RDS_AUX_FUNC(rdsEnumDynVarsExA,RDS_IBhDwCb11pV,"rdsEnumDynVarsExA")
    _RDS_AUX_FUNC(rdsEnumDynVarsExW,RDS_IBhDwCb11wpV,"rdsEnumDynVarsExW")
    _RDS_AUX_FUNC(rdsEnumExternalDynVarsExA,RDS_IBhDwCb11pV,"rdsEnumExternalDynVarsExA")
    _RDS_AUX_FUNC(rdsEnumExternalDynVarsExW,RDS_IBhDwCb11wpV,"rdsEnumExternalDynVarsExW")
    _RDS_AUX_FUNC(rdsGetVarParamsA,RDS_BVhpSpCpSpDwpIpS,"rdsGetVarParamsA")
    _RDS_AUX_FUNC(rdsGetVarParamsW,RDS_BVhpWspCpWspDwpIpWs,"rdsGetVarParamsW")
    _RDS_AUX_FUNC(rdsVarTypeTextByParamsA,RDS_SCSDwI,"rdsVarTypeTextByParamsA")
    _RDS_AUX_FUNC(rdsVarTypeTextByParamsW,RDS_WsCWsDwI,"rdsVarTypeTextByParamsW")
    _RDS_AUX_FUNC(rdsVarParamsByTypeTextA,RDS_BSpCpSpDwpI,"rdsVarParamsByTypeTextA")
    _RDS_AUX_FUNC(rdsVarParamsByTypeTextW,RDS_BWspCpWspDwpI,"rdsVarParamsByTypeTextW")
    _RDS_AUX_FUNC(rdsBlockVarCompareMem,RDS_BBhIpVID,"rdsBlockVarCompareMem")
    // 1.0.499
    _RDS_AUX_FUNC(rdsFORMTBLSetColTextListA,RDS_VHoIIS,"rdsFORMTBLSetColTextListA")
    _RDS_AUX_FUNC(rdsFORMTBLSetColTextListW,RDS_VHoIIWs,"rdsFORMTBLSetColTextListW")
    _RDS_AUX_FUNC(rdsFORMTBLSetColDefValueA,RDS_VHoIIS,"rdsFORMTBLSetColDefValueA")
    _RDS_AUX_FUNC(rdsFORMTBLSetColDefValueW,RDS_VHoIIWs,"rdsFORMTBLSetColDefValueW")
    // 1.0.500
    _RDS_AUX_FUNC(rdsFORMTBLSetServFunc,RDS_VHoICb6,"rdsFORMTBLSetServFunc")
    // 1.0.504
    _RDS_AUX_FUNC(rdsCWCreateA,RDS_HoBhSIICwDw,"rdsCWCreateA")
    _RDS_AUX_FUNC(rdsCWCreateW,RDS_HoBhWsIICwDw,"rdsCWCreateW")
    // 1.0.505
    _RDS_AUX_FUNC(rdsCWGetParameters,RDS_BHoCw,"rdsCWGetParameters")
    _RDS_AUX_FUNC(rdsCWCreateCopyA,RDS_HoBhSIIDwHo,"rdsCWCreateCopyA")
    _RDS_AUX_FUNC(rdsCWCreateCopyW,RDS_HoBhWsIIDwHo,"rdsCWCreateCopyW")
    // 1.0.508
    _RDS_AUX_FUNC(rdsCWTranslateChanges,RDS_BHoHo,"rdsCWTranslateChanges")
    // 1.0.511
    _RDS_AUX_FUNC(rdsForceDirectoriesA,RDS_BSDw,"rdsForceDirectoriesA")
    _RDS_AUX_FUNC(rdsForceDirectoriesW,RDS_BWsDw,"rdsForceDirectoriesW")
    // 1.0.512
    _RDS_AUX_FUNC(rdsResetAllBlockSignals,RDS_VBhI,"rdsResetAllBlockSignals")
    // 1.0.514
    _RDS_AUX_FUNC(rdsGetUICurrentModA,RDS_SSFt,"rdsGetUICurrentModA")
    _RDS_AUX_FUNC(rdsGetUICurrentModW,RDS_WsWsFt,"rdsGetUICurrentModW")
    _RDS_AUX_FUNC(rdsUIMODCreate,RDS_HoV,"rdsUIMODCreate")
    _RDS_AUX_FUNC(rdsUIMODLoadGroupA,RDS_BHoSS,"rdsUIMODLoadGroupA")
    _RDS_AUX_FUNC(rdsUIMODLoadGroupW,RDS_BHoWsWs,"rdsUIMODLoadGroupW")
    _RDS_AUX_FUNC(rdsUIMODGetParamStringA,RDS_SHoSIS,"rdsUIMODGetParamStringA")
    _RDS_AUX_FUNC(rdsUIMODGetParamStringW,RDS_WsHoWsIWs,"rdsUIMODGetParamStringW")
    _RDS_AUX_FUNC(rdsUIMODGetParamStrByNumA,RDS_SHoSIpIS,"rdsUIMODGetParamStrByNumA")
    _RDS_AUX_FUNC(rdsUIMODGetParamStrByNumW,RDS_WsHoWsIpIWs,"rdsUIMODGetParamStrByNumW")
    _RDS_AUX_FUNC(rdsGetUIModsListA,RDS_SS,"rdsGetUIModsListA")
    _RDS_AUX_FUNC(rdsGetUIModsListW,RDS_WsWs,"rdsGetUIModsListW")
    _RDS_AUX_FUNC(rdsUIMODGetParamStrByNameA,RDS_SHoSSS,"rdsUIMODGetParamStrByNameA")
    _RDS_AUX_FUNC(rdsUIMODGetParamStrByNameW,RDS_WsHoWsWsWs,"rdsUIMODGetParamStrByNameW")
    _RDS_AUX_FUNC(rdsUIMODSetParamStrByNameA,RDS_VHoSSS,"rdsUIMODSetParamStrByNameA")
    _RDS_AUX_FUNC(rdsUIMODSetParamStrByNameW,RDS_VHoWsWsWs,"rdsUIMODSetParamStrByNameW")
    // 1.0.516
    _RDS_AUX_FUNC(rdsBMPCreateA,RDS_HoS,"rdsBMPCreateA")
    _RDS_AUX_FUNC(rdsBMPCreateW,RDS_HoWs,"rdsBMPCreateW")
    _RDS_AUX_FUNC(rdsBMPDraw,RDS_VHoII,"rdsBMPDraw")
    _RDS_AUX_FUNC(rdsBMPStretchDraw,RDS_VHoIIII,"rdsBMPStretchDraw")
    // 1.0.519
    _RDS_AUX_FUNC(rdsUIMODLoadSingleObjectA,RDS_BHoSSS,"rdsUIMODLoadSingleObjectA")
    _RDS_AUX_FUNC(rdsUIMODLoadSingleObjectW,RDS_BHoWsWsWs,"rdsUIMODLoadSingleObjectW")
    _RDS_AUX_FUNC(rdsUIMODGetParamListStringA,RDS_SHoSIS,"rdsUIMODGetParamListStringA")
    _RDS_AUX_FUNC(rdsUIMODGetParamListStringW,RDS_WsHoWsIWs,"rdsUIMODGetParamListStringW")
    // 1.0.520
    _RDS_AUX_FUNC(rdsThisIsDebugVersion,RDS_VV,"rdsThisIsDebugVersion")
    // 1.0.538
    _RDS_AUX_FUNC(rdsVSCreateFromConnA,RDS_VHoChS,"rdsVSCreateFromConnA")
    _RDS_AUX_FUNC(rdsVSCreateFromConnW,RDS_VHoChWs,"rdsVSCreateFromConnW")
    // 1.0.542
    _RDS_AUX_FUNC(rdsSGPRegisterNameA,RDS_IS,"rdsSGPRegisterNameA")
    _RDS_AUX_FUNC(rdsSGPRegisterNameW,RDS_IWs,"rdsSGPRegisterNameW")
    _RDS_AUX_FUNC(rdsSGPSetDataA,RDS_BSgp,"rdsSGPSetDataA")
    _RDS_AUX_FUNC(rdsSGPSetDataW,RDS_BSgp,"rdsSGPSetDataW")
    _RDS_AUX_FUNC(rdsSGPGetDataA,RDS_BSgp,"rdsSGPGetDataA")
    _RDS_AUX_FUNC(rdsSGPGetDataW,RDS_BSgp,"rdsSGPGetDataW")
    _RDS_AUX_FUNC(rdsSGPDelete,RDS_BI,"rdsSGPDelete")
    _RDS_AUX_FUNC(rdsSGPGetDataByNum,RDS_BISgp,"rdsSGPGetDataByNum")
    // 1.0.544
    _RDS_AUX_FUNC(rdsAtoDwA,RDS_DwSpI,"rdsAtoDwA")
    _RDS_AUX_FUNC(rdsAtoDwW,RDS_DwWspI,"rdsAtoDwW")
    _RDS_AUX_FUNC(rdsDwtoAA,RDS_SDwII,"rdsDwtoAA")
    _RDS_AUX_FUNC(rdsDwtoAW,RDS_WsDwII,"rdsDwtoAW")
    // 1.0.545
    _RDS_AUX_FUNC(rdsRegisterFuncCallMenuItemA,RDS_ISDwIDwII,"rdsRegisterFuncCallMenuItemA")
    _RDS_AUX_FUNC(rdsRegisterFuncCallMenuItemW,RDS_IWsDwIDwII,"rdsRegisterFuncCallMenuItemW")
    _RDS_AUX_FUNC(rdsUnregisterFuncCallMenuItem,RDS_BI,"rdsUnregisterFuncCallMenuItem")
    _RDS_AUX_FUNC(rdsChangeFuncCallMenuItemA,RDS_BISDwIDw,"rdsChangeFuncCallMenuItemA")
    _RDS_AUX_FUNC(rdsChangeFuncCallMenuItemW,RDS_BIWsDwIDw,"rdsChangeFuncCallMenuItemW")
    _RDS_AUX_FUNC(rdsSetFuncCallMenuItemFlags,RDS_VIDw,"rdsSetFuncCallMenuItemFlags")
    _RDS_AUX_FUNC(rdsIncompatibleDll,RDS_VV,"rdsIncompatibleDll")
    // 1.0.546
    _RDS_AUX_FUNC(rdsNetGetServerConnectionData,RDS_IIIINgsc,"rdsNetGetServerConnectionData")
    _RDS_AUX_FUNC(rdsNetGetServerStationConnIndex,RDS_IINsNgsc,"rdsNetGetServerStationConnIndex")
    // 1.0.552
    _RDS_AUX_FUNC(rdsGetBlockClass,RDS_IBhI,"rdsGetBlockClass")
    _RDS_AUX_FUNC(rdsGetConnectionClass,RDS_IChI,"rdsGetConnectionClass")
    _RDS_AUX_FUNC(rdsGetObjectClassNameA,RDS_SI,"rdsGetObjectClassNameA")
    _RDS_AUX_FUNC(rdsGetObjectClassNameW,RDS_WsI,"rdsGetObjectClassNameW")
    _RDS_AUX_FUNC(rdsIsClassVisible,RDS_BBhII,"rdsIsClassVisible")
    _RDS_AUX_FUNC(rdsGetConnectionFlags,RDS_DwCh,"rdsGetConnectionFlags")
    _RDS_AUX_FUNC(rdsSetConnectionFlags,RDS_VChDwDw,"rdsSetConnectionFlags")
    // 1.0.553
    _RDS_AUX_FUNC(rdsSearchConnErrors,RDS_BChBhB,"rdsSearchConnErrors")
    // 1.0.554
    _RDS_AUX_FUNC(rdsSortVarArray,RDS_VpVIDw,"rdsSortVarArray")
    // 1.0.558
    _RDS_AUX_FUNC(rdsSetZoomPercentDbl,RDS_VBhDII,"rdsSetZoomPercentDbl")
    // 1.0.561
    _RDS_AUX_FUNC(rdsBringAppToFrontEx,RDS_VI,"rdsBringAppToFrontEx")
    // 1.0.563
    _RDS_AUX_FUNC(rdsShowSeeAlsoExamplesA,RDS_ISSB,"rdsShowSeeAlsoExamplesA")
    _RDS_AUX_FUNC(rdsShowSeeAlsoExamplesW,RDS_IWsWsB,"rdsShowSeeAlsoExamplesW")
    // 1.0.566
    _RDS_AUX_FUNC(rdsCanEditSystem,RDS_BBh,"rdsCanEditSystem")
    // 1.0.568
    _RDS_AUX_FUNC(rdsFORMMakeSearchA,RDS_VHoBIS,"rdsFORMMakeSearchA")
    _RDS_AUX_FUNC(rdsFORMMakeSearchW,RDS_VHoBIWs,"rdsFORMMakeSearchW")
    _RDS_AUX_FUNC(rdsFORMAddSearchResultA,RDS_VHoSS,"rdsFORMAddSearchResultA")
    _RDS_AUX_FUNC(rdsFORMAddSearchResultW,RDS_VHoWsWs,"rdsFORMAddSearchResultW")
    _RDS_AUX_FUNC(rdsFORMGetSearchResultA,RDS_BHoIpSpS,"rdsFORMGetSearchResultA")
    _RDS_AUX_FUNC(rdsFORMGetSearchResultW,RDS_BHoIpWspWs,"rdsFORMGetSearchResultW")
    // 1.0.571
    _RDS_AUX_FUNC(rdsBMPCreateExA,RDS_HoSIII,"rdsBMPCreateExA")
    _RDS_AUX_FUNC(rdsBMPCreateExW,RDS_HoWsIII,"rdsBMPCreateExW")
    // 1.0.572
    _RDS_AUX_FUNC(rdsFORMTBLExchangeLines,RDS_BHoIII,"rdsFORMTBLExchangeLines")
    // 1.0.584
    _RDS_AUX_FUNC(rdsGetObjectClassId,RDS_II,"rdsGetObjectClassId")
    _RDS_AUX_FUNC(rdsBlockBelongsToClass,RDS_BBhI,"rdsBlockBelongsToClass")
    _RDS_AUX_FUNC(rdsConnBelongsToClass,RDS_BChI,"rdsConnBelongsToClass")
    // 1.0.585
    _RDS_AUX_FUNC(rdsVSExecuteEditorExA,RDS_BHoBDwISCb12Cb12,"rdsVSExecuteEditorExA")
    _RDS_AUX_FUNC(rdsVSExecuteEditorExW,RDS_BHoBDwIWsCb12wCb12w,"rdsVSExecuteEditorExW")
    _RDS_AUX_FUNC(rdsPICCreate,RDS_HoBh,"rdsPICCreate")
    _RDS_AUX_FUNC(rdsVarToMem,RDS_pVVhpVBpI,"rdsVarToMem")
    _RDS_AUX_FUNC(rdsVarFromMem,RDS_BVhpVpVI,"rdsVarFromMem")
    // 1.0.586
    _RDS_AUX_FUNC(rdsVSGetVarParamsA,RDS_BHoIpSpCpSpDwpIpS,"rdsVSGetVarParamsA")
    _RDS_AUX_FUNC(rdsVSGetVarParamsW,RDS_BHoIpWspCpWspDwpIpWs,"rdsVSGetVarParamsW")
    _RDS_AUX_FUNC(rdsCreateVarTypeStringA,RDS_SVh,"rdsCreateVarTypeStringA")
    _RDS_AUX_FUNC(rdsCreateVarTypeStringW,RDS_WsVh,"rdsCreateVarTypeStringW")
    _RDS_AUX_FUNC(rdsFindBlockVarIndexA,RDS_IBhSVdpI,"rdsFindBlockVarIndexA")
    _RDS_AUX_FUNC(rdsFindBlockVarIndexW,RDS_IBhWsVdpI,"rdsFindBlockVarIndexW")
    _RDS_AUX_FUNC(rdsMatchesMaskA,RDS_BSSB,"rdsMatchesMaskA")
    _RDS_AUX_FUNC(rdsMatchesMaskW,RDS_BWsWsB,"rdsMatchesMaskW")
    // 1.0.587
    _RDS_AUX_FUNC(rdsGetBlockConnPoint,RDS_ChBhIBBPd,"rdsGetBlockConnPoint")
    _RDS_AUX_FUNC(rdsIsHugeDoubleSafe,RDS_BpD,"rdsIsHugeDoubleSafe")
    // 1.0.589
    _RDS_AUX_FUNC(rdsVarArrayOp,RDS_BpVpVIIIII,"rdsVarArrayOp")
    // 1.0.597
    _RDS_AUX_FUNC(rdsIsValidVarNameRemA,RDS_BSIB,"rdsIsValidVarNameRemA")
    _RDS_AUX_FUNC(rdsIsValidVarNameRemW,RDS_BWsIB,"rdsIsValidVarNameRemW")
    // 1.0.602
    _RDS_AUX_FUNC(rdsConsoleWindowOpA,RDS_HwIIS,"rdsConsoleWindowOpA")
    _RDS_AUX_FUNC(rdsConsoleWindowOpW,RDS_HwIIWs,"rdsConsoleWindowOpW")
    // 1.0.603
    _RDS_AUX_FUNC(rdsVNCreateNameValidatorA,RDS_HoDwS,"rdsVNCreateNameValidatorA")
    _RDS_AUX_FUNC(rdsVNCreateNameValidatorW,RDS_HoDwWs,"rdsVNCreateNameValidatorW")
    _RDS_AUX_FUNC(rdsVNCheckA,RDS_IHoS,"rdsVNCheckA")
    _RDS_AUX_FUNC(rdsVNCheckW,RDS_IHoWs,"rdsVNCheckW")
    _RDS_AUX_FUNC(rdsVNValidateA,RDS_SHoSpI,"rdsVNValidateA")
    _RDS_AUX_FUNC(rdsVNValidateW,RDS_WsHoWspI,"rdsVNValidateW")
    _RDS_AUX_FUNC(rdsGetObjectPtrCheckA,RDS_pVHoIS,"rdsGetObjectPtrCheckA")
    _RDS_AUX_FUNC(rdsGetObjectPtrCheckW,RDS_pVHoIWs,"rdsGetObjectPtrCheckW")
    _RDS_AUX_FUNC(rdsVSApplyVarRenames,RDS_BHoBh,"rdsVSApplyVarRenames")
    _RDS_AUX_FUNC(rdsGetBlockType,RDS_IBh,"rdsGetBlockType")
    _RDS_AUX_FUNC(rdsGetExtId,RDS_DwBhCh,"rdsGetExtId")
    // 1.0.604
    _RDS_AUX_FUNC(rdsFORMTBLSortTable,RDS_IHoIBpIII,"rdsFORMTBLSortTable")
    _RDS_AUX_FUNC(rdsBCLGetBlockIndex,RDS_IHoBh,"rdsBCLGetBlockIndex")
    _RDS_AUX_FUNC(rdsBCLGetConnIndex,RDS_IHoCh,"rdsBCLGetConnIndex")
    // 1.0.605
    _RDS_AUX_FUNC(rdsMUOCreate,RDS_HoV,"rdsMUOCreate")
    _RDS_AUX_FUNC(rdsMUOBlockOp,RDS_VHoIBhDw,"rdsMUOBlockOp")
    _RDS_AUX_FUNC(rdsMUOConnOp,RDS_VHoIChDw,"rdsMUOConnOp")
    // 1.0.606
    _RDS_AUX_FUNC(rdsBCLRemoveBlock,RDS_IHoBh,"rdsBCLRemoveBlock")
    _RDS_AUX_FUNC(rdsBCLRemoveConn,RDS_IHoCh,"rdsBCLRemoveConn")
    // 1.0.607
    _RDS_AUX_FUNC(rdsSetBlockClass,RDS_VBhII,"rdsSetBlockClass")
    _RDS_AUX_FUNC(rdsSetConnectionClass,RDS_VChII,"rdsSetConnectionClass")
    // 1.0.609
    _RDS_AUX_FUNC(rdsScrollWindowToRectEx,RDS_VBhIIIIDw,"rdsScrollWindowToRectEx")
    // 1.0.610
    _RDS_AUX_FUNC(rdsINFOCreate,RDS_HoV,"rdsINFOCreate")
    _RDS_AUX_FUNC(rdsINFOSetSize,RDS_VHoII,"rdsINFOSetSize")
    _RDS_AUX_FUNC(rdsINFOSetPos,RDS_VHoBIIII,"rdsINFOSetPos")
    _RDS_AUX_FUNC(rdsINFOSetRelPosBySys,RDS_VHoBhII,"rdsINFOSetRelPosBySys")
    _RDS_AUX_FUNC(rdsINFOSetRelPosPrimary,RDS_VHoII,"rdsINFOSetRelPosPrimary")
    // 1.0.613
    _RDS_AUX_FUNC(rdsSaveWindowConfigA,RDS_VS3,"rdsSaveWindowConfigA")
    _RDS_AUX_FUNC(rdsSaveWindowConfigW,RDS_VS3,"rdsSaveWindowConfigW")
    // 1.0.625
    _RDS_AUX_FUNC(rdsAuxThreadStart,RDS_ThCb13Cb13pV,"rdsAuxThreadStart")
    _RDS_AUX_FUNC(rdsAuxThreadSync,RDS_VThCb14pV,"rdsAuxThreadSync")
    _RDS_AUX_FUNC(rdsAuxThreadAskStop,RDS_VTh,"rdsAuxThreadAskStop")
    _RDS_AUX_FUNC(rdsFORMSetMainButtonsA,RDS_VHoISB,"rdsFORMSetMainButtonsA")
    _RDS_AUX_FUNC(rdsFORMSetMainButtonsW,RDS_VHoIWsB,"rdsFORMSetMainButtonsW")
    // 1.0.626
    _RDS_AUX_FUNC(rdsBMPCreateManual,RDS_HoII,"rdsBMPCreateManual")
    _RDS_AUX_FUNC(rdsBMPManualDraw,RDS_VHoCb15pV,"rdsBMPManualDraw")
    // 2.0.0
    _RDS_AUX_FUNC(rdsUTF16toUTF8,RDS_SWsB,"rdsUTF16toUTF8")
    _RDS_AUX_FUNC(rdsUTF8toUTF16,RDS_WsSB,"rdsUTF8toUTF16")
    _RDS_AUX_FUNC(rdscompLinkAvailableModuleA,RDS_BS,"rdscompLinkAvailableModuleA")
    _RDS_AUX_FUNC(rdscompLinkAvailableModuleW,RDS_BWs,"rdscompLinkAvailableModuleW")
    _RDS_AUX_FUNC(rdscompLinkModuleAllowed,RDS_BV,"rdscompLinkModuleAllowed")
    _RDS_AUX_FUNC(rdscompSetModelFunctionExA,RDS_VMhISS,"rdscompSetModelFunctionExA")
    _RDS_AUX_FUNC(rdscompSetModelFunctionExW,RDS_VMhIWsWs,"rdscompSetModelFunctionExW")
    _RDS_AUX_FUNC(rdsGetEnvironmentVariableA,RDS_SS,"rdsGetEnvironmentVariableA")
    _RDS_AUX_FUNC(rdsGetEnvironmentVariableW,RDS_WsWs,"rdsGetEnvironmentVariableW")
    _RDS_AUX_FUNC(rdsSetEnvironmentVariableA,RDS_SSSB,"rdsSetEnvironmentVariableA")
    _RDS_AUX_FUNC(rdsSetEnvironmentVariableW,RDS_WsWsWsB,"rdsSetEnvironmentVariableW")
    _RDS_AUX_FUNC(rdsInitExecToolExtData,RDS_VS2,"rdsInitExecToolExtData")
    _RDS_AUX_FUNC(rdscompTestCompileA,RDS_BSSSpSpSpS,"rdscompTestCompileA")
    _RDS_AUX_FUNC(rdscompTestCompileW,RDS_BWsWsWspWspWspWs,"rdscompTestCompileW")
    _RDS_AUX_FUNC(rdscompTestCompReturnStringA,RDS_VIS,"rdscompTestCompReturnStringA")
    _RDS_AUX_FUNC(rdscompTestCompReturnStringW,RDS_VIWs,"rdscompTestCompReturnStringW")
    _RDS_AUX_FUNC(rdsStrLenA,RDS_DwS,"rdsStrLenA")
    _RDS_AUX_FUNC(rdsStrLenW,RDS_DwWs,"rdsStrLenW")
    _RDS_AUX_FUNC(rdsIsUTF8Text,RDS_BSDw,"rdsIsUTF8Text")
    _RDS_AUX_FUNC(rdsGetFlag,RDS_BDwDw,"rdsGetFlag")
    _RDS_AUX_FUNC(rdsSetFlag,RDS_DwDwDwB,"rdsSetFlag")
    _RDS_AUX_FUNC(rdsSetFlagP,RDS_VpDwDwB,"rdsSetFlagP")
    _RDS_AUX_FUNC(rdsTMPCreateEmptyFileAnyExtA,RDS_SIS,"rdsTMPCreateEmptyFileAnyExtA")
    _RDS_AUX_FUNC(rdsTMPCreateEmptyFileAnyExtW,RDS_WsIWs,"rdsTMPCreateEmptyFileAnyExtW")
    // 2.0.1
    _RDS_AUX_FUNC(rdsGetVarArrayItemAddr,RDS_pVpVIBpI,"rdsGetVarArrayItemAddr")
    _RDS_AUX_FUNC(rdsGetVarMatrItemAddr,RDS_pVpVIIBpI,"rdsGetVarMatrItemAddr")
    // 2.0.2
    _RDS_AUX_FUNC(rdsSetBlockModelKeepDataA,RDS_BBhSS,"rdsSetBlockModelKeepDataA")
    _RDS_AUX_FUNC(rdsSetBlockModelKeepDataW,RDS_BBhWsWs,"rdsSetBlockModelKeepDataW")
    // 2.0.9
    _RDS_AUX_FUNC(rdsXGDrawStdIconOnBlock,RDS_VBhIIDwII,"rdsXGDrawStdIconOnBlock")
    // 2.0.11
    _RDS_AUX_FUNC(rdsCompareVarArray,RDS_BpVpVD,"rdsCompareVarArray")
    _RDS_AUX_FUNC(rdsCallConnectedBlocksFunction,RDS_VBhIDwIpV,"rdsCallConnectedBlocksFunction")
    // 2.0.13
    _RDS_AUX_FUNC(rdsExecuteBlockSetup,RDS_VBh,"rdsExecuteBlockSetup")
    _RDS_AUX_FUNC(rdsBCLListConnectedBlocksByVar,RDS_IHoBhIDw,"rdsBCLListConnectedBlocksByVar")
    _RDS_AUX_FUNC(rdsFindDataSourceBlock,RDS_BhBhIPd,"rdsFindDataSourceBlock")
    // 2.0.14
    _RDS_AUX_FUNC(rdsXGCalcBlockPointCoords,RDS_VIIpIpI,"rdsXGCalcBlockPointCoords")
    // 2.0.16
    _RDS_AUX_FUNC(rdsCountSimpleSourceBlocks,RDS_IBhI,"rdsCountSimpleSourceBlocks")
    _RDS_AUX_FUNC(rdsCountSimpleSourceBlocksN,RDS_IBhpII,"rdsCountSimpleSourceBlocksN")
    // 2.0.17
    _RDS_AUX_FUNC(rdsCountSimpleDestBlocks,RDS_IBhI,"rdsCountSimpleDestBlocks")
    _RDS_AUX_FUNC(rdsCountSimpleDestBlocksN,RDS_IBhpII,"rdsCountSimpleDestBlocksN")
    // 2.0.20
    _RDS_AUX_FUNC(rdsGetCallerBlock,RDS_BhBd,"rdsGetCallerBlock")
    _RDS_AUX_FUNC(rdsSubscribeToFuncProviderSameSystem,RDS_BFl,"rdsSubscribeToFuncProviderSameSystem")
    _RDS_AUX_FUNC(rdsBlockHookAdd,RDS_BhookICb16pVDw,"rdsBlockHookAdd")
    _RDS_AUX_FUNC(rdsBlockHookChange,RDS_BBhookCb16pVDw,"rdsBlockHookChange")
    _RDS_AUX_FUNC(rdsBlockHookDelete,RDS_VBhook,"rdsBlockHookDelete")
    _RDS_AUX_FUNC(rdsCallFontDialog,RDS_BpFs,"rdsCallFontDialog")
    _RDS_AUX_FUNC(rdsCallFontDialogEx,RDS_BpFsDwCr,"rdsCallFontDialogEx")
    // Get functions by name - autogenerated (end)

    #undef _RDS_AUX_FUNC
    return ok;
  }
// конец #ifdef RDS_SERV_FUNC_BODY
#endif
//===================================================================================


//===================================================================================
// Описания указателей на функции для файлов, не использующих #define RDS_SERV_FUNC_BODY
// (с "extern")
//===================================================================================
#if !defined(RDS_NOEXTERNFUNCPTRS) && !defined(RDS_SERV_FUNC_BODY)
  // Вспомогательный макрос, объявляющий внешнюю переменную-указатель
  #define _RDS_AUX_FUNC(name,type) extern type name;

  // Описания с extern
  // Global function vars - autogenerated (begin)
  _RDS_AUX_FUNC(rdsServiceVersion,RDS_IV)
  _RDS_AUX_FUNC(rdsCallerThreadType,RDS_IV)
  _RDS_AUX_FUNC(rdsGetTopWindowBlock,RDS_BhV)
  _RDS_AUX_FUNC(rdsGetBlockDescription,RDS_IBhBd)
  _RDS_AUX_FUNC(rdsGetAppWindowHandle,RDS_HwV)
  _RDS_AUX_FUNC(rdsGetMainWindow,RDS_HwV)
  _RDS_AUX_FUNC(rdsGetFirstBlock,RDS_BhBhIBd)
  _RDS_AUX_FUNC(rdsGetNextBlock,RDS_BhBhIBd)
  _RDS_AUX_FUNC(rdsGetConnDescription,RDS_IChCd)
  _RDS_AUX_FUNC(rdsGetFirstConn,RDS_ChBhICd)
  _RDS_AUX_FUNC(rdsGetNextConn,RDS_ChChICd)
  _RDS_AUX_FUNC(rdsGetPointDescription,RDS_IChIPd)
  _RDS_AUX_FUNC(rdsGetSystemPathA,RDS_SI)
  _RDS_AUX_FUNC(rdsGetSystemPathW,RDS_WsI)
  _RDS_AUX_FUNC(rdsRemoteControllerCallA,RDS_IIS)
  _RDS_AUX_FUNC(rdsRemoteControllerCallW,RDS_IIWs)
  _RDS_AUX_FUNC(rdsRemoteReplyA,RDS_VS)
  _RDS_AUX_FUNC(rdsRemoteReplyW,RDS_VWs)
  _RDS_AUX_FUNC(rdsReportTextLoadErrorA,RDS_VS)
  _RDS_AUX_FUNC(rdsReportTextLoadErrorW,RDS_VWs)
  _RDS_AUX_FUNC(rdsSetHintTextA,RDS_VS)
  _RDS_AUX_FUNC(rdsSetHintTextW,RDS_VWs)
  _RDS_AUX_FUNC(rdsGetRemoteControllerNameA,RDS_SV)
  _RDS_AUX_FUNC(rdsGetRemoteControllerNameW,RDS_WsV)
  _RDS_AUX_FUNC(rdsWriteBlockData,RDS_BpVI)
  _RDS_AUX_FUNC(rdsReadBlockData,RDS_BpVI)
  _RDS_AUX_FUNC(rdsWriteBlockDataTextA,RDS_VSB)
  _RDS_AUX_FUNC(rdsWriteBlockDataTextW,RDS_VWsB)
  _RDS_AUX_FUNC(rdsSetDebugTextA,RDS_VSB)
  _RDS_AUX_FUNC(rdsSetDebugTextW,RDS_VWsB)
  _RDS_AUX_FUNC(rdsXGSetPenStyle,RDS_VIIICrI)
  _RDS_AUX_FUNC(rdsXGSetBrushStyle,RDS_VIICr)
  _RDS_AUX_FUNC(rdsXGSetFontA,RDS_VISICrIIBBBB)
  _RDS_AUX_FUNC(rdsXGSetFontW,RDS_VIWsICrIIBBBB)
  _RDS_AUX_FUNC(rdsWriteFontTextA,RDS_VISICrIIBBBB)
  _RDS_AUX_FUNC(rdsWriteFontTextW,RDS_VIWsICrIIBBBB)
  _RDS_AUX_FUNC(rdsXGSetLogFontA,RDS_VpLfCr)
  _RDS_AUX_FUNC(rdsXGSetLogFontW,RDS_VpLfwCr)
  _RDS_AUX_FUNC(rdsXGGetTextSizeA,RDS_VSpIpI)
  _RDS_AUX_FUNC(rdsXGGetTextSizeW,RDS_VWspIpI)
  _RDS_AUX_FUNC(rdsXGRectangle,RDS_VIIII)
  _RDS_AUX_FUNC(rdsXGInvertRect,RDS_VIIII)
  _RDS_AUX_FUNC(rdsXGEllipse,RDS_VIIII)
  _RDS_AUX_FUNC(rdsXGArc,RDS_VIIIIIIII)
  _RDS_AUX_FUNC(rdsXGPie,RDS_VIIIIIIII)
  _RDS_AUX_FUNC(rdsXGChord,RDS_VIIIIIIII)
  _RDS_AUX_FUNC(rdsXGTextOutA,RDS_VIIS)
  _RDS_AUX_FUNC(rdsXGTextOutW,RDS_VIIWs)
  _RDS_AUX_FUNC(rdsXGTextRectA,RDS_VIISpR)
  _RDS_AUX_FUNC(rdsXGTextRectW,RDS_VIIWspR)
  _RDS_AUX_FUNC(rdsSetBlockTimer,RDS_ThThDwDwB)
  _RDS_AUX_FUNC(rdsGetCustomColors,RDS_pCrV)
  _RDS_AUX_FUNC(rdsCallColorDialog,RDS_BpCr)
  _RDS_AUX_FUNC(rdsGetEditorParameters,RDS_BBhEd)
  _RDS_AUX_FUNC(rdsGetBlockTimerDescr,RDS_BThTd)
  _RDS_AUX_FUNC(rdsDeleteBlockTimer,RDS_VTh)
  _RDS_AUX_FUNC(rdsStopBlockTimer,RDS_VTh)
  _RDS_AUX_FUNC(rdsRestartBlockTimer,RDS_VThDw)
  _RDS_AUX_FUNC(rdsXGMoveTo,RDS_VII)
  _RDS_AUX_FUNC(rdsXGLineTo,RDS_VII)
  _RDS_AUX_FUNC(rdsGetTextWordA,RDS_SSpSpCB)
  _RDS_AUX_FUNC(rdsGetTextWordW,RDS_WsSpSpCB)
  _RDS_AUX_FUNC(rdsWriteLineStyleText,RDS_VIB)
  _RDS_AUX_FUNC(rdsWriteWordValueTextA,RDS_VSI)
  _RDS_AUX_FUNC(rdsWriteWordValueTextW,RDS_VWsI)
  _RDS_AUX_FUNC(rdsWriteColorTextA,RDS_VSCrB)
  _RDS_AUX_FUNC(rdsWriteColorTextW,RDS_VWsCrB)
  _RDS_AUX_FUNC(rdsReadColorText,RDS_CrSpS)
  _RDS_AUX_FUNC(rdsReadFontTextA,RDS_BSpSSIpIpCrpIpIpBpBpBpB)
  _RDS_AUX_FUNC(rdsReadFontTextW,RDS_BSpSWsIpIpCrpIpIpBpBpBpB)
  _RDS_AUX_FUNC(rdsXGGetVisibleRect,RDS_VpR)
  _RDS_AUX_FUNC(rdsXGSetClipRect,RDS_VpR)
  _RDS_AUX_FUNC(rdsWriteWordStringTextA,RDS_VSS)
  _RDS_AUX_FUNC(rdsWriteWordStringTextW,RDS_VWsWs)
  _RDS_AUX_FUNC(rdsXGDrawBlockPicture,RDS_VIIDDDB)
  _RDS_AUX_FUNC(rdsXGTriangle,RDS_VIIIIII)
  _RDS_AUX_FUNC(rdsXGPolygon,RDS_VpPI)
  _RDS_AUX_FUNC(rdsXGFontSizeToHeight,RDS_II)
  _RDS_AUX_FUNC(rdsCheckBlockFunctionSupport,RDS_BBhI)
  _RDS_AUX_FUNC(rdsCallBlockFunction,RDS_IBhIpV)
  _RDS_AUX_FUNC(rdsBroadcastFunctionCallsEx,RDS_IBhIpVDw)
  _RDS_AUX_FUNC(rdsBroadcastFunctionCalls,RDS_VBhIpVB)
  _RDS_AUX_FUNC(rdsGetConnAppearance,RDS_VChCa)
  _RDS_AUX_FUNC(rdsSetConnAppearance,RDS_VChCa)
  _RDS_AUX_FUNC(rdsGetConnStyleAppearanceA,RDS_BSCa)
  _RDS_AUX_FUNC(rdsGetConnStyleAppearanceW,RDS_BWsCa)
  _RDS_AUX_FUNC(rdsSystemInEditMode,RDS_BV)
  _RDS_AUX_FUNC(rdsGetBlockLink,RDS_ChBhChBBPd)
  _RDS_AUX_FUNC(rdsCreateDynamicVarA,RDS_pVISSBS)
  _RDS_AUX_FUNC(rdsCreateDynamicVarW,RDS_pVIWsWsBWs)
  _RDS_AUX_FUNC(rdsCreateAndSubscribeDVA,RDS_DvISSBS)
  _RDS_AUX_FUNC(rdsCreateAndSubscribeDVW,RDS_DvIWsWsBWs)
  _RDS_AUX_FUNC(rdsDeleteDynamicVarA,RDS_BIS)
  _RDS_AUX_FUNC(rdsDeleteDynamicVarW,RDS_BIWs)
  _RDS_AUX_FUNC(rdsSubscribeToDynamicVarA,RDS_DvISSB)
  _RDS_AUX_FUNC(rdsSubscribeToDynamicVarW,RDS_DvIWsWsB)
  _RDS_AUX_FUNC(rdsUnsubscribeFromDynamicVar,RDS_VDv)
  _RDS_AUX_FUNC(rdsGetChildBlockByNameA,RDS_BhBhSBd)
  _RDS_AUX_FUNC(rdsGetChildBlockByNameW,RDS_BhBhWsBd)
  _RDS_AUX_FUNC(rdsGetIOBlockByVarNameA,RDS_BhBhSBd)
  _RDS_AUX_FUNC(rdsGetIOBlockByVarNameW,RDS_BhBhWsBd)
  _RDS_AUX_FUNC(rdsGetRootSystem,RDS_BhBd)
  _RDS_AUX_FUNC(rdsGetIOBlockLink,RDS_ChBhChPd)
  _RDS_AUX_FUNC(rdsRefreshBlockWindows,RDS_VBhB)
  _RDS_AUX_FUNC(rdsCountBlocks,RDS_IBhIB)
  _RDS_AUX_FUNC(rdsSetBlockCommentA,RDS_VBhS)
  _RDS_AUX_FUNC(rdsSetBlockCommentW,RDS_VBhWs)
  _RDS_AUX_FUNC(rdsSetModifiedFlag,RDS_VB)
  _RDS_AUX_FUNC(rdsOpenSystemWindow,RDS_VBh)
  _RDS_AUX_FUNC(rdsCloseSystemWindow,RDS_VBh)
  _RDS_AUX_FUNC(rdsScrollWindowToBlock,RDS_VBh)
  _RDS_AUX_FUNC(rdsAltConnAppearanceOp,RDS_IChIICa)
  _RDS_AUX_FUNC(rdsGetLayerConfigNameA,RDS_SBhI)
  _RDS_AUX_FUNC(rdsGetLayerConfigNameW,RDS_WsBhI)
  _RDS_AUX_FUNC(rdsGetLayerNameA,RDS_SBhI)
  _RDS_AUX_FUNC(rdsGetLayerNameW,RDS_WsBhI)
  _RDS_AUX_FUNC(rdsSetCurLayerConfig,RDS_BBhI)
  _RDS_AUX_FUNC(rdsSetCurLayerConfigByNameA,RDS_BBhS)
  _RDS_AUX_FUNC(rdsSetCurLayerConfigByNameW,RDS_BBhWs)
  _RDS_AUX_FUNC(rdsEnableWindowRefresh,RDS_VBhBB)
  _RDS_AUX_FUNC(rdsStopCalc,RDS_VV)
  _RDS_AUX_FUNC(rdsGetVarArrayParams,RDS_pVpVpIpI)
  _RDS_AUX_FUNC(rdsGetVarArrayAccessData,RDS_BpVAd)
  _RDS_AUX_FUNC(rdsResizeVarArray,RDS_BpVIIBAd)
  _RDS_AUX_FUNC(rdsEnumBlocks,RDS_BhBhIBCbpV)
  _RDS_AUX_FUNC(rdsGetPictureObjectId,RDS_IIIB)
  _RDS_AUX_FUNC(rdsSaveSystemState,RDS_IBhIBCb2)
  _RDS_AUX_FUNC(rdsLoadSystemState,RDS_BICb2)
  _RDS_AUX_FUNC(rdsGetScreenCoords,RDS_BBhIIpIpI)
  _RDS_AUX_FUNC(rdsLockBlockData,RDS_VV)
  _RDS_AUX_FUNC(rdsUnlockBlockData,RDS_VV)
  _RDS_AUX_FUNC(rdsBlockDataSyncCall,RDS_ICb4pV)
  _RDS_AUX_FUNC(rdsRegisterFunctionA,RDS_IS)
  _RDS_AUX_FUNC(rdsRegisterFunctionW,RDS_IWs)
  _RDS_AUX_FUNC(rdsActivateOutputConnections,RDS_VBhB)
  _RDS_AUX_FUNC(rdsSelectBlock,RDS_VBhBB)
  _RDS_AUX_FUNC(rdsCalcProcessIsRunning,RDS_BV)
  _RDS_AUX_FUNC(rdsEnumConnectedBlocks,RDS_BhBhDwCb1pV)
  _RDS_AUX_FUNC(rdsWriteHexText,RDS_VpVII)
  _RDS_AUX_FUNC(rdsReadHexText,RDS_ISpSpVI)
  _RDS_AUX_FUNC(rdsGetCmdParamCount,RDS_IV)
  _RDS_AUX_FUNC(rdsGetCmdParamA,RDS_SIB)
  _RDS_AUX_FUNC(rdsGetCmdParamW,RDS_WsIB)
  _RDS_AUX_FUNC(rdsFindCmdParamA,RDS_ISB)
  _RDS_AUX_FUNC(rdsFindCmdParamW,RDS_IWsB)
  _RDS_AUX_FUNC(rdsRegisterMenuItemA,RDS_MhSDwIDwII)
  _RDS_AUX_FUNC(rdsRegisterMenuItemW,RDS_MhWsDwIDwII)
  _RDS_AUX_FUNC(rdsEnableMenuItem,RDS_VMhBB)
  _RDS_AUX_FUNC(rdsUnregisterMenuItem,RDS_VMh)
  _RDS_AUX_FUNC(rdsFree,RDS_VpcV)
  _RDS_AUX_FUNC(rdsAllocate,RDS_pVDw)
  _RDS_AUX_FUNC(rdsCreateFullBlockNameStringA,RDS_SBhpI)
  _RDS_AUX_FUNC(rdsCreateFullBlockNameStringW,RDS_WsBhpI)
  _RDS_AUX_FUNC(rdsBlockByFullNameA,RDS_BhSBd)
  _RDS_AUX_FUNC(rdsBlockByFullNameW,RDS_BhWsBd)
  _RDS_AUX_FUNC(rdsParentIsRoot,RDS_BBh)
  _RDS_AUX_FUNC(rdsHasRemoteController,RDS_BV)
  _RDS_AUX_FUNC(rdsDeleteBlock,RDS_VBh)
  _RDS_AUX_FUNC(rdsDeleteConnection,RDS_VCh)
  _RDS_AUX_FUNC(rdsCreateBlockFromFileA,RDS_BhSBhIIBd)
  _RDS_AUX_FUNC(rdsCreateBlockFromFileW,RDS_BhWsBhIIBd)
  _RDS_AUX_FUNC(rdsDuplicateBlock,RDS_BhBhBhIIBd)
  _RDS_AUX_FUNC(rdsGetBlockVar,RDS_VhBhiVd)
  _RDS_AUX_FUNC(rdsFindBlockVarA,RDS_VhBhSBVd)
  _RDS_AUX_FUNC(rdsFindBlockVarW,RDS_VhBhWsBVd)
  _RDS_AUX_FUNC(rdsCECreateEditor,RDS_HoV)
  _RDS_AUX_FUNC(rdsDeleteObject,RDS_VHo)
  _RDS_AUX_FUNC(rdsCECreateConnBus,RDS_ChHoBhIpI)
  _RDS_AUX_FUNC(rdsCEEditConnBus,RDS_BHoChpI)
  _RDS_AUX_FUNC(rdsCEAddInternalPoint,RDS_IHoII)
  _RDS_AUX_FUNC(rdsCEAddBlockPointA,RDS_IHoBhSIIB)
  _RDS_AUX_FUNC(rdsCEAddBlockPointW,RDS_IHoBhWsIIB)
  _RDS_AUX_FUNC(rdsCEAddBusPointA,RDS_IHoChSBIIB)
  _RDS_AUX_FUNC(rdsCEAddBusPointW,RDS_IHoChWsBIIB)
  _RDS_AUX_FUNC(rdsCEAddLine,RDS_IHoII)
  _RDS_AUX_FUNC(rdsCEAddBezier,RDS_IHoIIIIII)
  _RDS_AUX_FUNC(rdsGetBlockDimensions,RDS_BBhBrB)
  _RDS_AUX_FUNC(rdsBCLCreateList,RDS_HoBhDwB)
  _RDS_AUX_FUNC(rdsGetObjectArray,RDS_pVHoIIpI)
  _RDS_AUX_FUNC(rdsMoveBlock,RDS_VBhII)
  _RDS_AUX_FUNC(rdsSetSystemUpdate,RDS_VB)
  _RDS_AUX_FUNC(rdsdebugBlockInfoA,RDS_VBhSS)
  _RDS_AUX_FUNC(rdsdebugBlockInfoW,RDS_VBhWsWs)
  _RDS_AUX_FUNC(rdsGetLineDescription,RDS_BChILdPdPd)
  _RDS_AUX_FUNC(rdsFindNextConnectedLine,RDS_IChIILdpI)
  _RDS_AUX_FUNC(rdsScrollWindowToRect,RDS_VBhIIIIB)
  _RDS_AUX_FUNC(rdsCheckRectVisibility,RDS_BBhIIII)
  _RDS_AUX_FUNC(rdsCalcProcessNeverStarted,RDS_BV)
  _RDS_AUX_FUNC(rdsCheckSystemWindow,RDS_BBh)
  _RDS_AUX_FUNC(rdscompSetModelFunctionA,RDS_VMhSS)
  _RDS_AUX_FUNC(rdscompSetModelFunctionW,RDS_VMhWsWs)
  _RDS_AUX_FUNC(rdsDeleteDVByLink,RDS_BDv)
  _RDS_AUX_FUNC(rdsCopyVarArray,RDS_BpVpV)
  _RDS_AUX_FUNC(rdsVSCreateEditor,RDS_HoV)
  _RDS_AUX_FUNC(rdsVSInstallStruct,RDS_BHopI)
  _RDS_AUX_FUNC(rdsVSAddVarA,RDS_IHoISCSDwIS)
  _RDS_AUX_FUNC(rdsVSAddVarW,RDS_IHoIWsCWsDwIWs)
  _RDS_AUX_FUNC(rdsSetObjectStrA,RDS_VHoIIS)
  _RDS_AUX_FUNC(rdsSetObjectStrW,RDS_VHoIIWs)
  _RDS_AUX_FUNC(rdsVSApplyToBlock,RDS_BHoBhpI)
  _RDS_AUX_FUNC(rdsVSAddAutoConnA,RDS_IHoSS)
  _RDS_AUX_FUNC(rdsVSAddAutoConnW,RDS_IHoWsWs)
  _RDS_AUX_FUNC(rdsCommandObjectEx,RDS_BHoIIpI)
  _RDS_AUX_FUNC(rdsCommandObject,RDS_BHoI)
  _RDS_AUX_FUNC(rdsGetVarField,RDS_VhVhiVd)
  _RDS_AUX_FUNC(rdsFindStructVarA,RDS_VhSVd)
  _RDS_AUX_FUNC(rdsFindStructVarW,RDS_VhWsVd)
  _RDS_AUX_FUNC(rdsVSGetVarDescription,RDS_BHoIVd)
  _RDS_AUX_FUNC(rdsVSExecuteEditorA,RDS_BHoBDwIS)
  _RDS_AUX_FUNC(rdsVSExecuteEditorW,RDS_BHoBDwIWs)
  _RDS_AUX_FUNC(rdsGetObjectInt,RDS_IHoII)
  _RDS_AUX_FUNC(rdsGetObjectStrA,RDS_SHoII)
  _RDS_AUX_FUNC(rdsGetObjectStrW,RDS_WsHoII)
  _RDS_AUX_FUNC(rdsSetObjectInt,RDS_VHoIII)
  _RDS_AUX_FUNC(rdsCreateVarDescriptionStringA,RDS_SVhBIpI)
  _RDS_AUX_FUNC(rdsCreateVarDescriptionStringW,RDS_WsVhBIpI)
  _RDS_AUX_FUNC(rdsVSAddVarByDescrA,RDS_IHoIS)
  _RDS_AUX_FUNC(rdsVSAddVarByDescrW,RDS_IHoIWs)
  _RDS_AUX_FUNC(rdsVSCreateByDescrA,RDS_BHoS)
  _RDS_AUX_FUNC(rdsVSCreateByDescrW,RDS_BHoWs)
  _RDS_AUX_FUNC(rdsVSAddTypeRenameA,RDS_IHoSS)
  _RDS_AUX_FUNC(rdsVSAddTypeRenameW,RDS_IHoWsWs)
  _RDS_AUX_FUNC(rdscompGetModelData,RDS_MdChI)
  _RDS_AUX_FUNC(rdsApplicationIsActive,RDS_BV)
  _RDS_AUX_FUNC(rdsRegisterWindowA,RDS_BHwSHbHiS)
  _RDS_AUX_FUNC(rdsRegisterWindowW,RDS_BHwWsHbHiWs)
  _RDS_AUX_FUNC(rdsUnregisterWindow,RDS_VHw)
  _RDS_AUX_FUNC(rdsRegWinActivateNotify,RDS_VHw)
  _RDS_AUX_FUNC(rdsVSFindAutoConnA,RDS_SHoS)
  _RDS_AUX_FUNC(rdsVSFindAutoConnW,RDS_WsHoWs)
  _RDS_AUX_FUNC(rdscompGetModelBlock,RDS_BhMhIBd)
  _RDS_AUX_FUNC(rdsVSAddVarRenameA,RDS_IHoSS)
  _RDS_AUX_FUNC(rdsVSAddVarRenameW,RDS_IHoWsWs)
  _RDS_AUX_FUNC(rdsGetStructVar,RDS_VhIVd)
  _RDS_AUX_FUNC(rdsGetSystemInt,RDS_II)
  _RDS_AUX_FUNC(rdsVSUsesStructTypeA,RDS_BHoS)
  _RDS_AUX_FUNC(rdsVSUsesStructTypeW,RDS_BHoWs)
  _RDS_AUX_FUNC(rdsVarUsesStructTypeA,RDS_BVhS)
  _RDS_AUX_FUNC(rdsVarUsesStructTypeW,RDS_BVhWs)
  _RDS_AUX_FUNC(rdscompRenameModelA,RDS_BChSSB)
  _RDS_AUX_FUNC(rdscompRenameModelW,RDS_BChWsWsB)
  _RDS_AUX_FUNC(rdscompGetModelDataByNameA,RDS_MdChS)
  _RDS_AUX_FUNC(rdscompGetModelDataByNameW,RDS_MdChWs)
  _RDS_AUX_FUNC(rdscompCompileModel,RDS_BMhB)
  _RDS_AUX_FUNC(rdscompReturnModelNameA,RDS_VS)
  _RDS_AUX_FUNC(rdscompReturnModelNameW,RDS_VWs)
  _RDS_AUX_FUNC(rdsGetFullFilePathA,RDS_SSSpI)
  _RDS_AUX_FUNC(rdsGetFullFilePathW,RDS_WsWsWspI)
  _RDS_AUX_FUNC(rdsGetRelFilePathA,RDS_SSSpI)
  _RDS_AUX_FUNC(rdsGetRelFilePathW,RDS_WsWsWspI)
  _RDS_AUX_FUNC(rdsExecutePrintDialog,RDS_VBh)
  _RDS_AUX_FUNC(rdsChangeRegWinTitleA,RDS_VHwS)
  _RDS_AUX_FUNC(rdsChangeRegWinTitleW,RDS_VHwWs)
  _RDS_AUX_FUNC(rdsBCLAddBlock,RDS_IHoBhB)
  _RDS_AUX_FUNC(rdsBCLAddConn,RDS_IHoChB)
  _RDS_AUX_FUNC(rdsBCLExecuteGroupSetDialogA,RDS_VHoDwSB)
  _RDS_AUX_FUNC(rdsBCLExecuteGroupSetDialogW,RDS_VHoDwWsB)
  _RDS_AUX_FUNC(rdsIsRoot,RDS_BBh)
  _RDS_AUX_FUNC(rdsMessageBoxA,RDS_ISSI)
  _RDS_AUX_FUNC(rdsMessageBoxW,RDS_IWsWsI)
  _RDS_AUX_FUNC(rdscompReturnModelNameLabelA,RDS_VS)
  _RDS_AUX_FUNC(rdscompReturnModelNameLabelW,RDS_VWs)
  _RDS_AUX_FUNC(rdscompSetAltModelNameA,RDS_VMhS)
  _RDS_AUX_FUNC(rdscompSetAltModelNameW,RDS_VMhWs)
  _RDS_AUX_FUNC(rdsSTRCreateTextReader,RDS_HoB)
  _RDS_AUX_FUNC(rdsSTRAddKeywordA,RDS_IHoSI)
  _RDS_AUX_FUNC(rdsSTRAddKeywordW,RDS_IHoWsI)
  _RDS_AUX_FUNC(rdsSTRAddKeywordsArrayA,RDS_BHopSII)
  _RDS_AUX_FUNC(rdsSTRAddKeywordsArrayW,RDS_BHopWsII)
  _RDS_AUX_FUNC(rdsSTRGetWordA,RDS_IHopSpSpCB)
  _RDS_AUX_FUNC(rdsSTRGetWordW,RDS_IHopWspWsWsB)
  _RDS_AUX_FUNC(rdsWriteWordDoubleTextA,RDS_VSD)
  _RDS_AUX_FUNC(rdsWriteWordDoubleTextW,RDS_VWsD)
  _RDS_AUX_FUNC(rdsReadLineStyleText,RDS_ISpS)
  _RDS_AUX_FUNC(rdsSetBlockVarDefValueStrA,RDS_BBhIS)
  _RDS_AUX_FUNC(rdsSetBlockVarDefValueStrW,RDS_BBhIWs)
  _RDS_AUX_FUNC(rdsGetBlockVarDefValueStrA,RDS_SBhIpI)
  _RDS_AUX_FUNC(rdsGetBlockVarDefValueStrW,RDS_WsBhIpI)
  _RDS_AUX_FUNC(rdsRunWithoutEvents,RDS_BB)
  _RDS_AUX_FUNC(rdsXGFillRect,RDS_VIIII)
  _RDS_AUX_FUNC(rdsXGPolyline,RDS_VpPI)
  _RDS_AUX_FUNC(rdsXGRoundRect,RDS_VIIIIII)
  _RDS_AUX_FUNC(rdsSetPointPosition,RDS_BChIIIDw)
  _RDS_AUX_FUNC(rdsGetParentBlock,RDS_BhBhBd)
  _RDS_AUX_FUNC(rdsRenameBlockA,RDS_BBhSBd)
  _RDS_AUX_FUNC(rdsRenameBlockW,RDS_BBhWsBd)
  _RDS_AUX_FUNC(rdsVSGetVarDefValueStrA,RDS_SHoIpI)
  _RDS_AUX_FUNC(rdsVSGetVarDefValueStrW,RDS_WsHoIpI)
  _RDS_AUX_FUNC(rdsSetZoomPercent,RDS_VBhIII)
  _RDS_AUX_FUNC(rdsChangeMenuItemA,RDS_BMhSDwIDwII)
  _RDS_AUX_FUNC(rdsChangeMenuItemW,RDS_BMhWsDwIDwII)
  _RDS_AUX_FUNC(rdsResetSystemState,RDS_VBh)
  _RDS_AUX_FUNC(rdsINICreateTextHolder,RDS_HoB)
  _RDS_AUX_FUNC(rdsSetObjectDouble,RDS_VHoIID)
  _RDS_AUX_FUNC(rdsGetObjectDouble,RDS_DHoII)
  _RDS_AUX_FUNC(rdsINIOpenSectionA,RDS_BHoS)
  _RDS_AUX_FUNC(rdsINIOpenSectionW,RDS_BHoWs)
  _RDS_AUX_FUNC(rdsINIWriteIntA,RDS_VHoSI)
  _RDS_AUX_FUNC(rdsINIWriteIntW,RDS_VHoWsI)
  _RDS_AUX_FUNC(rdsINIReadIntA,RDS_IHoSI)
  _RDS_AUX_FUNC(rdsINIReadIntW,RDS_IHoWsI)
  _RDS_AUX_FUNC(rdsINIWriteDoubleA,RDS_VHoSD)
  _RDS_AUX_FUNC(rdsINIWriteDoubleW,RDS_VHoWsD)
  _RDS_AUX_FUNC(rdsINIReadDoubleA,RDS_DHoSD)
  _RDS_AUX_FUNC(rdsINIReadDoubleW,RDS_DHoWsD)
  _RDS_AUX_FUNC(rdsINIWriteStringA,RDS_VHoSS)
  _RDS_AUX_FUNC(rdsINIWriteStringW,RDS_VHoWsWs)
  _RDS_AUX_FUNC(rdsINIReadStringA,RDS_SHoSSpI)
  _RDS_AUX_FUNC(rdsINIReadStringW,RDS_WsHoWsWspI)
  _RDS_AUX_FUNC(rdscompAttachDifferentModelA,RDS_VSS)
  _RDS_AUX_FUNC(rdscompAttachDifferentModelW,RDS_VWsWs)
  _RDS_AUX_FUNC(rdscompSetBlockModelA,RDS_IBhSSSS)
  _RDS_AUX_FUNC(rdscompSetBlockModelW,RDS_IBhWsWsWsWs)
  _RDS_AUX_FUNC(rdscompGetBlockModelData,RDS_MdBh)
  _RDS_AUX_FUNC(rdscompOpenBlockModelEditor,RDS_IBh)
  _RDS_AUX_FUNC(rdsGetEditorWindowFlags,RDS_DwBh)
  _RDS_AUX_FUNC(rdsSetEditorWindowFlags,RDS_VBhDwDw)
  _RDS_AUX_FUNC(rdsEnumConnectedBlocksByVar,RDS_BhBhIDwCb1pV)
  _RDS_AUX_FUNC(rdsFORMCreateA,RDS_HoBIIS)
  _RDS_AUX_FUNC(rdsFORMCreateW,RDS_HoBIIWs)
  _RDS_AUX_FUNC(rdsFORMAddTabA,RDS_VHoIS)
  _RDS_AUX_FUNC(rdsFORMAddTabW,RDS_VHoIWs)
  _RDS_AUX_FUNC(rdsFORMAddEditA,RDS_VHoIIDwSI)
  _RDS_AUX_FUNC(rdsFORMAddEditW,RDS_VHoIIDwWsI)
  _RDS_AUX_FUNC(rdsProcessTextA,RDS_SSIpI)
  _RDS_AUX_FUNC(rdsProcessTextW,RDS_WsWsIpI)
  _RDS_AUX_FUNC(rdsSetBlockSetupFuncNameA,RDS_VBhS)
  _RDS_AUX_FUNC(rdsSetBlockSetupFuncNameW,RDS_VBhWs)
  _RDS_AUX_FUNC(rdsDynStrCatA,RDS_SSSB)
  _RDS_AUX_FUNC(rdsDynStrCatW,RDS_WsWsWsB)
  _RDS_AUX_FUNC(rdsIsValidVarNameA,RDS_BSI)
  _RDS_AUX_FUNC(rdsIsValidVarNameW,RDS_BWsI)
  _RDS_AUX_FUNC(rdsRegisterFuncProvider,RDS_IIB)
  _RDS_AUX_FUNC(rdsUnregisterFuncProvider,RDS_BI)
  _RDS_AUX_FUNC(rdsSubscribeToFuncProvider,RDS_BFl)
  _RDS_AUX_FUNC(rdsUnsubscribeFromFuncProvider,RDS_VI)
  _RDS_AUX_FUNC(rdsStartCalc,RDS_VV)
  _RDS_AUX_FUNC(rdsFORMShowModalEx,RDS_BHoCb3)
  _RDS_AUX_FUNC(rdsGetHugeDouble,RDS_BpD)
  _RDS_AUX_FUNC(rdsSetBlockFlags,RDS_VBhDwDw)
  _RDS_AUX_FUNC(rdsSetBlockVarFlags,RDS_BBhIDwDw)
  _RDS_AUX_FUNC(rdsShowBlockPanelTabA,RDS_VIS)
  _RDS_AUX_FUNC(rdsShowBlockPanelTabW,RDS_VIWs)
  _RDS_AUX_FUNC(rdsSetBlockAltNameTextA,RDS_VBhSI)
  _RDS_AUX_FUNC(rdsSetBlockAltNameTextW,RDS_VBhWsI)
  _RDS_AUX_FUNC(rdsExecuteCommandA,RDS_VIDwSS)
  _RDS_AUX_FUNC(rdsExecuteCommandW,RDS_VIDwWsWs)
  _RDS_AUX_FUNC(rdsSetSystemWindowRect,RDS_VBhIIIIB)
  _RDS_AUX_FUNC(rdsRegisterContextMenuItemA,RDS_MhSII)
  _RDS_AUX_FUNC(rdsRegisterContextMenuItemW,RDS_MhWsII)
  _RDS_AUX_FUNC(rdsEnableCommandQueue,RDS_VB)
  _RDS_AUX_FUNC(rdsSetSystemWindowCaptionA,RDS_VBhSB)
  _RDS_AUX_FUNC(rdsSetSystemWindowCaptionW,RDS_VBhWsB)
  _RDS_AUX_FUNC(rdsCopyRuntimeType,RDS_BpVpV)
  _RDS_AUX_FUNC(rdsClearRuntimeType,RDS_VpV)
  _RDS_AUX_FUNC(rdsPBARCreateA,RDS_HoIS)
  _RDS_AUX_FUNC(rdsPBARCreateW,RDS_HoIWs)
  _RDS_AUX_FUNC(rdsInputStringA,RDS_SSSSI)
  _RDS_AUX_FUNC(rdsInputStringW,RDS_WsWsWsWsI)
  _RDS_AUX_FUNC(rdsUnlockAndCall,RDS_BCb4pVI)
  _RDS_AUX_FUNC(rdsGetRemoteControllerStringA,RDS_SI)
  _RDS_AUX_FUNC(rdsGetRemoteControllerStringW,RDS_WsI)
  _RDS_AUX_FUNC(rdsGetRuntimeTypeDataA,RDS_pVpVpS)
  _RDS_AUX_FUNC(rdsGetRuntimeTypeDataW,RDS_pVpVpWs)
  _RDS_AUX_FUNC(rdsShowMainWindow,RDS_VB)
  _RDS_AUX_FUNC(rdsMainWindowVisible,RDS_BV)
  _RDS_AUX_FUNC(rdsAdditionalContextMenuItemA,RDS_VSBII)
  _RDS_AUX_FUNC(rdsAdditionalContextMenuItemW,RDS_VWsBII)
  _RDS_AUX_FUNC(rdsGetBlockFlags,RDS_DwBh)
  _RDS_AUX_FUNC(rdsSetRuntimeTypeA,RDS_pVpVS)
  _RDS_AUX_FUNC(rdsSetRuntimeTypeW,RDS_pVpVWs)
  _RDS_AUX_FUNC(rdsBringAppToFront,RDS_VV)
  _RDS_AUX_FUNC(rdsBlockModalWinOpen,RDS_VBh)
  _RDS_AUX_FUNC(rdsBlockModalWinClose,RDS_VBh)
  _RDS_AUX_FUNC(rdsModalWindowMustClose,RDS_BV)
  _RDS_AUX_FUNC(rdsExecMenuItem,RDS_VBhII)
  _RDS_AUX_FUNC(rdsGetLayerIdA,RDS_IBhS)
  _RDS_AUX_FUNC(rdsGetLayerIdW,RDS_IBhWs)
  _RDS_AUX_FUNC(rdsAddLayerA,RDS_IBhS)
  _RDS_AUX_FUNC(rdsAddLayerW,RDS_IBhWs)
  _RDS_AUX_FUNC(rdsSetBlockLayer,RDS_BBhI)
  _RDS_AUX_FUNC(rdsGetAppInstance,RDS_HiV)
  _RDS_AUX_FUNC(rdsModalWindowExists,RDS_BV)
  _RDS_AUX_FUNC(rdsEnumDynVarSubscribers,RDS_BhDvCb5pV)
  _RDS_AUX_FUNC(rdsNotifyDynVarSubscribers,RDS_VDv)
  _RDS_AUX_FUNC(rdsCancelPaste,RDS_VV)
  _RDS_AUX_FUNC(rdsdebugLogStringA,RDS_BSSB)
  _RDS_AUX_FUNC(rdsdebugLogStringW,RDS_BWsWsB)
  _RDS_AUX_FUNC(rdsGetObjectDoubleP,RDS_VHoIIpD)
  _RDS_AUX_FUNC(rdsINIReadDoublePA,RDS_VHoSDpD)
  _RDS_AUX_FUNC(rdsINIReadDoublePW,RDS_VHoWsDpD)
  _RDS_AUX_FUNC(rdsNetServerA,RDS_IISB)
  _RDS_AUX_FUNC(rdsNetServerW,RDS_IIWsB)
  _RDS_AUX_FUNC(rdsNetConnectA,RDS_ISISB)
  _RDS_AUX_FUNC(rdsNetConnectW,RDS_IWsIWsB)
  _RDS_AUX_FUNC(rdsNetCloseConnection,RDS_VI)
  _RDS_AUX_FUNC(rdsNetBroadcastDataA,RDS_BIDwISpVDw)
  _RDS_AUX_FUNC(rdsNetBroadcastDataW,RDS_BIDwIWspVDw)
  _RDS_AUX_FUNC(rdsNetSendDataA,RDS_BIDwISpVDwNsNb)
  _RDS_AUX_FUNC(rdsNetSendDataW,RDS_BIDwIWspVDwNsNb)
  _RDS_AUX_FUNC(rdsBlockVarToMem,RDS_pVBhIBpI)
  _RDS_AUX_FUNC(rdsBlockVarFromMem,RDS_BBhIpVI)
  _RDS_AUX_FUNC(rdsXGDrawStdIcon,RDS_VIIDw)
  _RDS_AUX_FUNC(rdsXGGetStdIconSize,RDS_BDwpIpI)
  _RDS_AUX_FUNC(rdsBlockMessageBoxA,RDS_IBhSSI)
  _RDS_AUX_FUNC(rdsBlockMessageBoxW,RDS_IBhWsWsI)
  _RDS_AUX_FUNC(rdsFORMShowModalServ,RDS_BHoCb6)
  _RDS_AUX_FUNC(rdsCallBlockFunctionDelayed,RDS_VBhIpVDw)
  _RDS_AUX_FUNC(rdsBroadcastFuncCallsDelayed,RDS_VBhIpVDwDw)
  _RDS_AUX_FUNC(rdsFORMEnableSidePanel,RDS_VHoII)
  _RDS_AUX_FUNC(rdsSetExclusiveCalc,RDS_BBhB)
  _RDS_AUX_FUNC(rdsListVarTypesA,RDS_SDwS)
  _RDS_AUX_FUNC(rdsListVarTypesW,RDS_WsDwWs)
  _RDS_AUX_FUNC(rdsCreateVarTypeTextA,RDS_SVh)
  _RDS_AUX_FUNC(rdsCreateVarTypeTextW,RDS_WsVh)
  _RDS_AUX_FUNC(rdsVSAddVarByTypeTextA,RDS_IHoISSDwS)
  _RDS_AUX_FUNC(rdsVSAddVarByTypeTextW,RDS_IHoIWsWsDwWs)
  _RDS_AUX_FUNC(rdsCopyVarGeneral,RDS_BVhpVVhpV)
  _RDS_AUX_FUNC(rdsSetBlockVarDefValueByCur,RDS_BBhI)
  _RDS_AUX_FUNC(rdsGetBlockVarBase,RDS_pVBhIpI)
  _RDS_AUX_FUNC(rdsVSCreateFromBlock,RDS_VHoBhB)
  _RDS_AUX_FUNC(rdsAtoIA,RDS_ISpI)
  _RDS_AUX_FUNC(rdsAtoIW,RDS_IWspI)
  _RDS_AUX_FUNC(rdsItoAA,RDS_SIII)
  _RDS_AUX_FUNC(rdsItoAW,RDS_WsIII)
  _RDS_AUX_FUNC(rdsAtoDA,RDS_VSpD)
  _RDS_AUX_FUNC(rdsAtoDW,RDS_VWspD)
  _RDS_AUX_FUNC(rdsDtoAA,RDS_SDIpI)
  _RDS_AUX_FUNC(rdsDtoAW,RDS_WsDIpI)
  _RDS_AUX_FUNC(rdsSetBlockModelA,RDS_BBhSS)
  _RDS_AUX_FUNC(rdsSetBlockModelW,RDS_BBhWsWs)
  _RDS_AUX_FUNC(rdsSetSystemInt,RDS_VII)
  _RDS_AUX_FUNC(rdsBEUCreate,RDS_HoBh)
  _RDS_AUX_FUNC(rdsXGSetPixel,RDS_VII)
  _RDS_AUX_FUNC(rdsGetMouseObjectId,RDS_IMd)
  _RDS_AUX_FUNC(rdsOpenSystemWindowEx,RDS_VBhBIIII)
  _RDS_AUX_FUNC(rdsSetSystemWindowBounds,RDS_VBhBIIII)
  _RDS_AUX_FUNC(rdsVarArrayIndexCheckA,RDS_BpVIIDwSS)
  _RDS_AUX_FUNC(rdsVarArrayIndexCheckW,RDS_BpVIIDwWsWs)
  _RDS_AUX_FUNC(rdsBadSystemTime,RDS_BV)
  _RDS_AUX_FUNC(rdsExecutesRemoteOpsSetA,RDS_VSB)
  _RDS_AUX_FUNC(rdsExecutesRemoteOpsSetW,RDS_VWsB)
  _RDS_AUX_FUNC(rdsSetLayerPosition,RDS_BBhIIII)
  _RDS_AUX_FUNC(rdsGetLayerParams,RDS_BBhIIpBpBpB)
  _RDS_AUX_FUNC(rdsSetLayerParams,RDS_BBhIIBBB)
  _RDS_AUX_FUNC(rdsSetBlockRect,RDS_VBhIIII)
  _RDS_AUX_FUNC(rdsGetConnDimensions,RDS_BChBrB)
  _RDS_AUX_FUNC(rdsSetConnLayer,RDS_BChI)
  _RDS_AUX_FUNC(rdsUpdateExtIdsRange,RDS_VV)
  _RDS_AUX_FUNC(rdsBlockOrConnByExtId,RDS_BBhDwFbei)
  _RDS_AUX_FUNC(rdsPANCreateA,RDS_HoIIIIIIS)
  _RDS_AUX_FUNC(rdsPANCreateW,RDS_HoIIIIIIWs)
  _RDS_AUX_FUNC(rdsPANGetDescr,RDS_BHoPnd)
  _RDS_AUX_FUNC(rdsGetEditorFontA,RDS_BBhIpLfDwpI)
  _RDS_AUX_FUNC(rdsGetEditorFontW,RDS_BBhIpLfwDwpI)
  _RDS_AUX_FUNC(rdsXGSetFontByParStrA,RDS_VpFsD)
  _RDS_AUX_FUNC(rdsXGSetFontByParStrW,RDS_VpFsD)
  _RDS_AUX_FUNC(rdsFontTextToStruct,RDS_BSpSpFs)
  _RDS_AUX_FUNC(rdsStructToFontTextA,RDS_SpFspI)
  _RDS_AUX_FUNC(rdsStructToFontTextW,RDS_WspFspI)
  _RDS_AUX_FUNC(rdsAddToDynStrA,RDS_VpSSB)
  _RDS_AUX_FUNC(rdsAddToDynStrW,RDS_VpWsWsB)
  _RDS_AUX_FUNC(rdsForceBlockRedraw,RDS_VBh)
  _RDS_AUX_FUNC(rdsRegisterContextMenuItemExA,RDS_MhSDwII)
  _RDS_AUX_FUNC(rdsRegisterContextMenuItemExW,RDS_MhWsDwII)
  _RDS_AUX_FUNC(rdsSetMenuItemOptions,RDS_VMhDw)
  _RDS_AUX_FUNC(rdsAdditionalContextMenuItemExA,RDS_VSDwII)
  _RDS_AUX_FUNC(rdsAdditionalContextMenuItemExW,RDS_VWsDwII)
  _RDS_AUX_FUNC(rdsQueueCallBlockFunction,RDS_VBhIpVDwDw)
  _RDS_AUX_FUNC(rdsGetBlockDimensionsEx,RDS_BBhBrDw)
  _RDS_AUX_FUNC(rdsDeleteSystemState,RDS_VI)
  _RDS_AUX_FUNC(rdsVSSetVarFlags,RDS_VHoIDwDw)
  _RDS_AUX_FUNC(rdsMakeUniqueBlockNameA,RDS_SBhS)
  _RDS_AUX_FUNC(rdsMakeUniqueBlockNameW,RDS_WsBhWs)
  _RDS_AUX_FUNC(rdsCSVCreate,RDS_HoV)
  _RDS_AUX_FUNC(rdsCSVSetItemA,RDS_VHoIIS)
  _RDS_AUX_FUNC(rdsCSVSetItemW,RDS_VHoIIWs)
  _RDS_AUX_FUNC(rdsCSVGetItemA,RDS_SHoII)
  _RDS_AUX_FUNC(rdsCSVGetItemW,RDS_WsHoII)
  _RDS_AUX_FUNC(rdsStringReplaceA,RDS_SSpSpSIDw)
  _RDS_AUX_FUNC(rdsStringReplaceW,RDS_WsWspWspWsIDw)
  _RDS_AUX_FUNC(rdsDynStrCopyA,RDS_SS)
  _RDS_AUX_FUNC(rdsDynStrCopyW,RDS_WsWs)
  _RDS_AUX_FUNC(rdsCallFileDialogA,RDS_SSDwSSS)
  _RDS_AUX_FUNC(rdsCallFileDialogW,RDS_WsWsDwWsWsWs)
  _RDS_AUX_FUNC(rdsCallDirDialogA,RDS_SSSB)
  _RDS_AUX_FUNC(rdsCallDirDialogW,RDS_WsWsWsB)
  _RDS_AUX_FUNC(rdsTransformFileNameA,RDS_SSDwSpI)
  _RDS_AUX_FUNC(rdsTransformFileNameW,RDS_WsWsDwWspI)
  _RDS_AUX_FUNC(rdsTMPCreateFileSet,RDS_IV)
  _RDS_AUX_FUNC(rdsTMPDeleteFileSet,RDS_VI)
  _RDS_AUX_FUNC(rdsTMPCreateEmptyFileA,RDS_SIS)
  _RDS_AUX_FUNC(rdsTMPCreateEmptyFileW,RDS_WsIWs)
  _RDS_AUX_FUNC(rdsTMPDeleteFileA,RDS_VS)
  _RDS_AUX_FUNC(rdsTMPDeleteFileW,RDS_VWs)
  _RDS_AUX_FUNC(rdsTMPRememberFileNameA,RDS_SIS)
  _RDS_AUX_FUNC(rdsTMPRememberFileNameW,RDS_WsIWs)
  _RDS_AUX_FUNC(rdsGetLayerIdInConfig,RDS_IBhII)
  _RDS_AUX_FUNC(rdsGetTextWordDynA,RDS_SSpSpCB)
  _RDS_AUX_FUNC(rdsGetTextWordDynW,RDS_WsSpSpCB)
  _RDS_AUX_FUNC(rdsCEAddChannelA,RDS_BHoSCSI)
  _RDS_AUX_FUNC(rdsCEAddChannelW,RDS_BHoWsCWsI)
  _RDS_AUX_FUNC(rdsReportToolInfoA,RDS_VS)
  _RDS_AUX_FUNC(rdsReportToolInfoW,RDS_VWs)
  _RDS_AUX_FUNC(rdsSetToolTimer,RDS_VDw)
  _RDS_AUX_FUNC(rdsExecToolA,RDS_IDwSSIS)
  _RDS_AUX_FUNC(rdsExecToolW,RDS_IDwWsWsIWs)
  _RDS_AUX_FUNC(rdsSaveSystemBitmapA,RDS_BS1d)
  _RDS_AUX_FUNC(rdsSaveSystemBitmapW,RDS_BS1d)
  _RDS_AUX_FUNC(rdsPictureObjectDimensions,RDS_BIDwBr)
  _RDS_AUX_FUNC(rdsSuspendCalc,RDS_BBhB)
  _RDS_AUX_FUNC(rdsServiceVersionDate,RDS_DwV)
  _RDS_AUX_FUNC(rdsReportVersion,RDS_VIDw)
  _RDS_AUX_FUNC(rdsVSCompare,RDS_BHoHoDw)
  _RDS_AUX_FUNC(rdsGetBlockVarTypeStringA,RDS_SBh)
  _RDS_AUX_FUNC(rdsGetBlockVarTypeStringW,RDS_WsBh)
  _RDS_AUX_FUNC(rdsBLOBStartWrite,RDS_VIIB)
  _RDS_AUX_FUNC(rdsBLOBWrite,RDS_BpVI)
  _RDS_AUX_FUNC(rdsBLOBEndWrite,RDS_VV)
  _RDS_AUX_FUNC(rdsBLOBStartRead,RDS_BII)
  _RDS_AUX_FUNC(rdsBLOBRead,RDS_BpVI)
  _RDS_AUX_FUNC(rdsBLOBEndRead,RDS_VV)
  _RDS_AUX_FUNC(rdsGetIOBlockByVarNum,RDS_BhBhIBd)
  _RDS_AUX_FUNC(rdsSetEditorWorkspace,RDS_BBhII)
  _RDS_AUX_FUNC(rdsShowHelpA,RDS_ISSB)
  _RDS_AUX_FUNC(rdsShowHelpW,RDS_IWsWsB)
  _RDS_AUX_FUNC(rdsShowHelpFileA,RDS_ISSB)
  _RDS_AUX_FUNC(rdsShowHelpFileW,RDS_IWsWsB)
  _RDS_AUX_FUNC(rdsRegisterConnExtParamNameA,RDS_IS)
  _RDS_AUX_FUNC(rdsRegisterConnExtParamNameW,RDS_IWs)
  _RDS_AUX_FUNC(rdsGetConnExtParamsCount,RDS_ICh)
  _RDS_AUX_FUNC(rdsGetConnExtParamByNumA,RDS_IChIpSpIpIpDpS)
  _RDS_AUX_FUNC(rdsGetConnExtParamByNumW,RDS_IChIpWspIpIpDpWs)
  _RDS_AUX_FUNC(rdsGetConnExtParamByIdA,RDS_IChIpIpDpS)
  _RDS_AUX_FUNC(rdsGetConnExtParamByIdW,RDS_IChIpIpDpWs)
  _RDS_AUX_FUNC(rdsSetConnExtParamByIdA,RDS_BChIIIDS)
  _RDS_AUX_FUNC(rdsSetConnExtParamByIdW,RDS_BChIIIDWs)
  _RDS_AUX_FUNC(rdsConnSetupMenuNameA,RDS_VS)
  _RDS_AUX_FUNC(rdsConnSetupMenuNameW,RDS_VWs)
  _RDS_AUX_FUNC(rdsEnumDynVarsA,RDS_IBhDwCb7pV)
  _RDS_AUX_FUNC(rdsEnumDynVarsW,RDS_IBhDwCb7wpV)
  _RDS_AUX_FUNC(rdsGetConnExtParamByNumExA,RDS_IChIpSpIpIpDpSpDw)
  _RDS_AUX_FUNC(rdsGetConnExtParamByNumExW,RDS_IChIpWspIpIpDpWspDw)
  _RDS_AUX_FUNC(rdsGetConnExtParamByIdExA,RDS_IChIpIpDpSpDw)
  _RDS_AUX_FUNC(rdsGetConnExtParamByIdExW,RDS_IChIpIpDpWspDw)
  _RDS_AUX_FUNC(rdsSetConnExtParamByIdExA,RDS_BChIIIDSDw)
  _RDS_AUX_FUNC(rdsSetConnExtParamByIdExW,RDS_BChIIIDWsDw)
  _RDS_AUX_FUNC(rdsCallSaveAsDialog,RDS_BV)
  _RDS_AUX_FUNC(rdsSetObjectPtrA,RDS_VHoISpV)
  _RDS_AUX_FUNC(rdsSetObjectPtrW,RDS_VHoIWspV)
  _RDS_AUX_FUNC(rdsGetObjectPtrA,RDS_pVHoIpS)
  _RDS_AUX_FUNC(rdsGetObjectPtrW,RDS_pVHoIpWs)
  _RDS_AUX_FUNC(rdsExchangeVarArrays,RDS_BpVpV)
  _RDS_AUX_FUNC(rdsGetVarArrayElementType,RDS_IpV)
  _RDS_AUX_FUNC(rdsCopySelectedToMem,RDS_pVBhpIDw)
  _RDS_AUX_FUNC(rdsSelectConn,RDS_VChBB)
  _RDS_AUX_FUNC(rdsSelectAll,RDS_VBhBB)
  _RDS_AUX_FUNC(rdsPasteFromMem,RDS_BBhpVIDw)
  _RDS_AUX_FUNC(rdsDeleteSelected,RDS_VBhB)
  _RDS_AUX_FUNC(rdsCEUCreate,RDS_HoCh)
  _RDS_AUX_FUNC(rdsSubscribeToContentChange,RDS_VB)
  _RDS_AUX_FUNC(rdsUnsubscribeFromContentChange,RDS_VV)
  _RDS_AUX_FUNC(rdsSetSysModifiedFlag,RDS_VBhB)
  _RDS_AUX_FUNC(rdsTMPForgetFileNameA,RDS_BIS)
  _RDS_AUX_FUNC(rdsTMPForgetFileNameW,RDS_BIWs)
  _RDS_AUX_FUNC(rdscompGetModelModuleData,RDS_CdCh)
  _RDS_AUX_FUNC(rdscompIsEditorOpen,RDS_BMh)
  _RDS_AUX_FUNC(rdsExclusiveFileOpA,RDS_VSDw)
  _RDS_AUX_FUNC(rdsExclusiveFileOpW,RDS_VWsDw)
  _RDS_AUX_FUNC(rdsInfoMessageA,RDS_VSS)
  _RDS_AUX_FUNC(rdsInfoMessageW,RDS_VWsWs)
  _RDS_AUX_FUNC(rdscompCompileAll,RDS_BB)
  _RDS_AUX_FUNC(rdsVSCreateAutoConnsByDescrA,RDS_BHoS)
  _RDS_AUX_FUNC(rdsVSCreateAutoConnsByDescrW,RDS_BHoWs)
  _RDS_AUX_FUNC(rdscompLibraryOperation,RDS_BLop)
  _RDS_AUX_FUNC(rdsStoreTempGlobalA,RDS_VSSISpVDw)
  _RDS_AUX_FUNC(rdsStoreTempGlobalW,RDS_VWsWsIWspVDw)
  _RDS_AUX_FUNC(rdsReadTempGlobalA,RDS_BSSpIpSppVpDw)
  _RDS_AUX_FUNC(rdsReadTempGlobalW,RDS_BWsWspIpWsppVpDw)
  _RDS_AUX_FUNC(rdsDeleteConnExtParamById,RDS_BChI)
  _RDS_AUX_FUNC(rdsExecToolExtA,RDS_IDwSSS2)
  _RDS_AUX_FUNC(rdsExecToolExtW,RDS_IDwWsWsS2)
  _RDS_AUX_FUNC(rdsClearExecToolExtResults,RDS_VS2)
  _RDS_AUX_FUNC(rdsCountSelectedObjects,RDS_BBhpIpI)
  _RDS_AUX_FUNC(rdsFORMHelpButtonA,RDS_VHoDwSS)
  _RDS_AUX_FUNC(rdsFORMHelpButtonW,RDS_VHoDwWsWs)
  _RDS_AUX_FUNC(rdsRegisterUserNameSetA,RDS_IS)
  _RDS_AUX_FUNC(rdsRegisterUserNameSetW,RDS_IWs)
  _RDS_AUX_FUNC(rdsRegisterUserNameA,RDS_IIS)
  _RDS_AUX_FUNC(rdsRegisterUserNameW,RDS_IIWs)
  _RDS_AUX_FUNC(rdsGetRegisteredUserNameA,RDS_SII)
  _RDS_AUX_FUNC(rdsGetRegisteredUserNameW,RDS_WsII)
  _RDS_AUX_FUNC(rdsGetBlockVarOffset,RDS_IBhIpI)
  _RDS_AUX_FUNC(rdsRegisterGlobalIntVarA,RDS_pIS)
  _RDS_AUX_FUNC(rdsRegisterGlobalIntVarW,RDS_pIWs)
  _RDS_AUX_FUNC(rdscompForceModelNextCompile,RDS_VMhB)
  _RDS_AUX_FUNC(rdsDoInitialCalc,RDS_VBhDw)
  _RDS_AUX_FUNC(rdsShiftBakFileChainA,RDS_BSIS)
  _RDS_AUX_FUNC(rdsShiftBakFileChainW,RDS_BWsIWs)
  _RDS_AUX_FUNC(rdsGetBlockTextRectParams,RDS_BBhpBtrpFs)
  _RDS_AUX_FUNC(rdsSetBlockTextRectParamsA,RDS_BBhpBtrpFsDw)
  _RDS_AUX_FUNC(rdsSetBlockTextRectParamsW,RDS_BBhpBtrpFsDw)
  _RDS_AUX_FUNC(rdsINTCreate,RDS_HoB)
  _RDS_AUX_FUNC(rdsSCEUCreate,RDS_HoBh)
  _RDS_AUX_FUNC(rdsSCEUSaveBlock,RDS_VHoBhDw)
  _RDS_AUX_FUNC(rdsSCEUSaveConn,RDS_VHoChDw)
  _RDS_AUX_FUNC(rdsExecToolDelayedA,RDS_VDwSSS)
  _RDS_AUX_FUNC(rdsExecToolDelayedW,RDS_VDwWsWsWs)
  _RDS_AUX_FUNC(rdsLockDrawUpdates,RDS_BBhDw)
  _RDS_AUX_FUNC(rdsXGDrawBitmap,RDS_VIIHb)
  _RDS_AUX_FUNC(rdsGetEditorWinAndScroll,RDS_BBhpIpIpIpIpIpI)
  _RDS_AUX_FUNC(rdsGBLCreateA,RDS_HoS)
  _RDS_AUX_FUNC(rdsGBLCreateW,RDS_HoWs)
  _RDS_AUX_FUNC(rdsGBLBlockOp,RDS_VHoBhDw)
  _RDS_AUX_FUNC(rdsGBLGetBlock,RDS_BhHoI)
  _RDS_AUX_FUNC(rdsGBLBroadcastFunctionCalls,RDS_IHoIpVDw)
  _RDS_AUX_FUNC(rdsXGDrawStdIconDC,RDS_VDcIIDw)
  _RDS_AUX_FUNC(rdsInvalidateSystemWindows,RDS_VBhB)
  _RDS_AUX_FUNC(rdsSaveBlockToFileA,RDS_BBhSDwS)
  _RDS_AUX_FUNC(rdsSaveBlockToFileW,RDS_BBhWsDwWs)
  _RDS_AUX_FUNC(rdsSetBlockOrder,RDS_BhIBh)
  _RDS_AUX_FUNC(rdsSetConnOrder,RDS_ChICh)
  _RDS_AUX_FUNC(rdsSetConnTextA,RDS_BChDwSIBII)
  _RDS_AUX_FUNC(rdsSetConnTextW,RDS_BChDwWsIBII)
  _RDS_AUX_FUNC(rdscompCompileBlockModelDelayed,RDS_VBhB)
  _RDS_AUX_FUNC(rdsFileExistsA,RDS_BSSpSpI)
  _RDS_AUX_FUNC(rdsFileExistsW,RDS_BWsWspWspI)
  _RDS_AUX_FUNC(rdsBlockStateToBuffer,RDS_pVBhpDw)
  _RDS_AUX_FUNC(rdsBlockStateFromBuffer,RDS_BBhpVDw)
  _RDS_AUX_FUNC(rdsCreateSharedMemPlainA,RDS_SmISDw)
  _RDS_AUX_FUNC(rdsCreateSharedMemPlainW,RDS_SmIWsDw)
  _RDS_AUX_FUNC(rdsCreateSharedMemVarA,RDS_SmISS)
  _RDS_AUX_FUNC(rdsCreateSharedMemVarW,RDS_SmIWsWs)
  _RDS_AUX_FUNC(rdsDeleteSharedMem,RDS_VSm)
  _RDS_AUX_FUNC(rdsNotifySharedMemUsers,RDS_VSm)
  _RDS_AUX_FUNC(rdsEnumSharedMemUsers,RDS_BhSmCb8pV)
  _RDS_AUX_FUNC(rdsTranslateParameterA,RDS_SSIISpI)
  _RDS_AUX_FUNC(rdsTranslateParameterW,RDS_WsWsIIWspI)
  _RDS_AUX_FUNC(rdsTranslateTextA,RDS_SSIpI)
  _RDS_AUX_FUNC(rdsTranslateTextW,RDS_WsWsIpI)
  _RDS_AUX_FUNC(rdsSetConnTextExA,RDS_BChDwSIBIIB)
  _RDS_AUX_FUNC(rdsSetConnTextExW,RDS_BChDwWsIBIIB)
  _RDS_AUX_FUNC(rdsGetLayerConfigId,RDS_DwBhI)
  _RDS_AUX_FUNC(rdsGetLayerConfigNumById,RDS_IBhDw)
  _RDS_AUX_FUNC(rdsFORMTBLSetStrA,RDS_VHoIIIS)
  _RDS_AUX_FUNC(rdsFORMTBLSetStrW,RDS_VHoIIIWs)
  _RDS_AUX_FUNC(rdsFORMTBLGetStrA,RDS_SHoIIIpB)
  _RDS_AUX_FUNC(rdsFORMTBLGetStrW,RDS_WsHoIIIpB)
  _RDS_AUX_FUNC(rdsFORMTBLSetHeaderA,RDS_VHoIISDwI)
  _RDS_AUX_FUNC(rdsFORMTBLSetHeaderW,RDS_VHoIIWsDwI)
  _RDS_AUX_FUNC(rdsFORMTBLSetInt,RDS_VHoIIII)
  _RDS_AUX_FUNC(rdsFORMTBLGetInt,RDS_IHoIIIpB)
  _RDS_AUX_FUNC(rdsFORMTBLSetDouble,RDS_VHoIIID)
  _RDS_AUX_FUNC(rdsFORMTBLGetDouble,RDS_DHoIIIpB)
  _RDS_AUX_FUNC(rdsFORMTBLGetDoubleP,RDS_BHoIIIpD)
  _RDS_AUX_FUNC(rdsFORMTBLMoveLine,RDS_BHoIII)
  _RDS_AUX_FUNC(rdsCreateSystemA,RDS_BhBhSIIBhDw)
  _RDS_AUX_FUNC(rdsCreateSystemW,RDS_BhBhWsIIBhDw)
  _RDS_AUX_FUNC(rdsNetListServerChannelsA,RDS_SI)
  _RDS_AUX_FUNC(rdsNetListServerChannelsW,RDS_WsI)
  _RDS_AUX_FUNC(rdsNetListChannelsA,RDS_SSI)
  _RDS_AUX_FUNC(rdsNetListChannelsW,RDS_WsWsI)
  _RDS_AUX_FUNC(rdsCreateBlockA,RDS_BhBhISII)
  _RDS_AUX_FUNC(rdsCreateBlockW,RDS_BhBhIWsII)
  _RDS_AUX_FUNC(rdsCESetInternalPoint,RDS_IHoIII)
  _RDS_AUX_FUNC(rdsCESetBlockPointA,RDS_IHoIBhSIIDwII)
  _RDS_AUX_FUNC(rdsCESetBlockPointW,RDS_IHoIBhWsIIDwII)
  _RDS_AUX_FUNC(rdsCESetBusPointA,RDS_IHoIChSBIIDwII)
  _RDS_AUX_FUNC(rdsCESetBusPointW,RDS_IHoIChWsBIIDwII)
  _RDS_AUX_FUNC(rdsCESetLine,RDS_IHoIII)
  _RDS_AUX_FUNC(rdsCESetBezier,RDS_IHoIIIIIII)
  _RDS_AUX_FUNC(rdsCEReadConnBus,RDS_BHoCh)
  _RDS_AUX_FUNC(rdsCEGetPointDescription,RDS_BHoIPd)
  _RDS_AUX_FUNC(rdsCEGetLineDescription,RDS_BHoILd)
  // 1.0.494
  _RDS_AUX_FUNC(rdsEnumConnectedBuses,RDS_ChChDwCb9pV)
  _RDS_AUX_FUNC(rdsBusChannelNameByNumA,RDS_SChI)
  _RDS_AUX_FUNC(rdsBusChannelNameByNumW,RDS_WsChI)
  _RDS_AUX_FUNC(rdsEnumBusLinks,RDS_ChChIDwCb10pV)
  // 1.0.496
  _RDS_AUX_FUNC(rdsGetBusChannelParamsA,RDS_BChIpSpCpSpDwpIpS)
  _RDS_AUX_FUNC(rdsGetBusChannelParamsW,RDS_BChIpWspCpWspDwpIpWs)
  _RDS_AUX_FUNC(rdsGetSystemPtr,RDS_pVIIpV)
  // 1.0.497
  _RDS_AUX_FUNC(rdsCompareVarGeneral,RDS_BVhpVVhpVD)
  _RDS_AUX_FUNC(rdsEnumExternalDynVarsA,RDS_IBhDwCb7pV)
  _RDS_AUX_FUNC(rdsEnumExternalDynVarsW,RDS_IBhDwCb7wpV)
  // 1.0.498
  _RDS_AUX_FUNC(rdsEnumDynVarsExA,RDS_IBhDwCb11pV)
  _RDS_AUX_FUNC(rdsEnumDynVarsExW,RDS_IBhDwCb11wpV)
  _RDS_AUX_FUNC(rdsEnumExternalDynVarsExA,RDS_IBhDwCb11pV)
  _RDS_AUX_FUNC(rdsEnumExternalDynVarsExW,RDS_IBhDwCb11wpV)
  _RDS_AUX_FUNC(rdsGetVarParamsA,RDS_BVhpSpCpSpDwpIpS)
  _RDS_AUX_FUNC(rdsGetVarParamsW,RDS_BVhpWspCpWspDwpIpWs)
  _RDS_AUX_FUNC(rdsVarTypeTextByParamsA,RDS_SCSDwI)
  _RDS_AUX_FUNC(rdsVarTypeTextByParamsW,RDS_WsCWsDwI)
  _RDS_AUX_FUNC(rdsVarParamsByTypeTextA,RDS_BSpCpSpDwpI)
  _RDS_AUX_FUNC(rdsVarParamsByTypeTextW,RDS_BWspCpWspDwpI)
  _RDS_AUX_FUNC(rdsBlockVarCompareMem,RDS_BBhIpVID)
  // 1.0.499
  _RDS_AUX_FUNC(rdsFORMTBLSetColTextListA,RDS_VHoIIS)
  _RDS_AUX_FUNC(rdsFORMTBLSetColTextListW,RDS_VHoIIWs)
  _RDS_AUX_FUNC(rdsFORMTBLSetColDefValueA,RDS_VHoIIS)
  _RDS_AUX_FUNC(rdsFORMTBLSetColDefValueW,RDS_VHoIIWs)
  // 1.0.500
  _RDS_AUX_FUNC(rdsFORMTBLSetServFunc,RDS_VHoICb6)
  // 1.0.504
  _RDS_AUX_FUNC(rdsCWCreateA,RDS_HoBhSIICwDw)
  _RDS_AUX_FUNC(rdsCWCreateW,RDS_HoBhWsIICwDw)
  // 1.0.505
  _RDS_AUX_FUNC(rdsCWGetParameters,RDS_BHoCw)
  _RDS_AUX_FUNC(rdsCWCreateCopyA,RDS_HoBhSIIDwHo)
  _RDS_AUX_FUNC(rdsCWCreateCopyW,RDS_HoBhWsIIDwHo)
  // 1.0.508
  _RDS_AUX_FUNC(rdsCWTranslateChanges,RDS_BHoHo)
  // 1.0.511
  _RDS_AUX_FUNC(rdsForceDirectoriesA,RDS_BSDw)
  _RDS_AUX_FUNC(rdsForceDirectoriesW,RDS_BWsDw)
  // 1.0.512
  _RDS_AUX_FUNC(rdsResetAllBlockSignals,RDS_VBhI)
  // 1.0.514
  _RDS_AUX_FUNC(rdsGetUICurrentModA,RDS_SSFt)
  _RDS_AUX_FUNC(rdsGetUICurrentModW,RDS_WsWsFt)
  _RDS_AUX_FUNC(rdsUIMODCreate,RDS_HoV)
  _RDS_AUX_FUNC(rdsUIMODLoadGroupA,RDS_BHoSS)
  _RDS_AUX_FUNC(rdsUIMODLoadGroupW,RDS_BHoWsWs)
  _RDS_AUX_FUNC(rdsUIMODGetParamStringA,RDS_SHoSIS)
  _RDS_AUX_FUNC(rdsUIMODGetParamStringW,RDS_WsHoWsIWs)
  _RDS_AUX_FUNC(rdsUIMODGetParamStrByNumA,RDS_SHoSIpIS)
  _RDS_AUX_FUNC(rdsUIMODGetParamStrByNumW,RDS_WsHoWsIpIWs)
  _RDS_AUX_FUNC(rdsGetUIModsListA,RDS_SS)
  _RDS_AUX_FUNC(rdsGetUIModsListW,RDS_WsWs)
  _RDS_AUX_FUNC(rdsUIMODGetParamStrByNameA,RDS_SHoSSS)
  _RDS_AUX_FUNC(rdsUIMODGetParamStrByNameW,RDS_WsHoWsWsWs)
  _RDS_AUX_FUNC(rdsUIMODSetParamStrByNameA,RDS_VHoSSS)
  _RDS_AUX_FUNC(rdsUIMODSetParamStrByNameW,RDS_VHoWsWsWs)
  // 1.0.516
  _RDS_AUX_FUNC(rdsBMPCreateA,RDS_HoS)
  _RDS_AUX_FUNC(rdsBMPCreateW,RDS_HoWs)
  _RDS_AUX_FUNC(rdsBMPDraw,RDS_VHoII)
  _RDS_AUX_FUNC(rdsBMPStretchDraw,RDS_VHoIIII)
  // 1.0.519
  _RDS_AUX_FUNC(rdsUIMODLoadSingleObjectA,RDS_BHoSSS)
  _RDS_AUX_FUNC(rdsUIMODLoadSingleObjectW,RDS_BHoWsWsWs)
  _RDS_AUX_FUNC(rdsUIMODGetParamListStringA,RDS_SHoSIS)
  _RDS_AUX_FUNC(rdsUIMODGetParamListStringW,RDS_WsHoWsIWs)
  // 1.0.520
  _RDS_AUX_FUNC(rdsThisIsDebugVersion,RDS_VV)
  // 1.0.538
  _RDS_AUX_FUNC(rdsVSCreateFromConnA,RDS_VHoChS)
  _RDS_AUX_FUNC(rdsVSCreateFromConnW,RDS_VHoChWs)
  // 1.0.542
  _RDS_AUX_FUNC(rdsSGPRegisterNameA,RDS_IS)
  _RDS_AUX_FUNC(rdsSGPRegisterNameW,RDS_IWs)
  _RDS_AUX_FUNC(rdsSGPSetDataA,RDS_BSgp)
  _RDS_AUX_FUNC(rdsSGPSetDataW,RDS_BSgp)
  _RDS_AUX_FUNC(rdsSGPGetDataA,RDS_BSgp)
  _RDS_AUX_FUNC(rdsSGPGetDataW,RDS_BSgp)
  _RDS_AUX_FUNC(rdsSGPDelete,RDS_BI)
  _RDS_AUX_FUNC(rdsSGPGetDataByNum,RDS_BISgp)
  // 1.0.544
  _RDS_AUX_FUNC(rdsAtoDwA,RDS_DwSpI)
  _RDS_AUX_FUNC(rdsAtoDwW,RDS_DwWspI)
  _RDS_AUX_FUNC(rdsDwtoAA,RDS_SDwII)
  _RDS_AUX_FUNC(rdsDwtoAW,RDS_WsDwII)
  // 1.0.545
  _RDS_AUX_FUNC(rdsRegisterFuncCallMenuItemA,RDS_ISDwIDwII)
  _RDS_AUX_FUNC(rdsRegisterFuncCallMenuItemW,RDS_IWsDwIDwII)
  _RDS_AUX_FUNC(rdsUnregisterFuncCallMenuItem,RDS_BI)
  _RDS_AUX_FUNC(rdsChangeFuncCallMenuItemA,RDS_BISDwIDw)
  _RDS_AUX_FUNC(rdsChangeFuncCallMenuItemW,RDS_BIWsDwIDw)
  _RDS_AUX_FUNC(rdsSetFuncCallMenuItemFlags,RDS_VIDw)
  _RDS_AUX_FUNC(rdsIncompatibleDll,RDS_VV)
  // 1.0.546
  _RDS_AUX_FUNC(rdsNetGetServerConnectionData,RDS_IIIINgsc)
  _RDS_AUX_FUNC(rdsNetGetServerStationConnIndex,RDS_IINsNgsc)
  // 1.0.552
  _RDS_AUX_FUNC(rdsGetBlockClass,RDS_IBhI)
  _RDS_AUX_FUNC(rdsGetConnectionClass,RDS_IChI)
  _RDS_AUX_FUNC(rdsGetObjectClassNameA,RDS_SI)
  _RDS_AUX_FUNC(rdsGetObjectClassNameW,RDS_WsI)
  _RDS_AUX_FUNC(rdsIsClassVisible,RDS_BBhII)
  _RDS_AUX_FUNC(rdsGetConnectionFlags,RDS_DwCh)
  _RDS_AUX_FUNC(rdsSetConnectionFlags,RDS_VChDwDw)
  // 1.0.553
  _RDS_AUX_FUNC(rdsSearchConnErrors,RDS_BChBhB)
  // 1.0.554
  _RDS_AUX_FUNC(rdsSortVarArray,RDS_VpVIDw)
  // 1.0.558
  _RDS_AUX_FUNC(rdsSetZoomPercentDbl,RDS_VBhDII)
  // 1.0.561
  _RDS_AUX_FUNC(rdsBringAppToFrontEx,RDS_VI)
  // 1.0.563
  _RDS_AUX_FUNC(rdsShowSeeAlsoExamplesA,RDS_ISSB)
  _RDS_AUX_FUNC(rdsShowSeeAlsoExamplesW,RDS_IWsWsB)
  // 1.0.566
  _RDS_AUX_FUNC(rdsCanEditSystem,RDS_BBh)
  // 1.0.568
  _RDS_AUX_FUNC(rdsFORMMakeSearchA,RDS_VHoBIS)
  _RDS_AUX_FUNC(rdsFORMMakeSearchW,RDS_VHoBIWs)
  _RDS_AUX_FUNC(rdsFORMAddSearchResultA,RDS_VHoSS)
  _RDS_AUX_FUNC(rdsFORMAddSearchResultW,RDS_VHoWsWs)
  _RDS_AUX_FUNC(rdsFORMGetSearchResultA,RDS_BHoIpSpS)
  _RDS_AUX_FUNC(rdsFORMGetSearchResultW,RDS_BHoIpWspWs)
  // 1.0.571
  _RDS_AUX_FUNC(rdsBMPCreateExA,RDS_HoSIII)
  _RDS_AUX_FUNC(rdsBMPCreateExW,RDS_HoWsIII)
  // 1.0.572
  _RDS_AUX_FUNC(rdsFORMTBLExchangeLines,RDS_BHoIII)
  // 1.0.584
  _RDS_AUX_FUNC(rdsGetObjectClassId,RDS_II)
  _RDS_AUX_FUNC(rdsBlockBelongsToClass,RDS_BBhI)
  _RDS_AUX_FUNC(rdsConnBelongsToClass,RDS_BChI)
  // 1.0.585
  _RDS_AUX_FUNC(rdsVSExecuteEditorExA,RDS_BHoBDwISCb12Cb12)
  _RDS_AUX_FUNC(rdsVSExecuteEditorExW,RDS_BHoBDwIWsCb12wCb12w)
  _RDS_AUX_FUNC(rdsPICCreate,RDS_HoBh)
  _RDS_AUX_FUNC(rdsVarToMem,RDS_pVVhpVBpI)
  _RDS_AUX_FUNC(rdsVarFromMem,RDS_BVhpVpVI)
  // 1.0.586
  _RDS_AUX_FUNC(rdsVSGetVarParamsA,RDS_BHoIpSpCpSpDwpIpS)
  _RDS_AUX_FUNC(rdsVSGetVarParamsW,RDS_BHoIpWspCpWspDwpIpWs)
  _RDS_AUX_FUNC(rdsCreateVarTypeStringA,RDS_SVh)
  _RDS_AUX_FUNC(rdsCreateVarTypeStringW,RDS_WsVh)
  _RDS_AUX_FUNC(rdsFindBlockVarIndexA,RDS_IBhSVdpI)
  _RDS_AUX_FUNC(rdsFindBlockVarIndexW,RDS_IBhWsVdpI)
  _RDS_AUX_FUNC(rdsMatchesMaskA,RDS_BSSB)
  _RDS_AUX_FUNC(rdsMatchesMaskW,RDS_BWsWsB)
  // 1.0.587
  _RDS_AUX_FUNC(rdsGetBlockConnPoint,RDS_ChBhIBBPd)
  _RDS_AUX_FUNC(rdsIsHugeDoubleSafe,RDS_BpD)
  // 1.0.589
  _RDS_AUX_FUNC(rdsVarArrayOp,RDS_BpVpVIIIII)
  // 1.0.597
  _RDS_AUX_FUNC(rdsIsValidVarNameRemA,RDS_BSIB)
  _RDS_AUX_FUNC(rdsIsValidVarNameRemW,RDS_BWsIB)
  // 1.0.602
  _RDS_AUX_FUNC(rdsConsoleWindowOpA,RDS_HwIIS)
  _RDS_AUX_FUNC(rdsConsoleWindowOpW,RDS_HwIIWs)
  // 1.0.603
  _RDS_AUX_FUNC(rdsVNCreateNameValidatorA,RDS_HoDwS)
  _RDS_AUX_FUNC(rdsVNCreateNameValidatorW,RDS_HoDwWs)
  _RDS_AUX_FUNC(rdsVNCheckA,RDS_IHoS)
  _RDS_AUX_FUNC(rdsVNCheckW,RDS_IHoWs)
  _RDS_AUX_FUNC(rdsVNValidateA,RDS_SHoSpI)
  _RDS_AUX_FUNC(rdsVNValidateW,RDS_WsHoWspI)
  _RDS_AUX_FUNC(rdsGetObjectPtrCheckA,RDS_pVHoIS)
  _RDS_AUX_FUNC(rdsGetObjectPtrCheckW,RDS_pVHoIWs)
  _RDS_AUX_FUNC(rdsVSApplyVarRenames,RDS_BHoBh)
  _RDS_AUX_FUNC(rdsGetBlockType,RDS_IBh)
  _RDS_AUX_FUNC(rdsGetExtId,RDS_DwBhCh)
  // 1.0.604
  _RDS_AUX_FUNC(rdsFORMTBLSortTable,RDS_IHoIBpIII)
  _RDS_AUX_FUNC(rdsBCLGetBlockIndex,RDS_IHoBh)
  _RDS_AUX_FUNC(rdsBCLGetConnIndex,RDS_IHoCh)
  // 1.0.605
  _RDS_AUX_FUNC(rdsMUOCreate,RDS_HoV)
  _RDS_AUX_FUNC(rdsMUOBlockOp,RDS_VHoIBhDw)
  _RDS_AUX_FUNC(rdsMUOConnOp,RDS_VHoIChDw)
  // 1.0.606
  _RDS_AUX_FUNC(rdsBCLRemoveBlock,RDS_IHoBh)
  _RDS_AUX_FUNC(rdsBCLRemoveConn,RDS_IHoCh)
  // 1.0.607
  _RDS_AUX_FUNC(rdsSetBlockClass,RDS_VBhII)
  _RDS_AUX_FUNC(rdsSetConnectionClass,RDS_VChII)
  // 1.0.609
  _RDS_AUX_FUNC(rdsScrollWindowToRectEx,RDS_VBhIIIIDw)
  // 1.0.610
  _RDS_AUX_FUNC(rdsINFOCreate,RDS_HoV)
  _RDS_AUX_FUNC(rdsINFOSetSize,RDS_VHoII)
  _RDS_AUX_FUNC(rdsINFOSetPos,RDS_VHoBIIII)
  _RDS_AUX_FUNC(rdsINFOSetRelPosBySys,RDS_VHoBhII)
  _RDS_AUX_FUNC(rdsINFOSetRelPosPrimary,RDS_VHoII)
  // 1.0.613
  _RDS_AUX_FUNC(rdsSaveWindowConfigA,RDS_VS3)
  _RDS_AUX_FUNC(rdsSaveWindowConfigW,RDS_VS3)
  // 1.0.625
  _RDS_AUX_FUNC(rdsAuxThreadStart,RDS_ThCb13Cb13pV)
  _RDS_AUX_FUNC(rdsAuxThreadSync,RDS_VThCb14pV)
  _RDS_AUX_FUNC(rdsAuxThreadAskStop,RDS_VTh)
  _RDS_AUX_FUNC(rdsFORMSetMainButtonsA,RDS_VHoISB)
  _RDS_AUX_FUNC(rdsFORMSetMainButtonsW,RDS_VHoIWsB)
  // 1.0.626
  _RDS_AUX_FUNC(rdsBMPCreateManual,RDS_HoII)
  _RDS_AUX_FUNC(rdsBMPManualDraw,RDS_VHoCb15pV)
  // 2.0.0
  _RDS_AUX_FUNC(rdsUTF16toUTF8,RDS_SWsB)
  _RDS_AUX_FUNC(rdsUTF8toUTF16,RDS_WsSB)
  _RDS_AUX_FUNC(rdscompLinkAvailableModuleA,RDS_BS)
  _RDS_AUX_FUNC(rdscompLinkAvailableModuleW,RDS_BWs)
  _RDS_AUX_FUNC(rdscompLinkModuleAllowed,RDS_BV)
  _RDS_AUX_FUNC(rdscompSetModelFunctionExA,RDS_VMhISS)
  _RDS_AUX_FUNC(rdscompSetModelFunctionExW,RDS_VMhIWsWs)
  _RDS_AUX_FUNC(rdsGetEnvironmentVariableA,RDS_SS)
  _RDS_AUX_FUNC(rdsGetEnvironmentVariableW,RDS_WsWs)
  _RDS_AUX_FUNC(rdsSetEnvironmentVariableA,RDS_SSSB)
  _RDS_AUX_FUNC(rdsSetEnvironmentVariableW,RDS_WsWsWsB)
  _RDS_AUX_FUNC(rdsInitExecToolExtData,RDS_VS2)
  _RDS_AUX_FUNC(rdscompTestCompileA,RDS_BSSSpSpSpS)
  _RDS_AUX_FUNC(rdscompTestCompileW,RDS_BWsWsWspWspWspWs)
  _RDS_AUX_FUNC(rdscompTestCompReturnStringA,RDS_VIS)
  _RDS_AUX_FUNC(rdscompTestCompReturnStringW,RDS_VIWs)
  _RDS_AUX_FUNC(rdsStrLenA,RDS_DwS)
  _RDS_AUX_FUNC(rdsStrLenW,RDS_DwWs)
  _RDS_AUX_FUNC(rdsIsUTF8Text,RDS_BSDw)
  _RDS_AUX_FUNC(rdsGetFlag,RDS_BDwDw)
  _RDS_AUX_FUNC(rdsSetFlag,RDS_DwDwDwB)
  _RDS_AUX_FUNC(rdsSetFlagP,RDS_VpDwDwB)
  _RDS_AUX_FUNC(rdsTMPCreateEmptyFileAnyExtA,RDS_SIS)
  _RDS_AUX_FUNC(rdsTMPCreateEmptyFileAnyExtW,RDS_WsIWs)
  // 2.0.1
  _RDS_AUX_FUNC(rdsGetVarArrayItemAddr,RDS_pVpVIBpI)
  _RDS_AUX_FUNC(rdsGetVarMatrItemAddr,RDS_pVpVIIBpI)
  // 2.0.2
  _RDS_AUX_FUNC(rdsSetBlockModelKeepDataA,RDS_BBhSS)
  _RDS_AUX_FUNC(rdsSetBlockModelKeepDataW,RDS_BBhWsWs)
  // 2.0.9
  _RDS_AUX_FUNC(rdsXGDrawStdIconOnBlock,RDS_VBhIIDwII)
  // 2.0.11
  _RDS_AUX_FUNC(rdsCompareVarArray,RDS_BpVpVD)
  _RDS_AUX_FUNC(rdsCallConnectedBlocksFunction,RDS_VBhIDwIpV)
  // 2.0.13
  _RDS_AUX_FUNC(rdsExecuteBlockSetup,RDS_VBh)
  _RDS_AUX_FUNC(rdsBCLListConnectedBlocksByVar,RDS_IHoBhIDw)
  _RDS_AUX_FUNC(rdsFindDataSourceBlock,RDS_BhBhIPd)
  // 2.0.14
  _RDS_AUX_FUNC(rdsXGCalcBlockPointCoords,RDS_VIIpIpI)
  // 2.0.16
  _RDS_AUX_FUNC(rdsCountSimpleSourceBlocks,RDS_IBhI)
  _RDS_AUX_FUNC(rdsCountSimpleSourceBlocksN,RDS_IBhpII)
  // 2.0.17
  _RDS_AUX_FUNC(rdsCountSimpleDestBlocks,RDS_IBhI)
  _RDS_AUX_FUNC(rdsCountSimpleDestBlocksN,RDS_IBhpII)
  // 2.0.20
  _RDS_AUX_FUNC(rdsGetCallerBlock,RDS_BhBd)
  _RDS_AUX_FUNC(rdsSubscribeToFuncProviderSameSystem,RDS_BFl)
  _RDS_AUX_FUNC(rdsBlockHookAdd,RDS_BhookICb16pVDw)
  _RDS_AUX_FUNC(rdsBlockHookChange,RDS_BBhookCb16pVDw)
  _RDS_AUX_FUNC(rdsBlockHookDelete,RDS_VBhook)
  _RDS_AUX_FUNC(rdsCallFontDialog,RDS_BpFs)
  _RDS_AUX_FUNC(rdsCallFontDialogEx,RDS_BpFsDwCr)
  // Global function vars - autogenerated (end)

  #undef _RDS_AUX_FUNC
// конец #ifndef RDS_AUX_NOEXTERNFUNCPTRS
#endif
//===================================================================================


//===================================================================================
// Функции-синонимы (другие обозначения универсальных функций для улучшения
// читаемости исходных текстов)
//===================================================================================
#ifndef RDS_NOHOBJMACROS
  // Редактировать связь по вспомогательному объекту
  #define rdsCEEditConnection           rdsCEEditConnBus
  // Редактировать шину по вспомогательному объекту
  #define rdsCEEditBus                  rdsCEEditConnBus
  // Создать связь по вспомогательному объекту
  #define rdsCECreateConnection(o,p,e)  rdsCECreateConnBus((o),(p),RDS_CTCONNECTION,(e))
  // Создать шину по вспомогательному объекту
  #define rdsCECreateBus(o,p,e)         rdsCECreateConnBus((o),(p),RDS_CTBUS,(e))
  // Очистить объект-редактор связи
  #define rdsCEClearEditor(o)           rdsCommandObject((o),RDS_HCE_RESET)
  // Получить массив блоков из объекта-списка
  #define rdsBCLGetBlockArray(o,ps)     ((RDS_BHANDLE*)rdsGetObjectArray((o),RDS_HBCL_BLOCKARRAY,0,(ps)))
  // Получить массив связей из объекта-списка
  #define rdsBCLGetConnArray(o,ps)      ((RDS_CHANDLE*)rdsGetObjectArray((o),RDS_HBCL_CONNARRAY,0,(ps)))
  // Установить имя структуры для набора переменных
  #define rdsVSSetStructNameA(o,name)   rdsSetObjectStrA((o),RDS_HVAR_SETTYPENAME,0,(name))
  #define rdsVSSetStructNameW(o,name)   rdsSetObjectStrW((o),RDS_HVAR_SETTYPENAME,0,(name))
  // Получить имя структуры набора переменных
  #define rdsVSGetStructNameA(o)        rdsGetObjectStrA((o),RDS_HVAR_GETTYPENAME,0)
  #define rdsVSGetStructNameW(o)        rdsGetObjectStrW((o),RDS_HVAR_GETTYPENAME,0)
  // Очистить объект-набор переменных
  #define rdsVSClearEditor(o)           rdsCommandObject((o),RDS_HVAR_RESET)
  // Удалить переменную из набора переменных
  #define rdsVSDeleteVar(o,n)           rdsCommandObjectEx((o),RDS_HVAR_DELVAR,(n),NULL)
  // Удалить автосоединение из набора переменных
  #define rdsVSDeleteAutoConn(o,n)      rdsCommandObjectEx((o),RDS_HVAR_DELAUTO,(n),NULL)
  // Получить имя главной переменной автосоединения с указанным номером в наборе переменных
  #define rdsVSGetAutoMainA(o,n)        rdsGetObjectStrA((o),RDS_HVAR_GETAUTOMAIN,(n))
  #define rdsVSGetAutoMainW(o,n)        rdsGetObjectStrW((o),RDS_HVAR_GETAUTOMAIN,(n))
  // Получить имя связанной переменной автосоединения с указанным номером в наборе переменных
  #define rdsVSGetAutoConnA(o,n)        rdsGetObjectStrA((o),RDS_HVAR_GETAUTOCONN,(n))
  #define rdsVSGetAutoConnW(o,n)        rdsGetObjectStrW((o),RDS_HVAR_GETAUTOCONN,(n))
  // Получить число переменных в наборе переменных
  #define rdsVSGetFieldCount(o)         rdsGetObjectInt((o),RDS_HVAR_GETFIELDCOUNT,0)
  // Получить число автоматических соединений  в наборе переменных
  #define rdsVSGetAutoCount(o)          rdsGetObjectInt((o),RDS_HVAR_GETAUTOCOUNT,0)
  // Получить уровень набора переменных
  #define rdsVSGetStructRank(o)         rdsGetObjectInt((o),RDS_HVAR_GETVARRANK,0)
  // Очистить список переименования структур
  #define rdsVSClearTypeRenames(o)      rdsCommandObject((o),RDS_HVAR_CLEARTYPEREN)
  // Очистить список переименования переменных
  #define rdsVSClearVarRenames(o)       rdsCommandObject((o),RDS_HVAR_CLEARVARREN)
  // Установить текст для анализатора (rdsSTRCreateTextReader)
  #define rdsSTRSetTextToReadA(obj,text) rdsSetObjectStrA((obj),RDS_HSTR_SETTEXT,0,(text))
  #define rdsSTRSetTextToReadW(obj,text) rdsSetObjectStrW((obj),RDS_HSTR_SETTEXT,0,(text))
  // Считать целое число
  #define rdsSTRGetIntWord(obj,skiplf)  rdsGetObjectInt((o),RDS_HSTR_READINT,(skiplf))
  // Считать число double
  #define rdsSTRGetDoubleWord(obj,skiplf) rdsGetObjectDouble((o),RDS_HSTR_READDOUBLE,(skiplf))
  // Очистить текст обработчика INI-файлов (rdsINICreateTextHolder)
  #define rdsINIClearText(o)            rdsCommandObject((o),RDS_HINI_RESET)
  // Установить текст для обработчика INI-файлов
  #define rdsINISetTextA(obj,text)      rdsSetObjectStrA((obj),RDS_HINI_SETTEXT,0,(text))
  #define rdsINISetTextW(obj,text)      rdsSetObjectStrW((obj),RDS_HINI_SETTEXT,0,(text))
  // Загрузить файл для обработчика INI-файлов
  #define rdsINILoadFileA(obj,filename) rdsSetObjectStrA((obj),RDS_HINI_LOADFILE,0,(filename))
  #define rdsINILoadFileW(obj,filename) rdsSetObjectStrW((obj),RDS_HINI_LOADFILE,0,(filename))
  // Записать файл для обработчика INI-файлов
  #define rdsINISaveFileA(obj,filename) rdsSetObjectStrA((obj),RDS_HINI_SAVEFILE,0,(filename))
  #define rdsINISaveFileW(obj,filename) rdsSetObjectStrW((obj),RDS_HINI_SAVEFILE,0,(filename))
  // Создать секцию для обработчика INI-файлов
  #define rdsINICreateSectionA(obj,section)    rdsSetObjectStrA((obj),RDS_HINI_CREATESECTION,0,(section))
  #define rdsINICreateSectionW(obj,section)    rdsSetObjectStrW((obj),RDS_HINI_CREATESECTION,0,(section))
  // Удалить секцию для обработчика INI-файлов
  #define rdsINIDeleteSectionA(obj,section)    rdsSetObjectStrA((obj),RDS_HINI_DELETESECTION,0,(section))
  #define rdsINIDeleteSectionW(obj,section)    rdsSetObjectStrW((obj),RDS_HINI_DELETESECTION,0,(section))
  // Записать логическое значение в текущую секцию обработчика INI-файлов
  #define rdsINIWriteBoolA(obj,key,val) rdsINIWriteIntA((obj),(key),(val)?1:0)
  #define rdsINIWriteBoolW(obj,key,val) rdsINIWriteIntW((obj),(key),(val)?1:0)
  // Считать логическое значение из текущей секции обработчика INI-файлов
  #define rdsINIReadBoolA(obj,key,defval)       (rdsINIReadIntA((obj),(key),(defval)?1:0)!=0)
  #define rdsINIReadBoolW(obj,key,defval)       (rdsINIReadIntW(obj),(key),(defval)?1:0)!=0)
  // Удалить значение из текущей секции обработчика INI-файлов
  #define rdsINIDeleteValueA(obj,key)           rdsSetObjectStrA((obj),RDS_HINI_DELETEKEYLAST,0,(key))
  #define rdsINIDeleteValueW(obj,key)           rdsSetObjectStrW((obj),RDS_HINI_DELETEKEYLAST,0,(key))
  // Записать текст обработчика INI-файлов как данные блока в текстовом формате
  #define rdsINISaveBlockText(o,newln)          rdsCommandObjectEx((o),RDS_HINI_SAVEBLOCKTEXT,(newln)?1:0,NULL)
  // Передать форме целое число (для объекта rdsFORMCreate)
  #define rdsFORMSetInt(o,id,val)               rdsSetObjectInt((o),(id),RDS_FORMVAL_VALUE,(val))
  // Получить у формы целое число (для объекта rdsFORMCreate)
  #define rdsFORMGetInt(o,id)                   rdsGetObjectInt((o),(id),RDS_FORMVAL_VALUE)
  // Передать форме строку (для объекта rdsFORMCreate)
  #define rdsFORMSetStringA(o,id,str)           rdsSetObjectStrA((o),(id),RDS_FORMVAL_VALUE,(str))
  #define rdsFORMSetStringW(o,id,str)           rdsSetObjectStrW((o),(id),RDS_FORMVAL_VALUE,(str))
  // Получить у формы строку (для объекта rdsFORMCreate)
  #define rdsFORMGetStringA(o,id)               rdsGetObjectStrA((o),(id),RDS_FORMVAL_VALUE)
  #define rdsFORMGetStringW(o,id)               rdsGetObjectStrW((o),(id),RDS_FORMVAL_VALUE)
  // Передать форме число double (для объекта rdsFORMCreate)
  #define rdsFORMSetDouble(o,id,val)            rdsSetObjectDouble((o),(id),RDS_FORMVAL_VALUE,(val))
  // Получить у формы число double (для объекта rdsFORMCreate)
  #define rdsFORMGetDouble(o,id)                rdsGetObjectDouble((o),(id),RDS_FORMVAL_VALUE)
  // Передать форме BOOL (для объекта rdsFORMCreate)
  #define rdsFORMSetBool(o,id,val)              rdsSetObjectInt((o),(id),RDS_FORMVAL_VALUE,(val)?1:0)
  // Получить у формы BOOL (для объекта rdsFORMCreate)
  #define rdsFORMGetBool(o,id)                  (rdsGetObjectInt((o),(id),RDS_FORMVAL_VALUE)!=0)
  // Установить список вариантов для поля ввода (для объекта rdsFORMCreate)
  #define rdsFORMSetComboListA(o,id,list)       rdsSetObjectStrA((o),(id),RDS_FORMVAL_LIST,(list))
  #define rdsFORMSetComboListW(o,id,list)       rdsSetObjectStrW((o),(id),RDS_FORMVAL_LIST,(list))
  // Установить дополнительный флаг разрешения поля ввода (для объекта rdsFORMCreate)
  #define rdsFORMSetEnableCheck(o,id,enabled)   rdsSetObjectInt((o),(id),RDS_FORMVAL_CHECK,(enabled)?1:0)
  // Получить дополнительный флаг разрешения поля ввода (для объекта rdsFORMCreate)
  #define rdsFORMGetEnableCheck(o,id)           (rdsGetObjectInt((o),(id),RDS_FORMVAL_CHECK)!=0)
  // Разрешить/запретить весь орган управления
  #define rdsFORMEnableControl(o,id,enabled)    rdsSetObjectInt((o),(id),RDS_FORMVAL_ENABLED,(enabled)?1:0)
  // Установить высоту для многострочного поля ввода (для объекта rdsFORMCreate)
  #define rdsFORMSetMultilineHeight(o,id,height)   rdsSetObjectInt((o),(id),RDS_FORMVAL_MLHEIGHT,(height))
  // Очистить форму (для объекта rdsFORMCreate)
  #define rdsFORMClear(o)                       rdsCommandObject((o),RDS_FORM_CLEAR)
  // Показать форму (для объекта rdsFORMCreate)
  #define rdsFORMShowModal(o)                   rdsCommandObject((o),RDS_FORM_SHOWMODAL)
  // Показать или убрать ProgressBar (для объекта rdsPBARCreate)
  #define rdsPBARShow(o,show)                   rdsCommandObject((o),(show)?RDS_PBAR_SHOW:RDS_PBAR_HIDE)
  // Установить текущее значение ProgressBar (для объекта rdsPBARCreate)
  #define rdsPBARSetPos(o,pos)                  rdsSetObjectInt((o),RDS_PBAR_POSITION,0,(pos))
  // Изменить текущее значение ProgressBar (для объекта rdsPBARCreate)
  #define rdsPBARIncrement(o,inc)               rdsSetObjectInt((o),RDS_PBAR_ADDTOPOS,0,(inc))
  //  Записать новые параметры блока в undo (для объекта rdsBEUCreate)
  #define rdsBEUStore(o)                        rdsCommandObject((o),RDS_BEU_STORECHANGED)
  // Вырезать часть матрицы
  #define rdsVarArrayCut(DestBaseAddr,SrcBaseAddr,r1,r2,c1,c2,sizes) rdsVarArrayOp((DestBaseAddr),(SrcBaseAddr),(sizes)?RDS_ARROP_CUTCNT:RDS_ARROP_CUT,(r1),(r2),(c1),(c2))
  // Удалить строки
  #define rdsVarArrayDelRows(DestBaseAddr,SrcBaseAddr,r1,r2,sizes) rdsVarArrayOp((DestBaseAddr),(SrcBaseAddr),(sizes)?RDS_ARROP_DELROWSCNT:RDS_ARROP_DELROWS,(r1),(r2),0,0)
  // Удалить столбцы
  #define rdsVarArrayDelCols(DestBaseAddr,SrcBaseAddr,c1,c2,sizes) rdsVarArrayOp((DestBaseAddr),(SrcBaseAddr),(sizes)?RDS_ARROP_DELCOLSCNT:RDS_ARROP_DELCOLS,0,0,(c1),(c2))
  // Вставить строки
  #define rdsVarArrayInsRows(DestBaseAddr,SrcBaseAddr,r1,r2,sizes) rdsVarArrayOp((DestBaseAddr),(SrcBaseAddr),(sizes)?RDS_ARROP_INSROWSCNT:RDS_ARROP_INSROWS,(r1),(r2),0,0)
  // Вставить столбцы
  #define rdsVarArrayInsCols(DestBaseAddr,SrcBaseAddr,c1,c2,sizes) rdsVarArrayOp((DestBaseAddr),(SrcBaseAddr),(sizes)?RDS_ARROP_INSCOLSCNT:RDS_ARROP_INSCOLS,0,0,(c1),(c2))
  // Транспонировать
  #define rdsVarArrayTransp(DestBaseAddr,SrcBaseAddr) rdsVarArrayOp((DestBaseAddr),(SrcBaseAddr),RDS_ARROP_TRANSP,0,0,0,0)

  // Псевдонимы
  #ifndef RDS_NO_UTFALIASES
    #define rdsVSSetStructName(o,name)    rdsSetObjectStr((o),RDS_HVAR_SETTYPENAME,0,(name))
    #define rdsVSGetStructName(o)         rdsGetObjectStr((o),RDS_HVAR_GETTYPENAME,0)
    #define rdsVSGetAutoMain(o,n)         rdsGetObjectStr((o),RDS_HVAR_GETAUTOMAIN,(n))
    #define rdsVSGetAutoConn(o,n)         rdsGetObjectStr((o),RDS_HVAR_GETAUTOCONN,(n))
    #define rdsSTRSetTextToRead(obj,text) rdsSetObjectStr((obj),RDS_HSTR_SETTEXT,0,(text))
    #define rdsINISetText(obj,text)       rdsSetObjectStr((obj),RDS_HINI_SETTEXT,0,(text))
    #define rdsINILoadFile(obj,filename)  rdsSetObjectStr((obj),RDS_HINI_LOADFILE,0,(filename))
    #define rdsINISaveFile(obj,filename)  rdsSetObjectStr((obj),RDS_HINI_SAVEFILE,0,(filename))
    #define rdsINIDeleteSection(obj,section)     rdsSetObjectStr((obj),RDS_HINI_DELETESECTION,0,(section))
    #define rdsINIWriteBool(obj,key,val)  rdsINIWriteInt((obj),(key),(val)?1:0)
    #define rdsINIReadBool(obj,key,defval)        (rdsINIReadInt((obj),(key),(defval)?1:0)!=0)
    #define rdsINIDeleteValue(obj,key)            rdsSetObjectStr((obj),RDS_HINI_DELETEKEYLAST,0,(key))
    #define rdsFORMSetString(o,id,str)            rdsSetObjectStr((o),(id),RDS_FORMVAL_VALUE,(str))
    #define rdsFORMGetString(o,id)                rdsGetObjectStr((o),(id),RDS_FORMVAL_VALUE)
    #define rdsFORMSetComboList(o,id,list)        rdsSetObjectStr((o),(id),RDS_FORMVAL_LIST,(list))
    #define rdsINICreateSection(obj,section)     rdsSetObjectStr((obj),RDS_HINI_CREATESECTION,0,(section))
  #endif
#endif
//===================================================================================

// Если определена константа RDS_UTF16DEFAULT, то для пары структур или функций
// nameA и nameW вводится "#define name nameW". В противном случае - "#define name nameA"
// (т.е. как в версиях RDS 1.x)

// Global function aliases - autogenerated (begin)
#if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
  #define rdsGetSystemPath rdsGetSystemPathA
  #define rdsRemoteControllerCall rdsRemoteControllerCallA
  #define rdsRemoteReply rdsRemoteReplyA
  #define rdsReportTextLoadError rdsReportTextLoadErrorA
  #define rdsSetHintText rdsSetHintTextA
  #define rdsGetRemoteControllerName rdsGetRemoteControllerNameA
  #define rdsWriteBlockDataText rdsWriteBlockDataTextA
  #define rdsSetDebugText rdsSetDebugTextA
  #define rdsXGSetFont rdsXGSetFontA
  #define rdsWriteFontText rdsWriteFontTextA
  #define rdsXGSetLogFont rdsXGSetLogFontA
  #define rdsXGGetTextSize rdsXGGetTextSizeA
  #define rdsXGTextOut rdsXGTextOutA
  #define rdsXGTextRect rdsXGTextRectA
  #define rdsGetTextWord rdsGetTextWordA
  #define rdsWriteWordValueText rdsWriteWordValueTextA
  #define rdsWriteColorText rdsWriteColorTextA
  #define rdsReadFontText rdsReadFontTextA
  #define rdsWriteWordStringText rdsWriteWordStringTextA
  #define rdsGetConnStyleAppearance rdsGetConnStyleAppearanceA
  #define rdsCreateDynamicVar rdsCreateDynamicVarA
  #define rdsCreateAndSubscribeDV rdsCreateAndSubscribeDVA
  #define rdsDeleteDynamicVar rdsDeleteDynamicVarA
  #define rdsSubscribeToDynamicVar rdsSubscribeToDynamicVarA
  #define rdsGetChildBlockByName rdsGetChildBlockByNameA
  #define rdsGetIOBlockByVarName rdsGetIOBlockByVarNameA
  #define rdsSetBlockComment rdsSetBlockCommentA
  #define rdsGetLayerConfigName rdsGetLayerConfigNameA
  #define rdsGetLayerName rdsGetLayerNameA
  #define rdsSetCurLayerConfigByName rdsSetCurLayerConfigByNameA
  #define rdsRegisterFunction rdsRegisterFunctionA
  #define rdsGetCmdParam rdsGetCmdParamA
  #define rdsFindCmdParam rdsFindCmdParamA
  #define rdsRegisterMenuItem rdsRegisterMenuItemA
  #define rdsCreateFullBlockNameString rdsCreateFullBlockNameStringA
  #define rdsBlockByFullName rdsBlockByFullNameA
  #define rdsCreateBlockFromFile rdsCreateBlockFromFileA
  #define rdsFindBlockVar rdsFindBlockVarA
  #define rdsCEAddBlockPoint rdsCEAddBlockPointA
  #define rdsCEAddBusPoint rdsCEAddBusPointA
  #define rdsdebugBlockInfo rdsdebugBlockInfoA
  #define rdscompSetModelFunction rdscompSetModelFunctionA
  #define rdsVSAddVar rdsVSAddVarA
  #define rdsSetObjectStr rdsSetObjectStrA
  #define rdsVSAddAutoConn rdsVSAddAutoConnA
  #define rdsFindStructVar rdsFindStructVarA
  #define rdsVSExecuteEditor rdsVSExecuteEditorA
  #define rdsGetObjectStr rdsGetObjectStrA
  #define rdsCreateVarDescriptionString rdsCreateVarDescriptionStringA
  #define rdsVSAddVarByDescr rdsVSAddVarByDescrA
  #define rdsVSCreateByDescr rdsVSCreateByDescrA
  #define rdsVSAddTypeRename rdsVSAddTypeRenameA
  #define rdsRegisterWindow rdsRegisterWindowA
  #define rdsVSFindAutoConn rdsVSFindAutoConnA
  #define rdsVSAddVarRename rdsVSAddVarRenameA
  #define rdsVSUsesStructType rdsVSUsesStructTypeA
  #define rdsVarUsesStructType rdsVarUsesStructTypeA
  #define rdscompRenameModel rdscompRenameModelA
  #define rdscompGetModelDataByName rdscompGetModelDataByNameA
  #define rdscompReturnModelName rdscompReturnModelNameA
  #define rdsGetFullFilePath rdsGetFullFilePathA
  #define rdsGetRelFilePath rdsGetRelFilePathA
  #define rdsChangeRegWinTitle rdsChangeRegWinTitleA
  #define rdsBCLExecuteGroupSetDialog rdsBCLExecuteGroupSetDialogA
  #define rdsMessageBox rdsMessageBoxA
  #define rdscompReturnModelNameLabel rdscompReturnModelNameLabelA
  #define rdscompSetAltModelName rdscompSetAltModelNameA
  #define rdsSTRAddKeyword rdsSTRAddKeywordA
  #define rdsSTRAddKeywordsArray rdsSTRAddKeywordsArrayA
  #define rdsSTRGetWord rdsSTRGetWordA
  #define rdsWriteWordDoubleText rdsWriteWordDoubleTextA
  #define rdsSetBlockVarDefValueStr rdsSetBlockVarDefValueStrA
  #define rdsGetBlockVarDefValueStr rdsGetBlockVarDefValueStrA
  #define rdsRenameBlock rdsRenameBlockA
  #define rdsVSGetVarDefValueStr rdsVSGetVarDefValueStrA
  #define rdsChangeMenuItem rdsChangeMenuItemA
  #define rdsINIOpenSection rdsINIOpenSectionA
  #define rdsINIWriteInt rdsINIWriteIntA
  #define rdsINIReadInt rdsINIReadIntA
  #define rdsINIWriteDouble rdsINIWriteDoubleA
  #define rdsINIReadDouble rdsINIReadDoubleA
  #define rdsINIWriteString rdsINIWriteStringA
  #define rdsINIReadString rdsINIReadStringA
  #define rdscompAttachDifferentModel rdscompAttachDifferentModelA
  #define rdscompSetBlockModel rdscompSetBlockModelA
  #define rdsFORMCreate rdsFORMCreateA
  #define rdsFORMAddTab rdsFORMAddTabA
  #define rdsFORMAddEdit rdsFORMAddEditA
  #define rdsProcessText rdsProcessTextA
  #define rdsSetBlockSetupFuncName rdsSetBlockSetupFuncNameA
  #define rdsDynStrCat rdsDynStrCatA
  #define rdsIsValidVarName rdsIsValidVarNameA
  #define rdsShowBlockPanelTab rdsShowBlockPanelTabA
  #define rdsSetBlockAltNameText rdsSetBlockAltNameTextA
  #define rdsExecuteCommand rdsExecuteCommandA
  #define rdsRegisterContextMenuItem rdsRegisterContextMenuItemA
  #define rdsSetSystemWindowCaption rdsSetSystemWindowCaptionA
  #define rdsPBARCreate rdsPBARCreateA
  #define rdsInputString rdsInputStringA
  #define rdsGetRemoteControllerString rdsGetRemoteControllerStringA
  #define rdsGetRuntimeTypeData rdsGetRuntimeTypeDataA
  #define rdsAdditionalContextMenuItem rdsAdditionalContextMenuItemA
  #define rdsSetRuntimeType rdsSetRuntimeTypeA
  #define rdsGetLayerId rdsGetLayerIdA
  #define rdsAddLayer rdsAddLayerA
  #define rdsdebugLogString rdsdebugLogStringA
  #define rdsINIReadDoubleP rdsINIReadDoublePA
  #define rdsNetServer rdsNetServerA
  #define rdsNetConnect rdsNetConnectA
  #define rdsNetBroadcastData rdsNetBroadcastDataA
  #define rdsNetSendData rdsNetSendDataA
  #define rdsBlockMessageBox rdsBlockMessageBoxA
  #define rdsListVarTypes rdsListVarTypesA
  #define rdsCreateVarTypeText rdsCreateVarTypeTextA
  #define rdsVSAddVarByTypeText rdsVSAddVarByTypeTextA
  #define rdsAtoI rdsAtoIA
  #define rdsItoA rdsItoAA
  #define rdsAtoD rdsAtoDA
  #define rdsDtoA rdsDtoAA
  #define rdsSetBlockModel rdsSetBlockModelA
  #define rdsVarArrayIndexCheck rdsVarArrayIndexCheckA
  #define rdsExecutesRemoteOpsSet rdsExecutesRemoteOpsSetA
  #define rdsPANCreate rdsPANCreateA
  #define rdsGetEditorFont rdsGetEditorFontA
  #define rdsXGSetFontByParStr rdsXGSetFontByParStrA
  #define rdsStructToFontText rdsStructToFontTextA
  #define rdsAddToDynStr rdsAddToDynStrA
  #define rdsRegisterContextMenuItemEx rdsRegisterContextMenuItemExA
  #define rdsAdditionalContextMenuItemEx rdsAdditionalContextMenuItemExA
  #define rdsMakeUniqueBlockName rdsMakeUniqueBlockNameA
  #define rdsCSVSetItem rdsCSVSetItemA
  #define rdsCSVGetItem rdsCSVGetItemA
  #define rdsStringReplace rdsStringReplaceA
  #define rdsDynStrCopy rdsDynStrCopyA
  #define rdsCallFileDialog rdsCallFileDialogA
  #define rdsCallDirDialog rdsCallDirDialogA
  #define rdsTransformFileName rdsTransformFileNameA
  #define rdsTMPCreateEmptyFile rdsTMPCreateEmptyFileA
  #define rdsTMPDeleteFile rdsTMPDeleteFileA
  #define rdsTMPRememberFileName rdsTMPRememberFileNameA
  #define rdsGetTextWordDyn rdsGetTextWordDynA
  #define rdsCEAddChannel rdsCEAddChannelA
  #define rdsReportToolInfo rdsReportToolInfoA
  #define rdsExecTool rdsExecToolA
  #define rdsSaveSystemBitmap rdsSaveSystemBitmapA
  #define rdsGetBlockVarTypeString rdsGetBlockVarTypeStringA
  #define rdsShowHelp rdsShowHelpA
  #define rdsShowHelpFile rdsShowHelpFileA
  #define rdsRegisterConnExtParamName rdsRegisterConnExtParamNameA
  #define rdsGetConnExtParamByNum rdsGetConnExtParamByNumA
  #define rdsGetConnExtParamById rdsGetConnExtParamByIdA
  #define rdsSetConnExtParamById rdsSetConnExtParamByIdA
  #define rdsConnSetupMenuName rdsConnSetupMenuNameA
  #define rdsEnumDynVars rdsEnumDynVarsA
  #define rdsGetConnExtParamByNumEx rdsGetConnExtParamByNumExA
  #define rdsGetConnExtParamByIdEx rdsGetConnExtParamByIdExA
  #define rdsSetConnExtParamByIdEx rdsSetConnExtParamByIdExA
  #define rdsSetObjectPtr rdsSetObjectPtrA
  #define rdsGetObjectPtr rdsGetObjectPtrA
  #define rdsTMPForgetFileName rdsTMPForgetFileNameA
  #define rdsExclusiveFileOp rdsExclusiveFileOpA
  #define rdsInfoMessage rdsInfoMessageA
  #define rdsVSCreateAutoConnsByDescr rdsVSCreateAutoConnsByDescrA
  #define rdsStoreTempGlobal rdsStoreTempGlobalA
  #define rdsReadTempGlobal rdsReadTempGlobalA
  #define rdsExecToolExt rdsExecToolExtA
  #define rdsFORMHelpButton rdsFORMHelpButtonA
  #define rdsRegisterUserNameSet rdsRegisterUserNameSetA
  #define rdsRegisterUserName rdsRegisterUserNameA
  #define rdsGetRegisteredUserName rdsGetRegisteredUserNameA
  #define rdsRegisterGlobalIntVar rdsRegisterGlobalIntVarA
  #define rdsShiftBakFileChain rdsShiftBakFileChainA
  #define rdsSetBlockTextRectParams rdsSetBlockTextRectParamsA
  #define rdsExecToolDelayed rdsExecToolDelayedA
  #define rdsGBLCreate rdsGBLCreateA
  #define rdsSaveBlockToFile rdsSaveBlockToFileA
  #define rdsSetConnText rdsSetConnTextA
  #define rdsFileExists rdsFileExistsA
  #define rdsCreateSharedMemPlain rdsCreateSharedMemPlainA
  #define rdsCreateSharedMemVar rdsCreateSharedMemVarA
  #define rdsTranslateParameter rdsTranslateParameterA
  #define rdsTranslateText rdsTranslateTextA
  #define rdsSetConnTextEx rdsSetConnTextExA
  #define rdsFORMTBLSetStr rdsFORMTBLSetStrA
  #define rdsFORMTBLGetStr rdsFORMTBLGetStrA
  #define rdsFORMTBLSetHeader rdsFORMTBLSetHeaderA
  #define rdsCreateSystem rdsCreateSystemA
  #define rdsNetListServerChannels rdsNetListServerChannelsA
  #define rdsNetListChannels rdsNetListChannelsA
  #define rdsCreateBlock rdsCreateBlockA
  #define rdsCESetBlockPoint rdsCESetBlockPointA
  #define rdsCESetBusPoint rdsCESetBusPointA
  #define rdsBusChannelNameByNum rdsBusChannelNameByNumA
  #define rdsGetBusChannelParams rdsGetBusChannelParamsA
  #define rdsEnumExternalDynVars rdsEnumExternalDynVarsA
  #define rdsEnumDynVarsEx rdsEnumDynVarsExA
  #define rdsEnumExternalDynVarsEx rdsEnumExternalDynVarsExA
  #define rdsGetVarParams rdsGetVarParamsA
  #define rdsVarTypeTextByParams rdsVarTypeTextByParamsA
  #define rdsVarParamsByTypeText rdsVarParamsByTypeTextA
  #define rdsFORMTBLSetColTextList rdsFORMTBLSetColTextListA
  #define rdsFORMTBLSetColDefValue rdsFORMTBLSetColDefValueA
  #define rdsCWCreate rdsCWCreateA
  #define rdsCWCreateCopy rdsCWCreateCopyA
  #define rdsForceDirectories rdsForceDirectoriesA
  #define rdsGetUICurrentMod rdsGetUICurrentModA
  #define rdsUIMODLoadGroup rdsUIMODLoadGroupA
  #define rdsUIMODGetParamString rdsUIMODGetParamStringA
  #define rdsUIMODGetParamStrByNum rdsUIMODGetParamStrByNumA
  #define rdsGetUIModsList rdsGetUIModsListA
  #define rdsUIMODGetParamStrByName rdsUIMODGetParamStrByNameA
  #define rdsUIMODSetParamStrByName rdsUIMODSetParamStrByNameA
  #define rdsBMPCreate rdsBMPCreateA
  #define rdsUIMODLoadSingleObject rdsUIMODLoadSingleObjectA
  #define rdsUIMODGetParamListString rdsUIMODGetParamListStringA
  #define rdsVSCreateFromConn rdsVSCreateFromConnA
  #define rdsSGPRegisterName rdsSGPRegisterNameA
  #define rdsSGPSetData rdsSGPSetDataA
  #define rdsSGPGetData rdsSGPGetDataA
  #define rdsAtoDw rdsAtoDwA
  #define rdsDwtoA rdsDwtoAA
  #define rdsRegisterFuncCallMenuItem rdsRegisterFuncCallMenuItemA
  #define rdsChangeFuncCallMenuItem rdsChangeFuncCallMenuItemA
  #define rdsGetObjectClassName rdsGetObjectClassNameA
  #define rdsShowSeeAlsoExamples rdsShowSeeAlsoExamplesA
  #define rdsFORMMakeSearch rdsFORMMakeSearchA
  #define rdsFORMAddSearchResult rdsFORMAddSearchResultA
  #define rdsFORMGetSearchResult rdsFORMGetSearchResultA
  #define rdsBMPCreateEx rdsBMPCreateExA
  #define rdsVSExecuteEditorEx rdsVSExecuteEditorExA
  #define rdsVSGetVarParams rdsVSGetVarParamsA
  #define rdsCreateVarTypeString rdsCreateVarTypeStringA
  #define rdsFindBlockVarIndex rdsFindBlockVarIndexA
  #define rdsMatchesMask rdsMatchesMaskA
  #define rdsIsValidVarNameRem rdsIsValidVarNameRemA
  #define rdsConsoleWindowOp rdsConsoleWindowOpA
  #define rdsVNCreateNameValidator rdsVNCreateNameValidatorA
  #define rdsVNCheck rdsVNCheckA
  #define rdsVNValidate rdsVNValidateA
  #define rdsGetObjectPtrCheck rdsGetObjectPtrCheckA
  #define rdsSaveWindowConfig rdsSaveWindowConfigA
  #define rdsFORMSetMainButtons rdsFORMSetMainButtonsA
  #define rdscompLinkAvailableModule rdscompLinkAvailableModuleA
  #define rdscompSetModelFunctionEx rdscompSetModelFunctionExA
  #define rdsGetEnvironmentVariable rdsGetEnvironmentVariableA
  #define rdsSetEnvironmentVariable rdsSetEnvironmentVariableA
  #define rdscompTestCompile rdscompTestCompileA
  #define rdscompTestCompReturnString rdscompTestCompReturnStringA
  #define rdsStrLen rdsStrLenA
  #define rdsTMPCreateEmptyFileAnyExt rdsTMPCreateEmptyFileAnyExtA
  #define rdsSetBlockModelKeepData rdsSetBlockModelKeepDataA
#endif // #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
#if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
  #define rdsGetSystemPath rdsGetSystemPathW
  #define rdsRemoteControllerCall rdsRemoteControllerCallW
  #define rdsRemoteReply rdsRemoteReplyW
  #define rdsReportTextLoadError rdsReportTextLoadErrorW
  #define rdsSetHintText rdsSetHintTextW
  #define rdsGetRemoteControllerName rdsGetRemoteControllerNameW
  #define rdsWriteBlockDataText rdsWriteBlockDataTextW
  #define rdsSetDebugText rdsSetDebugTextW
  #define rdsXGSetFont rdsXGSetFontW
  #define rdsWriteFontText rdsWriteFontTextW
  #define rdsXGSetLogFont rdsXGSetLogFontW
  #define rdsXGGetTextSize rdsXGGetTextSizeW
  #define rdsXGTextOut rdsXGTextOutW
  #define rdsXGTextRect rdsXGTextRectW
  #define rdsGetTextWord rdsGetTextWordW
  #define rdsWriteWordValueText rdsWriteWordValueTextW
  #define rdsWriteColorText rdsWriteColorTextW
  #define rdsReadFontText rdsReadFontTextW
  #define rdsWriteWordStringText rdsWriteWordStringTextW
  #define rdsGetConnStyleAppearance rdsGetConnStyleAppearanceW
  #define rdsCreateDynamicVar rdsCreateDynamicVarW
  #define rdsCreateAndSubscribeDV rdsCreateAndSubscribeDVW
  #define rdsDeleteDynamicVar rdsDeleteDynamicVarW
  #define rdsSubscribeToDynamicVar rdsSubscribeToDynamicVarW
  #define rdsGetChildBlockByName rdsGetChildBlockByNameW
  #define rdsGetIOBlockByVarName rdsGetIOBlockByVarNameW
  #define rdsSetBlockComment rdsSetBlockCommentW
  #define rdsGetLayerConfigName rdsGetLayerConfigNameW
  #define rdsGetLayerName rdsGetLayerNameW
  #define rdsSetCurLayerConfigByName rdsSetCurLayerConfigByNameW
  #define rdsRegisterFunction rdsRegisterFunctionW
  #define rdsGetCmdParam rdsGetCmdParamW
  #define rdsFindCmdParam rdsFindCmdParamW
  #define rdsRegisterMenuItem rdsRegisterMenuItemW
  #define rdsCreateFullBlockNameString rdsCreateFullBlockNameStringW
  #define rdsBlockByFullName rdsBlockByFullNameW
  #define rdsCreateBlockFromFile rdsCreateBlockFromFileW
  #define rdsFindBlockVar rdsFindBlockVarW
  #define rdsCEAddBlockPoint rdsCEAddBlockPointW
  #define rdsCEAddBusPoint rdsCEAddBusPointW
  #define rdsdebugBlockInfo rdsdebugBlockInfoW
  #define rdscompSetModelFunction rdscompSetModelFunctionW
  #define rdsVSAddVar rdsVSAddVarW
  #define rdsSetObjectStr rdsSetObjectStrW
  #define rdsVSAddAutoConn rdsVSAddAutoConnW
  #define rdsFindStructVar rdsFindStructVarW
  #define rdsVSExecuteEditor rdsVSExecuteEditorW
  #define rdsGetObjectStr rdsGetObjectStrW
  #define rdsCreateVarDescriptionString rdsCreateVarDescriptionStringW
  #define rdsVSAddVarByDescr rdsVSAddVarByDescrW
  #define rdsVSCreateByDescr rdsVSCreateByDescrW
  #define rdsVSAddTypeRename rdsVSAddTypeRenameW
  #define rdsRegisterWindow rdsRegisterWindowW
  #define rdsVSFindAutoConn rdsVSFindAutoConnW
  #define rdsVSAddVarRename rdsVSAddVarRenameW
  #define rdsVSUsesStructType rdsVSUsesStructTypeW
  #define rdsVarUsesStructType rdsVarUsesStructTypeW
  #define rdscompRenameModel rdscompRenameModelW
  #define rdscompGetModelDataByName rdscompGetModelDataByNameW
  #define rdscompReturnModelName rdscompReturnModelNameW
  #define rdsGetFullFilePath rdsGetFullFilePathW
  #define rdsGetRelFilePath rdsGetRelFilePathW
  #define rdsChangeRegWinTitle rdsChangeRegWinTitleW
  #define rdsBCLExecuteGroupSetDialog rdsBCLExecuteGroupSetDialogW
  #define rdsMessageBox rdsMessageBoxW
  #define rdscompReturnModelNameLabel rdscompReturnModelNameLabelW
  #define rdscompSetAltModelName rdscompSetAltModelNameW
  #define rdsSTRAddKeyword rdsSTRAddKeywordW
  #define rdsSTRAddKeywordsArray rdsSTRAddKeywordsArrayW
  #define rdsSTRGetWord rdsSTRGetWordW
  #define rdsWriteWordDoubleText rdsWriteWordDoubleTextW
  #define rdsSetBlockVarDefValueStr rdsSetBlockVarDefValueStrW
  #define rdsGetBlockVarDefValueStr rdsGetBlockVarDefValueStrW
  #define rdsRenameBlock rdsRenameBlockW
  #define rdsVSGetVarDefValueStr rdsVSGetVarDefValueStrW
  #define rdsChangeMenuItem rdsChangeMenuItemW
  #define rdsINIOpenSection rdsINIOpenSectionW
  #define rdsINIWriteInt rdsINIWriteIntW
  #define rdsINIReadInt rdsINIReadIntW
  #define rdsINIWriteDouble rdsINIWriteDoubleW
  #define rdsINIReadDouble rdsINIReadDoubleW
  #define rdsINIWriteString rdsINIWriteStringW
  #define rdsINIReadString rdsINIReadStringW
  #define rdscompAttachDifferentModel rdscompAttachDifferentModelW
  #define rdscompSetBlockModel rdscompSetBlockModelW
  #define rdsFORMCreate rdsFORMCreateW
  #define rdsFORMAddTab rdsFORMAddTabW
  #define rdsFORMAddEdit rdsFORMAddEditW
  #define rdsProcessText rdsProcessTextW
  #define rdsSetBlockSetupFuncName rdsSetBlockSetupFuncNameW
  #define rdsDynStrCat rdsDynStrCatW
  #define rdsIsValidVarName rdsIsValidVarNameW
  #define rdsShowBlockPanelTab rdsShowBlockPanelTabW
  #define rdsSetBlockAltNameText rdsSetBlockAltNameTextW
  #define rdsExecuteCommand rdsExecuteCommandW
  #define rdsRegisterContextMenuItem rdsRegisterContextMenuItemW
  #define rdsSetSystemWindowCaption rdsSetSystemWindowCaptionW
  #define rdsPBARCreate rdsPBARCreateW
  #define rdsInputString rdsInputStringW
  #define rdsGetRemoteControllerString rdsGetRemoteControllerStringW
  #define rdsGetRuntimeTypeData rdsGetRuntimeTypeDataW
  #define rdsAdditionalContextMenuItem rdsAdditionalContextMenuItemW
  #define rdsSetRuntimeType rdsSetRuntimeTypeW
  #define rdsGetLayerId rdsGetLayerIdW
  #define rdsAddLayer rdsAddLayerW
  #define rdsdebugLogString rdsdebugLogStringW
  #define rdsINIReadDoubleP rdsINIReadDoublePW
  #define rdsNetServer rdsNetServerW
  #define rdsNetConnect rdsNetConnectW
  #define rdsNetBroadcastData rdsNetBroadcastDataW
  #define rdsNetSendData rdsNetSendDataW
  #define rdsBlockMessageBox rdsBlockMessageBoxW
  #define rdsListVarTypes rdsListVarTypesW
  #define rdsCreateVarTypeText rdsCreateVarTypeTextW
  #define rdsVSAddVarByTypeText rdsVSAddVarByTypeTextW
  #define rdsAtoI rdsAtoIW
  #define rdsItoA rdsItoAW
  #define rdsAtoD rdsAtoDW
  #define rdsDtoA rdsDtoAW
  #define rdsSetBlockModel rdsSetBlockModelW
  #define rdsVarArrayIndexCheck rdsVarArrayIndexCheckW
  #define rdsExecutesRemoteOpsSet rdsExecutesRemoteOpsSetW
  #define rdsPANCreate rdsPANCreateW
  #define rdsGetEditorFont rdsGetEditorFontW
  #define rdsXGSetFontByParStr rdsXGSetFontByParStrW
  #define rdsStructToFontText rdsStructToFontTextW
  #define rdsAddToDynStr rdsAddToDynStrW
  #define rdsRegisterContextMenuItemEx rdsRegisterContextMenuItemExW
  #define rdsAdditionalContextMenuItemEx rdsAdditionalContextMenuItemExW
  #define rdsMakeUniqueBlockName rdsMakeUniqueBlockNameW
  #define rdsCSVSetItem rdsCSVSetItemW
  #define rdsCSVGetItem rdsCSVGetItemW
  #define rdsStringReplace rdsStringReplaceW
  #define rdsDynStrCopy rdsDynStrCopyW
  #define rdsCallFileDialog rdsCallFileDialogW
  #define rdsCallDirDialog rdsCallDirDialogW
  #define rdsTransformFileName rdsTransformFileNameW
  #define rdsTMPCreateEmptyFile rdsTMPCreateEmptyFileW
  #define rdsTMPDeleteFile rdsTMPDeleteFileW
  #define rdsTMPRememberFileName rdsTMPRememberFileNameW
  #define rdsGetTextWordDyn rdsGetTextWordDynW
  #define rdsCEAddChannel rdsCEAddChannelW
  #define rdsReportToolInfo rdsReportToolInfoW
  #define rdsExecTool rdsExecToolW
  #define rdsSaveSystemBitmap rdsSaveSystemBitmapW
  #define rdsGetBlockVarTypeString rdsGetBlockVarTypeStringW
  #define rdsShowHelp rdsShowHelpW
  #define rdsShowHelpFile rdsShowHelpFileW
  #define rdsRegisterConnExtParamName rdsRegisterConnExtParamNameW
  #define rdsGetConnExtParamByNum rdsGetConnExtParamByNumW
  #define rdsGetConnExtParamById rdsGetConnExtParamByIdW
  #define rdsSetConnExtParamById rdsSetConnExtParamByIdW
  #define rdsConnSetupMenuName rdsConnSetupMenuNameW
  #define rdsEnumDynVars rdsEnumDynVarsW
  #define rdsGetConnExtParamByNumEx rdsGetConnExtParamByNumExW
  #define rdsGetConnExtParamByIdEx rdsGetConnExtParamByIdExW
  #define rdsSetConnExtParamByIdEx rdsSetConnExtParamByIdExW
  #define rdsSetObjectPtr rdsSetObjectPtrW
  #define rdsGetObjectPtr rdsGetObjectPtrW
  #define rdsTMPForgetFileName rdsTMPForgetFileNameW
  #define rdsExclusiveFileOp rdsExclusiveFileOpW
  #define rdsInfoMessage rdsInfoMessageW
  #define rdsVSCreateAutoConnsByDescr rdsVSCreateAutoConnsByDescrW
  #define rdsStoreTempGlobal rdsStoreTempGlobalW
  #define rdsReadTempGlobal rdsReadTempGlobalW
  #define rdsExecToolExt rdsExecToolExtW
  #define rdsFORMHelpButton rdsFORMHelpButtonW
  #define rdsRegisterUserNameSet rdsRegisterUserNameSetW
  #define rdsRegisterUserName rdsRegisterUserNameW
  #define rdsGetRegisteredUserName rdsGetRegisteredUserNameW
  #define rdsRegisterGlobalIntVar rdsRegisterGlobalIntVarW
  #define rdsShiftBakFileChain rdsShiftBakFileChainW
  #define rdsSetBlockTextRectParams rdsSetBlockTextRectParamsW
  #define rdsExecToolDelayed rdsExecToolDelayedW
  #define rdsGBLCreate rdsGBLCreateW
  #define rdsSaveBlockToFile rdsSaveBlockToFileW
  #define rdsSetConnText rdsSetConnTextW
  #define rdsFileExists rdsFileExistsW
  #define rdsCreateSharedMemPlain rdsCreateSharedMemPlainW
  #define rdsCreateSharedMemVar rdsCreateSharedMemVarW
  #define rdsTranslateParameter rdsTranslateParameterW
  #define rdsTranslateText rdsTranslateTextW
  #define rdsSetConnTextEx rdsSetConnTextExW
  #define rdsFORMTBLSetStr rdsFORMTBLSetStrW
  #define rdsFORMTBLGetStr rdsFORMTBLGetStrW
  #define rdsFORMTBLSetHeader rdsFORMTBLSetHeaderW
  #define rdsCreateSystem rdsCreateSystemW
  #define rdsNetListServerChannels rdsNetListServerChannelsW
  #define rdsNetListChannels rdsNetListChannelsW
  #define rdsCreateBlock rdsCreateBlockW
  #define rdsCESetBlockPoint rdsCESetBlockPointW
  #define rdsCESetBusPoint rdsCESetBusPointW
  #define rdsBusChannelNameByNum rdsBusChannelNameByNumW
  #define rdsGetBusChannelParams rdsGetBusChannelParamsW
  #define rdsEnumExternalDynVars rdsEnumExternalDynVarsW
  #define rdsEnumDynVarsEx rdsEnumDynVarsExW
  #define rdsEnumExternalDynVarsEx rdsEnumExternalDynVarsExW
  #define rdsGetVarParams rdsGetVarParamsW
  #define rdsVarTypeTextByParams rdsVarTypeTextByParamsW
  #define rdsVarParamsByTypeText rdsVarParamsByTypeTextW
  #define rdsFORMTBLSetColTextList rdsFORMTBLSetColTextListW
  #define rdsFORMTBLSetColDefValue rdsFORMTBLSetColDefValueW
  #define rdsCWCreate rdsCWCreateW
  #define rdsCWCreateCopy rdsCWCreateCopyW
  #define rdsForceDirectories rdsForceDirectoriesW
  #define rdsGetUICurrentMod rdsGetUICurrentModW
  #define rdsUIMODLoadGroup rdsUIMODLoadGroupW
  #define rdsUIMODGetParamString rdsUIMODGetParamStringW
  #define rdsUIMODGetParamStrByNum rdsUIMODGetParamStrByNumW
  #define rdsGetUIModsList rdsGetUIModsListW
  #define rdsUIMODGetParamStrByName rdsUIMODGetParamStrByNameW
  #define rdsUIMODSetParamStrByName rdsUIMODSetParamStrByNameW
  #define rdsBMPCreate rdsBMPCreateW
  #define rdsUIMODLoadSingleObject rdsUIMODLoadSingleObjectW
  #define rdsUIMODGetParamListString rdsUIMODGetParamListStringW
  #define rdsVSCreateFromConn rdsVSCreateFromConnW
  #define rdsSGPRegisterName rdsSGPRegisterNameW
  #define rdsSGPSetData rdsSGPSetDataW
  #define rdsSGPGetData rdsSGPGetDataW
  #define rdsAtoDw rdsAtoDwW
  #define rdsDwtoA rdsDwtoAW
  #define rdsRegisterFuncCallMenuItem rdsRegisterFuncCallMenuItemW
  #define rdsChangeFuncCallMenuItem rdsChangeFuncCallMenuItemW
  #define rdsGetObjectClassName rdsGetObjectClassNameW
  #define rdsShowSeeAlsoExamples rdsShowSeeAlsoExamplesW
  #define rdsFORMMakeSearch rdsFORMMakeSearchW
  #define rdsFORMAddSearchResult rdsFORMAddSearchResultW
  #define rdsFORMGetSearchResult rdsFORMGetSearchResultW
  #define rdsBMPCreateEx rdsBMPCreateExW
  #define rdsVSExecuteEditorEx rdsVSExecuteEditorExW
  #define rdsVSGetVarParams rdsVSGetVarParamsW
  #define rdsCreateVarTypeString rdsCreateVarTypeStringW
  #define rdsFindBlockVarIndex rdsFindBlockVarIndexW
  #define rdsMatchesMask rdsMatchesMaskW
  #define rdsIsValidVarNameRem rdsIsValidVarNameRemW
  #define rdsConsoleWindowOp rdsConsoleWindowOpW
  #define rdsVNCreateNameValidator rdsVNCreateNameValidatorW
  #define rdsVNCheck rdsVNCheckW
  #define rdsVNValidate rdsVNValidateW
  #define rdsGetObjectPtrCheck rdsGetObjectPtrCheckW
  #define rdsSaveWindowConfig rdsSaveWindowConfigW
  #define rdsFORMSetMainButtons rdsFORMSetMainButtonsW
  #define rdscompLinkAvailableModule rdscompLinkAvailableModuleW
  #define rdscompSetModelFunctionEx rdscompSetModelFunctionExW
  #define rdsGetEnvironmentVariable rdsGetEnvironmentVariableW
  #define rdsSetEnvironmentVariable rdsSetEnvironmentVariableW
  #define rdscompTestCompile rdscompTestCompileW
  #define rdscompTestCompReturnString rdscompTestCompReturnStringW
  #define rdsStrLen rdsStrLenW
  #define rdsTMPCreateEmptyFileAnyExt rdsTMPCreateEmptyFileAnyExtW
  #define rdsSetBlockModelKeepData rdsSetBlockModelKeepDataW
#endif // #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
// Global function aliases - autogenerated (end)

#endif

