//---------------------------------------------------------------------------
// Описания, необходимые для моделей блоков RDS (версия 2.x)
//---------------------------------------------------------------------------
#ifndef RdsDefH
#define RdsDefH
// Описания Windows API должны быть включены ПЕРЕД этим файлом
//================ Описания, необходимые для совместимости ==================
#ifndef RDS_NO_PACK
  #include <pshpack1.h> // Установка плотной упаковки структур
#endif
#ifndef RDSCALL
  #define RDSCALL CALLBACK
#endif
#ifndef RDSINT32
  #define RDSINT32 int
#endif

// Преобразование аргумента в строковую константу
#define RDS__STR1(s) #s // Вспомогательный
#define RDS__STR2(s) RDS__STR1(s)
// Префикс "L" для строки
#define RDS__LPREFIX1(x) L##x
#define RDS__LPREFIX(x) RDS__LPREFIX1(x)

//===================================================================================
// Версия RDS, на которую рассчитаны эти описания. Может использоваться для сравнения
// с номером версии, полученным из RDS, и вывода сообщения об ошибке.
// Пример:
// if(rdsServiceVersion!=NULL && (rdsServiceVersion()<RDS_FVERSION))
//   { // Сообщение об ошибке: старая версия RDS
//     // ....
//   }
//===================================================================================
// Преобразование версии в RDSINT32
#define RDS_INTVERSION(high,low,build) (((high)<<24) | ((low)<<16) | (build))
// Преобразование даты версии в DWORD
#define RDS_DWORDVERDATE(y,mon,d,h,mnu,q) ( (((((y)-2000))&0x3ff)<<22)|(((mon)&0xf)<<18)|(((d)&0x1f)<<13)|(((h)&0x1f)<<8)|(((mnu)&0x3f)<<2)|((q)&3) )
#define RDS_DWORDVERDATESHORT(y,mon,d) ( (((((y)-2000))&0x3ff)<<22)|(((mon)&0xf)<<18)|(((d)&0x1f)<<13) )

#ifndef RDS_NOVERSIONDEFINES
  // Описания версии RDS
  #define RDS_FVERSIONHIGH      2
  #define RDS_FVERSIONLOW       0
  #define RDS_FVERSIONBUILD     20
  #define RDS_FVERSION          (RDS_INTVERSION(RDS_FVERSIONHIGH,RDS_FVERSIONLOW,RDS_FVERSIONBUILD))
  // Описания даты выпуска этой версии RDS
  #define RDS_FVERSIONYEAR      2025    // Год
  #define RDS_FVERSIONMONTH     11      // Месяц
  #define RDS_FVERSIONDAY       1       // День
  #define RDS_FVERSIONHOUR      0       // Час
  #define RDS_FVERSIONMIN       0       // Минута
  #define RDS_FVERSIONQUARTER   0       // Четверть минуты
  #define RDS_FVERSIONDATE      (RDS_DWORDVERDATE(RDS_FVERSIONYEAR,RDS_FVERSIONMONTH,RDS_FVERSIONDAY,RDS_FVERSIONHOUR,RDS_FVERSIONMIN,RDS_FVERSIONQUARTER))
  // Строка версии
  #define RDS_STRVERSIONA RDS__STR2(RDS_FVERSIONHIGH) "." RDS__STR2(RDS_FVERSIONLOW) "." RDS__STR2(RDS_FVERSIONBUILD)
  #define RDS_STRVERSIONW RDS__LPREFIX(RDS__STR2(RDS_FVERSIONHIGH)) L"." RDS__LPREFIX(RDS__STR2(RDS_FVERSIONLOW)) L"." RDS__LPREFIX(RDS__STR2(RDS_FVERSIONBUILD))
#endif
//===================================================================================

//===================================================================================
// Платформо-независимые описания
//===================================================================================
// Указатель NULL
#define RDS_NULLPTR ((char*)NULL)
// Параметр "строка" в сервисных функциях и структурах
// Строка UTF8 (в RDS) или ANSI (в WinAPI)
#define RDSSTR LPSTR
#define RDSVSTR LPSTR
#define RDSCSTR LPCSTR
typedef LPSTR *RDSSTRARRAY;
typedef LPCSTR *RDSCSTRARRAY;
// Строка UTF16 для WinAPI
#define RDSWSTR LPWSTR
#define RDSWVSTR LPWSTR
#define RDSWCSTR LPCWSTR
typedef LPWSTR *RDSWSTRARRAY;
typedef LPCWSTR *RDSCWSTRARRAY;
// Строка по умолчанию (в зависимости от макроопределения RDS_UTF16DEFAULT)
#ifdef RDS_UTF16DEFAULT
  #define RDSXSTR LPWSTR
  #define RDSXVSTR LPWSTR
  #define RDSXCSTR LPCWSTR
  #define RDSXCHAR WCHAR
  typedef LPWSTR *RDSXSTRARRAY;
  typedef LPCWSTR *RDSXCSTRARRAY;
#else
  #define RDSXSTR LPSTR
  #define RDSXVSTR LPSTR
  #define RDSXCSTR LPCSTR
  #define RDSXCHAR char
  typedef LPSTR *RDSXSTRARRAY;
  typedef LPCSTR *RDSXCSTRARRAY;
#endif
// Массив байтов
typedef BYTE *RDSBYTES;
#ifdef __cplusplus
  typedef const void *RDSPCVOID;
#else
  typedef void *RDSPCVOID;
#endif
typedef double *RDSPDOUBLE;
// Строка с префиксом или без в зависимости от кодировки по умолчанию
#ifdef RDS_UTF16DEFAULT
  #define RDS__TEXTPREFIX(x) L##x
#else
  #define RDS__TEXTPREFIX(x) x
#endif
#define RDS_T(x) RDS__TEXTPREFIX(x)
//===================================================================================

// Описания обеих платформ
#define RDS_WIN32_NAME  "Win32"
#define RDS_WIN32_ID    0
#define RDS_WIN64_NAME  "Win64"
#define RDS_WIN64_ID    1
// Число платформ (более понятная замена константы "2" в массивах, если они есть)
#define RDS_PLATFORMS_COUNT 2

//===================================================================================
// Платформо-зависимые описания
//===================================================================================
// Описания текущей платформы
#if (!defined(RDS_WIN64)) && (!defined(RDS_WIN32))
  // Платформа не задана явно - попытка определить самостоятельно
  #ifdef _WIN64
    #define RDS_WIN64
  #else
    #define RDS_WIN32
  #endif
#endif
#if defined(RDS_WIN64) && defined(RDS_WIN32)
  #error Both RDS_WIN64 and RDS_WIN32 defined
#endif
// Максимальный размер поля-указателя во всех возможных платформах (в байтах)
#define RDSBIGGESTPOINTERSIZE 8
#if defined(RDS_WIN32)
  // Описания для Win32
  #define RDSBIGGESTTYPE  double  // Самый большой "плоский" тип из используемых
  typedef short int RDS_SHORT;    // int16 одним словом (для совместимости, в интерфейсе не применяется)
  // Имя и индекс
  #define RDS_PLATFORMNAME  RDS_WIN32_NAME
  #define RDS_PLATFORMID    RDS_WIN32_ID
#elif defined(RDS_WIN64)
  // Описания для Win64
  #define RDSBIGGESTTYPE  LPVOID  // Самый большой "плоский" тип из используемых
  typedef short int RDS_SHORT;    // int16 одним словом (для совместимости, в интерфейсе не применяется)
  // Имя и индекс
  #define RDS_PLATFORMNAME  RDS_WIN64_NAME
  #define RDS_PLATFORMID    RDS_WIN64_ID
#endif
//===================================================================================

// Смещение поля относительно начала структуры
#ifndef RDS_OFFSETOF_DISABLED
  // Собственное описание
  #define RDS_OFFSETOF(type,field) ((size_t)((char *)&(((type*)0)->field) - (char *)0))
#else
  // Стандартное описание (если поддерживается)
  #define RDS_OFFSETOF(type,field)  offsetof(type,field)
#endif
//===================================================================================


//======================== Основные описания ================================
// Описания, необходимые для функций отклика блоков

//---------------------------------------------------------------------------
// Сообщения (режимы вызова)
#define RDS_BFM_INIT                     0 // Инициализация блока
#define RDS_BFM_CLEANUP                  1 // Очистка (вызывается перед удалением)
#define RDS_BFM_MODEL                    2 // Моделирование
#define RDS_BFM_RENAME                   3 // Сообщение о переименовании блока
#define RDS_BFM_VARCHECK                 4 // Проверка структуры переменных
#define RDS_BFM_SETUP                    5 // Вызов функции настройки
#define RDS_BFM_REMOTEMSG                6 // Сообщение от внешнего управления (УСТАРЕВШЕЕ)
#define RDS_BFM_RESIZE                   7 // Размер блока изменен (с возможностью вмешаться)
#define RDS_BFM_RESIZING                 8 // Размер блока изменяется пользователем
#define RDS_BFM_TIMER                    9 // Сработал таймер
#define RDS_BFM_STARTCALC               10 // Расчет запущен
#define RDS_BFM_STOPCALC                11 // Расчет остановлен
#define RDS_BFM_RESETCALC               12 // Расчет сброшен
#define RDS_BFM_WINREFRESH              13 // Необходимо обновить немодальное окно
#define RDS_BFM_CHECKFUNCSUPPORT        14 // Проверить поддержку глобальной функции блоком (устаревшая)
#define RDS_BFM_FUNCTIONCALL            15 // Вызов глобальной функции
#define RDS_BFM_EDITMODE                16 // Вход в режим редактирования
#define RDS_BFM_CALCMODE                17 // Вход в режим расчета
#define RDS_BFM_POPUPHINT               18 // Запрос текста всплывающей подсказки
#define RDS_BFM_MENUFUNCTION            19 // Вызов внутренней функции блока (реакция на пункт меню)
#define RDS_BFM_UNLOADSYSTEM            20 // Вся система будет выгружена
#define RDS_BFM_MOVED                   21 // Блок перемещен
#define RDS_BFM_MANUALDELETE            22 // Перед удалением блока (вызывается только при удалении блоков
                                           // из схемы ПОЛЬЗОВАТЕЛЕМ)
#define RDS_BFM_BEFORESAVE              23 // Перед сохранением всей схемы
#define RDS_BFM_AFTERSAVE               24 // После сохранения всей схемы
#define RDS_BFM_CONTEXTPOPUP            25 // Вызов контекстного меню блока
#define RDS_BFM_MANUALINSERT            26 // После добавления блока в схему из буфера
                                           // обмена или из файла
#define RDS_BFM_DYNVARCHANGE            27 // Изменение динамической переменной
#define RDS_BFM_PREMODEL                28 // Перед тактом моделирования (для установивших флаг RDS_CTRLCALC)
#define RDS_BFM_BLOCKPANEL              29 // Какое-либо уведомление от панели блока в подсистеме
#define RDS_BFM_AFTERLOAD               30 // После загрузки всей схемы
#define RDS_BFM_CONTENTCHANGE           31 // Реакция на изменения в подсистеме (при подписке)
#define RDS_BFM_LEAVINGEDITMODE         32 // Перед выходом из режима редактирования
#define RDS_BFM_HELP                    33 // Запрос справки к блоку
#define RDS_BFM_SYSWORKSIZECHANGE       34 // Изменение размера рабочего поля подсистемы
#define RDS_BFM_LAYERCONFIGCHANGE       35 // Изменение конфигурации слоев подсистемы
#define RDS_BFM_SHAREDMEMCHANGE         36 // Изменение разделяемой переменной
#define RDS_BFM_TRANSLATE               37 // Вызов для перевода текстов
#define RDS_BFM_SHOWEXAMPLE             38 // Запрос примера к блоку
#define RDS_BFM_GLOBALPARAMCHANGE       39 // Сообщение об изменении глобального параметра схемы
#define RDS_BFM_RESIZED                 40 // Размер блока окончательно изменен
#define RDS_BFM_DELAYEDCALLCOMMAND      41 // Отложенный вызов блока
#define RDS_BFM_AFTERPASTE              42 // После вставки из буфера обмена
#define RDS_BFM_SYSMENUSHOW             43 // При открытии системного меню (вызывается у добавивших пункты)  2021_05_28
#define RDS_BFM_NEWCONNECTION           44 // После присоединения новой связи 2025_04_06
#define RDS_BFM_CONNGEOMETRY            45 // Изменение геоматрии присоединенной связи 2025_04_08
#define RDS_BFM_EXCEPTION               46 // Обработка исключения самим блоком 2025_04_29

// Загрузка и запись личных данных блока
#define RDS_BFM_LOADBIN                 50 // Загрузка в двоичном виде
#define RDS_BFM_LOADTXT                 51 // Загрузка в текстовом виде
#define RDS_BFM_SAVEBIN                 52 // Запись в двоичном виде
#define RDS_BFM_SAVETXT                 53 // Запись в текстовом виде

// Загрузка и запись текущего состояния блока
#define RDS_BFM_LOADSTATE               60 // Загрузка состояния в двоичном виде
#define RDS_BFM_SAVESTATE               61 // Запись состояния в двоичном виде

// Реакция на "мышь" на изображении блока
#define RDS_BFM_MOUSEDOWN              100 // Реакция на нажатие кнопки "мыши" в режиме расчета
#define RDS_BFM_MOUSEUP                101 // Реакция на отпускание кнопки "мыши" в режиме расчета
#define RDS_BFM_MOUSEMOVE              102 // Реакция на перемещение "мыши" в режиме расчета
#define RDS_BFM_MOUSEDBLCLICK          103 // Реакция на двойной щелчок в режиме расчета
#define RDS_BFM_MOUSESELECT            104 // Возможность выбора блока щелчком "мыши" в режиме редактирования

// Реакция на "мышь" вне изображения блока, если блок взвел флаг RDS_PROCESSUNHANDLEDMOUSE
#define RDS_BFM_EXTMOUSEDOWN           105 // Реакция на нажатие кнопки "мыши" в режиме расчета
#define RDS_BFM_EXTMOUSEUP             106 // Реакция на отпускание кнопки "мыши" в режиме расчета
#define RDS_BFM_EXTMOUSEMOVE           107 // Реакция на перемещение "мыши" в режиме расчета
#define RDS_BFM_EXTMOUSEDBLCLICK       108 // Реакция на двойной щелчок в режиме расчета

// Реакция на клавиатуру
#define RDS_BFM_KEYDOWN                120 // Реакция на нажатие клавиши в режиме расчета
#define RDS_BFM_KEYUP                  121 // Реакция на отпускание клавиши в режиме расчета

#define RDS_BFM_DRAW                   150 // Рисование изображения блока
#define RDS_BFM_DRAWADDITIONAL         151 // Рисование дополнительных элементов
#define RDS_BFM_DRAWOVER               152 // Рисование с исключающим ИЛИ при перемещении и масштабировании

// Сообщения, обрабатываемые подсистемой, если блоки не среагировали на "мышь"
#define RDS_BFM_WINDOWMOUSEDOWN        200 // Реакция на нажатие кнопки "мыши" в режиме расчета
#define RDS_BFM_WINDOWMOUSEUP          201 // Реакция на отпускание кнопки "мыши" в режиме расчета
#define RDS_BFM_WINDOWMOUSEMOVE        202 // Реакция на перемещение "мыши" в режиме расчета
#define RDS_BFM_WINDOWMOUSEDBLCLICK    203 // Реакция на двойной щелчок в режиме расчета

// Сообщения, обрабатываемые подсистемой, если блоки не среагировали на клавиатуру
#define RDS_BFM_WINDOWKEYDOWN          220 // Реакция на нажатие клавиши в режиме расчета
#define RDS_BFM_WINDOWKEYUP            221 // Реакция на отпускание клавиши в режиме расчета

// Реакция на действия с окном подсистемы (вызывается у подсистемы и всех блоков в ее окне)
#define RDS_BFM_WINDOWOPERATION        230 // Открытие и закрытие окна подсистемы

// Реакции на сетевые события
#define RDS_BFM_NETCONNECT             300 // Соединение установлено
#define RDS_BFM_NETDISCONNECT          301 // Соединение разорвано
#define RDS_BFM_NETDATARECEIVED        302 // Получены данные
#define RDS_BFM_NETERROR               303 // Ошибка
#define RDS_BFM_NETDATAACCEPTED        304 // Данные блока получены сервером

// Реакции на запрос настроек параметров связи и прочие, связанные с обслуживанием связи
#define RDS_BFM_SUPPORTSCONNSETUP      400 // Блок поддерживает настройку своей связи
#define RDS_BFM_CONNSETUP              401 // Вызов настройки связи
#define RDS_BFM_CONNHINT               402 // Запрос всплывающей подсказки связи
#define RDS_BFM_CONNPOPUP              403 // Вызов контекстного меню присоединенной связи
#define RDS_BFM_CONNPOPUPITEM          404 // Выбран добавленный пункт контекстного меню присоединенной связи
#define RDS_BFM_CONNCHECKERROR         405 // Проверка присоединенной связи на какие-нибудь ошибки
#define RDS_BFM_CONNERRORDRAW          406 // Рисование маркера ошибки на присоединенной связи
#define RDS_BFM_ASKALTCONNAPPEARANCE   407 // Запрос параметров для альтернативного внешнего вида связи
#define RDS_BFM_CONNADDITIONALDRAW     408 // Дополнительное рисование на присоединенной связи

// Реакции, связанные с наблюдением за срабатыванием связей в подграфе (см. rdsCWCreate)
#define RDS_BFM_CONNCHANGEON           500 // В подграфе связей начались изменения
#define RDS_BFM_CONNCHANGEOFF          501 // В подграфе связей прекратились изменения (за последний такт)
#define RDS_BFM_CONNCHGCTRLSTART       502 // Предварительный вызов всех блоков, установивших флаг RDS_CONNCHANGECTRL
#define RDS_BFM_CONNCHGCTRLASK         503 // Вызов блока с флагом RDS_CONNCHANGECTRL в процессе формирования наблюдателей
                                           // при обнаружении его выхода в исследуемом подграфе
#define RDS_BFM_CONNCHGCTRLEND         504 // Финальный вызов всех блоков, установивших флаг RDS_CONNCHANGECTRL
                                           // (после всех RDS_BFM_CONNCHGCTRLASK, если они были)
#define RDS_BFM_CONNCHGCTRLPROCESS     505 // Запрос на обработку изменений входных подграфов для выходных для
                                           // блоков, установивших флаг RDS_CONNCHANGECTRL
#define RDS_BFM_CONNCHANGEERROR        506 // Процесс в подграфе связей расходится

// Реакции, связанные сохранением и восстановлением конфигурации окон
#define RDS_BFM_CLOSEALLWINDOWS        600 // Закрыть все немодальные окна блока
#define RDS_BFM_SAVEWINDOWCONFIG       601 // Сохранить конфигурацию окон
#define RDS_BFM_LOADWINDOWCONFIG       602 // Восстановить конфигурацию окна (конкретного)

// Специальная константа, не совпадающая ни с одним режимом вызова
#define RDS_BFM_ALL                     -1
//---------------------------------------------------------------------------

// Возвращаемые функцией значения
#define RDS_BFR_DONE            0 // Нормальное завершение (для всех режимов)
#define RDS_BFR_ERROR           1 // Ошибка (для некоторых режимов)
#define RDS_BFR_NOTPROCESSED    1 // Отказ от обработки (для некоторых режимов), ==RDS_BFR_ERROR
#define RDS_BFR_STOP            1 // Прекращение дальнейшей обработки (для некоторых режимов), ==RDS_BFR_ERROR
#define RDS_BFR_BADVARSMSG      2 // Ошибка при вызове RDS_BFM_VARCHECK, но сообщение об ошибке
                                  // должна вывести основная программа.
#define RDS_BFR_MODIFIED        1 // Параметры изменены (для RDS_BFM_SETUP)
#define RDS_BFR_SHOWMENU        2 // При реакции на нажатие правой кнопки мыши - нажатие обработано,
                                  // нужно показать контекстное меню
#define RDS_BFR_RETRY           1 // Повтор операции (для RDS_BFM_LEAVINGEDITMODE) **** REV2 ****
#define RDS_BFR_ABORT           2 // Отмена операции (для RDS_BFM_LEAVINGEDITMODE) **** REV2 ****
#define RDS_BFR_REDRAW          1 // Необходимо повторно нарисовать блок после всех остальных (для RDS_BFM_DRAW,RDS_BFM_DRAWADDITIONAL)
//---------------------------------------------------------------------------

// Флаги мыши и клавиатуры
#define RDS_MLEFTBUTTON         1
#define RDS_MRIGHTBUTTON        2
#define RDS_MMIDDLEBUTTON       4
#define RDS_KSHIFT              8
#define RDS_KALT               16
#define RDS_KCTRL              32
#define RDS_MOUSEFLAGS         (RDS_MLEFTBUTTON|RDS_MRIGHTBUTTON|RDS_MMIDDLEBUTTON)
#define RDS_KBDFLAGS           (RDS_KSHIFT|RDS_KALT|RDS_KCTRL)
//---------------------------------------------------------------------------

// Константа для отсутсвия любых флагов (вместо нуля, для лучшей читаемости программы)
#define RDS_NO_FLAGS            0
//---------------------------------------------------------------------------

// Уникальный идентификатор блока
typedef LPVOID RDS_BHANDLE;
// Уникальный идентификатор связи
typedef LPVOID RDS_CHANDLE;
// Уникальный идентификатор программируемого таймера
typedef LPVOID RDS_TIMERID;
// Уникальный идентификатор пункта меню "Система"
typedef LPVOID RDS_MENUITEM;
// Уникальный идентификатор переменной блока
typedef LPVOID RDS_VHANDLE;
// Уникальный идентификатор вспомогательного объекта
typedef LPVOID RDS_HOBJECT;
// Идентификатор сетевой станции (соединения)
typedef LARGE_INTEGER RDS_NETSTATION;
// Идентификатор блока на сетевом соединении
typedef LARGE_INTEGER RDS_NETBLOCK;
// Идентификатор пользовательского потока  **** REV2 ****
typedef LPVOID RDS_USERAUXTHREAD;
//---------------------------------------------------------------------------
// Флаги блока (RDS_BLOCKDATA::Flags)
// разряд 0
#define RDS_NEEDSDLLREDRAW    1  // Требуется перерисовка после завершения функции
                                 // отклика (игнорируется при вызове модели блока,
                                 // который не рисует себя сам, чтение/запись)
// разряд 1
#define RDS_VARCHECKFAILED    2  // Предыдущий вызов RDS_BFM_VARCHECK вернул
                                 // флаг ошибки (только чтение)
// разряд 2
#define RDS_MOUSECAPTURE      4  // Блок захватил "мышь" (чтение/запись)
// разряд 3
#define RDS_NOWINREFRESH      8  // Перерисовка немодальных окон блока временно
                                 // запрещена (чтение/запись, управляется интерфейсной
                                 // функцией EnableWindowRefresh)
// разряд 4
#define RDS_WINREFRESHWAITING 16 // Сразу после разрешения перерисовки немодальных окон
                                 // интерфейсной функцией EnableWindowRefresh необходимо
                                 // перерисовать одно из окон (чтение/запись)
// разряд 5
#define RDS_DISABLED          32 // Блок не реагирует на действия пользователя - он не
                                 // может его выделить, отредактировать или удалить.
                                 // Блок изображается, но не реагирует на "мышь" и клавиатуру.
// разряд 6
#define RDS_CTRLCALC          64 // Блок должен быть вызван перед каждым тактом расчета
                                 // в режиме RDS_BFM_PREMODEL
// разряд 7
#define RDS_NOSUSPEND        128 // Вызовы блока в режимах RDS_BFM_MODEL и RDS_BFM_PREMODEL
                                 // не могут быть остановлены сервисной функцией
                                 // rdsSuspendCalc
// разряд 8
#define RDS_SUSPENDED        256 // Была вызвана сервисная функция rdsSuspendCalc для остановки
                                 // вызовов этого блока и его соседей в режимах RDS_BFM_MODEL и
                                 // RDS_BFM_PREMODEL. При этом вызовы будут все равно продолжаться
                                 // несмотря на это, если взведен флаг RDS_NOSUSPEND
// разряд 9
#define RDS_ALWAYSSETUP      512 // Вход в настройку блока разрешен, даже если проверка переменных
                                 // не прошла (установлен RDS_VARCHECKFAILED)
// разряд 10
#define RDS_ALWAYSLOADSAVE  1024 // Сохранение и загрузка параметров блока разрешены, даже если проверка переменных
                                 // не прошла (установлен RDS_VARCHECKFAILED)
// разряд 11
#define RDS_BLOCKHASHELP    2048 // У блока есть пункт "справка" в контекстном меню
// разряд 12
#define RDS_INITCALC        4096 // Блок вызывается для инициализационного расчета при первом
                                 // выходе из редактирования при приходе данных от других блоков
// разряд 13
#define RDS_INITCALCFIRST 0x2000 // Блок вызывается для инициализационного расчета при первом
                                 // выходе из редактирования в самом начале независимо от готовности
// разряд 14
#define RDS_LOCKTEXTRECT  0x4000 // Изменение параметров прямоугольника с текстом во внешнем виде блока производится в
                                 // настройках самого блока (предупреждение пользователю в окне параметров, также
                                 // блокирует перевод текста на прямоугольнике)
// разряд 15
#define RDS_CONNCHANGECTRL 0x8000 // Блок самостоятельно решает, какие входы влияют на какие выходы при наблюдении
                                  // за срабатыванием связей (rdsCWCreate)
// разряд 16
#define RDS_HIDESTART     0x10000 // Скрывать переменную "Start" при присоединении связей
// разряд 17
#define RDS_DYNVARBYINPUT 0x20000 // Блок изменяет динамические переменные, на которые он подписан, при изменении
                                  // своих входов (используется только при настройке  наблюдателей за срабатыванием
                                  // связей, создаваемых функцией rdsCWCreate)
// разряд 18
#define RDS_MULTICALC     0x40000 // Блок может перезапускать сам себя для продолжения начатых в такте вычислений
                                  // (используется только при настройке  наблюдателей за срабатыванием
                                  // связей, создаваемых функцией rdsCWCreate)
// разряд 19
#define RDS_MULTICALCON   0x80000 // В данный момент блок перезапускает сам себя для продолжения начатых в такте вычислений
                                  // (используется только при настройке  наблюдателей за срабатыванием
                                  // связей, создаваемых функцией rdsCWCreate)
// разряд 20
#define RDS_BLOCKHASEXAMPLE 0x100000 // У блока есть пункт "пример" в контекстном меню
// разряд 21
#define RDS_PROCESSUNHANDLEDMOUSE 0x200000 // Блок обрабаывает действия "мыши" в своей подсистеме не на своем изображении
// разряд 22
#define RDS_NAMEMOUSEREACTION 0x400000 // Имя блока в режимах моделирования и расчета чувствительно к действиям "мыши"
// разряд 23
#define RDS_FASTUNDO          0x800000 // При отмене операции не обязательно отключать модель от блока и подключать ее снова
// разряд 24
#define RDS_NOFPEXCEPTIONS    0x1000000 // На время вызова блока отключать математические исключения
// разряд 25
#define RDS_SETUPNONCHANGING  0x2000000 // Вызов "настройки" блока не изменяет его параметров
// разряд 26
#define RDS_BLOCKDRAWOVER     0x4000000 // При перетаскивании и масштабировании блок рисует себя исключающим ИЛИ
// Разряд 27
#define RDS_IGNOREEXCEPTIONS  0x8000000 // Игнорировать исключения в блоке
// Разряд 28
#define RDS_SELFPROCEXCEPTIONS  0x10000000 // Вызывать сам блок для обработки исключений
// Разряд 29
#define RDS_NORESETVARS         0x20000000 // Не сбрасывать значения переменных при сбросе расчета
//---------------------------------------------------------------------------
// Флаг-синоним для старых версий моделей
#define RDS_NEEDSREDRAW         RDS_NEEDSDLLREDRAW
//---------------------------------------------------------------------------

// Данные блока
typedef struct // RDS_BLOCKDATA
{ union
    { LPVOID VarTreeData;          // Адрес дерева данных блока (только чтение)
      RDSBIGGESTTYPE align0;
      #ifdef RDS_VARDATAALIAS
        LPVOID VarData;
      #endif
    };
  union
    { LPVOID BlockData;            // Адрес области данных блока (чтение/запись)
      RDSBIGGESTTYPE align1;
    };
  union
    { RDS_BHANDLE Block;           // Идентификатор блока (только чтение)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSCSTR BlockNameA;          // Имя блока (только чтение) в UTF8
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR BlockName;
      #endif
    };
  union
    { RDSWCSTR BlockNameW;         // Имя блока (только чтение) в UTF16
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR BlockName;
      #endif
    };
  union
    { RDS_BHANDLE Parent;          // Идентификатор окружающей подсистемы (только чтение)
      RDSBIGGESTTYPE align5;
    };
  union
    { DWORD Flags;                 // Флаги (см. выше)
      RDSBIGGESTTYPE align6;
    };
  // Размеры базового (заданного в режиме редактирования) описывающего прямоугольника.
  // Эти данные имеют смысл только если блок рисует себя функцией отклика.
  // Поскольку положение верхнего левого угла прямоугольника (т.е. точки привязки при
  // рисовании функцией) может быть связано с переменными, конкретное вычисленное
  // значение его координат передается в RDS_DRAWDATA и RDS_MOUSEDATA при соответствующих
  // вызовах.
  union
    { RDSINT32 Width;
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSINT32 Height;
      RDSBIGGESTTYPE align8;
    };
  // Целое пользовательское поле (не обрабатывается и не инициализируется)
  union
    { RDSINT32 Tag;
      RDSBIGGESTTYPE align9;
    };
  // Пользовательское поле для обработки исключений (с версии 2.0.9).
  // Инициализируется нулем, автоматически сбрасывается в ноль после завершения любого события.
  // При разрешении блоку обрабатывать свои исключения в него можно записывать какой-то идентификатор
  // выполняемых действий, чтобы правильно отреагировать при обработке.
  union
    { RDSINT32 ExceptionTag;
      RDSBIGGESTTYPE align10;
    };
} RDS_BLOCKDATA;
typedef RDS_BLOCKDATA *RDS_PBLOCKDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая ТОЛЬКО при инициализационном расчете в режиме RDS_BFM_MODEL
// (при обычном расчете передается NULL)
typedef struct // RDS_INITIALCALCDATA
{ union
    { BOOL FirstInChain;       // Этот блок начинает передачу из-за флага RDS_INITCALCFIRST
      RDSBIGGESTTYPE align0;
    };
} RDS_INITIALCALCDATA;
typedef RDS_INITIALCALCDATA *RDS_PINITIALCALCDATA;
//---------------------------------------------------------------------------


// Структура, передаваемая вместе с мышиными сообщениями
// (RDS_BFM_MOUSE*, RDS_BFM_WINDOWMOUSE* и RDS_BFM_EXTMOUSE*)
typedef struct // RDS_MOUSEDATA
{ union
    { RDSINT32 x;                // Координаты "мыши"
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 y;
      RDSBIGGESTTYPE align1;
    };

  union
    { RDSINT32 BlockX;           // Координаты точки привязки блока (с учетом связи с переменными)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 BlockY;           // (только для сообщений RDS_BFM_MOUSE*)
      RDSBIGGESTTYPE align3;
    };

  union
    { RDSINT32 Left;             // Верхний левый угол зоны блока (по последнему рисованию)
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 Top;              // (только для сообщений RDS_BFM_MOUSE*)
      RDSBIGGESTTYPE align5;
    };

  union
    { RDSINT32 Width;            // Размеры зоны блока (по последнему рисованию)
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 Height;           // (только для сообщений RDS_BFM_MOUSE*)
      RDSBIGGESTTYPE align7;
    };

  union
    { RDSINT32 IntZoom;          // Масштаб в % (целый)
      RDSBIGGESTTYPE align8;
    };
  union
    { DWORD Button;              // Кнопка - причина вызова (один из трех флагов "мыши" RDS_M*)
      RDSBIGGESTTYPE align9;
    };
  union
    { DWORD Shift;               // Флаги мыши и клавиатуры (RDS_M*, RDS_K*)
      RDSBIGGESTTYPE align10;
    };
  union
    { BOOL BlockName;            // Операция на имени блока **** REV2 ****
      RDSBIGGESTTYPE align11;
    };
  union
    { double DoubleZoom;         // Масштабный к-т (в долях единицы)
      RDSBIGGESTTYPE align12;
    };

  union
    { RDSINT32 MouseEvent;       // Причина вызова - RDS_BFM_MOUSEDOWN, RDS_BFM_MOUSEUP,
                                 // RDS_BFM_MOUSEMOVE или RDS_BFM_MOUSEDBLCLICK
                                 // (при вызове с сообщением RDS_BFM_WINDOWMOUSE* и RDS_BFM_EXTMOUSE* сюда записывается
                                 // соответствующая константа RDS_BFM_MOUSE*)
      RDSBIGGESTTYPE align13;
    };
  union
    { RDSINT32 Viewport;         // Номер порта вывода, через которое пришло сообщение, или -1,
                                 // если оно пришло от обычного окна подсистемы
      RDSBIGGESTTYPE align14;
    };
} RDS_MOUSEDATA;
typedef RDS_MOUSEDATA *RDS_PMOUSEDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с клавиатурными сообщениями
// (RDS_BFM_KEY* и RDS_BFM_WINDOWKEY*)
typedef struct // RDS_KEYDATA
{ union
    { RDSINT32 KeyCode;           // Код клавиши (виртуальный, см. WinAPI)
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Repeat;                // Для RDS_BFM_KEYDOWN: нажатие сгенерировано автоповтором
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 RepeatCount;       // Для RDS_BFM_KEYDOWN при Repeat==TRUE: число повторенных
                                  // с момента предыдущего вызова (обычно 1)
      RDSBIGGESTTYPE align2;
    };
  union
    { DWORD Shift;                // Флаги клавиатуры (RDS_M*, RDS_K*)
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 KeyEvent;          // Причина вызова - RDS_BFM_KEYDOWN или RDS_BFM_KEYUP
                                  // (при вызове с сообщением RDS_BFM_WINDOWKEY* сюда записывается
                                  // соответствующая константа RDS_BFM_KEY*)
      RDSBIGGESTTYPE align4;
    };
  // ------- Возвращаемые параметры -------
  union
    { BOOL Handled;               // Устанавливается в TRUE, если остальные блоки (и системное
                                  // меню в случае RDS_BFM_KEYDOWN) не должны реагировать на эту клавишу
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 Viewport;          // Номер порта вывода, через которое пришло сообщение, или -1,
                                  // если оно пришло от обычного окна подсистемы
      RDSBIGGESTTYPE align6;
    };
} RDS_KEYDATA;
typedef RDS_KEYDATA *RDS_PKEYDATA;
//---------------------------------------------------------------------------

// Действия, вызвавшие загрузку или запись данных блока
// (возвращается rdsGetSystemInt(RDS_GSISAVELOADACTION))
#define RDS_LS_ERROR            0       // В данный момент не производится загрузка или запись
#define RDS_LS_LOADROOT         1       // Загрузка корневого блока при загрузке системы
#define RDS_LS_SAVEROOT         2       // Запись корневого блока при записи системы
#define RDS_LS_LOADCONTENT      3       // Загрузка блока в составе загружаемой подсистемы
#define RDS_LS_SAVECONTENT      4       // Запись блока в составе записываемой подсистемы
#define RDS_LS_LOADCLIPBRD      5       // Загрузка блока при вставке из буфера обмена
#define RDS_LS_SAVECLIPBRD      6       // Запись блока при копировании в буфера обмена
#define RDS_LS_LOADFROMFILE     7       // Загрузка одиночного блока с диска или из библиотеки
#define RDS_LS_SAVETOFILE       8       // Запись одиночного блока на диск или в библиотеку
#define RDS_LS_LOADUNDO         9       // Загрузка блока из-за отмены изменений
#define RDS_LS_SAVEUNDO         10      // Запись блока в буфер для отмены изменений
#define RDS_LS_LOADAUTOCOMP     11      // Загрузка данных блока после автокомпиляции модели
#define RDS_LS_SAVEAUTOCOMP     12      // Запись данных блока перед автокомпиляцией модели
#define RDS_LS_LOADTAGGED       13      // Загрузка блока в спец.формате с тегами
#define RDS_LS_SAVETAGGED       14      // Запись блока в спец.формате с тегами
#define RDS_LS_LOADPROG         15      // Загрузка блока из-за вызова какой-либо сервисной функции **** REV2 ****
#define RDS_LS_SAVEPROG         16      // Запись блока из-за вызова какой-либо сервисной функции **** REV2 ****
//---------------------------------------------------------------------------

// Операция, вызвавшая загрузку или запись данных блока при сохранении/загрузке при отмене изменений
// (т.е. при rdsGetSystemInt(RDS_GSISAVELOADACTION)==RDS_LS_LOADUNDO или RDS_LS_SAVEUNDO
// (возвращается rdsGetSystemInt(RDS_GSIUNDOACTION))  **** REV2 ****
#define RDS_UA_ERROR            0       // В данный момент не производится загрузка или запись для отмены операции
#define RDS_UA_ADDBLOCK         1       // Добавление блока
#define RDS_UA_DELBLOCK         2       // Удаление блока
#define RDS_UA_EDITBLOCK        3       // Изменение различных параметров блока (вызова настройки не было)
#define RDS_UA_SETUPBLOCK       4       // Вызов настройки блока
#define RDS_UA_PROGUNDO         5       // Создание точки отмены для блока сервисной функцией
#define RDS_UA_TRANSLATE        6       // Реакция на перевод текстов
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщениями о рисовании (RDS_BFM_DRAW,RDS_BFM_DRAWADDITIONAL)
typedef struct // RDS_DRAWDATA
{ union
    { HDC dc;                     // Где рисовать (контекст, см. WinAPI)
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL CalcMode;              // TRUE - режим расчета, FALSE - режим редактирования
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 BlockX;            // Координаты точки привязки блока (с учетом связи с переменными)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 BlockY;
      RDSBIGGESTTYPE align3;
    };
  union
    { double DoubleZoom;          // Масштабный к-т (в долях единицы)
      RDSBIGGESTTYPE align4;
    };

  // Данные реального описывающего прямоугольника - заполняются процедурой рисования
  // для дальнейшего использования. Все координаты - абсолютные на рабочем поле с учетом
  // масштаба. Данные используются ТОЛЬКО в режиме расчета, в режиме редактирования
  // размеры прямоугольника берутся из RDS_BLOCKDATA::Width и RDS_BLOCKDATA::Height,
  // а верхний левый угол совпадает с точкой привязки.
  union
    { BOOL RectValid;             // Если процедура заполнила следующие далее данные, она должна
                                  // установить эту переменную в TRUE. Иначе данные будут
                                  // проигнорированы, и прямоугольник заполнится по RDS_BLOCKDATA.
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 Left;              // Верхний левый угол зоны блока
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 Top;
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSINT32 Width;             // Размеры зоны блока
      RDSBIGGESTTYPE align8;
    };
  union
    { RDSINT32 Height;
      RDSBIGGESTTYPE align9;
    };
  // ---------
  union
    { LPRECT VisibleRect;         // Реально отображаемый в окне прямоугольник (весь, только чтение)
      RDSBIGGESTTYPE align10;
    };
  union
    { BOOL FullDraw;              // TRUE - нужно перерисовать весь блок, FALSE - можно перерисовать
                                  // только изменившиеся с прошлого вызова части (при упрощенном
                                  // режиме рисования)
      RDSBIGGESTTYPE align11;
    };
  union
    { BOOL Redraw;                // Рисование вызвано повторно по просьбе блока  **** REV2 ****
      RDSBIGGESTTYPE align12;
    };
  // Флаги и параметры, влияющие на рисование имени блока (устанавливаются блоком при вызове)
  union
    { double NameFontScale;       // Измененный масштаб шрифта имени (-1 - оставить текущий) **** REV2 ****
      RDSBIGGESTTYPE align13;
    };
  union
    { DWORD OutFlags;             // Флаги, см. ниже **** REV2 ****
      RDSBIGGESTTYPE align14;
    };
  union
    { RDSINT32 NameShiftDx;       // Измененное смещение имени для единичного масштаба **** REV2 ****
      RDSBIGGESTTYPE align15;
    };
  union
    { RDSINT32 NameShiftDy;
      RDSBIGGESTTYPE align16;
    };
} RDS_DRAWDATA;
typedef RDS_DRAWDATA *RDS_PDRAWDATA;
// Флаги для RDS_DRAWDATA::OutFlags
#define RDS_DDF_ALTNAMESHIFT        1       // Смещение имени изменено
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщениями об изменении размера блока
// (RDS_BFM_RESIZE, RDS_BFM_RESIZING)
typedef struct // RDS_RESIZEDATA
{ union
    { BOOL HorzResize;          // Идет изменение горизонтального размера
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL VertResize;          // Идет изменение вертикального размера
      RDSBIGGESTTYPE align1;
    };
  // HorzResize и VertResize устанавливаются в зависимости от того,
  // за какую из восьми меток масштабирования "тянет" пользователь.
  // При изменении размера через параметры блока обе эти переменные
  // равны FALSE.
  union
    { RDSINT32 newWidth;        // Новые значения ширины и высоты
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 newHeight;
      RDSBIGGESTTYPE align3;
    };
  // Параметры сетки редактора
  union
    { RDSINT32 GridDx;          // Размеры
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 GridDy;
      RDSBIGGESTTYPE align5;
    };
  union
    { BOOL SnapToGrid;          // Включена ли привязка
      RDSBIGGESTTYPE align6;
    };
} RDS_RESIZEDATA;
typedef RDS_RESIZEDATA *RDS_PRESIZEDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением о перемещении блока
// (RDS_BFM_MOVED)
typedef struct // RDS_MOVEDATA
{ union
    { RDSINT32 MoveReason;       // Причина перемещения (RDS_MR_*)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 OldX;             // Старые координаты точки привязки
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 OldY;
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 NewX;             // Новые координаты точки привязки
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 NewY;
      RDSBIGGESTTYPE align4;
    };
} RDS_MOVEDATA;
typedef RDS_MOVEDATA *RDS_PMOVEDATA;
// Причины перемещения
#define RDS_MR_SET      0       // Непосредственная установка координат (вставка из
                                // буфера обмена, сервисная функция и т.п)
#define RDS_MR_DRAG     1       // Перетаскивание в окне подсистемы
#define RDS_MR_KEYBOARD 2       // Перемещение с клавиатуры в окне подсистемы
#define RDS_MR_UNDOREDO 3       // Отмена или повтор действий пользователя по
                                // перемещению 
#define RDS_MR_HMIRROR  4       // Отражение по горизонтали с картинкой **** REV2 ****
#define RDS_MR_VMIRROR  5       // Отражение по вертикали с картинкой **** REV2 ****
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщениями об запуске и остановке расчета
// (RDS_BFM_STARTCALC, RDS_BFM_STOPCALC)
// Все параметры - только чтение
typedef struct // RDS_STARTSTOPDATA
{ union
    { BOOL FirstStart;        // TRUE  - расчет запущен с самого начала
                              // FALSE - расчет продолжен
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Loop;              // TRUE  - запуск неперерывного расчета
                              // FALSE - запуск на один такт
      RDSBIGGESTTYPE align1;
    };
} RDS_STARTSTOPDATA;
typedef RDS_STARTSTOPDATA *RDS_PSTARTSTOPDATA;
//---------------------------------------------------------------------------

// Структура параметров вызова специальной (глобальной) функции блока
// (RDS_BFM_FUNCTIONCALL)
typedef struct // RDS_FUNCTIONCALLDATA
{ union
    { RDSINT32 Function;           // Номер функции
      RDSBIGGESTTYPE align0;
    };
  union
    { LPVOID Data;                 // Данные функции (не обрабатываются системой)
      RDSBIGGESTTYPE align1;
    };

  union
    { RDS_BHANDLE Caller;          // Вызвавший блок
      RDSBIGGESTTYPE align2;
    };
  union
    { BOOL Broadcast;              // TRUE - широковещательное сообщение, FALSE - личное
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 BroadcastCnt;       // При Broadcast==TRUE - счетчик с 0, указывающий на порядковый
                                   // номер данного блока среди получивших сообщение
      RDSBIGGESTTYPE align4;
    };
  union
    { BOOL Stop;                   // При Broadcast==TRUE и соотв. параметрах функции rdsBroadcastFunctionCallsEx
                                   // может быть установлена в блоком TRUE, после чего широковещательный вызов
                                   // будет немедленно прекращен
      RDSBIGGESTTYPE align5;
    };
  union
    { BOOL Delayed;                // TRUE - отложенный вызов, FALSE - прямой
      RDSBIGGESTTYPE align6;
    };
  // Для отложенного вызова
  union
    { DWORD DataBufSize;           // Размер буфера, адрес которого передан через Data
      RDSBIGGESTTYPE align7;
    };
} RDS_FUNCTIONCALLDATA;
typedef RDS_FUNCTIONCALLDATA *RDS_PFUNCTIONCALLDATA;
//---------------------------------------------------------------------------
// Сервисные макросы для приведения типа параметров функции
#define RDS_FUNCPARAMCAST(datastruct,type) ((type*)(((RDS_PFUNCTIONCALLDATA)(datastruct))->Data))
#define RDS_FUNCPARAMPVOID(datastruct) (((RDS_PFUNCTIONCALLDATA)(datastruct))->Data)
//---------------------------------------------------------------------------

// Структура параметров вызова внутренней функции блока (реакции на пункт
// меню, созданный самим блоком)
// (RDS_BFM_MENUFUNCTION)
typedef struct // RDS_MENUFUNCDATA
{ union
    { RDSINT32 Function;       // Номер внутренней функции
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 MenuData;       // Данные функции (не обрабатываются системой)
      RDSBIGGESTTYPE align1;
    };
} RDS_MENUFUNCDATA;
typedef RDS_MENUFUNCDATA *RDS_PMENUFUNCDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением о всплывающей подсказке
// (RDS_BFM_POPUPHINT)
typedef struct // RDS_POPUPHINTDATA
{ union
    { RDSINT32 x;                   // Координаты "мыши"
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 y;
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 BlockX;              // Координаты точки привязки блока (с учетом связи с переменными)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 BlockY;
      RDSBIGGESTTYPE align3;
    };
  // Описывающий прямоугольник блока
  union
    { RDSINT32 Left;                // Верхний левый угол зоны блока (по последнему рисованию)
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 Top;
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 Width;               // Размеры зоны блока (по последнему рисованию)
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 Height;
      RDSBIGGESTTYPE align7;
    };
  // ------- Возвращаемые параметры -------
  union
    { RDSINT32 HZLeft;              // Размеры зоны действия подсказки (по умолчанию -
      RDSBIGGESTTYPE align8;
    };
  union
    { RDSINT32 HZTop;               // весь прямоугольник блока)
      RDSBIGGESTTYPE align9;
    };
  union
    { RDSINT32 HZWidth;
      RDSBIGGESTTYPE align10;
    };
  union
    { RDSINT32 HZHeight;
      RDSBIGGESTTYPE align11;
    };
  union
    { RDSINT32 ReshowTimeout;       // Интервал (мс), через который нужно заново вывести подсказку
                                    // (по умолчанию - 0, т.е. не выводить больше до покидания зоны HZ*)
      RDSBIGGESTTYPE align12;
    };
  union
    { RDSINT32 HideTimeout;         // Интервал (мс), через который нужно погасить подсказку
                                    // по умолчанию - стандартное значение для Windows)
      RDSBIGGESTTYPE align13;
    };
  // --------------------------------------
  // Масштаб (на всякий случай)
  union
    { RDSINT32 IntZoom;             // Масштаб в % (целый)
      RDSBIGGESTTYPE align14;
    };
  union
    { double DoubleZoom;            // Масштабный к-т (в долях единицы)
      RDSBIGGESTTYPE align15;
    };
} RDS_POPUPHINTDATA;
typedef RDS_POPUPHINTDATA *RDS_PPOPUPHINTDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением от дистанционного управления
// (RDS_BFM_REMOTEMSG) УСТАРЕВШАЯ
typedef struct // RDS_REMOTEMSGDATA
{ union
    { RDSCSTR StringA;                // Переданная строка (UTF8)
      RDSBIGGESTTYPE align0;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR String;
      #endif
    };
  union
    { RDSWCSTR StringW;               // То же в UTF16
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR String;
      #endif
    };
  union
    { RDSINT32 Value;                 // Переданное число
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSCSTR ControllerNameA;        // Имя программы дистанционного управления (если она
                                      // его сообщила)
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ControllerName;
      #endif
    };
  union
    { RDSWCSTR ControllerNameW;       // То же в UTF16
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ControllerName;
      #endif
    };
} RDS_REMOTEMSGDATA;
typedef RDS_REMOTEMSGDATA *RDS_PREMOTEMSGDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением о необходимости обновить окна
// (RDS_BFM_WINREFRESH)
typedef struct // RDS_WINREFRESHDATA
{ union
    { RDS_TIMERID Timer;       // Таймер, вызвавший обновление, или NULL, если обновление
                               // вызвано сервисной функцией (только чтение)
      RDSBIGGESTTYPE align0;
    };
  union
    { DWORD Flags;             // Флаги (см. ниже) **** REV2 ****
      RDSBIGGESTTYPE align1;
    };
  // ------- Возвращаемый параметр -------
  union
    { double Delay;            // Время обновления окна, мс (запись, исходное -1.0)
      RDSBIGGESTTYPE align2;
    };
} RDS_WINREFRESHDATA;
// Флаги RDS_WINREFRESHDATA::Flags
#define RDS_WINREFF_UNCONDITIONAL   1       // Принудительное обновление по команде
#define RDS_WINREFF_USER            2       // По команде пользователя (F5)
typedef RDS_WINREFRESHDATA *RDS_PWINREFRESHDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением о действиях с окном подсистемы
// (RDS_BFM_WINDOWOPERATION)
typedef struct // RDS_WINOPERATIONDATA
{ union
    { RDSINT32 Operation;       // Операция с окном
      RDSBIGGESTTYPE align0;
    };
  union
    { HWND Handle;              // Handle окна
      RDSBIGGESTTYPE align1;
    };
  union
    { BOOL EditMode;            // Включен режим редактирования
      RDSBIGGESTTYPE align2;
    };
  union
    { BOOL Running;             // Идет моделирование (только при EditMode==FALSE)
      RDSBIGGESTTYPE align3;
    };
  union
    { BOOL OwnWindow;           // Операция с окном данной подсистемы (TRUE) или родительской (FALSE)
      RDSBIGGESTTYPE align4;
    };
} RDS_WINOPERATIONDATA;
typedef RDS_WINOPERATIONDATA *RDS_PWINOPERATIONDATA;
//---------------------------------------------------------------------------
// Операции с окном для RDS_WINOPERATIONDATA::Operation
#define RDS_SWO_OPEN    0       // Открытие окна
#define RDS_SWO_CLOSE   1       // Закрытие окна
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением об открытии контекстного меню
// (RDS_BFM_CONTEXTPOPUP)
// Все параметры - только чтение
typedef struct // RDS_CONTEXTPOPUPDATA
{ union
    { BOOL EditMode;          // Включен режим редактирования
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL FreeSpace;         // Меню открывается не для блока, а для свободного места подсистемы
                              // (только для подсистем)
      RDSBIGGESTTYPE align1;
    };
} RDS_CONTEXTPOPUPDATA;
typedef RDS_CONTEXTPOPUPDATA *RDS_PCONTEXTPOPUPDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с командой отложенного вызова блока
// (RDS_BFM_DELAYEDCALLCOMMAND)
typedef struct // RDS_BLOCKDELAYEDCALLDATA
{ union
    { DWORD Flags;            // Флаги команды
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR TextA;          // Текст команды (UTF8)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Text;
      #endif
    };
  union
    { RDSWCSTR TextW;         // Текст команды (UTF16)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Text;
      #endif
    };
} RDS_BLOCKDELAYEDCALLDATA;
typedef RDS_BLOCKDELAYEDCALLDATA *RDS_PBLOCKDELAYEDCALLDATA;
//---------------------------------------------------------------------------


// Структура, передаваемая вместе с сообщением о добавлении блока пользователем
// (RDS_BFM_MANUALINSERT)
typedef struct // RDS_MANUALINSERTDATA
{ union
    { RDSINT32 Reason;        // Добавление блока из буфера обмена (RDS_LS_LOADCLIPBRD) или
                              // из файла (RDS_LS_LOADFROMFILE)
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Single;            // Добавляется один блок (TRUE) или несколько (FALSE)
      RDSBIGGESTTYPE align1;
    };
} RDS_MANUALINSERTDATA;
typedef RDS_MANUALINSERTDATA *RDS_PMANUALINSERTDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением об удалении блока пользователем
// (RDS_BFM_MANUALDELETE)
typedef struct // RDS_MANUALDELETEDATA
{ union
    { BOOL Single;            // Удаляется один блок (TRUE) или несколько (FALSE)
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL WithSys;           // Удаляется внутри удаляемой подсистемы (TRUE) или
                              // самостоятельно (в составе группы выделенных блоков
                              // или один)
      RDSBIGGESTTYPE align1;
    };
} RDS_MANUALDELETEDATA;
typedef RDS_MANUALDELETEDATA *RDS_PMANUALDELETEDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением о присоединении связи
// (RDS_BFM_NEWCONNECTION)
typedef struct // RDS_NEWCONNECTIONDATA
{ union
    { DWORD servSize;         // Размер структуры
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_CHANDLE Conn;       // Идентификатор связи
      RDSBIGGESTTYPE align1;
    };
} RDS_NEWCONNECTIONDATA;
typedef RDS_NEWCONNECTIONDATA *RDS_PNEWCONNECTIONDATA;
//---------------------------------------------------------------------------


// Структура, передаваемая вместе с сообщением об изменении геометрии связи
// (RDS_BFM_CONNGEOMETRY)
typedef struct // RDS_CONNCHANGEGEOMETRYDATA
{ union
    { DWORD servSize;               // Размер структуры
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_CHANDLE Conn;             // Идентификатор связи
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 BlockPointNum;       // Номер точки присоединения к этому блоку
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 Operation;           // Причина изменения (RDS_CCG_*)
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 OpPointNum;          // Номер точки или -1
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 OpLineNum;           // Номер линии или -1
      RDSBIGGESTTYPE align5;
    };
} RDS_CONNCHANGEGEOMETRYDATA;
typedef RDS_CONNCHANGEGEOMETRYDATA *RDS_PCONNCHANGEGEOMETRYDATA;
// Причины изменения
#define RDS_CCG_FULL            0 // Программное изменение всей связи или удаление ее нескольких кусков
#define RDS_CCG_POINTMOVE       1 // Перемещение точки
#define RDS_CCG_LINEMOVE        2 // Перемещение линии
#define RDS_CCG_BEZIERCTRLMOVE  3 // Перемещение управляющей точки кривой Безье
#define RDS_CCG_VARNAMEMOVE     4 // Перемещение имени переменной
#define RDS_CCG_TEXTMOVE        5 // Перемещение текста связи
#define RDS_CCG_MOVESELECTED    6 // Изменение геометрии из-за перемещения
                                  // выделенной связи при не выделенных подключенных блоках/шинах
#define RDS_CCG_MOVEOTHER       7 // Изменение геометрии не выделенной связи из-за перемещения
                                  // выделенных подключенных объектах
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением об исключении в модели
// (RDS_BFM_EXCEPTION)
typedef struct // RDS_EXCEPTIONDATA
{ union
    { DWORD servSize;              // Размер структуры
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 CallMode;           // Событие, в котором возникло исключение
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 ExceptionTag;       // Копия одноименного поля из RDS_BLOCKDATA
      RDSBIGGESTTYPE align2;
    };
} RDS_EXCEPTIONDATA;
typedef RDS_EXCEPTIONDATA *RDS_PEXCEPTIONDATA;
//---------------------------------------------------------------------------


// Структура, передаваемая вместе с сообщением об установлении или разрыве сетевого соединения
// (RDS_BFM_NETCONNECT, RDS_BFM_NETDISCONNECT)
typedef struct // RDS_NETCONNDATA
{ union
    { RDSINT32 ConnId;         // Идентификатор соединения
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR HostA;           // Адрес сервера (только для клиента, UTF8)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Host;
      #endif
    };
  union
    { RDSWCSTR HostW;
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Host;
      #endif
    };
  union
    { RDSINT32 Port;           // Порт
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSCSTR ChannelA;        // Имя канала (UTF8)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Channel;
      #endif
    };
  union
    { RDSWCSTR ChannelW;
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Channel;
      #endif
    };
  union
    { BOOL ByServer;           // Для клиента при RDS_BFM_NETDISCONNECT - TRUE если соединение разорвано сервером
      RDSBIGGESTTYPE align6;
    };
} RDS_NETCONNDATA;
typedef RDS_NETCONNDATA *RDS_PNETCONNDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением о принятых по сети данных
// (RDS_BFM_NETDATARECEIVED)
typedef struct // RDS_NETRECEIVEDDATA
{ union
    { RDSINT32 ConnId;                    // Идентификатор соединения
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR HostA;                      // Адрес сервера (только для клиента, UTF8)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Host;
      #endif
    };
  union
    { RDSWCSTR HostW;                     // То же в UTF16
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Host;
      #endif
    };
  union
    { RDSINT32 Port;                      // Порт
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSCSTR ChannelA;                   // Имя канала (UTF8)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Channel;
      #endif
    };
  union
    { RDSWCSTR ChannelW;                  // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Channel;
      #endif
    };

  union
    { RDSINT32 Id;                        // Принятое целое число
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSCSTR StrA;                       // Принятая строка (UTF8, не может быть NULL)
      RDSBIGGESTTYPE align7;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Str;
      #endif
    };
  union
    { RDSWCSTR StrW;                      // То же в UTF16
      RDSBIGGESTTYPE align8;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Str;
      #endif
    };
  union
    { LPVOID Buffer;                      // Принятый буфер или NULL
      RDSBIGGESTTYPE align9;
    };
  union
    { DWORD BufferSize;                   // Размер принятого буфера
      RDSBIGGESTTYPE align10;
    };

  union
    { RDS_NETSTATION SenderStation;       // Идентификатор машины-передатчика
      RDSBIGGESTTYPE align11;
    };
  union
    { RDS_NETBLOCK SenderBlock;           // Идентификатор блока на этой машине
      RDSBIGGESTTYPE align12;
    };
} RDS_NETRECEIVEDDATA;
typedef RDS_NETRECEIVEDDATA *RDS_PNETRECEIVEDDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением о сетевой ошибке
// (RDS_BFM_NETERROR)
typedef struct // RDS_NETERRORDATA
{ union
    { RDSINT32 ConnId;              // Идентификатор соединения
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR HostA;                // Адрес сервера (только для клиента)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Host;
      #endif
    };
  union
    { RDSWCSTR HostW;               // То же в UTF16
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Host;
      #endif
    };
  union
    { RDSINT32 Port;                // Порт
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSCSTR ChannelA;             // Имя канала
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Channel;
      #endif
    };
  union
    { RDSWCSTR ChannelW;            // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Channel;
      #endif
    };

  union
    { RDSINT32 ErrorCode;           // Код ошибки (RDS_NETERR_*)
      RDSBIGGESTTYPE align6;
    };

  union
    { RDS_NETSTATION Station;       // Идентификатор машины (для соответствующих ошибок)
      RDSBIGGESTTYPE align7;
    };
  union
    { RDS_NETBLOCK Block;           // Идентификатор блока (для соответствующих ошибок)
      RDSBIGGESTTYPE align8;
    };
} RDS_NETERRORDATA;
typedef RDS_NETERRORDATA *RDS_PNETERRORDATA;
// Коды ошибок
#define RDS_NETERR_NOBLOCK      1       // Нет блока, которому были переданы данные
#define RDS_NETERR_GENERAL      2       // Неизвестная ошибка
#define RDS_NETERR_SEND         3       // Ошибка при передаче
#define RDS_NETERR_RECEIVE      4       // Ошибка при приеме
#define RDS_NETERR_DISCONNECT   5       // Ошибка при попытке разорвать связь
#define RDS_NETERR_ACCEPT       6       // Ошибка при установке соединения с клиентом
#define RDS_NETERR_CLIENTCONN   7       // Ошибка при установке связи (только для сервера)
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением о получении данных сервером
// (RDS_BFM_NETDATAACCEPTED)
typedef struct // RDS_NETACCEPTDATA
{ union
    { RDSINT32 ConnId;         // Идентификатор соединения
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR HostA;           // Адрес сервера (только для клиента, UTF8)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Host;
      #endif
    };
  union
    { RDSWCSTR HostW;          // То же в UTF16
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Host;
      #endif
    };
  union
    { RDSINT32 Port;           // Порт
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSCSTR ChannelA;        // Имя канала (UTF8)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Channel;
      #endif
    };
  union
    { RDSWCSTR ChannelW;       // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Channel;
      #endif
    };

  union
    { RDSINT32 Id;             // Id отправленных данных
      RDSBIGGESTTYPE align6;
    };
} RDS_NETACCEPTDATA;
typedef RDS_NETACCEPTDATA *RDS_PNETACCEPTDATA;
//---------------------------------------------------------------------------

// Структура описания внешнего вида связи, используемая функциями
// rdsGetConnAppearance, rdsSetConnAppearance
typedef struct // RDS_CONNAPPEARANCE
{ union
    { DWORD servSize;             // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { COLORREF LineColor;         // Цвет линии
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 LineWidth;         // Толщина линии
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 LineStyle;         // Стиль линии (WinAPI)
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 ArrowLength;       // Длина стрелки (0...255)
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 ArrowWidth;        // Выступ стрелки (0...255)
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 DotSize;           // Диаметр точки соединения
      RDSBIGGESTTYPE align6;
    };
} RDS_CONNAPPEARANCE;
typedef RDS_CONNAPPEARANCE *RDS_PCONNAPPEARANCE;
//---------------------------------------------------------------------------

// Типы точек связи, используемые интерфейсными функциями
#define RDS_PTINTERNAL          1       // Внутренняя точка
#define RDS_PTBLOCK             2       // Соединение с блоком
#define RDS_PTBUS               4       // Соединение с шиной
#define RDS_PTBUSTOBLOCK        8       // Соединение шины с блоком
// Состояния точек
#define RDS_PSNORMAL            0       // Точка в порядке
#define RDS_PSBADVAR            1       // Нет такой переменной
#define RDS_PSBADTYPE           2       // Несоответствие типов
// Структура описания точки связи, заполняемая функцией rdsGetPointDescription
// Запрещается изменять строки, адреса которых содержатся в структуре
typedef struct // RDS_POINTDESCRIPTION
{ union
    { DWORD servSize;             // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 PointType;         // Тип точки (см. выше)
      RDSBIGGESTTYPE align1;
    };
  union
    { BOOL Source;                // TRUE - источник данных, FALSE - получатель
                                  // (не используется для RDS_PTINTERNAL)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 Status;            // Состояние (RDS_PS******)
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSCSTR ObjectNameA;        // Имя блока или шины в UTF8 (кроме RDS_PTINTERNAL)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ObjectName;
      #endif
    };
  union
    { RDSWCSTR ObjectNameW;       // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ObjectName;
      #endif
    };
  union
    { RDSCSTR VarNameA;           // Имя переменной в UTF8 (кроме RDS_PTINTERNAL)
      RDSBIGGESTTYPE align6;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR VarName;
      #endif
    };
  union
    { RDSWCSTR VarNameW;          // То же в UTF16
      RDSBIGGESTTYPE align7;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR VarName;
      #endif
    };
  union
    { RDS_BHANDLE Block;          // Присоединенный блок для PointType==RDS_PTBLOCK или NULL
      RDSBIGGESTTYPE align8;
    };
  union
    { RDS_CHANDLE Bus;            // Присоединенная шина для PointType==RDS_PTBUS или NULL
      RDSBIGGESTTYPE align9;
    };

  union
    { RDS_CHANDLE Owner;          // Связь-владелец точки
      RDSBIGGESTTYPE align10;
    };
  union
    { RDSINT32 x;                 // Координаты точки (для RDS_PTBLOCK - относительные)
      RDSBIGGESTTYPE align11;
    };
  union
    { RDSINT32 y;
      RDSBIGGESTTYPE align12;
    };
  union
    { RDSINT32 PointNum;          // Номер точки в связи
      RDSBIGGESTTYPE align13;
    };

  union
    { RDSINT32 VarType;           // Односимвольный тип переменной (RDS_VARTYPE_*, кроме RDS_PTINTERNAL) **** REV2 ****
      RDSBIGGESTTYPE align14;
    };
  union
    { RDSINT32 VarNum;            // Номер переменной в блоке (только для RDS_PTBLOCK) или -1 **** REV2 ****
      RDSBIGGESTTYPE align15;
    };
  union
    { DWORD Flags;                // Флаги (RDS_PF*), см. ниже **** REV2 ****
      RDSBIGGESTTYPE align16;
    };
  union
    { RDSINT32 NameDX;            // Смещение имени относительно точки (левый верхний угол в 100%) **** REV2 ****
      RDSBIGGESTTYPE align17;
    };
  union
    { RDSINT32 NameDY;
      RDSBIGGESTTYPE align18;
    };
} RDS_POINTDESCRIPTION;
// Флаги RDS_POINTDESCRIPTION::Flags
#define RDS_PFSHOWNAME      1       // Показывать имя (только для точек соединения)
#define RDS_PFNAMEDRAGGED   2       // Имя было вручную перемещено пользователем (только для точек соединения)
#define RDS_PFNAMEAUTO      4       // Автоподстройка положения имени при редактировании связи (только для точек соединения)
#define RDS_PFCALCNAMECOORD 8       // Вспомогательный флаг для объекта программного редактирования связи:
                                    // после создания связи автоматически определить NameDx и NameDy (только для точек соединения)
typedef RDS_POINTDESCRIPTION *RDS_PPOINTDESCRIPTION;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщениями о событиях в присоединенной связи
// (RDS_BFM_SUPPORTSCONNSETUP, RDS_BFM_CONNSETUP, RDS_BFM_CONNPOPUP, RDS_BFM_CONNPOPUPITEM,
// RDS_BFM_ASKALTCONNAPPEARANCE, RDS_BFM_CONNCHECKERROR, RDS_BFM_CONNERRORDRAW и RDS_BFM_CONNHINT)
typedef struct // RDS_CONNSETUPDATA
{ union
    { RDS_CHANDLE Conn;                       // Идентификатор связи
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Output;                            // TRUE - связь подключена к выходу блока, FALSE - ко входу
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR VarNameA;                       // Полное имя подключенной переменной (UTF8)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR VarName;
      #endif
    };
  union
    { RDSWCSTR VarNameW;                      // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR VarName;
      #endif
    };
  union
    { RDSINT32 VarType;                       // Односимвольный тип переменной (RDS_VARTYPE_*)
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 VarNum;                        // Номер переменной в блоке
      RDSBIGGESTTYPE align5;
    };

  // Только для RDS_BFM_CONNHINT (возвращаемые параметры)
  union
    { RDSINT32 ReshowTimeout;                 // Интервал (мс), через который нужно заново вывести подсказку
                                              // (по умолчанию - 0, т.е. не выводить больше до покидания зоны HZ*)
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 HideTimeout;                   // Интервал (мс), через который нужно погасить подсказку
                                              // (по умолчанию - стандартное значение для Windows)
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSCSTR DefaultHintA;                   // Подсказка из параметров связи в UTF8 (NULL, если нет)
      RDSBIGGESTTYPE align8;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR DefaultHint;
      #endif
    };
  union
    { RDSWCSTR DefaultHintW;                  // То же в UTF16
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR DefaultHint;
      #endif
    };

  // Только для RDS_BFM_CONNPOPUP, RDS_BFM_CONNERRORDRAW и RDS_BFM_ASKALTCONNAPPEARANCE
  union
    { BOOL EditMode;                          // Включен режим редактирования
      RDSBIGGESTTYPE align10;
    };

  // Только для RDS_BFM_CONNPOPUPITEM
  union
    { RDSINT32 Function;                      // Номер функции
      RDSBIGGESTTYPE align11;
    };
  union
    { RDSINT32 MenuData;                      // Данные функции
      RDSBIGGESTTYPE align12;
    };

  // Только для RDS_BFM_CONNCHECKERROR (возвращаемый параметр)
  union
    { BOOL Error;                             // Результат проверки: TRUE - есть ошибка, FALSE - ошибки точно нет
      RDSBIGGESTTYPE align13;
    };
  union
    { RDSINT32 ErrorCode;                     // Код ошибки
      RDSBIGGESTTYPE align14;
    };

  // Только для RDS_BFM_CONNERRORDRAW и RDS_BFM_CONNADDITIONALDRAW
  union
    { HDC dc;                                 // Где рисовать (контекст, см. WinAPI)
      RDSBIGGESTTYPE align15;
    };
  union
    { RDSINT32 X;                             // Координаты центра отрезка связи (или точки для RDS_BFM_CONNADDITIONALDRAW)
      RDSBIGGESTTYPE align16;
    };
  union
    { RDSINT32 Y;
      RDSBIGGESTTYPE align17;
    };
  union
    { double DoubleZoom;                      // Масштабный к-т (в долях единицы), используется также для RDS_BFM_ASKALTCONNAPPEARANCE
      RDSBIGGESTTYPE align18;
    };

  // Только для RDS_BFM_ASKALTCONNAPPEARANCE
  union
    { RDSINT32 AltConnAppearanceNum;          // Номер альтернативного внешнего вида
      RDSBIGGESTTYPE align19;
    };
  union
    { RDS_PCONNAPPEARANCE Appearance;         // Заполняемое описание
      RDSBIGGESTTYPE align20;
    };
  union
    { BOOL AdditionalDraw;                    // Нужно вызвать блок для дорисовки чего-то на связи
      RDSBIGGESTTYPE align21;
    };

  // Только для RDS_BFM_CONNADDITIONALDRAW
  union
    { RDSINT32 DrawMode;                      // Режим вызова для рисования (см. ниже)
      RDSBIGGESTTYPE align22;
    };
  union
    { RDS_PPOINTDESCRIPTION PointDescr;       // Описание точки или NULL (RDS_CSDM_DRAWPOINT)
      RDSBIGGESTTYPE align23;
    };
  union
    { RDSINT32 LineMarkerRange;               // Расстояние между метками линии в текущем масштабе или -1 для одной по центру
      RDSBIGGESTTYPE align24;
    };
  union
    { RDSINT32 LineMarkerId;                  // Идентификатор рисуемого маркера (в первой итерации - -1)
      RDSBIGGESTTYPE align25;
    };
  union
    { RDSINT32 LineMarkerIteration;           // Номер вызова для рисования
      RDSBIGGESTTYPE align26;
    };
} RDS_CONNSETUPDATA;
// Значения RDS_CONNSETUPDATA::DrawMode
#define RDS_CSDM_NODRAW            -1       // Вызов не для рисования (заглушка)
#define RDS_CSDM_DRAWPOINT          1       // Вызов для рисования метки на точке
#define RDS_CSDM_NEEDSLINEDRAW      2       // Запрос: требуется ли рисование меток на линии
                                            // (вызывается в цикле, пока блок не вернет 0, при этом устанавливается
                                            //  LineMarkerRange и LineMarkerId)
#define RDS_CSDM_DRAWLINEMARK       3       // Рисование метки на линии
typedef RDS_CONNSETUPDATA *RDS_PCONNSETUPDATA;
//---------------------------------------------------------------------------

// Структура описания панели блока в окне подсистемы
typedef struct // RDS_PANDESCRIPTION
{ union
    { DWORD servSize;           // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_HOBJECT Object;       // Объект, связанный с этой панелью
      RDSBIGGESTTYPE align1;
    };
  union
    { RDS_BHANDLE Block;        // Блок-владелец панели
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 PLeft;           // Левый верхний угол панели в системных координатах (масштаб 100%)
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 PTop;
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 PWidth;          // Размер панели в системных координатах (масштаб 100%)
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 PHeight;
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 Order;           // Номер панели в данном блоке
      RDSBIGGESTTYPE align7;
    };
  union
    { BOOL Visible;             // Видимость панели
      RDSBIGGESTTYPE align8;
    };
  union
    { HWND Handle;              // Handle оконного объекта панели или NULL
      RDSBIGGESTTYPE align9;
    };
  union
    { RDSINT32 Width;           // Размеры оконного объекта панели (при Handle!=NULL)
      RDSBIGGESTTYPE align10;
    };
  union
    { RDSINT32 Height;
      RDSBIGGESTTYPE align11;
    };
  union
    { BOOL Border;              // Наличие рамки вокруг оконного объекта
      RDSBIGGESTTYPE align12;
    };
  union
    { BOOL CloseButton;         // Наличие кнопки закрытия панели
      RDSBIGGESTTYPE align13;
    };
  union
    { BOOL Scalable;            // Панель меняет размер при изменении масштаба системы
      RDSBIGGESTTYPE align14;
    };
  union
    { BOOL Sizeable;            // Размер панели может изменяться пользователем
      RDSBIGGESTTYPE align15;
    };
  union
    { BOOL Moveable;            // Положение панели может изменяться пользователем
      RDSBIGGESTTYPE align16;
    };
  union
    { BOOL CaptionBar;          // Есть полоса заголовка окна (за которую можно перетаскивать)
      RDSBIGGESTTYPE align17;
    };
  union
    { RDSCSTR CaptionA;         // Текущий заголовок в UTF8 (изменять в этой структуре нельзя!)
      RDSBIGGESTTYPE align18;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Caption;
      #endif
    };
  union
    { RDSWCSTR CaptionW;        // То же в UTF16
      RDSBIGGESTTYPE align19;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Caption;
      #endif
    };
} RDS_PANDESCRIPTION;
typedef RDS_PANDESCRIPTION *RDS_PPANDESCRIPTION;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением от панели блока
// (RDS_BFM_BLOCKPANEL)
typedef struct // RDS_PANOPERATION
{ union
    { RDSINT32 Operation;              // Действие с панелью (одна из констант RDS_PANOP_*)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_PPANDESCRIPTION Panel;       // Описание панели (указатель на структуру, существующую
                                       // только в момент вызова сообщения)
      RDSBIGGESTTYPE align1;
    };
} RDS_PANOPERATION;
typedef RDS_PANOPERATION *RDS_PPANOPERATION;
// Действия
#define RDS_PANOP_CREATE        0       // Создание оконного объекта для панели
#define RDS_PANOP_DESTROY       1       // Уничтожение оконного объекта для панели
#define RDS_PANOP_RESIZED       2       // Размер панели изменен
#define RDS_PANOP_MOVED         3       // Панель перемещена пользователем
#define RDS_PANOP_PAINT         4       // Необходимо перерисовать панель
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением об изменениях в подсистеме
// (RDS_BFM_CONTENTCHANGE)
typedef struct // RDS_CONTENTCHANGE
{ union
    { RDS_BHANDLE Changed;       // Подсистема (возможно, вложенная), в которой произошли изменения
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Deep;                 // Изменения не в самой подсистеме, а во вложенной (Changed!=Parent)
      RDSBIGGESTTYPE align1;
    };
  union
    { int Reason;                // Причина изменения (RDS_CCREASON_*)
      RDSBIGGESTTYPE align2;
    };
} RDS_CONTENTCHANGE;
typedef RDS_CONTENTCHANGE *RDS_PCONTENTCHANGE;
// Причины изменений
#define RDS_CCREASON_GENERAL    0 // Прочие изменения
#define RDS_CCREASON_BLKEDIT    1 // Изменения параметров одного блока
#define RDS_CCREASON_MOVE       2 // Один или несколько объектов перемещены
#define RDS_CCREASON_CHGORDER   3 // У одного или нескольких объектов изменены слои или порядок
#define RDS_CCREASON_LAYEROP    4 // Изменены параметры слоев (созданы, пересортированы, изменения конфигураций и т.п.)
#define RDS_CCREASON_CONNEDIT   5 // Изменения параметров (в т.ч. присоединений) одной связи
#define RDS_CCREASON_ADD        6 // Добавлены блоки или связи
#define RDS_CCREASON_DELETE     7 // Удаление блоков и связей
#define RDS_CCREASON_GRPEDIT    8 // Групповая установка параметров
#define RDS_CCREASON_ADDDELEDIT 9 // Одновременное добавление и удаление объектов (сложная операция)
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением об изменении размеров рабочего поля подсистемы
// (RDS_BFM_SYSWORKSIZECHANGE)
typedef struct // RDS_SYSWORKWIDTHCHANGE
{ union
    { RDS_BHANDLE Sys;          // Подсистема
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 OldWidth;        // Старые размеры
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 OldHeight;
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 NewWidth;        // Старые размеры
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 NewHeight;
      RDSBIGGESTTYPE align4;
    };
} RDS_SYSWORKWIDTHCHANGE;
typedef RDS_SYSWORKWIDTHCHANGE *RDS_PSYSWORKWIDTHCHANGE;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением об изменении конфигурации слоев подсистемы
// (RDS_BFM_LAYERCONFIGCHANGE)
typedef struct // RDS_LAYERCONFIGCHANGE
{ union
    { RDS_BHANDLE Sys;            // Подсистема
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL OwnConfig;             // TRUE  - реакция самой подсистемы на изменение конфигурации в ней
                                  // FALSE - реакция блока на изменение конфигурации в родительской подсистеме
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR ConfigNameA;        // Имя установленной конфигурации (UTF8)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ConfigName;
      #endif
    };
  union
    { RDSWCSTR ConfigNameW;       // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ConfigName;
      #endif
    };
  union
    { RDSINT32 ConfigNum;         // Номер установленной конфигурации
      RDSBIGGESTTYPE align4;
    };
} RDS_LAYERCONFIGCHANGE;
typedef RDS_LAYERCONFIGCHANGE *RDS_PLAYERCONFIGCHANGE;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением о записи или загрузке файла переводов
// (RDS_BFM_TRANSLATE)
typedef struct // RDS_TRANSLATEDATA
{ union
    { BOOL Save;              // TRUE  - идет запись файла переводов
                              // FALSE - идет загрузка переводов
      RDSBIGGESTTYPE align0;
    };
} RDS_TRANSLATEDATA;
typedef RDS_TRANSLATEDATA *RDS_PTRANSLATEDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщениями об изменениях в подграфе связей
// (RDS_BFM_CONNCHANGEON, RDS_BFM_CONNCHANGEOFF, RDS_BFM_CONNCHANGEERROR, для объекта rdsCWCreate)
typedef struct // RDS_CONNCHANGEDATA
{ union
    { RDS_HOBJECT Object;         // Объект, с помощью которого запрошено наблюдение за подграфом
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Id;                // Идентификатор, переданный при создании объекта
      RDSBIGGESTTYPE align1;
    };
  union
    { BOOL Changes;               // TRUE - изменения начались, FALSE - прекратились
      RDSBIGGESTTYPE align2;
    };
  union
    { BOOL Error;                 // TRUE при вызове в RDS_BFM_CONNCHANGEERROR, иначе FALSE
      RDSBIGGESTTYPE align3;
    };

  union
    { RDS_BHANDLE ObjBlock;       // Блок, входной подграф которого был запрошен
      RDSBIGGESTTYPE align4;
    };
} RDS_CONNCHANGEDATA;
typedef RDS_CONNCHANGEDATA *RDS_PCONNCHANGEDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_BFM_CONNCHGCTRLASK для формирования входных подграфов
// по выходным
// Вызов с этой структурой делается для каждого выхода блока, влияющего на какой-то подграф
typedef struct // RDS_BFM_CONNCHGASKDATA
{ union
    { RDS_HOBJECT Object;       // Объект-наблюдатель за подграфом, на который влияет выход блока
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR VarNameA;         // Имя переменной выхода (UTF8)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR VarName;
      #endif
    };
  union
    { RDSWCSTR VarNameW;        // То же в UTF16
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR VarName;
      #endif
    };
  union
    { RDS_CHANDLE Owner;        // Связь-владелец точки выхода
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 VarNum;          // Номер переменной-выхода в блоке
      RDSBIGGESTTYPE align4;
    };
} RDS_BFM_CONNCHGASKDATA;
typedef RDS_BFM_CONNCHGASKDATA *RDS_BFM_PCONNCHGASKDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_BFM_LOADWINDOWCONFIG и при вызове функции rdsSaveWindowConfig
typedef struct // RDS_BFM_WINCONFIGDATA
{ union
    { DWORD servSize;                 // Размер структуры (присваивается перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 PrivateId;             // Идентификатор (внутреннее дело блока)
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR AdditionalInfoA;        // Дополнительная информация в UTF8
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR AdditionalInfo;
      #endif
    };
  union
    { RDSWCSTR AdditionalInfoW;       // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR AdditionalInfo;
      #endif
    };
  union
    { RDSINT32 Left;                  // Размеры окна
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 Top;
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 Width;
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 Height;
      RDSBIGGESTTYPE align7;
    };
  union
    { BOOL Maximized;                 // Развернутость
      RDSBIGGESTTYPE align8;
    };
  union
    { BOOL Visible;                   // Окно видимо
      RDSBIGGESTTYPE align9;
    };
} RDS_BFM_WINCONFIGDATA;
typedef RDS_BFM_WINCONFIGDATA *RDS_BFM_PWINCONFIGDATA;
//---------------------------------------------------------------------------

// Функция вызова блока - тип указателя
typedef RDSINT32 (RDSCALL *RDS_BLOCKENTRYPOINT)(RDSINT32,RDS_PBLOCKDATA,LPVOID);
//---------------------------------------------------------------------------

//======================= Вспомогательные описания ============================
// Описания, необходимые для вызова некоторых интерфейсных функций

// Указатель на COLORREF
typedef COLORREF *RDS_PCOLORREF;
//---------------------------------------------------------------------------

// Типы блоков и связей, используемые интерфейсными функциями
#define RDS_TUNKNOWN            0       // Непонятно что (при ошибке в функции)
// Блоки
#define RDS_BTSYSTEM            1       // Подсистема
#define RDS_BTSIMPLEBLOCK       2       // Блок с моделью DLL (простой)
#define RDS_BTINPUTBLOCK        4       // Внешний вход
#define RDS_BTOUTPUTBLOCK       8       // Внешний выход
#define RDS_BTBUSPORT           64      // Ввод шины
#define RDS_BTDLLBLOCK          RDS_BTSIMPLEBLOCK // Синоним (для совместимости)
// Связи
#define RDS_CTCONNECTION        16      // Простая связь
#define RDS_CTBUS               32      // Шина
//---------------------------------------------------------------------------
// Все типы блоков
#define RDS_BTALLTYPES  (RDS_BTSYSTEM | RDS_BTSIMPLEBLOCK | RDS_BTINPUTBLOCK | RDS_BTOUTPUTBLOCK | RDS_BTBUSPORT)
// Все типы связей
#define RDS_CTALLTYPES  (RDS_CTCONNECTION | RDS_CTBUS)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Инициализация поля servSize в структурах, передаваемых в RDS для заполнения
#define RDS_INITSERVSIZE(s)     s.servSize=sizeof(s)
//---------------------------------------------------------------------------

// Структура описания блока, заполняемая функцией rdsGetBlockDescription
// Запрещается изменять строки, адреса которых содержатся в структуре
typedef struct // RDS_BLOCKDESCRIPTION
{ union
    { DWORD servSize;                  // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_BHANDLE Block;               // Идентификатор блока
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 BlockType;              // Тип блока (см. выше)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSCSTR BlockNameA;              // Имя блока (UTF8)
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR BlockName;
      #endif
    };
  union
    { RDSWCSTR BlockNameW;             // То же в UTF16
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR BlockName;
      #endif
    };
  union
    { RDS_BHANDLE Parent;              // Идентификатор окружающей подсистемы
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSCSTR ParentNameA;             // Имя подсистемы (UTF8)
      RDSBIGGESTTYPE align6;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ParentName;
      #endif
    };
  union
    { RDSWCSTR ParentNameW;            // То же в UTF16
      RDSBIGGESTTYPE align7;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ParentName;
      #endif
    };
  union
    { RDSCSTR BlockCommentA;           // Комментарий блока (UTF8)
      RDSBIGGESTTYPE align8;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR BlockComment;
      #endif
    };
  union
    { RDSWCSTR BlockCommentW;          // То же в UTF16
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR BlockComment;
      #endif
    };
  union
    { RDSINT32 LayerId;                // Идентификатор слоя
      RDSBIGGESTTYPE align10;
    };

  union
    { RDSCSTR DllFileA;                // Имя модуля DLL или NULL (UTF8)
      RDSBIGGESTTYPE align11;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR DllFile;
      #endif
    };
  union
    { RDSWCSTR DllFileW;               // То же в UTF16
      RDSBIGGESTTYPE align12;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR DllFile;
      #endif
    };
  union
    { RDSCSTR DllFuncA;                // Имя функции DLL или NULL (UTF8)
      RDSBIGGESTTYPE align13;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR DllFunc;
      #endif
    };
  union
    { RDSWCSTR DllFuncW;               // То же в UTF16
      RDSBIGGESTTYPE align14;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR DllFunc;
      #endif
    };
  union
    { HINSTANCE Module;                // Загруженный модуль DLL или NULL
      RDSBIGGESTTYPE align15;
    };
  union
    { RDSCSTR ParentVarA;              // Имя переменной подсистемы в UTF8, которая соответствует этому
                                       // блоку (только для внешнего входа и выхода) или NULL
      RDSBIGGESTTYPE align16;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ParentVar;
      #endif
    };
  union
    { RDSWCSTR ParentVarW;             // То же в UTF16
      RDSBIGGESTTYPE align17;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ParentVar;
      #endif
    };
  union
    { BOOL Selected;                   // Блок выделен в редакторе (только в режиме редактирования)
      RDSBIGGESTTYPE align18;
    };
  union
    { RDSINT32 NumberOfVars;           // Число переменных блока
      RDSBIGGESTTYPE align19;
    };
  union
    { DWORD Flags;                     // Флаги описания (RDS_BDF_*)
      RDSBIGGESTTYPE align20;
    };
  union
    { DWORD ExtId;                     // Внешний уникальный идентификатор (для приложений, управляющих
                                       // RDS снаружи)
      RDSBIGGESTTYPE align21;
    };
  union
    { RDSINT32 NamePos;                // Положение имени блока (RDS_BDNP_*)
      RDSBIGGESTTYPE align22;
    };
  union
    { RDSINT32 NameDx;                 // Смещение левого верхнего угла имени от точки привязки блока (в масштабе 100%)
      RDSBIGGESTTYPE align23;
    };
  union
    { RDSINT32 NameDy;
      RDSBIGGESTTYPE align24;
    };
  union
    { RDSINT32 AltNameAlignment;       // Выравнивание текста, выводимого вместо имени (если он есть):
                                       // -1 (влево), 0 (по центру) или 1 (вправо)
      RDSBIGGESTTYPE align25;
    };
} RDS_BLOCKDESCRIPTION;
typedef RDS_BLOCKDESCRIPTION *RDS_PBLOCKDESCRIPTION;
// Флаги описания
#define RDS_BDF_RUNEVERYCYCLE   1       // Запуск каждый такт
#define RDS_BDF_NAMEOFF         2       // Запрещение вывода имени блока
#define RDS_BDF_SHOWMAINPOINT   4       // Показывать в редакторе точку привязки
#define RDS_BDF_SELFDRAW        8       // Рисование производится функцией DLL
#define RDS_BDF_MOUSEEVENTS     0x10    // Функция блока получает сообщения от "мыши"
#define RDS_BDF_FREEMOUSEMOVE   0x20    // Функция блока получает сообщения о перемещении "мыши"
                                        // с отпущенными кнопками
#define RDS_BDF_ALLOWRESIZE     0x40    // Разрешение масштабирования "мышью"
#define RDS_BDF_LOCKWIDTH       0x80    // Фиксировать ширину при масштабировании (при RDS_BDF_ALLOWRESIZE)
#define RDS_BDF_LOCKHEIGHT      0x100   // Фиксировать высоту при масштабировании (при RDS_BDF_ALLOWRESIZE)
#define RDS_BDF_SETUPFUNC       0x200   // Есть функция настройки
#define RDS_BDF_SETUPBYDCLICK   0x400   // Функция настройки по двойному щелчку
#define RDS_BDF_POPUPHINT       0x800   // Есть реакция на Hint
#define RDS_BDF_KBDEVENTS       0x1000  // Получает сообщения от клавиатуры
#define RDS_BDF_HASPICTURE      0x2000  // Есть картинка
#define RDS_BDF_TEXTRECT        0x4000  // Блок изображается прямоугольником с текстом
#define RDS_BDF_ALLOWMOVE       0x8000  // Блок может перемещаться пользователем **** REV2 ****
#define RDS_BDF_HIDDEN          0x10000 // Изображение блока программно запрещено (временно, в режиме моделирования) **** REV2 ****
#define RDS_BDF_ALWAYSHIDDEN    0x20000 // Изображение блока программно запрещено (всегда) **** REV2 ****
//                              0xffffffff
// Положение имени блока
#define RDS_BDNP_BELOW          0       // Под блоком
#define RDS_BDNP_ABOVE          1       // Над блоком
#define RDS_BDNP_CUSTOM         2       // Произвольное (перемещено пользователем вручную)
//---------------------------------------------------------------------------

// Структура описания размеров описывающего прямоугольника блока
// и точки привязки (заполняется функцией rdsGetBlockDimensions)
typedef struct // RDS_BLOCKDIMENSIONS
{ union
    { DWORD servSize;         // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 BlockX;        // Положение точки привязки на рабочем поле
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 BlockY;
      RDSBIGGESTTYPE align2;
    };

  union
    { RDSINT32 Left;          // Верхний левый угол зоны блока на рабочем поле
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 Top;
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 Width;         // Размеры зоны блока на рабочем поле
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 Height;
      RDSBIGGESTTYPE align6;
    };
} RDS_BLOCKDIMENSIONS;
typedef RDS_BLOCKDIMENSIONS *RDS_PBLOCKDIMENSIONS;
//---------------------------------------------------------------------------
// Флаги для rdsGetBlockDimensionsEx
#define RDS_GBD_NONE            0       // Нет флагов (для лучшей читаемости программы)
#define RDS_GBD_USEZOOM         1       // Использовать масштаб родительской подсистемы
#define RDS_GBD_USEVARS         2       // В режимах моделирования и расчета учитывать связь с переменными
//---------------------------------------------------------------------------

// Структура описания связи, заполняемая функцией rdsGetConnDescription
// Запрещается изменять строки, адреса которых содержатся в структуре
typedef struct // RDS_CONNDESCRIPTION
{ union
    { DWORD servSize;               // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_CHANDLE Conn;             // Идентификатор связи
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 ConnType;            // Тип связи (см. выше)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDS_BHANDLE Parent;           // Идентификатор окружающей подсистемы
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSCSTR ParentNameA;          // Имя подсистемы (UTF8)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ParentName;
      #endif
    };
  union
    { RDSWCSTR ParentNameW;         // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ParentName;
      #endif
    };
  union
    { BOOL Active;                  // Состояние связи (включена/отключена)
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 LayerId;             // Идентификатор слоя
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSINT32 NumPoints;           // Число точек в связи
      RDSBIGGESTTYPE align8;
    };
  union
    { RDSCSTR BusNameA;             // Имя (UTF8, только для шины)
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR BusName;
      #endif
    };
  union
    { RDSWCSTR BusNameW;            // То же в UTF16
      RDSBIGGESTTYPE align10;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR BusName;
      #endif
    };
  union
    { RDSINT32 NumChannels;         // Число каналов (только для шины)
      RDSBIGGESTTYPE align11;
    };
  union
    { RDSINT32 NumLines;            // Число линий, соединяющих точки на изображении связи
      RDSBIGGESTTYPE align12;
    };
  union
    { DWORD ExtId;                  // Внешний уникальный идентификатор (для приложений, управляющих
                                    // RDS снаружи)
      RDSBIGGESTTYPE align13;
    };
  union
    { BOOL Selected;                // Связь выделена в редакторе (только в режиме редактирования) **** REV2 ****
      RDSBIGGESTTYPE align14;
    };
  union
    { RDSCSTR TextA;                // Дополнительный текст в UTF8 или NULL, если его нет **** REV2 ****
      RDSBIGGESTTYPE align15;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Text;
      #endif
    };
  union
    { RDSWCSTR TextW;               // То же в UTF16
      RDSBIGGESTTYPE align16;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Text;
      #endif
    };
  union
    { BOOL ShowText;                // Показывать дополнительный текст рядом со связью **** REV2 ****
      RDSBIGGESTTYPE align17;
    };
  union
    { RDSINT32 TextX;               // Абсолютные координаты центра дополнительного текста, если он есть **** REV2 ****
      RDSBIGGESTTYPE align18;
    };
  union
    { RDSINT32 TextY;
      RDSBIGGESTTYPE align19;
    };
  union
    { RDSINT32 TextAlignment;       // Выравнивание текста (-1 - влево, 0 - по центру, 1 - вправо) **** REV2 ****
      RDSBIGGESTTYPE align20;
    };
  union
    { BOOL TextTranslate;           // Необходимость перевода текста **** REV2 ****
      RDSBIGGESTTYPE align21;
    };
  union
    { DWORD Flags;                  // Флаги описания (RDS_CDF_*) **** REV2 ****
      RDSBIGGESTTYPE align22;
    };
} RDS_CONNDESCRIPTION;
typedef RDS_CONNDESCRIPTION *RDS_PCONNDESCRIPTION;
// Флаги описания  **** REV2 ****
#define RDS_CDF_ACTIVE          1       // Включена (аналог Active в структуре)
#define RDS_CDF_ALLOWMOVE       2       // Разрешено перемещение пользователем
#define RDS_CDF_HIDDEN          4       // Изображение связи программно запрещено (временно)
#define RDS_CDF_TEXT            8       // Выводится пользовательский текст
#define RDS_CDF_ALWAYSHIDDEN    16      // Изображение связи программно запрещено (постоянно)
#define RDS_CDF_BLOCKDRAW       32      // Требуется дополнительное рисование одним из подключенных блоков
//---------------------------------------------------------------------------

// Типы линий связи, используемые интерфейсными функциями
#define RDS_LNLINE      1       // Прямая линия
#define RDS_LNBEZIER    2       // Кривая
// Структура описания линии связи, заполняемая функцией GetLineDescription
typedef struct // RDS_LINEDESCRIPTION
{ union
    { DWORD servSize;          // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 LineType;       // Тип линии (RDS_LN*)
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 nPoint1;        // Номера соединяемых точек
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 nPoint2;
      RDSBIGGESTTYPE align3;
    };

  union
    { RDSINT32 x1;             // Абсолютные координаты точки nPoint1
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 y1;
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 x2;             // Абсолютные координаты точки nPoint2
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 y2;
      RDSBIGGESTTYPE align7;
    };

  union
    { RDSINT32 dx1;            // Смещения управляющей точки для nPoint1 при LineType==RDS_LNBEZIER
      RDSBIGGESTTYPE align8;
    };
  union
    { RDSINT32 dy1;
      RDSBIGGESTTYPE align9;
    };
  union
    { RDSINT32 dx2;            // Смещения управляющей точки для nPoint2 при LineType==RDS_LNBEZIER
      RDSBIGGESTTYPE align10;
    };
  union
    { RDSINT32 dy2;
      RDSBIGGESTTYPE align11;
    };

  union
    { RDS_CHANDLE Owner;       // Связь-владелец линии
      RDSBIGGESTTYPE align12;
    };
} RDS_LINEDESCRIPTION;
typedef RDS_LINEDESCRIPTION *RDS_PLINEDESCRIPTION;
//---------------------------------------------------------------------------

// Флаги переменных блока, используемые интерфейсными функциями
#define RDS_VARFLAG_INPUT       1       // Вход (не употребляется вместе с RDS_VARFALG_OUTPUT)
#define RDS_VARFLAG_OUTPUT      2       // Выход (не употребляется вместе с RDS_VARFALG_INPUT)
#define RDS_VARFLAG_RUN         4       // При срабатывании входа запускается модель
#define RDS_VARFLAG_MENU        8       // Присутствует в меню присоединения входов/выходов
#define RDS_VARFLAG_SHOWNAME    16      // Вывод имени разрешен по умолчанию
#define RDS_VARFLAG_ONEINDEX    32      // Одноиндексный массив (только для массивов)
#define RDS_VARFLAG_MULTICONN   64      // При присоединении связи не скрывать вход с уже присоединенной связью
#define RDS_VARFLAG_REMNAME     128     // В точке присоединения связи показывать комментарий вместо имени
// Дополнительные флаги - не описывают переменные, а используются при их создании
// интерфейсными функциями
#define RDS_VARFLAG_EXT_CHGNAME 0x10000 // Изменить имя создаваемой переменной, если такая
                                        // уже есть

// Структура описания переменной блока
// Запрещается изменять строки, адреса которых содержатся в структуре
typedef struct // RDS_VARDESCRIPTION
{ union
    { DWORD servSize;              // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Type;               // Односимвольный тип переменной (RDS_VARTYPE_*)
      RDSBIGGESTTYPE align1;
    };
  union
    { DWORD Flags;                 // Набор битовых флагов (RDS_VARFLAG_*)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSCSTR NameA;               // Имя переменной (UTF8)
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Name;
      #endif
    };
  union
    { RDSWCSTR NameW;              // То же в UTF16
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Name;
      #endif
    };
  union
    { RDSCSTR StructTypeA;         // Имя типа (UTF8, только для структур, для остальных - NULL)
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR StructType;
      #endif
    };
  union
    { RDSWCSTR StructTypeW;        // То же в UTF16
      RDSBIGGESTTYPE align6;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR StructType;
      #endif
    };
  union
    { RDSINT32 StructFields;       // Число полей (только для структур)
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSINT32 DataSize;           // Размер блока данных
      RDSBIGGESTTYPE align8;
    };
  union
    { RDS_VHANDLE Var;             // Уникальный идентификатор
      RDSBIGGESTTYPE align9;
    };
  union
    { RDSINT32 Rank;               // Уровень переменной
      RDSBIGGESTTYPE align10;
    };
  union
    { RDSCSTR RemarkA;             // Комментарий переменной (UTF8, пустая строка, если его нет)
      RDSBIGGESTTYPE align11;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Remark;
      #endif
    };
  union
    { RDSWCSTR RemarkW;            // То же в UTF16
      RDSBIGGESTTYPE align12;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Remark;
      #endif
    };
} RDS_VARDESCRIPTION;
typedef RDS_VARDESCRIPTION *RDS_PVARDESCRIPTION;
//---------------------------------------------------------------------------

// Структура описания параметров редактора подсистемы, заполняемая функцией
// rdsGetEditorParameters
typedef struct // RDS_EDITORPARAMETERS
{ union
    { DWORD servSize;                   // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 GridDx;                  // Шаг сетки по горизонтали и вертикали
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 GridDy;
      RDSBIGGESTTYPE align2;
    };
  union
    { BOOL SnapToGrid;                  // Включена ли привязка к сетке
      RDSBIGGESTTYPE align3;
    };
  union
    { BOOL DisplayGrid;                 // Изображается ли сетка
      RDSBIGGESTTYPE align4;
    };
  union
    { COLORREF GridColor;               // Цвет точек сетки
      RDSBIGGESTTYPE align5;
    };

  union
    { BOOL Visible;                     // Окно редактора открыто
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 WinLeft;                 // Размеры и положение окна
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSINT32 WinTop;
      RDSBIGGESTTYPE align8;
    };
  union
    { RDSINT32 WinWidth;
      RDSBIGGESTTYPE align9;
    };
  union
    { RDSINT32 WinHeight;
      RDSBIGGESTTYPE align10;
    };
  union
    { RDSINT32 WorkWidth;               // Размеры рабочей области
      RDSBIGGESTTYPE align11;
    };
  union
    { RDSINT32 WorkHeight;
      RDSBIGGESTTYPE align12;
    };
  union
    { RDSINT32 ScrollX;                 // Позиция ScrollBar-ов
      RDSBIGGESTTYPE align13;
    };
  union
    { RDSINT32 ScrollY;
      RDSBIGGESTTYPE align14;
    };
  union
    { double Zoom;                      // Масштаб
      RDSBIGGESTTYPE align15;
    };

  union
    { COLORREF MainPointColor;          // Цвет точек привязки блоков
      RDSBIGGESTTYPE align16;
    };
  union
    { BOOL ShowBlockNames;              // Показывать имена блоков
      RDSBIGGESTTYPE align17;
    };
  union
    { BOOL ShowVarNames;                // Показывать имена переменных
      RDSBIGGESTTYPE align18;
    };

  union
    { RDSINT32 NumLayers;               // Число слоев
      RDSBIGGESTTYPE align19;
    };
  union
    { RDSINT32 CurLayerNum;             // Номер текущего слоя (0...NumLayers-1)
      RDSBIGGESTTYPE align20;
    };
  union
    { RDSINT32 CurLayerId;              // Id текущего слоя
      RDSBIGGESTTYPE align21;
    };
  union
    { RDSINT32 NumConfigs;              // Число конфигураций слоев
      RDSBIGGESTTYPE align22;
    };
  union
    { RDSINT32 CurConfig;               // Номер текущей конфигурации (0...NumConfigs-1)
      RDSBIGGESTTYPE align23;
    };

  union
    { BOOL PrintZoneActive;             // Зона печати включена
      RDSBIGGESTTYPE align24;
    };
  union
    { BOOL DisplayPrintZone;            // Зона печати отображается
      RDSBIGGESTTYPE align25;
    };
  union
    { RDSINT32 PZLeft;                  // Размеры и положение зоны печати
      RDSBIGGESTTYPE align26;
    };
  union
    { RDSINT32 PZTop;
      RDSBIGGESTTYPE align27;
    };
  union
    { RDSINT32 PZWidth;
      RDSBIGGESTTYPE align28;
    };
  union
    { RDSINT32 PZHeight;
      RDSBIGGESTTYPE align29;
    };

  union
    { BOOL WinMaximized;                // Окно развернуто на весь экран
      RDSBIGGESTTYPE align30;
    };
  union
    { BOOL WinMinimized;                // Окно свернуто
      RDSBIGGESTTYPE align31;
    };

  union
    { DWORD RefreshDelay;               // Задержка автоматического обновления окна в режиме расчета,
                                        // или 0, если обновление отключено
      RDSBIGGESTTYPE align32;
    };

  union
    { COLORREF BlockNameColor;          // Цвет имен блоков
      RDSBIGGESTTYPE align33;
    };
  union
    { RDSINT32 BlockNameDistance;       // Расстояние от блока до имени по умолчанию
      RDSBIGGESTTYPE align34;
    };

  union
    { COLORREF BackgroundColor;         // Цвет фона окна
      RDSBIGGESTTYPE align35;
    };
  union
    { BOOL DefBackground;               // В качестве цвета фона окна выбран цвет окна Windows
      RDSBIGGESTTYPE align36;
    };

  union
    { DWORD WindowReactions;            // Битовые флаги реакции окна на "мышь" и клавиатуру, не перехваченных блоками:
                                        // RDS_BDF_MOUSEEVENTS, RDS_BDF_FREEMOUSEMOVE, RDS_BDF_KBDEVENTS
      RDSBIGGESTTYPE align37;
    };
  union
    { BOOL Wallpaper;                   // Включены обои
      RDSBIGGESTTYPE align38;
    };
  union
    { BOOL WallpaperTile;               // Обоями заполнено все рабочее поле
      RDSBIGGESTTYPE align39;
    };
  union
    { RDSINT32 WallpaperWidth;          // Размеры обоев
      RDSBIGGESTTYPE align40;
    };
  union
    { RDSINT32 WallpaperHeight;
      RDSBIGGESTTYPE align41;
    };

  union
    { BOOL Dashboard;                   // В системе только неподвижные не перекрывающиеся блоки (оптимизация обновления)
      RDSBIGGESTTYPE align42;
    };
} RDS_EDITORPARAMETERS;
typedef RDS_EDITORPARAMETERS *RDS_PEDITORPARAMETERS;
//---------------------------------------------------------------------------

// Константы для функции rdsGetEditorFont
#define RDS_GEF_BLOCKNAME       0       // Шрифт имен блоков
#define RDS_GEF_VARNAME         1       // Шрифт имен переменных

// Структура описания панелей редактора подсистемы, используемая функциями
// rdsGetEditorToolBars и rdsSetEditorToolBars
// Эти вызовы устарели, вместо них следует использовать
// rdsGetEditorWindowFlags и rdsSetEditorWindowFlags
typedef struct // RDS_EDITORTOOLBARS
{ union
    { BOOL LayersBar;         // Видимость панели слоя и конфигурации
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL ZoomBar;           // Видимость панели масштаба
      RDSBIGGESTTYPE align1;
    };
  union
    { BOOL DisplayBar;        // Видимость панели изображения (сетка и т.п)
      RDSBIGGESTTYPE align2;
    };
  union
    { BOOL PrintBar;          // Видимость панели печати
      RDSBIGGESTTYPE align3;
    };
  union
    { BOOL StatusBar;         // Видимость строки состояния
      RDSBIGGESTTYPE align4;
    };
} RDS_EDITORTOOLBARS;
typedef RDS_EDITORTOOLBARS *RDS_PEDITORTOOLBARS;
//---------------------------------------------------------------------------


// Режимы работы программируемых таймеров
#define RDS_TIMERM_DELETE       0       // Удалить таймер после срабатывания
#define RDS_TIMERM_STOP         1       // Таймер останавливается, но не удаляется
#define RDS_TIMERM_LOOP         2       // Таймер автоматически взводится заново
// Способы срабатывания таймеров
#define RDS_TIMERS_SIGNAL    0x10       // При срабатывании взводится сигнал запуска
#define RDS_TIMERS_TIMER     0x20       // При срабатывании вызвать блок с RDS_BFM_TIMER
#define RDS_TIMERS_WINREF    0x30       // При срабатывании вызвать блок с RDS_BFM_WINREFRESH
#define RDS_TIMERS_SYSTIMER  0x40       // При срабатывании вызвать блок с RDS_BFM_TIMER
                                        // даже в том случае, если процесс моделирования
                                        // остановлен или включен режим редактирования
// Флаги режимов
#define RDS_TIMERF_FIXFREQ   0x100      // Для RDS_BFM_WINREFRESH: не применять подстройку
                                        // частоты к этому таймеру
// Маски таймеров
#define RDS_TIMERMASK_M      0x0f       // Режим работы
#define RDS_TIMERMASK_S      0xf0       // Способ срабатывания
#define RDS_TIMERMASK_F    0xff00       // Флаги

// Структура параметров программируемого таймера
typedef struct // RDS_TIMERDESCRIPTION
{ union
    { DWORD servSize;         // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { DWORD Delay;            // Задержка таймера (мс)
      RDSBIGGESTTYPE align1;
    };
  union
    { DWORD StartTime;        // Время начала отсчета (мс)
      RDSBIGGESTTYPE align2;
    };
  union
    { BOOL On;                // Таймер включен
      RDSBIGGESTTYPE align3;
    };
  union
    { DWORD Mode;             // Режим (RDS_TIMERM_* | RDS_TIMERS_* | RDS_TIMERF_*)
      RDSBIGGESTTYPE align4;
    };
} RDS_TIMERDESCRIPTION;
typedef RDS_TIMERDESCRIPTION *RDS_PTIMERDESCRIPTION;
//---------------------------------------------------------------------------

// Псевдоидентификаторы блоков для функций работы с динамическими переменными
#define RDS_DVSELF      0       // Переменная в собственном блоке
#define RDS_DVPARENT    1       // Переменная в родительской подсистеме
#define RDS_DVROOT      2       // Переменная в главной подсистеме
// Структура параметров подписки на динамическую переменную
typedef struct // RDS_DYNVARLINK
{ union
    { LPVOID Data;                // Адрес области данных переменной или NULL
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR VarNameA;           // Имя переменной (UTF8, только чтение)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR VarName;
      #endif
    };
  union
    { RDSWCSTR VarNameW;          // То же в UTF16
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR VarName;
      #endif
    };
  union
    { RDSCSTR VarTypeA;           // Тип переменной (UTF8, только чтение)
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR VarType;
      #endif
    };
  union
    { RDSWCSTR VarTypeW;          // То же в UTF16
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR VarType;
      #endif
    };
  union
    { RDS_BHANDLE Provider;       // Блок, которому принадлежит данная переменная
      RDSBIGGESTTYPE align5;
    };
  union
    { LPVOID UID;                 // Уникальный идентификатор переменной в блоке Provider (служебная,
                                  // изменять нельзя)
      RDSBIGGESTTYPE align6;
    };
  union
    { RDS_VHANDLE Var;            // Идентификатор переменной для использования в сервисных функциях
      RDSBIGGESTTYPE align7;
    };
} RDS_DYNVARLINK;
typedef RDS_DYNVARLINK *RDS_PDYNVARLINK;
//---------------------------------------------------------------------------

// Структура параметров подписки на функцию блока
typedef struct // RDS_FUNCPROVIDERLINK
{ union
    { RDS_BHANDLE Block;       // Блок-провайдер
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 FuncId;         // Функция
      RDSBIGGESTTYPE align1;
    };
} RDS_FUNCPROVIDERLINK;
typedef RDS_FUNCPROVIDERLINK *RDS_PFUNCPROVIDERLINK;
// Макрос: удачность подписки
#define RDS_FUNCPROVIDERLINK_SUCCESS(pLink) ( ((pLink)!=NULL) && (((RDS_PFUNCPROVIDERLINK)(pLink))->Block!=NULL) )
//---------------------------------------------------------------------------

// Псевдоидентификаторы блоков для функций работы с разделяемой памятью **** REV2 ****
#define RDS_SMSELF      0       // Переменная в собственном блоке
#define RDS_SMPARENT    1       // Переменная в родительской подсистеме
#define RDS_SMROOT      2       // Переменная в главной подсистеме
// Структура параметров разделяемой блоками области памяти
typedef struct // RDS_SHAREDMEMPARAMS
{ union
    { BOOL RdsVar;             // TRUE - переменная RDS, FALSE - просто область памяти
      RDSBIGGESTTYPE align0;
    };
  union
    { LPVOID Data;             // Указатель на область памяти ИЛИ адрес области данных переменной RDS
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR NameA;           // Имя области памяти (UTF8, только чтение)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Name;
      #endif
    };
  union
    { RDSWCSTR NameW;          // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Name;
      #endif
    };
  union
    { RDSCSTR VarTypeA;        // Тип переменной RDS (UTF8, для переменных RDS, только чтение)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR VarType;
      #endif
    };
  union
    { RDSWCSTR VarTypeW;       // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR VarType;
      #endif
    };
  union
    { RDS_VHANDLE Var;         // Идентификатор переменной для использования в сервисных функциях
      RDSBIGGESTTYPE align6;
    };
  union
    { DWORD Size;              // Размер области памяти (только для простых областей памяти)
      RDSBIGGESTTYPE align7;
    };
  union
    { RDS_BHANDLE Block;       // Блок, в котором создана область памяти/переменная
      RDSBIGGESTTYPE align8;
    };
} RDS_SHAREDMEMPARAMS;
typedef RDS_SHAREDMEMPARAMS *RDS_PSHAREDMEMPARAMS;
//---------------------------------------------------------------------------

// Структура описания шрифта (используется в некоторых функциях)
#define RDS_SERVFONTPARAMSNAMESIZE      256     // Размер массива под имя шрифта
typedef struct // RDS_SERVFONTPARAMS
{ union
    { DWORD servSize;          // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { char NameA[RDS_SERVFONTPARAMSNAMESIZE];// Имя шрифта (UTF8)
      RDSBIGGESTTYPE align1[1+(RDS_SERVFONTPARAMSNAMESIZE)*sizeof(char)/sizeof(RDSBIGGESTTYPE)];
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        char Name[RDS_SERVFONTPARAMSNAMESIZE];
      #endif
    };
  union
    { WCHAR NameW[RDS_SERVFONTPARAMSNAMESIZE];// То же в UTF16
      RDSBIGGESTTYPE align2[1+(RDS_SERVFONTPARAMSNAMESIZE)*sizeof(WCHAR)/sizeof(RDSBIGGESTTYPE)];
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        WCHAR Name[RDS_SERVFONTPARAMSNAMESIZE];
      #endif
    };
  union
    { RDSINT32 CharSet;        // Набор символов
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 Height;         // Высота (в пикселах)
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 Size;           // Высота (в типографских точках)
      RDSBIGGESTTYPE align5;
    };
  union
    { BOOL SizePriority;       // Только при установке шрифта по этой структуре:
                               // TRUE - использовать Size, FALSE - использовать Height
      RDSBIGGESTTYPE align6;
    };
  union
    { COLORREF Color;          // Цвет шрифта
      RDSBIGGESTTYPE align7;
    };
  union
    { BOOL Bold;               // Жирный
      RDSBIGGESTTYPE align8;
    };
  union
    { BOOL Italic;             // Курсив
      RDSBIGGESTTYPE align9;
    };
  union
    { BOOL Underline;          // Подчеркнутый
      RDSBIGGESTTYPE align10;
    };
  union
    { BOOL StrikeOut;          // Зачеркнутый
      RDSBIGGESTTYPE align11;
    };
} RDS_SERVFONTPARAMS;
typedef RDS_SERVFONTPARAMS *RDS_PSERVFONTPARAMS;
//---------------------------------------------------------------------------

// Маски для графических сервисных функций
#define RDS_GFALL               0    // Все параметры (при этом для шрифта используется RDS_GFSIZE)
#define RDS_GFSTYLE             1    // Стиль линии или заливки
#define RDS_GFWIDTH             2    // Толщина линии
#define RDS_GFCOLOR             4    // Цвет (линии, шрифта, заливки)
#define RDS_GFMODE              8    // Режим рисования линии (WinAPI SetROP2)
// Далее - только для шрифта
#define RDS_GFNAME             16    // Имя шрифта
#define RDS_GFSIZE             32    // Размер шрифта в усл.ед (points)
#define RDS_GFHEIGHT           64    // Расмер шрифта в точках
#define RDS_GFCHARSET         128    // Набор символов
#define RDS_GFESCAPEMENT      256    // Угол поворота (в градусах)
#define RDS_GFBOLD           1024    // Полужирный
#define RDS_GFITALIC         2048    // Курсив
#define RDS_GFUNDERLINE      4096    // Подчеркнутый
#define RDS_GFSTRIKEOUT      8192    // Зачеркнутый
#define RDS_GFESCAPEMENT10  16384    // Угол поворота (в десятых долях градуса) **** REV2 ****
#define RDS_GFFONTSTYLES     (1024+2048+4096+8192) // Все стили
#define RDS_GFFONTALLHEIGHT  (4+16+64+128+256+1024+2048+4096+8192) // Все параметры и высота
                                                                   // GF_HEIGHT
#define RDS_GFFONTALLHE10    (4+16+64+128+16384+1024+2048+4096+8192) // Все параметры, высота
                                                                   // GF_HEIGHT и угол в десятых градуса **** REV2 ****
#define RDS_GFFONTBASIC      (4+16+64+128+1024+2048+4096+8192) // Все стили и высота без поворота

// Стили заливки для графических сервисных функций
#define RDS_GFS_EMPTY           0    // Нет заливки
#define RDS_GFS_SOLID           1    // Сплошная
#define RDS_GFS_BDIAGONAL       2    // 45-degree downward left-to-right hatch
#define RDS_GFS_CROSS           3    // Horizontal and vertical crosshatch
#define RDS_GFS_DIAGCROSS       4    // 45-degree crosshatch
#define RDS_GFS_FDIAGONAL       5    // 45-degree upward left-to-right hatch
#define RDS_GFS_HORIZONTAL      6    // Horizontal hatch
#define RDS_GFS_VERTICAL        7    // Vertical hatch

// Константы, используемые функцией rdsAltConnAppearanceOp
#define RDS_CAOSET              0    // Установить параметры альтернативного вида связи
#define RDS_CAOCOUNT            1    // Вернуть число альтернативных видов
#define RDS_CAOPREALLOCATE      2    // Отвести массив заданного размера
#define RDS_CAOGET              3    // Получить параметры альтернативного вида
#define RDS_CAOSETCURRENT       4    // Установить текущий вид по альтернативному
#define RDS_CAODELETE           5    // Удалить альтернативный вид
#define RDS_CAORESTORE          6    // Восстановить вид, заданный исходно
#define RDS_CAOSETBLOCKASK      7    // Спрашивать для этого альтернативного вида параметры рисования у присоединенных блоков **** REV2 ****
#define RDS_CAORESETBLOCKASK    8    // Отменить RDS_CAOSETBLOCKASK **** REV2 ****
#define RDS_CAOGETBLOCKASK      9    // Установлен ли RDS_CAOSETBLOCKASK **** REV2 ****
#define RDS_CAOCLEAR            10   // Удалить все альтернативные виды **** REV2 ****

// Константы, используемые функцией rdsGetSystemPath
#define RDS_GSPSYSTEMFILE       0    // Загруженный файл системы (с путем, если схема не
                                     // только что создана)
#define RDS_GSPAPPPATH          1    // Путь к EXE-файлу RDS без имени файла
#define RDS_GSPDLLPATH          2    // Директория стандартных Dll
#define RDS_GSPAPPEXE           3    // Путь к EXE-файлу RDS с именем файла
#define RDS_GSPTEMPLATEPATH     4    // Путь к шаблонам схем
#define RDS_GSPBLOCKLIBPATH     5    // Путь к библиотеке блоков
#define RDS_GSPBLOCKPANELPATH   6    // Путь к панели блоков
#define RDS_GSPTEMPPATH         7    // Путь к временной директории
#define RDS_GSPINCLUDEPATH      8    // Путь к директории заголовочных файлов
#define RDS_GSPSYSTEMFULLPATH   9    // Загруженный файл схемы с путем. Если пути еще нет
                                     // (только что создана), возвращается пустая строка
#define RDS_GSPINIPATH         10    // Путь к директории ini-файлов (обычно совпадает с RDS_GSPAPPPATH)
#define RDS_GSPDEFAULTHOST     11    // Имя сервера по умолчанию для сетевых соединений
#define RDS_GSPMODELSPATH      12    // Директория для автокомпилируемых моделей
#define RDS_GSPBAKFILEEXT      13    // Расширение файлов резервных копий схем
#define RDS_GSPDOCPATH         14    // Директория документации **** REV2 ****
#define RDS_GSPSYSTEMFULLDIR   15    // Директория загруженного файла схемы или пустая строка **** REV2 ****
#define RDS_GSPCURLANGUAGE     16    // Текущий язык (пустая строка - по умолчанию) **** REV2 ****
#define RDS_GSPDEFLANGTEXT     17    // Текстовое название для языка по умолчанию (для пользователя) **** REV2 ****
#define RDS_GSPSAMPLESPATH     18    // Директория примеров схем **** REV2 ****
#define RDS_GSPWINFONTREPLACE  19    // Имя шрифта замены для окон **** REV2 ****
#define RDS_GSPHINTFONTREPLACE 20    // Имя шрифта замены для подсказок **** REV2 ****
#define RDS_GSPSYMBOLFONTREPLACE 21    // Имя шрифта замены для шрифта "Symbol" в данных старой версии **** REV2 ****

// Константы, используемые функцией rdsGetSystemInt
#define RDS_GSICMDPARAMCOUNT    0    // Число необработанных параметров командной строки
#define RDS_GSIINSTSTRUCTCOUNT  1    // Число структур в общем списке
#define RDS_GSISAVELOADACTION   2    // Действие, вызвавшее загрузку или запись блока
                                     // (одна из констант RDS_LS_*)
#define RDS_GSIMODIFIED         3    // 1 - система изменена, 0 - не изменена
#define RDS_GSITICKPARITY       4    // 0 - четный такт, 1 - нечетный
#define RDS_GSIDEFAULTPORT      5    // Порт по умолчанию для сетевых соединений
#define RDS_GSIUNDOSIZE         6    // Число шагов undo (0 - выключено)
#define RDS_GSIUIENABLED        7    // Разрешен ли пользовательский интерфейс (0 - весь RDS спрятан,
                                     // работа через окно вывода в другом приложении)
#define RDS_GSISTOPPING         8    // 1 - в данный момент останавливается расчет, иначе - 0
#define RDS_GSITRACELEVEL       9    // Уровень ведения отладочного журнала (0 - отключен)
#define RDS_GSIBAKFILESCOUNT   10    // Число создаваемых при сохранении схемы резервных копий
#define RDS_GSIMODE            11    // Текущий режим RDS (одна из констант RDS_CM_*) **** REV2 ****
#define RDS_GSIMAINHELP        12    // Наличие главного файла справки RDS (1 - да,0 - нет) **** REV2 ****
#define RDS_GSIINVALIDPATHS    13    // При rdsGetSystemInt(RDS_GSISAVELOADACTION)==RDS_LS_LOADPROG -
                                     // следует ли игнорировать или как-то корректировать пути в параметрах блоков - например, если
                                     // данные для загрузки пришли по сети (1-игнорировать,0-нет) **** REV2 ****
#define RDS_GSIUNDOACTION      14    // Действие undo, вызвавшее загрузку или сохранение блока (RDS_UA_*) **** REV2 ****
#define RDS_GSISCHEMEGLOBALCNT 15    // Число глобальных параметров схемы **** REV2 ****
#define RDS_GSICOMMANDQUEUEON  16    // Работа очереди команд разрешена **** REV2 ****
#define RDS_GSISYSTEMUPDATE    17    // Системные обновления разрешены (см. rdsSetSystemUpdate) **** REV2 ****
#define RDS_GSIWINFONTREPLACE  18    // Включена замена шрифта в окнах **** REV2 ****
#define RDS_GSIHINTFONTREPLACE 19    // Включена замена шрифта в подсказках **** REV2 ****
#define RDS_GSIHINTFONTPERCENT 20    // Процентный множитель размера шрифта в подсказках для замены **** REV2 ****
#define RDS_GSINONUTFLOAD      21    // Загрузка данных старой версии (до перехода на UTF8) **** REV2 ****
#define RDS_GSISYMBOLFONTREPL  22    // В настройках включена замена шрифта "Symbol" при загрузке данных старой версии **** REV2 ****
#define RDS_GSIWINFONTNONAA    23    // Включено принудительное отключение сглаживания шрифтов (устаревшая) **** REV2 ****
#define RDS_GSILEGACYCODEPAGE  24    // Кодовая страница для старых схем **** REV3 ****
#define RDS_GSIWINFONTQUALITY  25    // Настройки качества шрифта **** REV3 ****

// Режим RDS, возвращаемый rdsGetSystemInt(RDS_GSIMODE)  **** REV2 ****
#define RDS_CM_EDIT     0       // Режим редактирования
#define RDS_CM_CALC     1       // Режим моделирования
#define RDS_CM_RUN      2       // Режим расчета

// Значение, возвращаемое rdsGetSystemInt(RDS_GSIWINFONTQUALITY)  **** REV3 ****
#define RDS_FQ_OFF              0 // Управление качеством отключено
#define RDS_FQ_NOAA             1 // Запрещено сглаживание
#define RDS_FQ_AA               2 // Сглаживание разрешено, если поддерживается шрифтом
#define RDS_FQ_CLEARTYPE        3 // Сглаживание ClearType
#define RDS_FQ_CLEARTYPENATURAL 4 // Сглаживание ClearTypeNatural
#define RDS_FQ_DEFAULT          5 // Согласно параметрам системы (служебная константа)
#define RDS_FQ_DRAFT            6 // Для растровых шрифтов разрешено масштабирование (для совместимости?)
#define RDS_FQ_PROOF            7 // Для растровых шрифтов запрещено масштабирование (для совместимости?)

// Константы, используемые функцией rdsSetSystemInt
#define RDS_SSIFASTTEXTSAVE     0    // Быстрое сохранение в текстовом виде (без доп.обработки)
                                     // Вызывается в реакции RDS_BFM_SAVETXT, потом автоматически сбрасывается)
#define RDS_SSIWAITCURSOR       1    // Установить вид курсора "песочные часы" или вернуть нормальный
#define RDS_SSILEAVEEDITSTATUS  2    // Установить необходимость повторить/отменить выход из режима редактирования **** REV2 ****
#define RDS_SSICANCELUNDOSTORE  3    // Не записывать операцию, выполняющуюся сейчас, в undo **** REV2 ****
#define RDS_SSIENABLERESETBTN   4    // Временно разрешить кнопку сброса при сброшенном расчете **** REV2 ****

// Константы, используемые функцией rdsBlockStateOp
#define RDS_BSOSAVE             0    // Запомнить состояние
#define RDS_BSOCOUNT            1    // Вернуть число сохраненных состояний
#define RDS_BSORESTORE          2    // Восстановить состояние
#define RDS_BSODELETE           3    // Удалить состояние

// Типы потоков, возвращаемые функцией rdsCallerThreadType
#define RDS_THREADMAIN  0       // Главный поток
#define RDS_THREADAUX   1       // Вспомогательный поток моделирования

// Сервисные макросы для установки и проверки DWORD-флагов
#define RDS_GETFLAG(storage,mask) (((storage) & (mask))!=0)
#define RDS_SETFLAG(storage,mask,value) ((storage) = (value)?((storage) | (mask)):((DWORD)((storage) & (~(mask)))))
//---------------------------------------------------------------------------

// Сервисные макросы для работы с переменными-массивами
// Проверить существование массива
//   baseaddr - базовый адрес массива (void*)
#define RDS_ARRAYEXISTS(baseaddr) (*((void**)(baseaddr))!=NULL)
// Число строк (первый индекс) массива (массив должен существовать)
#define RDS_ARRAYROWS(baseaddr)  (*(*((RDSINT32**)(baseaddr))))
// Число столбцов (второй индекс) массива (массив должен существовать)
#define RDS_ARRAYCOLS(baseaddr)  ( *( *((RDSINT32**)(baseaddr))+1 ) )
// Начало области данных массива (массив должен существовать)
// Область данных: M[r,c]
//                 r0c0   r0c1   r0c2   ... r0cN   r1c0   r1c1   ...
//                 M[0,0] M[0,1] M[0,2] ... M[0,N] M[1,0] M[1,1] ...
#define RDS_ARRAYDATA(baseaddr)  ( *((RDSINT32**)(baseaddr))+2 )
#define RDS_ARRAYDATAPTR(baseaddr,type)  ( (type*)RDS_ARRAYDATA(baseaddr) )  //  **** REV2 ****
// Структура для быстрого доступа к массиву
typedef struct // RDS_ARRAYACCESSDATA
{ union
    { BOOL Exists;             // TRUE - массив существует (т.е. не 0 x 0)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Rows;           // Размерность массива
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 Cols;
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 ItemSize;       // Размер элемента массива
      RDSBIGGESTTYPE align3;
    };
  union
    { LPVOID Data;             // Начало области данных массива
      RDSBIGGESTTYPE align4;
    };
} RDS_ARRAYACCESSDATA;
typedef RDS_ARRAYACCESSDATA *RDS_PARRAYACCESSDATA;
// Адрес элемента массива по структуре доступа (массив должен существовать)
//   acc - RDS_PARRAYACCESSDATA массива
//   r,c - первый и второй индексы
#define RDS_ARRAYITEMADDR(acc,r,c) ( ((char*)((acc)->Data)) + ((r)*((acc)->Cols)+(c))*((acc)->ItemSize) )
// То же для одномерного массива
#define RDS_ARRAYITEMPLAINADDR(acc,n) ( ((char*)((acc)->Data)) + (n)*((acc)->ItemSize) )
// Элемент массива по структуре доступа
// type - тип элемента массива (например, double)
#define RDS_ARRAYITEM(type,acc,r,c) ( *((type *)RDS_ARRAYITEMADDR(acc,r,c)) )
//---------------------------------------------------------------------------

// Флаги для функции rdsEnumConnectedBlocks
#define RDS_BEN_INPUTS          1       // Просматривать входы блока
#define RDS_BEN_OUTPUTS         2       // Просматривать выходы блока
#define RDS_BEN_TRACELINKS      4       // Прослеживать связи внутрь и наружу подсистем до простых
                                        // блоков
#define RDS_BEN_USEDISABLED     8       // Если связь отключена, все равно обрабатывать ее **** REV2 ****
#define RDS_BEN_OUTERINPUTS     16      // Вызывать для входов соединенных блоков **** REV3 ****
#define RDS_BEN_OUTEROUTPUTS    32      // Вызывать для выходов соединенных блоков **** REV3 ****
//---------------------------------------------------------------------------

// Флаги, используемые функциями rdsBroadcastFunctionCallsEx, rdsBroadcastFuncCallsDelayed
#define RDS_BCALL_SUBSYSTEMS    1    // Вызывать все вложенные блоки всех вложенных подсистем
#define RDS_BCALL_CHECKSUPPORT  2    // Вызывать функцию только если выполнится RDS_BFM_CHECKFUNCSUPPORT
#define RDS_BCALL_ALLOWSTOP     4    // Разрешить блоку прекратить дальнейшие вызовы
#define RDS_BCALL_FIRST         8    // При отложенном вызове помещается в начало очереди
#define RDS_BCALL_LAST          0    // При отложенном вызове помещается в конец очереди (введен для
                                     // улучшения читаемости, можно не указывать)
//---------------------------------------------------------------------------

// Флаги для функции rdsSetPointPosition
#define RDS_SPP_RELATIVE        1       // Задаются координаты относительно точки привязки
#define RDS_SPP_REFRESH         2       // Обновить окно после установки координат точки
//---------------------------------------------------------------------------

// Однобайтовые обозначения типов переменных (из них формируется строка для RDS_BFM_VARCHECK)
// Простые
#define RDS_VARTYPE_SIGNAL      'S'     // Сигнал (1 байт - char)
#define RDS_VARTYPE_LOGICAL     'L'     // Логическая (1 байт - char)
#define RDS_VARTYPE_CHAR        'C'     // Целый (1 байт - char)
#define RDS_VARTYPE_SHORT       'H'     // Целый (2 байта - short int)
#define RDS_VARTYPE_INT         'I'     // Целый (4 байта - RDSINT32)
#define RDS_VARTYPE_FLOAT       'F'     // С плавающей точкой (4 байта - float)
#define RDS_VARTYPE_DOUBLE      'D'     // С плавающей точкой (8 байт - double)
// Сложные
#define RDS_VARTYPE_STRING      'A'     // Строка
#define RDS_VARTYPE_RUNTIME     'V'     // Изменяемый тип
#define RDS_VARTYPE_ARRAY       'M'     // Массив/матрица
#define RDS_VARTYPE_STRUCT      '{'     // Структура
#define RDS_VARTYPE_STRUCTEND   '}'     // Конец структуры
// Размеры простых переменных в дереве
#define RDS_VSZ_S               1       // Сигнал (1 байт)
#define RDS_VSZ_L               1       // Логическая (1 байт)
#define RDS_VSZ_C               1       // Целый (1 байт)
#define RDS_VSZ_H               (sizeof(short int)) // Целый (2 байта - short int)
#define RDS_VSZ_I               (sizeof(RDSINT32))  // Целый (4 байта - RDSINT32)
#define RDS_VSZ_F               (sizeof(float))     // С плавающей точкой (4 байта - float)
#define RDS_VSZ_D               (sizeof(double))    // С плавающей точкой (8 байт - double)
// Размеры сложных - один или два RDSBIGGESTPOINTERSIZE (два для массивов и произвольных,
// один - для всех остальных, см. описание)
#define RDS_VSZ_A               RDSBIGGESTPOINTERSIZE     // Строка
#define RDS_VSZ_V               (2*RDSBIGGESTPOINTERSIZE) // Изменяемый тип
#define RDS_VSZ_M               (2*RDSBIGGESTPOINTERSIZE) // Массив/матрица
#define RDS_VSZ_STRUCT          RDSBIGGESTPOINTERSIZE     // Структура
//---------------------------------------------------------------------------

// Флаги для функции rdsRegisterMenuItem, rdsChangeMenuItem
#define RDS_MENU_SHORTCUT       1       // Есть "горячая клавиша"
#define RDS_MENU_UNIQUECAPTION  2       // Не регистрировать, если уже есть пункт меню
                                        // с таким названием
#define RDS_MENU_CHECKED        4       // Есть "галочка"
#define RDS_MENU_DISABLED       8       // Пункт меню запрещен
#define RDS_MENU_HIDDEN        16       // Пункт меню невидим
#define RDS_MENU_DIVIDER       32       // Разделитель вместо пункта меню (только для контекстного,
                                        // не употребляется с другими флагами)
#define RDS_MENU_SEARCH        64       // Вызывается по Ctrl+F вместо стандартного поиска **** REV2 ****
#define RDS_MENU_TOPLEVEL      128      // Только для системного: не в "дополнительно", а непосредственно
                                        // в "система" **** REV2 ****
//---------------------------------------------------------------------------

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsCECreateEditor (объект для редактирования связи или шины)
// Через rdsCommandObject, rdsGetObjectInt)
#define RDS_HCE_RESET           0       // Очистить редактор
#define RDS_HCE_GETPOINTCOUNT   1       // Получить число точек **** REV2 ****
#define RDS_HCE_GETLINECOUNT    2       // Получить число линий **** REV2 ****
#define RDS_HCE_GETCHNCOUNT     3       // Получить число каналов **** REV2 ****
#define RDS_HCE_PROCESS         4       // Обработать (удалить пустые ветви и т.п.) **** REV2 ****
  // Флаги для RDS_HCE_PROCESS
  #define RDS_HCE_PROCESS_DELEMPTYBR    1       // Удалить пустые ветви
  #define RDS_HCE_PROCESS_DELMIDNODES   2       // Удалить лишние узлы на горизонтальных и вертикальных ветвях
// Коды ошибок функции rdsCECreateConnBus
#define RDS_HCE_ERR_OK          0       // Нет ошибок
#define RDS_HCE_ERR_BADOBJECT   1       // Параметр функции не является объектом rdsCECreateEditor
#define RDS_HCE_ERR_INVBLKBUS   2       // Один из блоков или одна из шин или связей отсутствует
#define RDS_HCE_ERR_BADLINE     3       // Одна из линий ссылается на несуществующую точку
#define RDS_HCE_ERR_ALLOC       4       // Ошибка отведения памяти
//---------------------------------------------------------------------------

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsBCLCreateList (список блоков и связей)
// Команды получения массивов (функция rdsGetObjectArray, макросы rdsBCLGetBlockArray и rdsBCLGetConnArray)
#define RDS_HBCL_BLOCKARRAY     0       // Операция с массивом блоков
#define RDS_HBCL_CONNARRAY      1       // Операция с массивом связей и шин
// Команды установки и получения целых и логических параметров (функции rdsSetObjectInt, rdsGetObjectInt)
#define RDS_HBCL_AUTODELETE     0       // Автоматически заносить в элемент массива
                                        // NULL, если блок или связь были удалены
#define RDS_HBCL_BLOCKCOUNT     1       // Число блоков в списке (только получение)
#define RDS_HBCL_CONNCOUNT      2       // Число связей в списке (только получение)
// Команды объекту
#define RDS_HBCL_CLEAR          3       // Очистить список
#define RDS_HBCL_REVBLOCKS      4       // Поменять порядок блоков на обратный **** REV2 ****
#define RDS_HBCL_REVCONNS       5       // Поменять порядок связей на обратный **** REV2 ****
// Флаги вызова функции групповой установки
#define RDS_GS_DISABLEVARCHANGE         1       // Запрет изменения переменных блока
#define RDS_GS_DISABLEVARVALUES         2       // Запрет присвоения переменным
#define RDS_GS_DISABLEEDITORPARAMS      4       // Запрет изменения параметров редактора
#define RDS_GS_DISABLEREMARKS           8       // Запрет изменения комментариев блоков
#define RDS_GS_DISABLELAYERCHANGE      16       // Запрет изменения слоя
#define RDS_GS_DISABLEDBLCLICK         32       // Запрет изменения реакции на двойной щелчок
#define RDS_GS_DISABLEPICTURE          64       // Запрет изменения картинки и ее параметров
#define RDS_GS_DISABLEDRAWTYPE        128       // Запрет изменения типа рисования (DLL/картинка)
#define RDS_GS_DISABLEBLOCKAPPEARANCE 256       // Запрет изменения параметров внешнего вида
                                                // (изображение имени, точки привязки и т.п.)
#define RDS_GS_DISABLESIZING          512       // Запрет изменения параметров масштабирования
#define RDS_GS_DISABLECONNAPPEARANCE 1024       // Запрет изменения внешнего вида связи
#define RDS_GS_DISABLECONNSTATE      2048       // Запрет включения/выключения связи
#define RDS_GS_DISABLEBUSPACK        4096       // Запрет удаления пустых каналов шин
#define RDS_GS_DISABLEDLLFUN         8192       // Запрет изменения функции отклика
#define RDS_GS_DISABLEDLLOPTIONS    16384       // Запрет изменения флагов реакции функции (всех)
#define RDS_GS_DISABLEAUTOCOMP      32768       // Запрет изменения параметров автокомпиляции
#define RDS_GS_DISABLEMOVING        65536       // Запрет изменения параметров перемещения **** REV2 ****
#define RDS_GS_DISABLEEXTCONNPARAMS 0x20000     // Запрет изменения дополнительных параметров связи **** REV2 ****
#define RDS_GS_DISABLECLASSES       0x40000     // Запрет изменения классов **** REV2 ****
//---------------------------------------------------------------------------

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsVSCreateEditor (набор переменных)
// Флаги редактора
#define RDS_HVAR_FSTRUCT        1       // Разрешено использование структур
#define RDS_HVAR_FARRAYS        2       // Разрешено использование массивов и матриц
#define RDS_HVAR_F1INDEX        4       // Разрешено использование массивов с одним индексом
#define RDS_HVAR_FRUNTIME       8       // Разрешено использование изменяемых типов
#define RDS_HVAR_FARROFSTRUCT  16       // Разрешено использование массивов структур
#define RDS_HVAR_FINT          32       // Разрешено использование RDSINT32
#define RDS_HVAR_FDOUBLE       64       // Разрешено использование double
#define RDS_HVAR_FCHAR        128       // Разрешено использование char
#define RDS_HVAR_FSHORT       256       // Разрешено использование short RDSINT32
#define RDS_HVAR_FFLOAT       512       // Разрешено использование float
#define RDS_HVAR_FLOGICAL    1024       // Разрешено использование однобайтовых логических
#define RDS_HVAR_FSIGNAL     2048       // Разрешено использование сигналов
#define RDS_HVAR_FSTRING     4096       // Разрешено использование строк
#define RDS_HVAR_FNOSTRUCTNAME 8192     // Для редактирования структуры - не показывать имя
#define RDS_HVAR_FNOOFFSET  16384       // Не показывать колонку смещения
#define RDS_HVAR_FNOREMARKS 32768       // Запретить комментарии переменных **** REV2 ****
#define RDS_HVAR_FNOINTERNAL 0x10000    // Запретить внутренние переменные **** REV2 ****
#define RDS_HVAR_FNOCTRLVARS 0x20000    // Запретить управляющие переменные (вход/сигнал, выход/логический) **** REV2 ****
#define RDS_HVAR_FMINIMAL    0x40000    // Только имя, тип и вход/выход **** REV2 ****
#define RDS_HVAR_FALLPLAIN   (32+64+128+256+512+1024+2048) // Все простые типы
#define RDS_HVAR_FALLPLAINNS (32+64+128+256+512+1024) // Все простые типы без сигналов
#define RDS_HVAR_FALL        (1+2+4+8+16+RDS_HVAR_FALLPLAIN+4096) // Все типы
#define RDS_HVAR_FALLNS      (1+2+4+8+16+RDS_HVAR_FALLPLAINNS+4096) // Все типы без сигналов
// Результаты
#define RDS_HVAR_ROK            0       // Операция выполнена успешно
#define RDS_HVAR_ROKRENAMED     1       // Операция выполнена успешно, но структура переименована
#define RDS_HVAR_RNOTYPENAME    2       // Для операции требуется, чтобы у структуры
                                        // было имя типа
#define RDS_HVAR_RVARCHECKERR   3       // Блок не может работать с такой структурой
#define RDS_HVAR_REMPTYVARSET   4       // Набор переменных пуст
#define RDS_HVAR_RBADBLOCKTYPE  5       // Недопустимый тип блока
#define RDS_HVAR_RNOBLKSIGNALS  6       // Набор переменных не может быть назначен блоку т.к.
                                        // в нем нет двух сигналов в начале
#define RDS_HVAR_RBADFORIO      7       // Набор переменных не может быть назначен блоку-входу или выходу т.к.
                                        // в нем больше одной переменной **** REV2 ****
// Команды (возврат целого числа)
#define RDS_HVAR_GETFIELDCOUNT  0       // Получить число полей структуры
#define RDS_HVAR_GETAUTOCOUNT   1       // Получить число автоматических соединений
#define RDS_HVAR_GETVARRANK     2       // Получить уровень переменной
#define RDS_HVAR_GETVARFLAGS    12      // Получить флаги переменной
// Команды (возврат строки)
#define RDS_HVAR_GETTYPENAME    3       // Получить строку типа структуры
#define RDS_HVAR_GETAUTOMAIN    4       // Получить имя главной переменной автосоединения
                                        // с указанным номером
#define RDS_HVAR_GETAUTOCONN    5       // Получить имя связанной переменной автосоединения
                                        // с указанным номером
#define RDS_HVAR_GETTYPESTRING  13      // Получить строку типа всей структуры                                        
#define RDS_HVAR_GETREMARK      14      // Получить комментарий переменной с указанным номером **** REV2 ****
// Команды (установка целого числа)
#define RDS_HVAR_SETVARFLAGS    RDS_HVAR_GETVARFLAGS    // Установить флаги переменной
// Команды (установка строки)
#define RDS_HVAR_SETTYPENAME    6       // Установить строку типа структуры
#define RDS_HVAR_SETREMARK      15      // Установить комментарий переменной с указанным номером **** REV2 ****
// Команды (без возврата)
#define RDS_HVAR_RESET          7       // Очистить редактор
#define RDS_HVAR_DELVAR         8       // Удалить переменную
#define RDS_HVAR_DELAUTO        9       // Удалить автосоединение
#define RDS_HVAR_CLEARTYPEREN   10      // Очистить список переименований типов
#define RDS_HVAR_CLEARENAMES    RDS_HVAR_CLEARTYPEREN      // Синоним
#define RDS_HVAR_CLEARVARREN    11      // Очистить список переименований переменных
//---------------------------------------------------------------------------

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsSTRCreateTextReader (простой анализ слов текста)
#define RDS_HSTR_DEFUNKNOWNWORD         -1      // Идентификатор неопознанного слова по умолчанию
#define RDS_HSTR_DEFENDOFLINE           -2      // Идентификатор конца строки по умолчанию
#define RDS_HSTR_DEFENDOFTEXT           -3      // Идентификатор конца текста по умолчанию
// Команды установки и получения целых и логических параметров (функции rdsSetObjectInt, rdsGetObjectInt)
#define RDS_HSTR_IGNORECASE     0       // Учитывать (1) или не учитывать (0) регистр при анализе
#define RDS_HSTR_UNKNOWNID      1       // Идентификатор неопознанного слова
#define RDS_HSTR_ENDOFLINEID    2       // Идентификатор конца строки
#define RDS_HSTR_ENDOFTEXTID    3       // Идентификатор конца текста
#define RDS_HSTR_READINT        7       // Считать из текста целое число (только получение)
// Команды установки строки
#define RDS_HSTR_SETTEXT        4       // Установить текст для анализа
// Команды получения строки
#define RDS_HSTR_GETLASTWORD    5       // Получить последнее считанное слово
#define RDS_HSTR_GETRESTOFTEXT  6       // Получить указатель на остаток текста после чтения
// Команды плучения вещественных чисел
#define RDS_HSTR_READDOUBLE     8       // Считать из текста число double

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsINICreateTextHolder (разбор данных формата INI-файла)
// Команды
#define RDS_HINI_RESET          0       // Очистка текста
#define RDS_HINI_GETLASTERROR   4       // Получить флаг ошибки последней операции
#define RDS_HINI_SAVEBLOCKTEXT  7       // Записать как текстовый формат блока
// Команды установки строки
#define RDS_HINI_SETTEXT        1       // Установить текст
#define RDS_HINI_LOADFILE       2       // Загрузить файл
#define RDS_HINI_SAVEFILE       3       // Записать файл
#define RDS_HINI_CREATESECTION  5       // Создать секцию
#define RDS_HINI_DELETESECTION  6       // Удалить секцию
#define RDS_HINI_DELETEKEYLAST  8       // Удалить значение в последней открытой секции
// Команда получения строки
#define RDS_HINI_GETTEXT        9       // Сформировать текст (результат действителен до следующего запроса) **** REV2 ****
#define RDS_HINI_GETSECTIONS    10      // Сформировать список секций через \n (результат действителен до следующего запроса) **** REV2 ****
#define RDS_HINI_GETKEYSLAST    11      // Сформировать список имен в последней открытой секции через \n (результат действителен до следующего запроса) **** REV2 ****

// Результат возврата некоторых функций, действие которых может быть отложено
#define RDS_FRESULT_ERROR       0       // Ошибка
#define RDS_FRESULT_OK          1       // Функция выполнена
#define RDS_FRESULT_DELAYED     2       // Функция отложена

// Флаги, используемые функциями rdsGetEditorWindowFlags и rdsSetEditorWindowFlags
#define RDS_EWF_STATUSBAR       1       // Есть строка состояния
#define RDS_EWF_LAYERSTOOLBAR   2       // Панель инструментов - слои
#define RDS_EWF_ZOOMTOOLBAR     4       // Панель инструментов - масштаб
#define RDS_EWF_DISPLAYTOOLBAR  8       // Панель инструментов - изображение
#define RDS_EWF_CALCTOOLBAR    16       // Панель инструментов - расчет и режимы
#define RDS_EWF_PRINTTOOLBAR   32       // Панель инструментов - печать
#define RDS_EWF_NOSCROLLBARS   64       // Нет полос прокрутки **** REV2 ****
#define RDS_EWF_WINMOUSE      128       // Окно реагирует на "мышь" после блоков **** REV2 ****
#define RDS_EWF_WINFREEMOUSE  256       // Окно реагирует на перемещения "мыши" **** REV2 ****
                                        // с отпущенными кнопками (после блоков)
#define RDS_EWF_WINKEYBOARD   512       // Окно реагирует на клавиатуру после блоков **** REV2 ****
// Маски и наборы флагов для тех же функций
#define RDS_EWF_ALLBARS        (1+2+4+8+16+32)  // Все панели и строка состояния

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsFORMCreate (объект для создания модального окна)
// Команды
#define RDS_FORM_CLEAR          0       // Очистить
#define RDS_FORM_SHOWMODAL      1       // Показать
#define RDS_FORM_INVALIDATE     2       // Перерисовать
#define RDS_FORM_CLOSE          3       // Закрыть (как "OK" или "Отмена") **** REV2 ****
#define RDS_FORM_TEMPCLOSE      4       // Закрыть, выполнить реакцию и открыть снова **** REV2 ****
#define RDS_FORM_SORTRESULTS    5       // Сортировать результаты поиска (только для окон поиска) **** REV2 ****
#define RDS_FORM_CLOSEBUTTON    6       // Заменить кнопки "OK" и "Отмена" на "Закрыть" (только до открытия окна) **** REV2 ****
#define RDS_FORM_SHOWTAB        7       // Включение видимости заголовка вкладки **** REV2 ****
#define RDS_FORM_HIDETAB        8       // Выключение видимости заголовка вкладки **** REV2 ****
#define RDS_FORM_ACTIVATETAB    9       // Выбор вкладки **** REV2 ****
// Типы полей ввода (младший байт DWORD, передаваемого в rdsFORMAddEdit)
#define RDS_FORMCTRL_EDIT       0       // Простое поле ввода
#define RDS_FORMCTRL_COMBOEDIT  1       // Поле ввода со списком вариантов
#define RDS_FORMCTRL_COMBOLIST  2       // Список вариантов без возможности редактирования
#define RDS_FORMCTRL_CHECKBOX   3       // Флаг (не может сочетаться с RDS_FORMFLAG_CHECK)
#define RDS_FORMCTRL_LABEL      4       // Надпись без возможности редактирования
#define RDS_FORMCTRL_COLOR      5       // Кнопка выбора цвета
#define RDS_FORMCTRL_OPENDIALOG 6       // Поле ввода для выбора файла (открытие, с диалогом)
#define RDS_FORMCTRL_SAVEDIALOG 7       // Поле ввода для выбора файла (сохранение, с диалогом)
#define RDS_FORMCTRL_UPDOWN     8       // Поле ввода со стрелками
#define RDS_FORMCTRL_DISPLAY    9       // Индикация значения без возможности редактирования
#define RDS_FORMCTRL_MULTILINE  10      // Поле ввода из нескольких строк
#define RDS_FORMCTRL_LISTANDEDIT 11     // Выпадающий список и поле ввода
#define RDS_FORMCTRL_RANGEEDIT  12      // Два поля ввода, разделенных "..."
#define RDS_FORMCTRL_NONVISUAL  13      // Просто хранимые данные (не отображаются в окне)
#define RDS_FORMCTRL_PAINTBOX   14      // Область, рисуемая служебной функцией
#define RDS_FORMCTRL_RADIOBUTTON 15     // Флаг, исключающий другие (не может сочетаться с RDS_FORMFLAG_CHECK)
#define RDS_FORMCTRL_BUTTON     16      // Кнопка
#define RDS_FORMCTRL_FONTSELECT 17      // Кнопка выбора шрифта
#define RDS_FORMCTRL_HOTKEY     18      // Поле ввода для сочетания клавиш
#define RDS_FORMCTRL_DIRDIALOG  19      // Поле ввода для выбора папки (с диалогом)
#define RDS_FORMCTRL_MULTILABEL 20      // Многострочная надпись без возможности редактирования **** REV2 ****
#define RDS_FORMCTRL_TABLE      21      // Таблица **** REV2 ****
#define RDS_FORMCTRL_VARTYPE    22      // Тип переменной **** REV2 ****
#define RDS_FORMCTRL_BUTTONS    23      // Набор кнопок (горизонтальный) **** REV2 ****
#define RDS_FORMCTRL_EDITANDBUTTON 24   // Поле ввода и кнопка **** REV2 ****
#define RDS_FORMCTRL_LIST       25      // Cписок (выбор строки из вертикального списка) **** REV2 ****
#define RDS_FORMCTRL_EDITANDCOLOR 26   // Поле ввода и кнопка выбора цвета **** REV2 ****
// Флаги полей (старшая часть DWORD, передаваемого в rdsFORMAddEdit)
#define RDS_FORMFLAG_LINE       0x100   // Рельефная линия под полем
#define RDS_FORMFLAG_CHECK      0x200   // С разрешающим/запрещающим флагом
#define RDS_FORMFLAG_DISABLED   0x400   // Поле ввода запрещено целиком (вместе с флагом, если он есть)
#define RDS_FORMFLAG_LRIGHT     0x800   // Метка поля ввода выровнена по правому краю
#define RDS_FORMFLAG_LCENTER    0x1000  // Метка поля ввода выровнена по центру
#define RDS_FORMFLAG_CHECKRADIO 0x2000  // Разрешающий/запрещающий флаг - RadioButton (при RDS_FORMFLAG_CHECK)
// Типы передаваемых и получаемых значений для функций rdsSetObject* и rdsGetObject* или
// заменяющих их макросов rdsFORMSet* и rdsFORMGet*.
#define RDS_FORMVAL_VALUE       0       // Значение органа управления (установка и чтение)
#define RDS_FORMVAL_LIST        1       // Список вариантов для RDS_FORMCTRL_COMBOEDIT и
                                        // RDS_FORMCTRL_COMBOLIST или список фильтров для
                                        // RDS_FORMCTRL_OPENDIALOG/RDS_FORMCTRL_SAVEDIALOG (только установка)
#define RDS_FORMVAL_CHECK       2       // Значение разрешающего/запрещающего флага (установка и чтение)
#define RDS_FORMVAL_UPDOWNINC   3       // Изменение для RDS_FORMCTRL_UPDOWN (установка и чтение)
#define RDS_FORMVAL_UPDOWNMIN   4       // Минимум для RDS_FORMCTRL_UPDOWN (установка и чтение)
#define RDS_FORMVAL_UPDOWNMAX   5       // Максимум для RDS_FORMCTRL_UPDOWN (установка и чтение)
#define RDS_FORMVAL_MLHEIGHT    6       // Высота для RDS_FORMCTRL_MULTILINE и RDS_FORMCTRL_MULTILABEL **** REV2 **** (только установка)
#define RDS_FORMVAL_ENABLED     7       // Общая разрешенность органа управления (установка и чтение)
                                        //-------- Для RDS_FORMCTRL_LISTANDEDIT ----------
#define RDS_FORMVAL_AUXLISTITEM 8       // Номер пункта вспомогательного списка для RDS_FORMCTRL_LISTANDEDIT (установка и чтение)
#define RDS_FORMVAL_AUXLISTWIDTH 9      // Ширина вспомогательного списка для RDS_FORMCTRL_LISTANDEDIT (только установка)
#define RDS_FORMVAL_2NDEDITENABLED 10   // Разрешенность второго поля ввода для RDS_FORMCTRL_LISTANDEDIT
#define RDS_FORMVAL_ITEMINDEX   11      // Номер выбранного пункта для RDS_FORMCTRL_COMBOLIST (даже если запрашивается строка,
                                        // возвращается символьное представление номера, а не название выбранного пункта)
                                        //-------- Для RDS_FORMCTRL_PAINTBOX ----------
#define RDS_FORMVAL_PBHEIGHT    RDS_FORMVAL_MLHEIGHT       // Высота для RDS_FORMCTRL_PAINTBOX (только установка)
#define RDS_FORMVAL_PBBEVEL     RDS_FORMVAL_AUXLISTWIDTH   // Наличие рамки для RDS_FORMCTRL_PAINTBOX (только установка)
                                        //-------- Для RDS_FORMCTRL_RANGEEDIT ----------
#define RDS_FORMVAL_RANGEMAX    RDS_FORMVAL_UPDOWNMAX  // Максимум для RDS_FORMCTRL_RANGEEDIT (установка и чтение)
                                        //-------- Для RDS_FORMCTRL_HOTKEY ----------
#define RDS_FORMVAL_HKSHIFTS    RDS_FORMVAL_MLHEIGHT    // Флаги Ctrl,Shift,Alt
                                        //-------- RDS_FORMCTRL_MULTILINE ---------
#define RDS_FORMVAL_MLRETURNS   RDS_FORMVAL_AUXLISTITEM // Разрешение переводов строк в поле
#define RDS_FORMVAL_MLREADONLY  RDS_FORMVAL_AUXLISTWIDTH // Только чтение **** REV2 ****
#define RDS_FORMVAL_MLBEVEL     RDS_FORMVAL_2NDEDITENABLED // Вид рамки (0,1,2 - только установка) **** REV2 ****
                                        //--------  RDS_FORMCTRL_MULTILABEL ---------  **** REV2 ****
#define RDS_FORMVAL_MLABELBEVEL  RDS_FORMVAL_AUXLISTWIDTH   // Наличие рамки для RDS_FORMCTRL_MULTILABEL (только установка)  **** REV2 ****
                                        //-------- RDS_FORMCTRL_EDITANDCOLOR ---------  **** REV2 ****
#define RDS_FORMVAL_AUXCOLOR RDS_FORMVAL_AUXLISTITEM     // Цвет кнопки справа от поля ввода
#define RDS_FORMVAL_AUXCOLORWIDTH RDS_FORMVAL_AUXLISTWIDTH // Ширина кнопки
                                        //--------  Файловые диалоги ---------  **** REV2 ****
#define RDS_FORMVAL_DEFPATH      12     // Путь по умолчанию для файловых диалогов **** REV2 ****
                                        //--------  RDS_FORMCTRL_TABLE ---------  **** REV2 ****
                                        // (rdsSetObjectInt и, кое-где, rdsSetObjectStr)
#define RDS_FORMVAL_TABLEHEIGHT  13     // Высота всей таблицы (только установка)
#define RDS_FORMVAL_TBLBTN_ADD   14     // Видимость (rdsSetObjectInt) или подсказка (rdsSetObjectStr) кнопки "добавить" (только установка)
#define RDS_FORMVAL_TBLBTN_UP    15     // Видимость или подсказка кнопки "вверх" (видимость автоматически включает и "вниз", только установка)
#define RDS_FORMVAL_TBLBTN_DOWN  16     // Видимость или подсказка кнопки "вниз" (видимость автоматически включает и "вверх", только установка)
#define RDS_FORMVAL_TBLBTN_PROP  17     // Видимость или подсказка кнопки "свойства" (только установка)
#define RDS_FORMVAL_TBLBTN_DEL   18     // Видимость или подсказка кнопки "удалить" (только установка)
#define RDS_FORMVAL_TBLHEADERS   19     // Наличие/отсутствие строки заголовка (установка/чтение)
#define RDS_FORMVAL_TBLFIXEDCOL  20     // Наличие/отсутствие фиксированного нулевого столбца (установка/чтение)
#define RDS_FORMVAL_TBLHDRHEIGHT 21     // Высота строки заголовка (в точках экрана, установка/чтение)
#define RDS_FORMVAL_TBLLINEHEIGHT 22    // Высота строк данных (в точках экрана, установка/чтение)
#define RDS_FORMVAL_TBLCOUNT     23     // Число строк (только чтение)
#define RDS_FORMVAL_TBLDELLINE   24     // Удалить строку (только установка)
#define RDS_FORMVAL_TBLEMPTYTEXT 25     // Текст, выводимый для пустой таблицы вместо сетки
#define RDS_FORMVAL_TBLREDRAW    26     // Перерисовать таблицу (независимо от значения)
#define RDS_FORMVAL_TBLINSLINE   27     // Вставить строку (только установка)
#define RDS_FORMVAL_TBLAUTOINS   28     // Управление автоматической вставкой строк
#define RDS_FORMVAL_TBLMINLINES  29     // Минимальное число строк в таблице
                                        //-------- Для RDS_FORMCTRL_COMBOLIST ----------
#define RDS_FORMVAL_INDEXBYSTR   30     // Установка номера по текстовому названию пункта (список уже должен быть установлен) **** REV2 ****
                                        //-------- Для RDS_FORMCTRL_VARTYPE ----------
#define RDS_FORMVAL_EXSTRUCT     31     // Установка имени исключаемой из списка структуры **** REV2 ****
#define RDS_FORMVAL_MAXMATRLEVEL 32     // Установка максимальной вложенности матриц **** REV2 ****
#define RDS_FORMVAL_VARTYPEFLAGS 33     // Установка флагов разрешенных типов переменных (RDS_HVAR_*) **** REV2 ****
#define RDS_FORMVAL_MATRLEVEL    34     // Установка значения: глубина вложенности матрицы **** REV2 ****
#define RDS_FORMVAL_ONEINDEX     35     // Установка значения: одноиндексность массива **** REV2 ****
#define RDS_FORMVAL_STRUCT       36     // Установка значения: имя структуры **** REV2 ****
                                        //-------- RDS_FORMCTRL_MULTILINE ---------
#define RDS_FORMVAL_MLNOWRAP     37     // Запрет переноса длинных строк **** REV2 ****
                                        //---  Универсальные ---  **** REV2 ****
#define RDS_FORMVAL_READONLY     38     // Запрет редактирования текста для тех, кто поддерживает
                                        //-------- Для RDS_FORMCTRL_BUTTONS -------**** REV2 ****
#define RDS_FORMVAL_BTNS_WIDTH   RDS_FORMVAL_UPDOWNMIN   // Ширина одной кнопки
#define RDS_FORMVAL_BTNS_GAP     RDS_FORMVAL_UPDOWNINC   // Зазор между кнопками
                                        //---  RDS_FORMCTRL_EDITANDBUTTON
#define RDS_FORMVAL_EDITBTNWIDTH RDS_FORMVAL_UPDOWNMIN  // Ширина кнопки
#define RDS_FORMVAL_EDITBTNTEXT  RDS_FORMVAL_UPDOWNINC     // Текст на кнопке
                                        //---  RDS_FORMCTRL_TABLE (продолжение) ---  **** REV2 ****
#define RDS_FORMVAL_TBLBTN_SHOW  39     // Видимость или подсказка кнопки со стрелкой (только установка)
#define RDS_FORMVAL_TBLSUSPEND   40     // Приостановить обновление (rdsSetObjectInt/rdsGetObjectInt)
#define RDS_FORMVAL_TBLCLEAR     41     // Очистить (rdsSetObjectInt)
                                        //---  RDS_FORMCTRL_RANGEEDIT ---  **** REV2 ****
#define RDS_FORMVAL_RANGEDIV     RDS_FORMVAL_UPDOWNINC   // Текст между двумя полями
                                        //--- RDS_FORMCTRL_PAINTBOX ---  **** REV2 ****
#define RDS_FORMVAL_PBOXREDRAW   RDS_FORMVAL_TBLREDRAW   // Перерисовать (независимо от значения)
#define RDS_FORMVAL_TYPE         42     // Тип поля (rdsGetObjectInt)

// Типы кнопок для rdsFORMSetMainButtons
#define RDS_FORMMB_OK           1       // OK
#define RDS_FORMMB_CANCEL       2       // Отмена
#define RDS_FORMMB_CLOSE        3       // Закрыть (для RDS_FORM_CLOSEBUTTON)

// События для универсальной служебной функции модального окна
#define RDS_FORMSERVEVENT_CHANGE        0       // Изменение одного или нескольких полей ввода
#define RDS_FORMSERVEVENT_DRAW          1       // Рисование (панели или ячейки таблицы)
#define RDS_FORMSERVEVENT_CLICK         2       // Нажатие кнопки
#define RDS_FORMSERVEVENT_HELP          3       // Нажатие кнопки справки  **** REV2 ****
#define RDS_FORMSERVEVENT_TCREACTION    4       // Реакция после временного закрытия  **** REV2 ****
#define RDS_FORMSERVEVENT_TCREOPEN      5       // Открытие после временного закрытия  **** REV2 ****
#define RDS_FORMSERVEVENT_TBLBUTTON     6       // Нажатие кнопки таблицы  **** REV2 ****
#define RDS_FORMSERVEVENT_TBLBTNENABLE  7       // Проверка разрешенности кнопок добавления и удаления в таблице **** REV2 ****
#define RDS_FORMSERVEVENT_TBLDATACHANGE 8       // Пользователь изменил данные в таблице **** REV2 ****
#define RDS_FORMSERVEVENT_SEARCH        9       // Выполнение поиска **** REV2 ****
#define RDS_FORMSERVEVENT_ENABLECHECK   10      // Пользователь изменил состояние вспомогательного флажка разрешения поля **** REV2 ****
#define RDS_FORMSERVEVENT_OK            11      // Пользователь нажал "OK" **** REV2 ****
#define RDS_FORMSERVEVENT_CANCEL        12      // Пользователь нажал "Отмена" **** REV2 ****
#define RDS_FORMSERVEVENT_CLOSE         13      // Пользователь закрывает окно **** REV2 ****
// Флаги для rdsFORMHelpButton  **** REV2 ****
#define RDS_FORMHELP_UI         1       // Справка через файл UI (сброшен - указывается сам файл справки)
#define RDS_FORMHELP_EVENT      2       // Создавать событие в функции обратного вызова вместо показа справки
#define RDS_FORMHELP_CHECK      4       // Проверить существование файла справки (если не через событие)
// Структура для универсальной служебной функции модального окна
typedef struct // RDS_FORMSERVFUNCDATA
{ union
    { RDSINT32 Event;                  // Событие (RDS_FORMSERVEVENT_*)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 CtrlId;                 // Идентификатор органа управления (если требуется для данного события)
      RDSBIGGESTTYPE align1;
    };

  // Для RDS_FORMSERVEVENT_DRAW
  union
    { HDC dc;                          // Где рисовать (контекст, см. WinAPI)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 Left;                   // Верхний левый угол зоны рисования
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 Top;
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 Width;                  // Размеры зоны рисования
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 Height;
      RDSBIGGESTTYPE align6;
    };

  // Дополнительно для рисования таблицы  **** REV2 ****
  union
    { RDSINT32 TableRow;               // Ячейка таблицы, если идет рисование таблицы
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSINT32 TableCol;               // для строки заголовка TableRow=-1), TableRow также используется в реакциях на кнопки таблицы
      RDSBIGGESTTYPE align8;
    };
  union
    { RDSINT32 ColId;                  // Идентификатор столбца таблицы (по заголовку, только при рисовании таблицы)
      RDSBIGGESTTYPE align9;
    };
  union
    { RDSCSTR CellValueA;              // Значение ячейки таблицы (UTF8, только при рисовании таблицы)
      RDSBIGGESTTYPE align10;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR CellValue;
      #endif
    };
  union
    { RDSWCSTR CellValueW;             // То же в UTF16
      RDSBIGGESTTYPE align11;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR CellValue;
      #endif
    };
  union
    { COLORREF BGColor;                // Цвета фона и текста текущей ячейки таблицы (только при рисовании таблицы)
      RDSBIGGESTTYPE align12;
    };
  union
    { COLORREF FGColor;
      RDSBIGGESTTYPE align13;
    };
  union
    { RDSINT32 CellAlignment;          // Выравнивание ячейки таблицы
      RDSBIGGESTTYPE align14;
    };
  union
    { BOOL DefaultTableDraw;           // Устанавливается в реакции в TRUE, если нужно нарисовать ячейку таблицы по умолчанию
      RDSBIGGESTTYPE align15;
    };

  // Для RDS_FORMSERVEVENT_TBLBUTTON и RDS_FORMSERVEVENT_TBLBTNENABLE **** REV2 ****
  // Для указания строки таблицы, если нужно, используется TableRow
  union
    { RDSINT32 Button;                 // Кнопка (RDS_FORMVAL_TBLBTN_*) или индекс кнопки в полосе кнопок (RDS_FORMCTRL_BUTTONS)
      RDSBIGGESTTYPE align16;
    };
  union
    { RDSINT32 ButtonResult;           // Результат (зависит от кнопки), см. ниже
      RDSBIGGESTTYPE align17;
    };
  union
    { RDSINT32 IndexAfterButton;       // Новый индекс строки, который нужно установить после реакции, или -1
      RDSBIGGESTTYPE align18;
    };
} RDS_FORMSERVFUNCDATA;
// Значения RDS_FORMSERVFUNCDATA::ButtonResult
#define RDS_FORMSERVRESULT_OK       1       // Нормальное завершение
#define RDS_FORMSERVRESULT_NO       0       // Отмена действия
typedef RDS_FORMSERVFUNCDATA *RDS_PFORMSERVFUNCDATA;
//---------------------------------------------------------------------------

// Структура для функции rdsBlockOrConnByExtId
typedef struct // RDS_FINDBYEXTIDDATA
{ union
    { DWORD servSize;          // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Found;              // Что-то найдено
      RDSBIGGESTTYPE align1;
    };
  union
    { RDS_BHANDLE Block;       // Найденный блок
      RDSBIGGESTTYPE align2;
    };
  union
    { RDS_CHANDLE Conn;        // Найденная связь или шина
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 Type;           // Тип найденного объекта (RDS_BT*,RDS_CT* или RDS_TUNKNOWN)
      RDSBIGGESTTYPE align4;
    };
} RDS_FINDBYEXTIDDATA;
typedef RDS_FINDBYEXTIDDATA *RDS_PFINDBYEXTIDDATA;
//---------------------------------------------------------------------------

// Константы для функции rdsProcessText
#define RDS_PT_TEXTTOSTRING     0       // Преобразование спецсимволов в символическое представление
#define RDS_PT_STRINGTOTEXT     1       // Обратная к RDS_PT_TEXTTOSTRING
#define RDS_PT_VARTYPETEXT      2       // Текстовое описание типа переменной по первой букве строки (RDS_VARTYPE_*)
#define RDS_PT_VARTYPECHAR      3       // Cтрока из одного символа RDS_VARTYPE_* по строке описания типа переменной
// **** REV2 ****
#define RDS_PT_RDSRUSENCODE     4       // Русские символы - в латинские с подчеркиванием
#define RDS_PT_RDSRUSDECODE     5       // Латинские символы с подчеркиванием - в русские
#define RDS_PT_ENCODEURICOMP    6       // Аналог encodeURIComponent в JavaScript
#define RDS_PT_DECODEURICOMP    7       // Аналог decodeURIComponent в JavaScript
#define RDS_PT_TEXTTOSTRINGSL   8       // Преобразование спецсимволов в символическое представление, замена '/' на '0x2f'
#define RDS_PT_UTF8TOANSI       9       // UTF8->ANSI
#define RDS_PT_ANSITOUTF8       10      // ANSI->UTF8
#define RDS_PT_UPPERCASE        11      // В верхний регистр
#define RDS_PT_ANSIUPPERCASE    RDS_PT_UPPERCASE
#define RDS_PT_LOWERCASE        12      // В нижний регистр
#define RDS_PT_ANSILOWERCASE    RDS_PT_LOWERCASE
#define RDS_PT_REMOVECRLF       13      // Заменить все переводы строк на пробелы
#define RDS_PT_GETVARNAME       14      // Вытащить из "имя комментарий" имя переменной блока
#define RDS_PT_GETVARREMARK     15      // Вытащить из "имя комментарий" комментарий переменной блока
#define RDS_PT_TRIM             16      // Удалить пробелы, табуляции и т.п. в начале и конце строки
#define RDS_PT_CODEHIGHCHARSU8  17      // Заменить символы со взведенным старшим битом на их коды (для UTF8)
#define RDS_PT_QUOTECHIGHCHARSU8 18     // Заменить в строках в кавычках программы на Си символы со взведенным старшим битом на их коды (для UTF8)
#define RDS_PT_FIXLEGACYSYMBOL  19      // Перекодировка строки для шрифта "Symbol" при загрузке схем старой версии
//---------------------------------------------------------------------------

// Константы для функции rdsShowBlockPanelTab
#define RDS_BLOCKPANELOP_HIDE           0       // Спрятать вкладку
#define RDS_BLOCKPANELOP_SHOW           1       // Показать вкладку
#define RDS_BLOCKPANELOP_HIDEEXCEPT     2       // Спрятать все, кроме указанной
#define RDS_BLOCKPANELOP_SHOWALL        3       // Показать все
#define RDS_BLOCKPANELOP_SELECT         4       // Сделать текущей
//---------------------------------------------------------------------------

// Константы для функции rdsSetBlockAltNameText
#define RDS_ALTBLKNAME_LEFT             -1      // Выравнивание влево
#define RDS_ALTBLKNAME_CENTER           0       // Выравнивание по центру
#define RDS_ALTBLKNAME_RIGHT            1       // Выравнивание вправо
//---------------------------------------------------------------------------

// Константы для функции rdsExecuteCommand
#define RDS_SYSCMD_STARTCALC            0       // Запустить расчет
#define RDS_SYSCMD_LOADFILE             1       // Загрузить файл
#define RDS_SYSCMD_SAVEFILE             2       // Записать файл
#define RDS_SYSCMD_LOADTEMPLATE         3       // Загрузить шаблон
#define RDS_SYSCMD_MESSAGEBOX           4       // Вывести окно с сообщением
#define RDS_SYSCMD_EDITMODE             5       // Перейти в режим редактирования
#define RDS_SYSCMD_CALCMODE             6       // Перейти в режим моделирования
#define RDS_SYSCMD_RESETCALC            7       // Сбросить расчет для всей схемы
#define RDS_SYSCMD_REFRESH              8       // Обновить окна для указанной подсистемы **** REV2 ****
#define RDS_SYSCMD_COMPILE              9       // Компилировать модель или все модели **** REV2 ****
#define RDS_SYSCMD_DELAYEDTOOLCALL      10      // Отложенный вызов модуля расширения без параметра (дублируется rdsExecToolDelayed) **** REV2 ****
#define RDS_SYSCMD_QUIT                 11      // Завершить RDS **** REV2 ****
#define RDS_SYSCMD_CLOSEMODALWIN        12      // Закрыть все модальные окна **** REV2 ****
#define RDS_SYSCMD_DELAYEDBLOCKCALL     13      // Отложенный вызов блока **** REV3 ****
// Флаги для команд RDS_SYSCMD_LOADFILE и RDS_SYSCMD_LOADTEMPLATE
#define RDS_SYSCMDF_KEEPQUEUE           1       // Не очищать очередь команд после загрузки **** REV2 ****
#define RDS_SYSCMDF_KEEPTOOLS           2       // Не выгружать модули расширения перед загрузкой **** REV2 ****
// Флаг для команды RDS_SYSCMD_REFRESH
#define RDS_SYSCMDF_RECURSE             1       // Обновить все вложенные окна **** REV2 ****
// Флаг для команды RDS_SYSCMD_COMPILE
#define RDS_SYSCMDF_REBUILD             1       // Принудительно компилировать **** REV2 ****
// Флаг для команды RDS_SYSCMD_SAVEFILE
#define RDS_SYSCMDF_FORCEDIR            1       // Создать директорию, если ее нет **** REV2 ****
#define RDS_SYSCMDF_SERVSAVE            2       // Служебное сохранение (без изменения текущей загруженной) **** REV2 **** 2021_05_12
//---------------------------------------------------------------------------

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsPBARCreate (ProgressBar)
// Команды
#define RDS_PBAR_RESET                  0       // Сбросить позицию в 0
#define RDS_PBAR_SHOW                   1       // Показать окно
#define RDS_PBAR_HIDE                   2       // Убрать окно
// Команды установки и получения целых параметров (функции rdsSetObjectInt, rdsGetObjectInt)
#define RDS_PBAR_MAX                    0       // Максимальное значение
#define RDS_PBAR_POSITION               1       // Текущее значение
#define RDS_PBAR_ADDTOPOS               2       // Добавить значение к текущему (только установка)
// Команды установки строки
#define RDS_PBAR_SETCAPTION             3       // Установить текст заголовка
//---------------------------------------------------------------------------

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsBEUCreate (undo изменения параметров блока)
// Команды
#define RDS_BEU_STORECHANGED            0       // Запомнить изменившиеся параметры
#define RDS_BEU_JOINNEXT                1       // Объединить со следующей операцией  **** REV2 ****

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsCEUCreate (undo изменения параметров связи)
// Команды
#define RDS_CEU_STORECHANGED            0       // Запомнить изменившиеся параметры  **** REV2 ****
#define RDS_CEU_JOINNEXT                1       // Объединить со следующей операцией  **** REV2 ****

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsPANCreate (панель в окне подсистемы)
// Флаги rdsPANCreate
#define RDS_PAN_F_BORDER        1       // У панели есть рамка
#define RDS_PAN_F_SCALABLE      2       // Панель меняет размер согласно масштабу подсистемы
#define RDS_PAN_F_SIZEABLE      4       // Пользователь может изменять размер панели (только вместе с RDS_PAN_F_BORDER)
#define RDS_PAN_F_MOVEABLE      8       // Пользователь может перемещать панель (только вместе с RDS_PAN_F_BORDER)
#define RDS_PAN_F_NOBUTTON     16       // Нет кнопки закрытия панели (только вместе с RDS_PAN_F_BORDER)
#define RDS_PAN_F_HIDDEN       32       // Панель создается скрытой
#define RDS_PAN_F_CAPTION      64       // Есть заголовок панели (только вместе с RDS_PAN_F_BORDER)
#define RDS_PAN_F_PAINTMSG    128       // Блок должен получать сообщение о необходимости перерисовать панель
// Команды установки и получения целых параметров (функции rdsSetObjectInt, rdsGetObjectInt)
#define RDS_PAN_VISIBLE         0       // Видимость панели
#define RDS_PAN_WIDTH           1       // Внешняя ширина панели
#define RDS_PAN_HEIGHT          2       // Внешняя высота панели
#define RDS_PAN_LEFT            3       // Горизонтальная координата левой стороны панели
#define RDS_PAN_TOP             4       // Вертикальная координата верхней стороны панели
#define RDS_PAN_CLIENTWIDTH     5       // Внутренняя ширина панели
#define RDS_PAN_CLIENTHEIGHT    6       // Внутренняя высота панели
#define RDS_PAN_MINCLWIDTH      7       // Минимальная внутренняя ширина панели
#define RDS_PAN_MAXCLWIDTH      8       // Максимальная внутренняя ширина панели
#define RDS_PAN_MINCLHEIGHT     9       // Минимальная внутренняя высота панели
#define RDS_PAN_MAXCLHEIGHT     10      // Максимальная внутренняя высота панели
#define RDS_PAN_FLAGS           11      // Флаги RDS_PAN_F_*
// Команды установки и получения строк
#define RDS_PAN_CAPTION         12      // Заголовок панели

// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsCSVCreate (объект для работы с CSV)
// Команды
#define RDS_CSV_CLEAR           0       // Очистить все данные
#define RDS_CSV_CLOSEFILE       1       // Закрыть открытый файл
#define RDS_CSV_STRFROMFILE     2       // Считать очередную строку из файла
#define RDS_CSV_STRTOFILE       3       // Записать строку в файл
#define RDS_CSV_REWINDFILE      4       // Снова начать чтение строк с начала файла **** REV2 ****
// Команды установки и получения целых параметров (функции rdsSetObjectInt, rdsGetObjectInt)
#define RDS_CSV_LINECOUNT       4       // Число строк (только чтение)
#define RDS_CSV_LINECOLUMNS     5       // Число столбцов в конкретной строке (только чтение)
#define RDS_CSV_MAXCOLUMNS      6       // Максимальное число столбцов по всем строкам (только чтение)
#define RDS_CSV_QUOTECHAR       7       // Символ кавычки (чтение, установка)
#define RDS_CSV_DELIMITERCHAR   8       // Символ-разделитель (чтение, установка)
#define RDS_CSV_FILEISOPEN      9       // Файл открыт (1 - да, только чтение)
#define RDS_CSV_FILEERROR       16      // Ошибка в файловой функции (1 - да, только чтение)
// Команды установки и получения строк
#define RDS_CSV_LINE            10      // Строка (чтение дин.копии, установка)
#define RDS_CSV_TEXT            11      // Весь текст (чтение дин.копии, установка)
#define RDS_CSV_OPENFILEREAD    12      // Открыть файл для чтения (только установка)
#define RDS_CSV_OPENFILEWRITE   13      // Открыть файл для записи (только установка)
#define RDS_CSV_LOADFROMFILE    14      // Загрузить из файла весь текст (только установка)
#define RDS_CSV_SAVETOFILE      15      // Записать в файл весь текст (только установка)


// Идентификаторы иконок для функций rdsXGDrawStdIcon и rdsXGGetStdIconSize
#define RDS_STDICON_GREENSQUARE         0       // Маленький зеленый квадрат
#define RDS_STDICON_YELLOWSQUARE        1       // Маленький желтый квадрат
#define RDS_STDICON_REDSQUARE           2       // Маленький красный квадрат
#define RDS_STDICON_YELLOWGEAR          7       // Желтая шестеренка
#define RDS_STDICON_RUN                 8       // Символ "play" (треугольник вправо)
#define RDS_STDICON_REDGEAR             9       // Красная шестеренка
#define RDS_STDICON_SYSTEM             10       // Маленький значок подсистемы
#define RDS_STDICON_BLOCK              11       // Маленький значок блока
#define RDS_STDICON_EYE                15       // Глаз (как в редакторе слоев)
#define RDS_STDICON_PENCIL             16       // Карандаш (как в редакторе слоев)
#define RDS_STDICON_REDTRIEXCLAM       23       // "!" в красном треугольнике
#define RDS_STDICON_YELLOWQUESTION     24       // "?" в желтом круге
#define RDS_STDICON_DISABLEDCONN       25       // "кирпич" (как на выключенных связях)
#define RDS_STDICON_REDCIRCEXCLAM      26       // "!" в красном круге
#define RDS_STDICON_YELCIRCEXCLAM      27       // "!" в желтом круге
#define RDS_STDICON_STOP               (0x20000|24) // Символ "stop" (черный квадрат)
#define RDS_STDICON_ZOOM               39       // Лупа                            **** REV2 **** начиная с этого
#define RDS_STDICON_NOZOOM             40       // Лупа с красным крестом
#define RDS_STDICON_ZOOMIN             41       // Лупа с плюсом
#define RDS_STDICON_ZOOMOUT            42       // Лупа с минусом
#define RDS_STDICON_TDOWN              43       // Треугольник вниз
#define RDS_STDICON_TUP                44       // Треугольник вверх
#define RDS_STDICON_TRIGHT             45       // Треугольник вправо
#define RDS_STDICON_TLEFT              46       // Треугольник влево
#define RDS_STDICON_PLUS               47       // Плюс
#define RDS_STDICON_MINUS              48       // Минус
#define RDS_STDICON_DELETE             49       // Знак удаления
#define RDS_STDICON_LEFT               50       // Тонкая стрелка влево
#define RDS_STDICON_RIGHT              51       // Тонкая стрелка вправо
#define RDS_STDICON_UP                 52       // Тонкая стрелка вверх
#define RDS_STDICON_DOWN               53       // Тонкая стрелка вниз
#define RDS_STDICON_HZOOMIN            54       // "+" в круге с горизонтальной двунаправленной стрелкой
#define RDS_STDICON_HZOOMOUT           55       // "-" в круге с горизонтальной двунаправленной стрелкой
#define RDS_STDICON_VZOOMIN            56       // "+" в круге с вертикальной двунаправленной стрелкой
#define RDS_STDICON_VZOOMOUT           57       // "-" в круге с вертикальной двунаправленной стрелкой
#define RDS_STDICON_HSIZE              58       // Две горизонтальные размерные стрелки
#define RDS_STDICON_VSIZE              59       // Две вертикальные размерные стрелки
#define RDS_STDICON_HVSIZE             60       // Прямоугольник с двумя размерными стрелками
//---------------------------------------------------------------------------

// Флаги для функций rdsNetBroadcastData и rdsNetSendData
#define RDS_NETSEND_UPDATE      1       // Можно заменить старые неотправленные данные новыми
#define RDS_NETSEND_NOWAIT      2       // Не ждать ответа сервера, передавать следующие
                                        // данные немедленно
#define RDS_NETSEND_SERVREPLY   4       // Получив данные, сервер должен сообщить об этом
                                        // пославшему блоку (RDS_BFM_NETDATAACCEPTED)
#define RDS_NETSEND_UDP         8       // Передать данные по протоколу UDP, если это разрешено
                                        // в настройках RDS
//---------------------------------------------------------------------------

// Флаги для функции rdsVarArrayIndexCheck
#define RDS_VAIC_SINGLE         1       // Проверять не индексы по отдельности, а сравнивать
                                        // произведение индексов с общим размером массива
                                        // Влияет также на текст сообщения ("массив" вместо "матрица")
#define RDS_VAIC_MESSAGE        2       // Выводить сообщение об ошибке
#define RDS_VAIC_SINGLEMSG      4       // Выводить только самое первое сообщение об ошибке
                                        // (при сброшенном RDS_VAIC_MESSAGE игнорируется)
#define RDS_VAIC_STOPCALC       8       // Останавливать расчет при ошибке
//---------------------------------------------------------------------------

// Байты тегов для специального формата сохранения
// 87654321
// .tttnnnn
// tt: 0 - служебные, 0x10 - блоки, 0x20 - связи
// Служебные
#define RDS_SFTAG_EOF           0       // Конец данных
#define RDS_SFTAG_CONNSTYLES    1       // Стили связей и шин
#define RDS_SFTAG_TYPES         2       // Структуры
#define RDS_SFTAG_DATATYPE      0xff    // Тип данных (за ним идет DWORD 0)
// Блоки
#define RDS_SFTAG_SIMPLEBLOCK   0x10    // Простой блок
#define RDS_SFTAG_SYSTEM        0x11    // Подсистема
#define RDS_SFTAG_INPUTBLOCK    0x12    // Внешний вход
#define RDS_SFTAG_OUTPUTBLOCK   0x13    // Внешний выход
#define RDS_SFTAG_BUSPORT       0x14    // Порт шины
#define RDS_SFTAG_ROOT          0x15    // Корневая подсистема
// Связи
#define RDS_SFTAG_CONNECTION    0x20    // Связь
#define RDS_SFTAG_BUS           0x21    // Шина
//---------------------------------------------------------------------------

// Константы для функции rdsSetLayerPosition (тип операции)
#define RDS_SLP_TOP     0       // На самый верх
#define RDS_SLP_BOTTOM  1       // В самый низ
#define RDS_SLP_BEFORE  2       // Перед указанным слоем
#define RDS_SLP_AFTER   3       // После указанного слоя
//---------------------------------------------------------------------------

// Флаги для rdsStringReplace
#define RDS_SRF_STDPATHS        1       // Заменять символы стандартных путей ($DLL$ и т.д)
                                        // на сами пути
#define RDS_SRF_IGNORECASE      2       // Игнорировать регистр при поиске подстрок
//---------------------------------------------------------------------------

// Флаги для rdsCallFileDialog
#define RDS_CFD_OPEN            0       // Диалог открытия (константа введена
                                        // просто для удобства)
#define RDS_CFD_SAVE            1       // Диалог сохраненния
#define RDS_CFD_CREATEPROMPT    2       // Подтверждать создание файла при выборе
                                        // несуществующего в диалоге сохранения)
#define RDS_CFD_OVERWRITEPROMPT 4       // Подтверждать замену файла при выборе
                                        // существующего в диалоге сохранения)
#define RDS_CFD_MUSTEXIST       8       // Файл должен существовать (для диалога открытия)
#define RDS_CFD_ABSPATH         16      // Возвращать абсолютный, а не относительный путь
//---------------------------------------------------------------------------

// Константы для rdsTransformFileName
#define RDS_TFN_GETPATH         0       // Выделить из имени файла путь с "\"
#define RDS_TFN_GETPATHNOBS     1       // Выделить из имени файла путь без "\"
#define RDS_TFN_GETEXT          2       // Выделить из имени файла расширение
#define RDS_TFN_GETNAME         3       // Выделить из имени файла само имя без пути
#define RDS_TFN_CHANGEEXT       4       // Заменить расширение на другое
#define RDS_TFN_INCLUDEPATHBS   5       // Добавить к пути "\", если его там нет
#define RDS_TFN_EXCLUDEPATHBS   6       // Убрать из конца пути "\", если он там есть
//---------------------------------------------------------------------------

// Структура-параметр функции rdsSaveSystemBitmap
typedef struct // RDS_SAVESYSBMPDATA
{ union
    { DWORD servSize;           // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_BHANDLE Block;        // Подсистема
      RDSBIGGESTTYPE align1;
    };
  union
    { DWORD Flags;              // Флаги (RDS_SSBF_*)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 Left;            // Начало сохраняемой области в масштабе 100% или Zoom (зависит от RDS_SSBF_ZOOMCOORDS)
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 Top;
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 Width;           // Размеры сохраняемой области в масштабе 100% или Zoom (зависит от RDS_SSBF_ZOOMCOORDS)
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 Height;
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 PicWidth;        // Максимальные размеры сохраняемой картинки
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSINT32 PicHeight;
      RDSBIGGESTTYPE align8;
    };
  union
    { RDSCSTR FileNameA;        // Шаблон имени файла с путем в UTF8 (можно использовать символьные константы путей и RDS_SSBC_*)
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR FileName;
      #endif
    };
  union
    { RDSWCSTR FileNameW;       // То же в UTF16
      RDSBIGGESTTYPE align10;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR FileName;
      #endif
    };
  // Расширение файла определяет формат картинки (возможные варианты - bmp или png)
  union
    { double Zoom;              // Масштаб
      RDSBIGGESTTYPE align11;
    };
} RDS_SAVESYSBMPDATA;
// Флаги RDS_SAVESYSBMPDATA::Flags
#define RDS_SSBF_ZOOMED     1       // Left,Top,Width и Height - в масштабе Zoom, а не 100%
#define RDS_SSBF_FORCEDIR   2       // Создать директорию, если ее нет
// Дополнительные символьные константы для RDS_SAVESYSBMPDATA::FileName
#define RDS_SSBC_NX         "$NX$"  // Номер картинки по горизонтали
#define RDS_SSBC_4NX        "$4NX$" // То же с ведущими нулями, всегда 4 символа
#define RDS_SSBC_NY         "$NY$"  // Номер картинки по вертикали
#define RDS_SSBC_4NY        "$4NY$" // То же с ведущими нулями, всегда 4 символа
#define RDS_SSBC_NN         "$NN$"  // Возрастающий порядковый номер картинки (из левого верхнего угла сначала вправо)
#define RDS_SSBC_4NN        "$4NN$" // То же с ведущими нулями, всегда 4 символа
typedef RDS_SAVESYSBMPDATA *RDS_PSAVESYSBMPDATA;
// Символьные константы для RDS_SAVESYSBMPDATA::FileNameW в UTF16
#define RDS_SSBC_NX_W       L"$NX$"  // Номер картинки по горизонтали
#define RDS_SSBC_4NX_W      L"$4NX$" // То же с ведущими нулями, всегда 4 символа
#define RDS_SSBC_NY_W       L"$NY$"  // Номер картинки по вертикали
#define RDS_SSBC_4NY_W      L"$4NY$" // То же с ведущими нулями, всегда 4 символа
#define RDS_SSBC_NN_W       L"$NN$"  // Возрастающий порядковый номер картинки (из левого верхнего угла сначала вправо)
#define RDS_SSBC_4NN_W      L"$4NN$" // То же с ведущими нулями, всегда 4 символа
//---------------------------------------------------------------------------

// Структура описания параметров внешнего вида блока "прямоугольник с текстом"
// Используется в rdsSetBlockTextRectParams, rdsGetBlockTextRectParams
typedef struct // RDS_BLOCKTEXTRECTDATA
{ union
    { DWORD servSize;             // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Exists;                // Блок изображается прямоугольником с текстом
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR TextA;              // Текст (UTF8)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Text;
      #endif
    };
  union
    { RDSWCSTR TextW;             // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Text;
      #endif
    };
  union
    { RDSINT32 HAlign;            // Выравнивание текста (-1 - влево, 0 - по центру, 1 - вправо)
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 VAlign;            // Выравнивание текста (-1 - вверх, 0 - по центру, 1 - вниз)
      RDSBIGGESTTYPE align5;
    };
  union
    { BOOL BorderFlag;            // Наличие рамки
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 BorderWidth;       // Толщина линии рамки
      RDSBIGGESTTYPE align7;
    };
  union
    { BOOL ScaleBorder;           // Масштабирование рамки
      RDSBIGGESTTYPE align8;
    };
  union
    { COLORREF Border;            // Цвет рамки
      RDSBIGGESTTYPE align9;
    };
  union
    { BOOL FillFlag;              // Наличие заполнения
      RDSBIGGESTTYPE align10;
    };
  union
    { COLORREF Fill;              // Цвет заполнения
      RDSBIGGESTTYPE align11;
    };
  union
    { BOOL Translate;             // Требуется перевод
      RDSBIGGESTTYPE align12;
    };
  // Шрифт передается/получается в отдельной структуре RDS_SERVFONTPARAMS
} RDS_BLOCKTEXTRECTDATA;
typedef RDS_BLOCKTEXTRECTDATA *RDS_PBLOCKTEXTRECTDATA;
//---------------------------------------------------------------------------

// Флаги для rdsSetBlockTextRectParams **** REV2 ****
#define RDS_SBTRPREFRESH        1       // Обновить окно
//---------------------------------------------------------------------------

// Флаги для rdsSCEUSaveBlock и rdsSCEUSaveConn **** REV2 ****
#define RDS_SCEUFLAG_FULL       1       // Запись всех данных блока (не только параметров)
#define RDS_SCEUFLAG_BEFORE     2       // Запись данных объекта перед операцией
#define RDS_SCEUFLAG_AFTER      0       // Запись данных объекта после операции (псевдо-флаг для ясности)
// Константы для вспомогательного объекта rdsSCEUCreate **** REV2 ****
// Команды
#define RDS_SCEU_CLEAR          0       // Очистить все данные
#define RDS_SCEU_STORE          1       // Записать в undo
#define RDS_SCEU_STOREDELAYED   2       // Записать в undo после следующей операции
#define RDS_SCEU_JOINPREV       3       // Объединить с предыдущей
//---------------------------------------------------------------------------

// Константы и описания для модулей расширения **** REV2 ****
// Режимы вызова
#define RDS_TOOLM_INIT          0       // Инициализация
#define RDS_TOOLM_CLEANUP       1       // Очистка
#define RDS_TOOLM_SETUP         2       // Вызов настроек
#define RDS_TOOLM_EXECUTE       3       // Вызов самого расширения
#define RDS_TOOLM_MODECHANGE    4       // Изменение режима RDS
#define RDS_TOOLM_TIMER         5       // Срабатывание таймера
#define RDS_TOOLM_BEFORESAVE    6       // Перед сохранением схемы
#define RDS_TOOLM_AFTERSAVE     7       // После сохранения схемы
#define RDS_TOOLM_UNLOADSYSTEM  8       // Вся система сейчас будет выгружена
#define RDS_TOOLM_AFTERLOAD     9       // После загрузки всей схемы
#define RDS_TOOLM_CALL          10      // Вызов из модели блока или другого модуля
#define RDS_TOOLM_REMOTECALL    11      // Вызов по ДУ
#define RDS_TOOLM_EXTCALL       12      // Расширенный вызов из модели блока или другого модуля
#define RDS_TOOLM_DELAYEDCALL   13      // Отложенный вызов из модели блока или другого модуля
//---------------------------------------------------------------------------
// Результаты **** REV2 ****
#define RDS_TOOLR_DONE          0       // Выполнено (можно выгружать модуль)
#define RDS_TOOLR_STAY          1       // Модуль должен остаться в памяти
//---------------------------------------------------------------------------
// Данные модуля расширения
typedef struct // RDS_TOOLMODULEDATA
{ union
    { LPVOID ModuleData;           // Адрес области данных модуля (чтение/запись)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 RDSMode;            // Текущий режим RDS (константа RDS_CM_*)
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR ServiceNameA;        // Внутреннее имя (UTF8, только чтение)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ServiceName;
      #endif
    };
  union
    { RDSWCSTR ServiceNameW;       // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ServiceName;
      #endif
    };
  // Целое пользовательское поле (не обрабатывается и не инициализируется)
  union
    { RDSINT32 Tag;
      RDSBIGGESTTYPE align4;
    };
  // Предлагаемое имя файла для хранения настроек (только для модулей, заданных файлами описания, только чтение)
  // Для модулей, не находящихся в общем списке, передается пустая строка
  union
    { RDSCSTR DataFileA;           // UTF8
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR DataFile;
      #endif
    };
  union
    { RDSWCSTR DataFileW;          // То же в UTF16
      RDSBIGGESTTYPE align6;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR DataFile;
      #endif
    };
} RDS_TOOLMODULEDATA;
typedef RDS_TOOLMODULEDATA *RDS_PTOOLMODULEDATA;
//---------------------------------------------------------------------------
// Параметры вызова модуля расширения
// Используются в режимах RDS_TOOLM_CALL и RDS_TOOLM_REMOTECALL
typedef struct // RDS_TOOLCALLDATA
{ union
    { RDSCSTR StringA;        // Переданная строка (UTF8)
      RDSBIGGESTTYPE align0;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR String;
      #endif
    };
  union
    { RDSWCSTR StringW;       // То же в UTF16
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR String;
      #endif
    };
  union
    { RDSINT32 Value;         // Переданное число
      RDSBIGGESTTYPE align2;
    };
} RDS_TOOLCALLDATA;
typedef RDS_TOOLCALLDATA *RDS_PTOOLCALLDATA;
//---------------------------------------------------------------------------
// Параметры расширенного вызова модуля расширения
// Используются в режиме RDS_TOOLM_EXTCALL
typedef struct // RDS_TOOLEXTCALLDATA
{ union
    { DWORD servSize;                 // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Command;               // Переданное число
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 IntParam;              // Дополнительное переданное число
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 IntValue;              // Дополнительное переданное число
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 NInStrings;            // Количество входных строк
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSCSTRARRAY InStringsA;        // Массив входных строк в UTF8 (поддерживаются и освобождаются вызвавшим)
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTRARRAY InStrings;
      #endif
    };
  union
    { RDSCWSTRARRAY InStringsW;       // То же в UTF16
      RDSBIGGESTTYPE align6;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSCWSTRARRAY InStrings;
      #endif
    };

  union
    { RDSINT32 NOutStrings;           // Число выходных строк
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSSTRARRAY OutStringsA;        // Массив выходных строк в UTF8 (отводится модулем при помощи rdsAllocate, каждая строка в массиве
                                      // тоже отводится модулем при помощи rdsAllocate, все освобождаются ВЫЗВАВШИМ при помощи
                                      // rdsFree)
      RDSBIGGESTTYPE align8;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSSTRARRAY OutStrings;
      #endif
    };
  union
    { RDSWSTRARRAY OutStringsW;       // То же в UTF16
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWSTRARRAY OutStrings;
      #endif
    };
  union
    { RDSINT32 Result;                // Возвращаемый результат
      RDSBIGGESTTYPE align10;
    };

  union
    { RDS_BHANDLE Block;              // Блок, для которого вызывается операция, или NULL (как входной параметр, заполняется
                                      // вызвавшим, может служить и выходным)
      RDSBIGGESTTYPE align11;
    };
} RDS_TOOLEXTCALLDATA;
typedef RDS_TOOLEXTCALLDATA *RDS_PTOOLEXTCALLDATA;
//---------------------------------------------------------------------------
// Флаги и константы функции rdsExecTool **** REV2 ****
//   3         2         1
//  10987654321098765432109876543210
//  ......................SSMMMMMMMM
// M - режим
// S - способ поиска модуля
// Режим
#define RDS_ETF_M_EXECUTE       0       // Вызвать модуль расширения в режиме RDS_TOOLM_EXECUTE (как из меню)
#define RDS_ETF_M_SETUP         1       // Вызвать модуль расширения в режиме RDS_TOOLM_SETUP (настройка)
#define RDS_ETF_M_CALL          2       // Вызвать модуль расширения в режиме RDS_TOOLM_CALL (или RDS_TOOLM_REMOTECALL) с параметром RDS_PTOOLCALLDATA
// Способ поиска модуля (используется и для rdsExecToolExt)
#define RDS_ETF_S_BYDLL         0       // По имени функции и имени DLL
#define RDS_ETF_S_BYSERVNAME    0x100   // По внутреннему имени
// Маски
#define RDS_ETF_MODEMASK        0xff    // Режим
#define RDS_ETF_SEARCHMASK      0x300   // Способ поиска
//---------------------------------------------------------------------------
// Флаги функции rdsVSCompare **** REV2 ****
#define RDS_VARCOMP_ALL         0       // Все параметры
#define RDS_VARCOMP_VARTYPES    1       // Типы переменных
#define RDS_VARCOMP_VARNAMES    2       // Имена переменных
#define RDS_VARCOMP_VARDEFAULTS 4       // Значения переменных по умолчанию
#define RDS_VARCOMP_VARIO       8       // Роли переменных в блоке (входы/выходы/внутренние)
#define RDS_VARCOMP_VARDISP     16      // Флаги отображения переменных (меню, отображение имени)
#define RDS_VARCOMP_VARAUTORUN  32      // Флаги автозапуска модели для входов
#define RDS_VARCOMP_VARREM      64      // Комментарии переменных
#define RDS_VARCOMP_AUTOCONN    128     // Связанные сигналы и логические переменные
//---------------------------------------------------------------------------
// Коды возврата функции справки **** REV2 ****
#define RDS_HELP_OK             0       // Все в порядке
#define RDS_HELP_NOUIFILE       1       // Файл UI (со списком тем) не найден
#define RDS_HELP_READERROR      2       // Ошибка чтения файла
#define RDS_HELP_NOTOPIC        3       // Тема не найдена
#define RDS_HELP_NOHELPFILE     4       // Файл самой справки (по ссылке из UI) не найден
#define RDS_HELP_NOEXE          5       // Для файла справки не найдена программа-обработчик
#define RDS_HELP_UNKNOWN        6       // Прочие ошибки
//---------------------------------------------------------------------------
// Флаги функции rdsEnumDynVars **** REV2 ****
#define RDS_EDV_SEARCH          1       // С поиском вверх по иерархии подсистем
//---------------------------------------------------------------------------
// Флаги дополнительных параметров связи **** REV2 ****
#define RDS_ACP_HINT            1       // Выводится во всплывающей подсказке
#define RDS_ACP_NOTRANSLATE     2       // Не требуется перевод
#define RDS_ACP_NOSTORE         4       // Не сохраняется вместе со схемой (временный)
//---------------------------------------------------------------------------
// Флаги функции rdsCopySelectedToMem **** REV2 ****
#define RDS_CSTM_STATE          1       // Копировать вместе с состояниями блоков
#define RDS_CSTM_AUTOCOMP       2       // Копировать вместе с глобальными данными автокомпиляции
#define RDS_CSTM_LAYERS         4       // Копировать вместе со слоями
#define RDS_CSTM_CLASSES        8       // Копировать вместе с классами
#define RDS_CSTM_KEEPEXTERNAL  16       // Запрет замены точек связей, соединенных с не выделенными объектами, на внутренние 
//---------------------------------------------------------------------------
// Флаги функции rdsPasteFromMem **** REV2 ****
#define RDS_PFM_UPDATEWIN       1       // Обновить окно
#define RDS_PFM_CONNDATA        2       // Принять внешние данные по связям после вставки
#define RDS_PFM_STATE           4       // Загрузить вместе с состояниями блоков
#define RDS_PFM_CREATELAYERS    8       // Если в заружаемых данных есть слои, создавать отсутствующие
#define RDS_PFM_INVALIDPATHS    16      // Не следует полагатьcя на пути в загружаемых данных (данные с другой машины)
//---------------------------------------------------------------------------
// Константы функции rdsExclusiveFileOp **** REV2 ****
#define RDS_EFO_USE     1       // Пометить файл как используемый
#define RDS_EFO_UNUSE   2       // Пометить файл как не используемый
#define RDS_EFO_FORGET  3       // Забыть о существовании файла
//---------------------------------------------------------------------------
// Флаги функции rdsPasteFromMem **** REV2 ****
#define RDS_ICF_NOCALL          1       // Не вызывать модель самого блока (начать с передачи его выходов)
#define RDS_ICF_ALLBLOCKS       2       // Вызвать инициализационный расчет для всех блоков
#define RDS_ICF_UPDATEWIN       4       // Обновить затронутые окна после операции (только в режимах редактирования и моделирования)
//---------------------------------------------------------------------------
// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsINTCreate (объект для работы с интервалами положительных целых чисел)  **** REV2 ****
// Команды
#define RDS_INT_CLEAR           0       // Очистить все данные
// Команды установки и получения целых параметров (функции rdsSetObjectInt, rdsGetObjectInt)
#define RDS_INT_ALLOWZERO       1       // Разрешение работы с нулем
#define RDS_INT_VALUE           2       // Установить значение или получить свободное
//---------------------------------------------------------------------------
// Флаги функции rdsLockDrawUpdates **** REV2 ****
#define RDS_LDUF_LOCK           1       // Заблокировать
#define RDS_LDUF_UNLOCK         2       // Разблокировать
//---------------------------------------------------------------------------
// Флаги функции rdsGBLAddBlock **** REV2 ****
#define RDS_GBL_ADD     0       // Добавить блок (младший бит - 0)
#define RDS_GBL_DELETE  1       // Удалить блок (младший бит - 1)
//---------------------------------------------------------------------------
// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsGBLCreate (объект для работы с глобальным списком блоков)
// Команды установки и получения целых параметров (функции rdsSetObjectInt, rdsGetObjectInt)
#define RDS_GBL_GETCOUNT        0       // Число блоков (только чтение)
//---------------------------------------------------------------------------
// Константы функций rdsSetBlockOrder и rdsSetConnOrder **** REV2 ****
#define RDS_BLOCKORDER_FIRST    0       // Сделать первым в подсистеме
#define RDS_BLOCKORDER_LAST     1       // Сделать последним в подсистеме
#define RDS_BLOCKORDER_AFTER    2       // Поставить после заданного
#define RDS_BLOCKORDER_BEFORE   3       // Поставить перед заданным
//---------------------------------------------------------------------------
// Флаги функции rdsSetConnText **** REV2 ****
#define RDS_SCTF_TEXT           1       // Установить/очистить текст
#define RDS_SCTF_ALIGNMENT      2       // Установить выравнивание текста
#define RDS_SCTF_SHOW           4       // Установить показ текста
#define RDS_SCTF_COORDS         8       // Установить координаты центра текста
#define RDS_SCTF_TRANSLATE      16      // Установить необходимость перевода
//---------------------------------------------------------------------------
// Константы типа текста для переводов **** REV2 ****
#define RDS_TRANSLML_SINGLE     0       // Однострочный текст
#define RDS_TRANSLML_LF         1       // Многострочный текст, разделитель "\n"
#define RDS_TRANSLML_CRLF       2       // Многострочный текст, разделитель "\r\n"
// Диапазон разрешенных целых иденификаторов переводимых параметров для внутренних нужд модулей автокомпиляции **** REV2 ****
#define RDS_TRANSLACPID_LOW     -199999 // Начало диапазона (включительно)
#define RDS_TRANSLACPID_HIGH    -100000 // Конец диапазона (включительно)
//---------------------------------------------------------------------------
// Флаги функции rdsFORMTBLSetHeader **** REV2 ****
// Маска выравнивания текста
#define RDS_FORMTBLF_ALIGN      3
  #define RDS_FORMTBLF_LEFT     0       // Влево
  #define RDS_FORMTBLF_CENTER   1       // По центру
  #define RDS_FORMTBLF_RIGHT    2       // Вправо
// Маска вырванивания заголовка
#define RDS_FORMTBLF_HDRALIGN   12
  #define RDS_FORMTBLF_HDRLEFT   0       // Влево
  #define RDS_FORMTBLF_HDRCENTER 4       // По центру
  #define RDS_FORMTBLF_HDRRIGHT  8       // Вправо
// Пользовательское рисование текста
#define RDS_FORMTBLF_DRAW       16
// Пользовательское рисование заголовка
#define RDS_FORMTBLF_HDRDRAW    32
// Специальные константы ширины столбца для rdsFORMTBLSetHeader **** REV2 ****
#define RDS_FORMTBLW_FILL       (-1)    // Автоматическое заполнение свободного места
#define RDS_FORMTBLW_AUTO       0       // По содержимому
// Режимы автоматического добавления записей в таблицу rdsFORMCreate / RDS_FORMVAL_TBLAUTOINS  **** REV2 ****
#define RDS_FORMTBLAI_NONE      0       // Отключено
#define RDS_FORMTBLAI_END       1       // Добавление в конец таблицы
#define RDS_FORMTBLAI_INS       2       // Добавление перед текущей записью
//---------------------------------------------------------------------------
// Флаги функции rdsCreateSystem **** REV2 ****
#define RDS_CSF_LAYERS          1       // Копировать слои, конфигурации и классы
#define RDS_CSF_EDITOR          2       // Копировать параметры редактора
#define RDS_CSF_WINDOW          4       // Копировать размеры, положение и заголовок окна
//---------------------------------------------------------------------------
// Флаги функции rdsEnumBusLinks **** REV2 ****
#define RDS_EBL_USEDISABLED     1       // Включать в перечисление отключенные связи
#define RDS_EBL_INPUTS          2       // Включать в перечисление связи, подводящие значение к шине
#define RDS_EBL_OUTPUTS         4       // Включать в перечисление связи, отводящие значение от шины
#define RDS_EBL_CONNBUSES       8       // Включать в перечисление связи, присоединенные к другим шинам, связанным с этой
//---------------------------------------------------------------------------
// Флаги функции rdsCWCreate **** REV2 ****
#define RDS_CWF_NOREACTION      1       // Не вызывать стандартную реакцию блока при изменении состояния подграфа связей
#define RDS_CWF_EXACTNAMEMATCH  2       // При указании имени входа вместо номера имя в присоединенной связи должно
                                        // в точности совпадать с указанным, иначе проверяется только начало имени
                                        // (например, при указании "x" будет найдена и "x[0]")
#define RDS_CWF_PARENTONLY      4       // Ограничить отслеживание только родительской подсистемой и вложенными в нее
//---------------------------------------------------------------------------
// Структура-параметр rdsCWCreate
typedef struct // RDS_CWCREATEDATA
{ union
    { DWORD servSize;                    // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };

  // Число последовательных тактов без изменений
  union
    { RDSINT32 Ticks;
      RDSBIGGESTTYPE align1;
    };

  // Запрошенные погрешности проверки вещественных чисел (проверяется изменение при передаче)
  union
    { double RelDelta;                   // Порог изменения (в долях единицы самого значения) или -1 для игнорирования погрешности
      RDSBIGGESTTYPE align2;
    };
  union
    { double MinDeltaRel;                // Если прогрешность, вычисленная через RelDelta, будет меньше этого значения,
                                         // Проверка по RelDelta производиться не будет (иначе при передаче очень маленьких значений
                                         // переходный процесс никогда не кончается)
      RDSBIGGESTTYPE align3;
    };
  union
    { double AbsDelta;                   // Порог изменения самого значения или -1 для игнорирования погрешности
      RDSBIGGESTTYPE align4;
    };

  union
    { BOOL CheckBadProcess;              // Проверка на "плохой" (не сходящийся) процесс
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 MinBadProcessTicks;       // Минимальный интервал измерения изменений для плохого процесса: вычисленное за такое число
                                         // тактов максимальное изменение в графе должно уменьшаться от измерения к измерению
      RDSBIGGESTTYPE align6;
    };
} RDS_CWCREATEDATA;
typedef RDS_CWCREATEDATA *RDS_PCWCREATEDATA;
// Сброс всего в структуре
#define RDS_CWCREATEDATA_RESET(d) {d.servSize=sizeof(d);d.Ticks=d.MinBadProcessTicks=0;d.RelDelta=d.MinDeltaRel=d.AbsDelta=-1.0;d.CheckBadProcess=FALSE;}
//---------------------------------------------------------------------------
// Константы для взаимодействия со вспомогательным объектом, созданным функцией
// rdsCWCreate **** REV2 ****
// Команды чтения/записи
#define RDS_CWPARAM_CHANGE      0       // Получить/установить флаг изменения (устанавливается только истина) или погрешность (при установке вещественного)
#define RDS_CWPARAM_RELDELTA    1       // Получить/установить относительную погрешность
#define RDS_CWPARAM_ABSDELTA    2       // Получить/установить абсолютную погрешность
#define RDS_CWPARAM_TICKS       3       // Получить/установить число тактов в пределах погрешности
#define RDS_CWPARAM_MINDREL     4       // Получить/установить MinDeltaRel (см. структуру выше)
#define RDS_CWPARAM_ADDVARNUM   5       // Добавить номер переменной (только установка)
#define RDS_CWPARAM_ADDVARNAME  6       // Добавить имя переменной (только установка, только строка)
//---------------------------------------------------------------------------
// Флаги функции rdsSaveBlockToFile **** REV2 ****
#define RDS_SBTF_FORCEDIR       1       // Создать директорию, если ее нет
//---------------------------------------------------------------------------
// Флаги функции rdsForceDirectories **** REV2 ****
#define RDS_FDF_FILENAME        1       // Передано имя файла, а не имя директории
//---------------------------------------------------------------------------
// Константы поддержки модификаций интерфейса пользователя **** REV2 ****
// Директории
#define RDS_UIMODD_DEFAULT      "Default"       // Директория с параметрами по умолчанию (для всех категорий)
#define RDS_UIMODD_DESCR        "Description"   // Директория с описаниями пользовательского интерфейса внутри $RDS$
#define RDS_UIMODD_MODS         "Interface"     // Директория с категориями модификаций внутри $INI$ (пользовательская) и $RDS$ (стандартная)
// Стандартные категории
#define RDS_UIMODC_LANGUAGE     "Language"      // Язык интерфейса
// Идентификатор для возврата любого параметра
#define RDS_UIMOD_ANYPARAMID    (-1)
// Те же константы в UTF16
#define RDS_UIMODD_DEFAULT_16   L"Default"
#define RDS_UIMODD_DESCR_16     L"Description"
#define RDS_UIMODD_MODS_16      L"Interface"
#define RDS_UIMODC_LANGUAGE_16  L"Language"
//---------------------------------------------------------------------------
// Константы работы с объектом, созданным функцией rdsUIMODCreate **** REV2 ****
#define RDS_UIMOD_SETOBJNAME    1       // Установить имя рабочего объекта (rdsSetObjectStr)
#define RDS_UIMOD_GETPARAMCNT   2       // Получить число параметров в рабочем объекте (rdsGetObjectInt)
#define RDS_UIMOD_CLEAR         3       // Очистить все (rdsCommandObject)
#define RDS_UIMOD_GETFILERESULT 4       // Получить результат файловой операции (rdsGetObjectInt)
#define RDS_UIMOD_SETFILEFORMAT 5       // Установить формат файла RDS_UIFRMT_* (rdsSetObjectInt)
#define RDS_UIMOD_LOADFILE      6       // Загрузить файл (rdsSetObjectStr)
#define RDS_UIMOD_SAVEFILE      7       // Записать файл (rdsSetObjectStr) - если успешно завершилась, но файла нет, значит, нечего было записывать
#define RDS_UIMOD_OPENGROUP     8       // Выбрать текущую группу для чтения/записи (rdsSetObjectStr)
#define RDS_UIMOD_CREATEGROUP   9       // Создать группу для чтения/записи и сделать ее текущей (rdsSetObjectStr)
#define RDS_UIMOD_CHECKGROUP    10      // Установлена ли текущая группа (rdsGetObjectInt)
#define RDS_UIMOD_CREATEOBJ     11      // Создать объект для чтения/записи и сделать его текущим (rdsSetObjectStr)
#define RDS_UIMOD_SETCRLFCORR   12      // Установить обработку переводов строк RDS_UIMOD_CRLF_* (rdsSetObjectInt)
#define RDS_UIMOD_SETSUBSTLANG  13      // Установить дополнительный язык (rdsSetObjectStr)
#define RDS_UIMOD_LOADFILESHORT 14      // Загрузить файл по короткому имени и заранее установленным категории и модификации (rdsSetObjectStr)
#define RDS_UIMOD_SAVEFILESHORT 15      // Записать файл по короткому имени и заранее установленным категории и модификации (rdsSetObjectStr) - если успешно завершилась, но файла нет, значит, нечего было записывать
#define RDS_UIMOD_CATEGORY      16      // Получить/установить категорию (rdsSetObjectStr/rdsGetObjectStr)
#define RDS_UIMOD_MODNAME       17      // Получить/установить имя модификации (rdsSetObjectStr/rdsGetObjectStr)
#define RDS_UIMOD_DATFILE       18      // Установить имя существующего dat-файла описания модификации для записи (rdsSetObjectStr)
#define RDS_UIMOD_JOINEQUAL     18      // Установить признак объединения одинаковых текстов для записи (rdsSetObjectInt)
// Форматы экспорта/импорта файлов модификаций интерфейса **** REV2 ****
#define RDS_UIFRMT_UNKNOWN      -1      // неизвестно (автоопределение)
#define RDS_UIFRMT_INI          0       // ini
#define RDS_UIFRMT_CSV          1       // csv
// Обработка переводов строк при загрузке данных из двоичного файла
#define RDS_UIMOD_CRLF_ANY      0       // Никак не обрабатывать
#define RDS_UIMOD_CRLF_LF       1       // Перевести "\r\n" в "\n"
#define RDS_UIMOD_CRLF_BOTH     2       // Перевести "\n" в "\r\n"
#define RDS_UIMOD_CRLF_NONE     3       // Перевести "\r" и "\n" в " "
//---------------------------------------------------------------------------
// Константы работы с объектом, созданным функцией rdsBMPCreate **** REV2 ****
#define RDS_BMP_LOADFROMFILE    1       // Загрузить из файла (rdsSetObjectStr)
#define RDS_BMP_ISLOADED        2       // Загружен ли? (rdsGetObjectInt)
#define RDS_BMP_GETWIDTH        3       // Ширина (rdsGetObjectInt)
#define RDS_BMP_GETHEIGHT       4       // Высота (rdsGetObjectInt)
#define RDS_BMP_CLEAR           5       // Очистить (rdsCommandObject)
#define RDS_BMP_TRANSPMODE      6       // Режим прозрачности (rdsSetObjectInt,rdsGetObjectInt)
  #define RDS_BMP_TM_NONE  0 // Нет
  #define RDS_BMP_TM_AUTO  1 // По левому нижнему углу
  #define RDS_BMP_TM_XY    2 // По координатам
#define RDS_BMP_TRANSPX         7       // Координата X для прозрачности (rdsSetObjectInt,rdsGetObjectInt)
#define RDS_BMP_TRANSPY         8       // Координата Y для прозрачности (rdsSetObjectInt,rdsGetObjectInt)
#define RDS_BMP_WIDTH           9       // Ширина (rdsGetObjectInt,rdsSetObjectInt)
#define RDS_BMP_HEIGHT          10      // Высота (rdsGetObjectInt,rdsSetObjectInt)
#define RDS_BMP_DETACHFILE      11      // "Отсоединить" от файла (rdsCommandObject) 2021_07_02
// Структура описания рисования в BMP
typedef struct
{ HDC dc;               // Где рисовать (контекст, см. WinAPI)
  int Width,Height;     // Размеры

} RDS_BMPDRAWDATA;
typedef RDS_BMPDRAWDATA *RDS_PBMPDRAWDATA;
//---------------------------------------------------------------------------
// Константы работы с объектом, созданным функцией rdsPICCreate **** REV2 ****
#define RDS_PIC_EDIT            1       // Открыть редактор (rdsCommandObject,rdsSetObjectStr)
#define RDS_PIC_APPLY           2       // Записать в блок (rdsCommandObject)
#define RDS_PIC_CLEAR           3       // Очистить (rdsCommandObject)
//---------------------------------------------------------------------------

// Структура описания глобального параметра схемы
typedef struct // RDS_SGPDATA
{ union
    { DWORD servSize;            // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Id;               // Идентификатор (при установке м.б.0, тогда регистрируется имя Name)
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR NameA;             // Имя (UTF8, соответствует идентификатору, при установке при наличии идентификатора игнорируется)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Name;
      #endif
    };
  union
    { RDSWCSTR NameW;            // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Name;
      #endif
    };
  union
    { RDSINT32 Type;             // Тип параметра (RDS_VARTYPE_INT,RDS_VARTYPE_DOUBLE,RDS_VARTYPE_STRING,RDS_VARTYPE_RUNTIME)
      RDSBIGGESTTYPE align4;
    };

  // Значения (заполняется только то, которое соответствует Type)
  union
    { double DoubleValue;        // Вещественное значение
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 IntValue;         // Целое значение
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSCSTR StrValueA;         // Строка (UTF8, при возврате - во внутренней памяти RDS)
      RDSBIGGESTTYPE align7;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR StrValue;
      #endif
    };
  union
    { RDSWCSTR StrValueW;        // То же в UTF16
      RDSBIGGESTTYPE align8;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR StrValue;
      #endif
    };
  union
    { RDSBYTES Bytes;            // Массив байтов (при возврате - во внутренней памяти RDS)
      RDSBIGGESTTYPE align9;
    };
  union
    { RDSINT32 BytesCount;       // Размер массива байтов
      RDSBIGGESTTYPE align10;
    };

  union
    { DWORD Flags;               // Флаги (см. ниже)
      RDSBIGGESTTYPE align11;
    };

  union
    { BOOL Exists;               // Параметр существует
      RDSBIGGESTTYPE align12;
    };
} RDS_SGPDATA;
// Флаги RDS_SGPDATA::Flags
#define RDS_SGP_TRANSLATE   1       // Требуется перевод строкового параметра
// Псевдо-тип для Type при работе с двоичными данными
#define RDS_VARTYPE_BINARY  RDS_VARTYPE_RUNTIME
typedef RDS_SGPDATA *RDS_PSGPDATA;
//---------------------------------------------------------------------------

// Запросы для rdsNetGetServerConnectionData  **** REV2 ****
#define RDS_NGSC_SERVERCOUNT    0       // Общее число запущенных серверов
#define RDS_NGSC_CONNCOUNT      1       // Общее число соединений
#define RDS_NGSC_IPCOUNT        2       // Общее число машин (соединений с разными IP)
#define RDS_NGSC_SERVERDATA     3       // Заполнить структуру параметрами сервера (только порт)
#define RDS_NGSC_CONNDATA       4       // Заполнить структуру параметрами соединения
#define RDS_NGSC_IPDATA         5       // Заполнить структуру параметрами машины
// Структура, заполняемая функцией rdsNetGetServerConnectionData
typedef struct // RDS_NGSCDATA
{ union
    { DWORD servSize;                     // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Mode;                      // Тип запрошенного параметра (RDS_NGSC_*)
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 ServerPort;                // Порт сервера, для которого эта информация заполнена
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 Index;                     // Индекс запрошенного параметра
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSCSTR ClientAddressA;             // Адрес клиента (UTF8)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ClientAddress;
      #endif
    };
  union
    { RDSWCSTR ClientAddressW;            // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ClientAddress;
      #endif
    };
  union
    { RDSINT32 IPIndex;                   // Индекс IP клиента в общей таблице (только для RDS_NGSC_CONNDATA и RDS_NGSC_IPDATA)
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 ClientPort;                // Порт клиента (только для RDS_NGSC_CONNDATA)
      RDSBIGGESTTYPE align7;
    };
  union
    { RDS_NETSTATION ClientStation;       // Идентификатор машины-клиента (только для RDS_NGSC_CONNDATA и RDS_NGSC_IPDATA)
      RDSBIGGESTTYPE align8;
    };
  union
    { BOOL Active;                        // Соединение активно, клиент подключен
      RDSBIGGESTTYPE align9;
    };
} RDS_NGSCDATA;
typedef RDS_NGSCDATA *RDS_PNGSCDATA;
//---------------------------------------------------------------------------

// Флаги для функции rdsSortVarArray  **** REV2 ****
#define RDS_RESIZEARR_ROW       0       // По строке (псевдо-флаг)
#define RDS_RESIZEARR_COL       1       // По столбцу
#define RDS_RESIZEARR_ASC       0       // По возрастанию (псевдо-флаг)
#define RDS_RESIZEARR_DESC      2       // По убыванию
//---------------------------------------------------------------------------

// Операции для функции rdsVarArrayOp  **** REV2 ****
#define RDS_ARROP_TRANSP        0       // Транспонировать
#define RDS_ARROP_INSROWS       1       // Вставить строки r1-r2 включительно
#define RDS_ARROP_INSROWSCNT    2       // Вставить r2 строк, начиная с r1
#define RDS_ARROP_INSCOLS       3       // Вставить столбцы c1-c2 включительно
#define RDS_ARROP_INSCOLSCNT    4       // Вставить c2 столбцов, начиная с c1
#define RDS_ARROP_DELROWS       5       // Удалить строки r1-r2 включительно
#define RDS_ARROP_DELROWSCNT    6       // Удалить r2 строк, начиная с r1
#define RDS_ARROP_DELCOLS       7       // Удалить столбцы c1-c2 включительно
#define RDS_ARROP_DELCOLSCNT    8       // Удалить c2 столбцов, начиная с c1
#define RDS_ARROP_CUT           9       // Вырезать часть матрицы, оставив только r1-r2,c1-c2 включительно
#define RDS_ARROP_CUTCNT        10      // Вырезать часть матрицы, оставив только r2 строк и с2 столбцов правее и ниже r1,c1
// Операции, НЕ ИЗМЕНЯЮЩИЕ реальный размер массива  **** REV3 ****
#define RDS_ARROP_MOVEROWS      1000    // Переместить строки от r1 до конца массива в положение r2, лишние заполнить значением по умолчанию
#define RDS_ARROP_MOVECOLS      1001    // Переместить столбцы от с1 до конца массива в положение с2, лишние заполнить значением по умолчанию
#define RDS_ARROP_MOVE1ROWCOL   1002    // Переместить строку r1 в положение r2 и столбец c1 в положение c2, "подвинув" остальные
//---------------------------------------------------------------------------

// Операции для функции rdsConsoleWindowOp  **** REV2 ****
#define RDS_CONS_CREATE         0       // Создать окно консоли
#define RDS_CONS_DELETE         1       // Закрыть окно консоли
#define RDS_CONS_SHOW           2       // Показать или скрыть окно консоли
#define RDS_CONS_SETTITLE       3       // Установить заголовок окна консоли
#define RDS_CONS_GETHANDLE      4       // Получить HWND окна консоли
//---------------------------------------------------------------------------

// Констатны для взаимодействия с объектом-валидатором имен rdsVNCreateNameValidator  **** REV2 ****
// Флаги
#define RDS_VN_F_CASESENSITIVE  1       // Имена чувствительны к регистру
#define RDS_VN_F_CRULES         2       // Проверять по правилам языка Си
#define RDS_VN_F_BLKNAMERULES   4       // Проверять по правилам имен блоков
#define RDS_VN_F_CRULESTRANSLIT 8       // Использовать транслитерацию при замене имени на допустимое (только для RDS_VN_F_CRULES)
// Константы функций установки
#define RDS_VN_ADDEXISTING      1       // Добавить существующее имя
#define RDS_VN_SETFALLBACK      2       // Установить имя для замены
#define RDS_VN_SETEXISTINGLIST  3       // Установить набор существующих имен
#define RDS_VN_ADDMORE          4       // Добавить имя в дополнительный список
#define RDS_VN_SETMORELIST      5       // Установить набор имен в дополнительном списке
// Результаты проверки (флаги, может быть взведено несколько)
#define RDS_VN_R_OK             0       // Все в порядке
#define RDS_VN_R_FATAL          1       // Внутренняя ошибка (неправильный  объект)
#define RDS_VN_R_EMPTY          2       // Пустое имя
#define RDS_VN_R_BADNAME        4       // Нарушены правила для имени
#define RDS_VN_R_EXISTING       8       // Имя существует
//---------------------------------------------------------------------------

// Операции для функций rdsMUOBlockOp и rdsMUOConnOp  **** REV2 ****
#define RDS_MUOOP_FINISH                0       // Завершение и запись в undo (блок/связь игнорируются, можно в CommandObject)
#define RDS_MUOOP_CLEAR                 1       // Очистка без записи в undo (блок/связь игнорируются, можно в CommandObject)
#define RDS_MUOOP_BEGINEDITBLOCK        2       // Перед изменением блока
#define RDS_MUOOP_ENDEDITBLOCK          3       // После изменения блока
#define RDS_MUOOP_BEGINEDITCONN         4       // Перед изменением связи
#define RDS_MUOOP_ENDEDITCONN           5       // После изменения связи
#define RDS_MUOOP_ADDBLOCK              6       // После добавления блока
#define RDS_MUOOP_DELETEBLOCK           7       // Перед удалением блока
#define RDS_MUOOP_ADDCONN               8       // После добавления связи
#define RDS_MUOOP_DELETECONN            9       // Перед удалением связи
#define RDS_MUOOP_CANCELEDIT            10      // Отмена любой операции с begin.../end...
#define RDS_MUOOP_JOINWITHNEXT          11      // Разрешить объединение со следующей операцией (блок/связь игнорируются, можно в CommandObject)
#define RDS_MUOOP_NOJOINWITHNEXT        12      // Запретить объединение со следующей операцией (по умолчанию, блок/связь игнорируются, можно в CommandObject)
#define RDS_MUOOP_FORCEREFRESH          13      // Обновить все окна принудительно (блок/связь игнорируются, можно в CommandObject)
#define RDS_MUOOP_NORMALREFRESH         14      // Обычное обновление окон (по умолчанию, блок/связь игнорируются, можно в CommandObject)
#define RDS_MUOOP_JOINWITHPREV          15      // Разрешить объединение с предыдущей операцией (блок/связь игнорируются, можно в CommandObject)
#define RDS_MUOOP_NOJOINWITHPREV        16      // Запретить объединение с предыдущей операцией (по умолчанию, блок/связь игнорируются, можно в CommandObject)
//---------------------------------------------------------------------------

// Операции для функций rdsSetBlockClass и rdsSetConnClass  **** REV2 ****
#define RDS_SETCLASS_ADD                0       // Добавить класс
#define RDS_SETCLASS_REMOVE             1       // Удалить класс
#define RDS_SETCLASS_SETONLY            2       // Сделать единственным классом
#define RDS_SETCLASS_CLEAR              3       // Удалить все
//---------------------------------------------------------------------------

// Флаги для функции rdsScrollWindowToRectEx  **** REV2 ****
#define RDS_SWRF_ZOOMOUT        1       // Уменьшить масштаб, если прямоугольник не умещается в окно
#define RDS_SWRF_ALWAYSSCROLL   2       // Прокручивать в центр, даже если прямоугольник умещается
//---------------------------------------------------------------------------

// Констатны для взаимодействия с объектом информационного окна rdsINFOCreate  **** REV2 ****
#define RDS_INFO_SETTEXT        0       // Установить текст (rdsSetObjectStr)
#define RDS_INFO_SETCAPTION     1       // Установить заголовок (rdsSetObjectStr)
#define RDS_INFO_SETICON        2       // Установить иконку (rdsSetObjectInt)
  #define RDS_INFOICON_NONE  0 // Нет
  #define RDS_INFOICON_INFO  1 // Информация
  #define RDS_INFOICON_WARN  2 // Предупреждение
#define RDS_INFO_SETFONTNAME    3       // Установить название шрифта (rdsSetObjectStr)
#define RDS_INFO_SETFONTHEIGHT  4       // Установить высоту шрифта (rdsSetObjectInt)
#define RDS_INFO_SETFONTCOLOR   5       // Установить цвет шрифта (rdsSetObjectInt)
#define RDS_INFO_FONTFLAGS      6       // Установить флаги шрифта (rdsSetObjectInt) или получить их (rdsGetObjectInt)
                                        // (RDS_GFBOLD,RDS_GFITALIC,RDS_GFUNDERLINE,RDS_GFSTRIKEOUT)
#define RDS_INFO_SHOW           9       // Показать (rdsSetObjectInt,rdsCommandObject) или проверить видимость (rdsGetObjectInt)
#define RDS_INFO_HIDE           10      // Скрыть (rdsSetObjectInt,rdsCommandObject)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Описания для модулей автокомпиляции (в версии 1.x были в "RdsComp.h")
//---------------------------------------------------------------------------
// Сообщения (режимы вызова)
#define RDS_COMPM_INIT          0 // Инициализация модуля
#define RDS_COMPM_CLEANUP       1 // Очистка (вызывается перед удалением модуля)
#define RDS_COMPM_MODELINIT     2 // Инициализация модели
#define RDS_COMPM_MODELCLEANUP  3 // Очистка модели (вызывается перед отключением модели)
#define RDS_COMPM_SETUP         5 // Вызов функции настройки
#define RDS_COMPM_ATTACHBLOCK   6 // Добавление блока к модели
#define RDS_COMPM_DETACHBLOCK   7 // Отключение блока от модели
#define RDS_COMPM_PREPARE       8 // Подготовиться к компиляции и проверить ее
                                  // необходимость
#define RDS_COMPM_COMPILE       9 // Компилировать
#define RDS_COMPM_STRUCTCHANGE 10 // Сообщение об изменении структуры
#define RDS_COMPM_OPENEDITOR   11 // Открыть окно редактора модели
#define RDS_COMPM_CANRENMODEL  12 // Можно ли переименовать модель (вызывается перед переименованием)
#define RDS_COMPM_MODELRENAMED 13 // Переименовать модель (вызывается после переименования)
#define RDS_COMPM_GETOPTIONS   14 // Получить флаги поддерживаемых функций
#define RDS_COMPM_EXECFUNCTION 15 // Выполнить одну из функций RDS_COMPFLAG_*
#define RDS_COMPM_SAVESYSTEM   16 // Вызывается перед сохранением системы
#define RDS_COMPM_CANATTACHBLK 17 // Вызывается перед добавлением блока к модели
                                  // (самой модели может еще не быть)
#define RDS_COMPM_SAVEBLOCK    18 // Вызывается перед сохранением каждого блока с моделью
                                  // (можно скорректировать имя модели перед сохранением)
#define RDS_COMPM_CLOSEALLWIN  19 // Закрыть все немодальные окна
#define RDS_COMPM_MODECHANGE   20 // Изменился режим RDS (редактирование, моделирование, расчет)

#define RDS_COMPM_AFTERSAVESYSTEM 21 // Вызывается после сохранения системы **** REV2 ****
#define RDS_COMPM_BEGINPASTE      22 // Начинается вставка блоков из буфера обмена **** REV2 ****
#define RDS_COMPM_ENDPASTE        23 // Закончена вставка блоков из буфера обмена **** REV2 ****
#define RDS_COMPM_AFTERLOADSYSTEM 24 // Вызывается после загрузки системы **** REV2 ****
#define RDS_COMPM_MODELPOSTINIT   25 // Альтернативная инициализация модели (аналог RDS_COMPM_MODELINIT с дополнительными параметрами) **** REV2 ****
#define RDS_COMPM_BLOCKDELETE    26 // Удаление блока из схемы **** REV2 ****
#define RDS_COMPM_ISEDITOROPEN   27 // Открыт ли редактор модели **** REV2 ****
#define RDS_COMPM_BLOCKFROMFILE  28 // Блок только что вставлен из библиотеки или файла **** REV2 ****
#define RDS_COMPM_BLOCKLIBRARYOP 29 // Какая-то операция с блоком в библиотеке **** REV2 ****
#define RDS_COMPM_SAVETEMPGLOBAL 30 // Записать глобальные данные в память при сохранении для буфера обмена или сервисной функции **** REV2 ****
#define RDS_COMPM_EXPIMPUIDATA   31 // Экспорт/импорт модификации пользовательского интерфейса для моделей схемы **** REV2 ****
#define RDS_COMPM_SETUPISOK      32 // Проверка наличия у этого модуля настроек (при поиске совместимого с моделью) **** REV2 ****
#define RDS_COMPM_TESTCOMPILE    33 // Выполнение тестовой (проверочной) компиляции модели **** REV2 ****

// Возвращаемые функцией значения
#define RDS_COMPR_DONE          0 // Нормальное завершение (для всех режимов)
#define RDS_COMPR_ERROR         1 // Ошибка
#define RDS_COMPR_ERRORNOMSG    2 // Ошибка, не выводить сообщение (для некоторых режимов)

// Уникальный идентификатор модуля автокомпиляции
typedef LPVOID RDS_COMPHANDLE;
// Уникальный идентификатор модели
typedef LPVOID RDS_MODELHANDLE;

// Данные модуля автокомпиляции (хранятся все время существования модуля)
typedef struct // RDS_COMPMODULEDATA
{ union
    { RDS_COMPHANDLE Module;       // Идентификатор модуля (только чтение)
      RDSBIGGESTTYPE align0;
    };
  union
    { LPVOID ModuleData;           // Адрес области данных модуля (чтение/запись)
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR DllFullPathA;        // Полный путь к DLL модуля (UTF8, только чтение)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR DllFullPath;
      #endif
    };
  union
    { RDSWCSTR DllFullPathW;       // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR DllFullPath;
      #endif
    };
  union
    { RDSCSTR DllFuncNameA;        // Имя функции DLL модуля (UTF8, только чтение)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR DllFuncName;
      #endif
    };
  union
    { RDSWCSTR DllFuncNameW;       // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR DllFuncName;
      #endif
    };
  union
    { RDSINT32 NModels;            // Число моделей, связанных с данным модулем (только чтение)
      RDSBIGGESTTYPE align6;
    };


  // Предлагаемое имя файла для хранения настроек (только для модулей, заданных файлами описания, только чтение)
  // Для модулей, не находящихся в общем списке, передается пустая строка **** REV2 ****
  union
    { RDSCSTR DataFileA;           // UTF8
      RDSBIGGESTTYPE align7;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR DataFile;
      #endif
    };
  union
    { RDSWCSTR DataFileW;          // То же в UTF16
      RDSBIGGESTTYPE align8;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR DataFile;
      #endif
    };

  // Текстовый уникальный идентификатор формата модели **** REV2 ****
  union
    { RDSCSTR ModelFormatA;        // UTF8
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelFormat;
      #endif
    };
  union
    { RDSWCSTR ModelFormatW;       // То же в UTF16
      RDSBIGGESTTYPE align10;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelFormat;
      #endif
    };
} RDS_COMPMODULEDATA;
typedef RDS_COMPMODULEDATA *RDS_PCOMPMODULEDATA;
//---------------------------------------------------------------------------

// Данные модели (хранятся все время существования модели)
typedef struct // RDS_COMPMODELDATA
{ union
    { RDS_MODELHANDLE Model;        // Идентификатор модели (только чтение)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR ModelNameA;           // Имя модели (UTF8, только чтение)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelName;
      #endif
    };
  union
    { RDSWCSTR ModelNameW;          // То же в UTF16
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelName;
      #endif
    };
  union
    { RDSCSTR ModelNameUCA;         // Имя модели в верхнем регистре (UTF8, только чтение)
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelNameUC;
      #endif
    };
  union
    { RDSWCSTR ModelNameUCW;        // То же в UTF16
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelNameUC;
      #endif
    };
  union
    { LPVOID ModelData;             // Адрес области данных модели (чтение/запись)
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 NBlocks;             // Число блоков, связанных с данной моделью (только чтение)
      RDSBIGGESTTYPE align6;
    };
  union
    { RDS_COMPHANDLE Module;        // Идентификатор модуля автокомпиляции, к которому относится
                                    // модель (только чтение)
      RDSBIGGESTTYPE align7;
    };
  // Параметры, устанавливаемые модулем автокомпиляции
  union
    { RDSCSTR CompDllNameA;         // DLL скомпилированной модели (UTF8, только чтение,
                                    // установка сервисной функцией во время вызова BFCM_COMP_PREPARE)
      RDSBIGGESTTYPE align8;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR CompDllName;
      #endif
    };
  union
    { RDSWCSTR CompDllNameW;        // То же в UTF16
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR CompDllName;
      #endif
    };
  union
    { RDSCSTR CompDllFuncA;         // Имя функции скомпилированной модели (UTF8, только чтение,
                                    // установка сервисной функцией во время вызова BFCM_COMP_PREPARE)
      RDSBIGGESTTYPE align10;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR CompDllFunc;
      #endif
    };
  union
    { RDSWCSTR CompDllFuncW;        // То же в UTF16
      RDSBIGGESTTYPE align11;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR CompDllFunc;
      #endif
    };
  union
    { BOOL Valid;                   // Признак необходимости перекомпиляции (чтение/запись, устанавливается
                                    // модулем во время вызова BFCM_COMP_PREPARE)
      RDSBIGGESTTYPE align12;
    };
  // Дополнительные параметры
  union
    { RDSCSTR AltModelNameA;        // Альтернативное имя модели (UTF8, только чтение). Хранится в схеме и может
                                    // использоваться модулем автокомпиляции для своих нужд. При подключении
                                    // новой модели через окно параметров блока всегда содержит пустую строку.
                                    // Устанавливается функцией rdscompSetAltModelName.
      RDSBIGGESTTYPE align13;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR AltModelName;
      #endif
    };
  union
    { RDSWCSTR AltModelNameW;       // То же в UTF16
      RDSBIGGESTTYPE align14;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR AltModelName;
      #endif
    };
  // Целое пользовательское поле (не обрабатывается и не инициализируется)
  union
    { RDSINT32 Tag;
      RDSBIGGESTTYPE align15;
    };
  union
    { RDSINT32 ModelVersion;        // Версия модели (устанавливается модулем) **** REV2 ****
      RDSBIGGESTTYPE align16;
    };
  union
    { DWORD ModelVersionDate;       // Дата модели (устанавливается модулем) **** REV2 ****
      RDSBIGGESTTYPE align17;
    };
} RDS_COMPMODELDATA;
typedef RDS_COMPMODELDATA *RDS_PCOMPMODELDATA;
typedef RDS_PCOMPMODELDATA *RDS_PCOMPMODELDATA_ARR;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_CANATTACHBLK
typedef struct // RDS_COMPCANATTACHBLKDATA
{ union
    { RDSCSTR ModelNameA;           // Имя модели (UTF8, только чтение)
      RDSBIGGESTTYPE align0;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelName;
      #endif
    };
  union
    { RDSWCSTR ModelNameW;          // То же в UTF16
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelName;
      #endif
    };
  union
    { RDSCSTR ModelNameUCA;         // Имя модели в верхнем регистре (UTF8, только чтение)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelNameUC;
      #endif
    };
  union
    { RDSWCSTR ModelNameUCW;        // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelNameUC;
      #endif
    };
  union
    { RDSCSTR AltModelNameA;        // Альтернативное имя модели (UTF8,только чтение)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR AltModelName;
      #endif
    };
  union
    { RDSWCSTR AltModelNameW;       // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR AltModelName;
      #endif
    };

  union
    { RDS_BHANDLE Block;            // Блок (только чтение)
      RDSBIGGESTTYPE align6;
    };

  union
    { RDSINT32 AttachReason;        // Причина подключения блока к модели (RDS_COMP_AR_*) (только чтение)
      RDSBIGGESTTYPE align7;
    };

  union
    { BOOL ChangeModel;             // Подключить другую модель вместо этой (запись)
                                    // По умолчанию - FALSE. Для подключения вместо указанной другой
                                    // модели следует установить в TRUE и передать новое имя модели при
                                    // помощи функции rdscompAttachDifferentModel
      RDSBIGGESTTYPE align8;
    };

  union
    { RDSCSTR BlockFileA;           // Имя файла блока или NULL (UTF8, только чтение,
                                    // только при AttachReason==RDS_COMP_AR_LOADFROMFILE или RDS_COMP_AR_LOADSYSTEM) **** REV2 ****
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR BlockFile;
      #endif
    };
  union
    { RDSWCSTR BlockFileW;          // То же в UTF16
      RDSBIGGESTTYPE align10;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR BlockFile;
      #endif
    };
  union
    { BOOL LoadSingleBlock;         // Идет загрузка одного блока (подсистемы) внутрь схемы (только чтение,
                                    // только при AttachReason==RDS_COMP_AR_LOADFROMFILE или RDS_COMP_AR_LOADSYSTEM) **** REV2 ****
      RDSBIGGESTTYPE align11;
    };
} RDS_COMPCANATTACHBLKDATA;
typedef RDS_COMPCANATTACHBLKDATA *RDS_PCOMPCANATTACHBLKDATA;
// Причины подключения блока (для AttachReason)
#define RDS_COMP_AR_UNKNOWN             0       // Неизвестно (внутренняя ошибка)
#define RDS_COMP_AR_LOADSYSTEM          1       // Загрузка всей системы
#define RDS_COMP_AR_LOADCLIPBRD         2       // Загрузка блоков из буфера обмена
#define RDS_COMP_AR_LOADFROMFILE        3       // Загрузка одиночного блока из библиотеки
#define RDS_COMP_AR_LOADUNDO            4       // Загрузка из-за отмены изменений
#define RDS_COMP_AR_MANUALSET           5       // Новая модель задана в окне параметров
                                                // или сервисной функцией
#define RDS_COMP_AR_RENAMEMODEL         6       // Переименование модели (т.е. подключение
                                                // всех блоков к переименованной)
#define RDS_COMP_AR_LOADPROG            7       // Загрузка блоков из памяти сервисной функцией
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщениями RDS_COMPM_ATTACHBLOCK и RDS_COMPM_DETACHBLOCK
typedef struct // RDS_COMPBLOCKOPDATA
{ union
    { RDS_PCOMPMODELDATA Model;       // Модель
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_BHANDLE Block;              // Блок
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 AttachReason;          // Причина подключения блока к модели
                                      // (RDS_COMP_AR_*, только для RDS_COMPM_ATTACHBLOCK)
      RDSBIGGESTTYPE align2;
    };
} RDS_COMPBLOCKOPDATA;
typedef RDS_COMPBLOCKOPDATA *RDS_PCOMPBLOCKOPDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_BLOCKDELETE
typedef struct // RDS_COMPBLOCKDELDATA
{ union
    { RDS_PCOMPMODELDATA Model;       // Модель
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_BHANDLE Block;              // Блок
      RDSBIGGESTTYPE align1;
    };
} RDS_COMPBLOCKDELDATA;
typedef RDS_COMPBLOCKDELDATA *RDS_PCOMPBLOCKDELDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_MODELPOSTINIT
typedef struct // RDS_COMPMPOSTINITDATA
{ union
    { RDS_PCOMPMODELDATA Model;       // Модель
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 AttachReason;          // Причина подключения модели
                                      // (RDS_COMP_AR_*)
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR BlockFileA;             // Имя файла блока или NULL (UTF8, только чтение,
                                      // только при AttachReason==RDS_COMP_AR_LOADFROMFILE) **** REV2 ****
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR BlockFile;
      #endif
    };
  union
    { RDSWCSTR BlockFileW;            // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR BlockFile;
      #endif
    };
} RDS_COMPMPOSTINITDATA;
typedef RDS_COMPMPOSTINITDATA *RDS_PCOMPMPOSTINITDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_OPENEDITOR и RDS_COMPM_ISEDITOROPEN
typedef struct // RDS_OPENEDITORDATA
{ union
    { RDS_PCOMPMODELDATA Model;       // Данные модели
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_BHANDLE Block;              // Блок, для которого вызван редактор (только для RDS_COMPM_OPENEDITOR)
      RDSBIGGESTTYPE align1;
    };
} RDS_OPENEDITORDATA;
typedef RDS_OPENEDITORDATA *RDS_POPENEDITORDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_PREPARE
typedef struct // RDS_COMPPREPAREDATA
{ union
    { RDS_PCOMPMODELDATA Model;       // Данные проверяемой и подготавливаемой модели
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Rebuild;                   // TRUE если проверка не нужна (при принудительной
                                      // перекомпиляции всех моделей независимо от их
                                      // состояния)
      RDSBIGGESTTYPE align1;
    };
} RDS_COMPPREPAREDATA;
typedef RDS_COMPPREPAREDATA *RDS_PCOMPPREPAREDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_COMPILE
typedef struct // RDS_COMPILEDATA
{ union
    { RDS_PCOMPMODELDATA_ARR InvalidModels;       // Модели, которые нужно компилировать
                                                  // (массив адресов структур)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 IMCount;                           // Размер массива InvalidModels
      RDSBIGGESTTYPE align1;
    };
  union
    { BOOL Rebuild;                               // TRUE - принудительная перекомпиляция
                                                  // всех моделей
      RDSBIGGESTTYPE align2;
    };
} RDS_COMPILEDATA;
typedef RDS_COMPILEDATA *RDS_PCOMPILEDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_STRUCTCHANGE
typedef struct // RDS_COMPSTRUCTCHGDATA
{ union
    { RDSCSTR OldStructTypeA;        // Имя типа структуры до изменения (UTF8)
      RDSBIGGESTTYPE align0;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR OldStructType;
      #endif
    };
  union
    { RDSWCSTR OldStructTypeW;       // То же в UTF16
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR OldStructType;
      #endif
    };
  union
    { RDSCSTR NewStructTypeA;        // Имя типа структуры после изменения (UTF8)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR NewStructType;
      #endif
    };
  union
    { RDSWCSTR NewStructTypeW;       // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR NewStructType;
      #endif
    };
  union
    { BOOL Renamed;                  // Структура переименована (OldStructType не совпадает с NewStructType)
      RDSBIGGESTTYPE align4;
    };
} RDS_COMPSTRUCTCHGDATA;
typedef RDS_COMPSTRUCTCHGDATA *RDS_PCOMPSTRUCTCHGDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщениями RDS_COMPM_CANRENMODEL и RDS_COMPM_MODELRENAMED
typedef struct // RDS_COMPMODELRENAMEDATA
{ union
    { RDS_PCOMPMODELDATA Model;       // Данные модели, которая будет переименована (для RDS_COMPM_CANRENMODEL)
                                      // или уже переименована (для RDS_COMPM_MODELRENAMED)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR OldModelNameA;          // Старое имя модели (UTF8)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR OldModelName;
      #endif
    };
  union
    { RDSWCSTR OldModelNameW;         // То же в UTF16
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR OldModelName;
      #endif
    };
  union
    { RDSCSTR NewModelNameA;          // Новое имя модели (UTF8)
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR NewModelName;
      #endif
    };
  union
    { RDSWCSTR NewModelNameW;         // То же в UTF16
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR NewModelName;
      #endif
    };
  // Возврат
  union
    { BOOL AllowRename;               // Переименование разрешено (возврат для RDS_COMPM_CANRENMODEL)
      RDSBIGGESTTYPE align5;
    };
} RDS_COMPMODELRENAMEDATA;
typedef RDS_COMPMODELRENAMEDATA *RDS_PCOMPMODELRENAMEDATA;
//---------------------------------------------------------------------------

// Флаги, возвращаемые в ответ на RDS_COMPM_GETOPTIONS
#define RDS_COMPFLAG_FUNCMODELUSERINPUT 1       // Можно вводить имя модели вручную
#define RDS_COMPFLAG_FUNCMODELBROWSE    2       // Работает кнопка "Обзор"
#define RDS_COMPFLAG_FUNCMODELCREATE    4       // Работает кнопка "Создать"
#define RDS_COMPFLAG_FUNCMODELSAVEAS    8       // Работает кнопка "Сохранить как..."

#define RDS_COMPFLAG_CANCHANGESTRUCT    16      // Модуль может менять структуры в моделях при
                                                // из изменении в RDS

#define RDS_COMPFLAG_CANTESTCOMPILE     32      // Модуль может выполнять тестовую компиляцию моделей **** REV2 ****

                                                // Структура, передаваемая вместе с сообщением RDS_COMPM_EXECFUNCTION
typedef struct // RDS_COMPEXECFUNCDATA
{ union
    { RDSINT32 Function;           // Функция (RDS_COMPFLAG_FUNC*)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR ModelNameA;          // Содержимое строки модели (UTF8)
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelName;
      #endif
    };
  union
    { RDSWCSTR ModelNameW;         // То же в UTF16
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelName;
      #endif
    };
  // Следующие параметры могут быть не определены для некоторых функций.
  union
    { RDS_HOBJECT BlockVars;       // Переменные блока (если есть, только при Function==RDS_COMPFLAG_FUNCMODELCREATE)
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 BlockType;          // Тип блока (RDS_BT* или RDS_TUNKNOWN, см. RdsDef.h)
      RDSBIGGESTTYPE align4;
    };
} RDS_COMPEXECFUNCDATA;
typedef RDS_COMPEXECFUNCDATA *RDS_PCOMPEXECFUNCDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщениями RDS_COMPM_SAVESYSTEM
// и RDS_COMPM_AFTERSAVESYSTEM **** REV2 ****
typedef struct // RDS_COMPSAVESYSTEMDATA
{ union
    { RDSCSTR FileNameA;           // Имя сохраняемого файла (UTF8)
      RDSBIGGESTTYPE align0;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR FileName;
      #endif
    };
  union
    { RDSWCSTR FileNameW;          // То же в UTF16
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR FileName;
      #endif
    };
  union
    { RDSCSTR OldFileNameA;        // Имя файла до сохранения или NULL при первом сохранении
                                   // созданной системы (UTF8)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR OldFileName;
      #endif
    };
  union
    { RDSWCSTR OldFileNameW;       // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR OldFileName;
      #endif
    };
} RDS_COMPSAVESYSTEMDATA;
typedef RDS_COMPSAVESYSTEMDATA *RDS_PCOMPSAVESYSTEMDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_SAVEBLOCK
typedef struct // RDS_COMPSAVEBLOCKDATA
{ union
    { RDS_PCOMPMODELDATA Model;       // Данные сохраняемой модели
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_BHANDLE Block;              // Сохраняемый блок
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 SaveAction;            // Причина сохранения (RDS_LS_SAVE*)
      RDSBIGGESTTYPE align2;
    };

  union
    { BOOL ChangeName;                // Записать другое имя модели (запись)
                                      // По умолчанию - FALSE. Для записи вместо указанной другой
                                      // модели следует установить в TRUE и передать новое имя модели при
                                      // помощи функции rdscompAttachDifferentModel
      RDSBIGGESTTYPE align3;
    };

  union
    { RDSCSTR TargetFileA;            // Полный путь к файлу, куда сохраняется блок или вся схема (UTF8), или NULL **** REV2 ****
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR TargetFile;
      #endif
    };
  union
    { RDSWCSTR TargetFileW;           // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR TargetFile;
      #endif
    };
  union
    { BOOL SaveSingleBlock;           // Идет сохранение одного блока (подсистемы) в отдельный файл **** REV2 ****
      RDSBIGGESTTYPE align6;
    };
} RDS_COMPSAVEBLOCKDATA;
typedef RDS_COMPSAVEBLOCKDATA *RDS_PCOMPSAVEBLOCKDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_BLOCKFROMFILE
typedef struct // RDS_COMPBLOCKFROMFILEDATA
{ union
    { RDS_BHANDLE Block;
      RDSBIGGESTTYPE align0;
    };
} RDS_COMPBLOCKFROMFILEDATA;
typedef RDS_COMPBLOCKFROMFILEDATA *RDS_PCOMPBLOCKFROMFILEDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_SAVETEMPGLOBAL
typedef struct // RDS_COMPSAVETEMPGLOBALDATA
{ union
    { RDS_PCOMPMODELDATA Model;       // Данные сохраняемой модели
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 SaveAction;            // Причина сохранения (RDS_LS_SAVE*)
      RDSBIGGESTTYPE align1;
    };
} RDS_COMPSAVETEMPGLOBALDATA;
typedef RDS_COMPSAVETEMPGLOBALDATA *RDS_PCOMPSAVETEMPGLOBALDATA;
//---------------------------------------------------------------------------

// Структура, передаваемая вместе с сообщением RDS_COMPM_EXPIMPUIDATA
typedef struct // RDS_COMPEXPIMPUIDATA
{ union
    { BOOL Export;                  // TRUE - экспорт, FALSE - импорт
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR CategoryA;            // Категория данных (например, RDS_UIMODC_LANGUAGE), UTF8
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Category;
      #endif
    };
  union
    { RDSWCSTR CategoryW;           // То же в UTF16
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Category;
      #endif
    };
  union
    { RDSCSTR ModificationA;        // Модификация (например, язык), UTF8, NULL для модификации по умолчанию при экспорте
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR Modification;
      #endif
    };
  union
    { RDSWCSTR ModificationW;       // То же в UTF16
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR Modification;
      #endif
    };
  union
    { BOOL OnlyNew;                 // При экспорте - сохранять только новые параметры
      RDSBIGGESTTYPE align5;
    };

  union
    { RDS_HOBJECT Storage;          // Объект с данными
      RDSBIGGESTTYPE align6;
    };

  union
    { RDSCSTR ModuleStringA;        // Уникальная строка этого модуля для формирования имени группы (обычно имя DLL + имя функции), UTF8
      RDSBIGGESTTYPE align7;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModuleString;
      #endif
    };
  union
    { RDSWCSTR ModuleStringW;       // То же в UTF16
      RDSBIGGESTTYPE align8;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModuleString;
      #endif
    };

  // Параметры файла, для которого создан объект Storage
  union
    { RDSCSTR FileA;                // Выбранный пользователем файл (UTF8)
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR File;
      #endif
    };
  union
    { RDSWCSTR FileW;               // То же в UTF16
      RDSBIGGESTTYPE align10;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR File;
      #endif
    };
  union
    { RDSINT32 Format;              // Формат файла (RDS_UIFRMT_*)
      RDSBIGGESTTYPE align11;
    };

  union
    { RDSINT32 Result;              // Возвращаемый результат (см. ниже)
      RDSBIGGESTTYPE align12;
    };
} RDS_COMPEXPIMPUIDATA;
// Значения RDS_COMPEXPIMPUIDATA::Result
#define RDS_COMPM_UIRES_OK                  0       // OK
#define RDS_COMPM_UIRES_NOTSUPPORTED        1       // Не поддерживается модулем
#define RDS_COMPM_UIRES_NOTHING             2       // Ничего не экспортировано
#define RDS_COMPM_UIRES_ERROR               3       // Ошибка чтения/записи
typedef RDS_COMPEXPIMPUIDATA *RDS_PCOMPEXPIMPUIDATA;
//---------------------------------------------------------------------------

// Данные тестовой компиляции модели
// Передается вмести с сообщением RDS_COMPM_TESTCOMPILE
typedef struct // RDS_COMPTESTCOMPDATA
{ union
    { RDSCSTR ModelFormatA;         // Строка формата модели (UTF8, только чтение)
      RDSBIGGESTTYPE align0;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelFormat;
      #endif
    };
  union
    { RDSWCSTR ModelFormatW;        // То же в UTF16
      RDSBIGGESTTYPE align1;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelFormat;
      #endif
    };
  union
    { RDSCSTR ModelNameA;           // Имя модели (UTF8, только чтение)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelName;
      #endif
    };
  union
    { RDSWCSTR ModelNameW;          // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelName;
      #endif
    };
  union
    { RDSCSTR ModelNameUCA;         // Имя модели в верхнем регистре (UTF8, только чтение)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelNameUC;
      #endif
    };
  union
    { RDSWCSTR ModelNameUCW;        // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelNameUC;
      #endif
    };
  union
    { RDSCSTR AltModelNameA;        // Альтернативное имя модели (UTF8,только чтение)
      RDSBIGGESTTYPE align6;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR AltModelName;
      #endif
    };
  union
    { RDSWCSTR AltModelNameW;       // То же в UTF16
      RDSBIGGESTTYPE align7;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR AltModelName;
      #endif
    };
} RDS_COMPTESTCOMPDATA;
typedef RDS_COMPTESTCOMPDATA *RDS_PCOMPTESTCOMPDATA;
//---------------------------------------------------------------------------

// Функция вызова модуля автокомпиляции - тип указателя
typedef int(RDSCALL *RDS_COMPENTRYPOINT)(int,RDS_PCOMPMODULEDATA,LPVOID);
//---------------------------------------------------------------------------

// Описание операции с библиотекой блоков
// Передается вмести с сообщением RDS_COMPM_BLOCKLIBRARYOP или заполняется функцией rdscompLibraryOperation
typedef struct // RDS_COMPLIBRARYOPDATA
{ union
    { DWORD servSize;                   // Размер этой структуры в байтах (необходимо присвоить перед вызовом функций)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Operation;               // Операция (RDS_LOP_*)
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR BlockFilePathA;           // Путь к файлу блока, с которым проводится операция (UTF8)
      RDSBIGGESTTYPE align2;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR BlockFilePath;
      #endif
    };
  union
    { RDSWCSTR BlockFilePathW;          // То же в UTF16
      RDSBIGGESTTYPE align3;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR BlockFilePath;
      #endif
    };
  union
    { RDSCSTR SystemPathA;              // Путь к файлу схемы, в которую вставляется блок для RDS_LOP_PASTE (UTF8)
      RDSBIGGESTTYPE align4;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR SystemPath;
      #endif
    };
  union
    { RDSWCSTR SystemPathW;             // То же в UTF16
      RDSBIGGESTTYPE align5;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR SystemPath;
      #endif
    };
  union
    { RDSCSTR OldBlockFilePathA;        // Путь к исходному файлу блока для RDS_LOP_COPY и RDS_LOP_RENAME (UTF8)
      RDSBIGGESTTYPE align6;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR OldBlockFilePath;
      #endif
    };
  union
    { RDSWCSTR OldBlockFilePathW;       // То же в UTF16
      RDSBIGGESTTYPE align7;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR OldBlockFilePath;
      #endif
    };
  // Следующие поля - только при реакции на сообщение RDS_COMPM_BLOCKLIBRARYOP
  union
    { RDSINT32 Status;                  // Состояние (RDS_LOPST_*)
      RDSBIGGESTTYPE align8;
    };
  union
    { RDSCSTR ModelNameA;               // Имя модели (UTF8)
      RDSBIGGESTTYPE align9;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR ModelName;
      #endif
    };
  union
    { RDSWCSTR ModelNameW;              // То же в UTF16
      RDSBIGGESTTYPE align10;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR ModelName;
      #endif
    };
  union
    { RDSCSTR AltModelNameA;            // Альтернативное имя модели (UTF8)
      RDSBIGGESTTYPE align11;
      #if (!defined(RDS_NO_UTFALIASES)) && (!defined(RDS_UTF16DEFAULT))
        RDSCSTR AltModelName;
      #endif
    };
  union
    { RDSWCSTR AltModelNameW;           // То же в UTF16
      RDSBIGGESTTYPE align12;
      #if (!defined(RDS_NO_UTFALIASES)) && defined(RDS_UTF16DEFAULT)
        RDSWCSTR AltModelName;
      #endif
    };
} RDS_COMPLIBRARYOPDATA;
// Значения RDS_COMPLIBRARYOPDATA::Operation
#define RDS_LOP_NONE        0       // Действий с библиотекой сейчас не производится
#define RDS_LOP_PASTE       1       // Вставка блока в подсистему из буфера обмена для последующей записи в библиотеку
#define RDS_LOP_SAVE        2       // Сохранение блока из памяти в файл
#define RDS_LOP_COPY        3       // Копирование библиотечного блока
#define RDS_LOP_RENAME      4       // Переименование библиотечного блока
#define RDS_LOP_DELETE      5       // Удаление библиотечного блока
//  Значения RDS_COMPLIBRARYOPDATA::Status
#define RDS_LOPST_NONE      0       // Не реакция на сообщение, поля модели не заполнены
#define RDS_LOPST_BEGIN     1       // Перед операцией, поля модели не заполнены
#define RDS_LOPST_END       2       // После операции, поля модели не заполнены
#define RDS_LOPST_MODEL     3       // Вызов для модели, поля модели заполнены
typedef RDS_COMPLIBRARYOPDATA *RDS_PCOMPLIBRARYOPDATA;
//---------------------------------------------------------------------------

// Типы возвращаемых строк для rdscompTestCompReturnString **** REV2 ****
#define RDS_TCRS_ERRORS     0 // Список ошибок
#define RDS_TCRS_COMPNAME   1 // Название компилятора
#define RDS_TCRS_ERRHEADER  2 // Общее сообщение об ошибках
//---------------------------------------------------------------------------

// Дополнительная функция блока (для rdsBlockHook...) **** REV3 ****
typedef void (RDSCALL *RDS_BLOCKHOOKFUNCTION)(LPVOID,RDSINT32,RDS_PBLOCKDATA,LPVOID);
// Идентификатор дополнительной функции **** REV3 ****
typedef LPVOID RDS_BLOCKHOOK;
// Флаги вызова дополнительной функции **** REV3 ****
#define RDS_HOOKFLAG_ONECALL  1   // Удалить после первого вызова
//---------------------------------------------------------------------------

// Флаги для функции rdsCallFontDialogEx
#define RDS_CFTD_NONE       0 // Нет флагов
#define RDS_CFTD_NOCOLOR    1 // Не задавать цвет
#define RDS_CFTD_BACKGROUND 2 // Использовать цвет фона для образца шрифта в диалоге
//---------------------------------------------------------------------------


// Интерфейсные функции - типы указателей
typedef void (RDSCALL *RDS_VS)(RDSCSTR);
typedef void (RDSCALL *RDS_VWs)(RDSWCSTR);
typedef RDSINT32 (RDSCALL *RDS_IV)(void);
typedef HWND (RDSCALL *RDS_HwV)(void);
typedef RDS_BHANDLE (RDSCALL *RDS_BhV)(void);
typedef RDSINT32 (RDSCALL *RDS_IBhBd)(RDS_BHANDLE,RDS_PBLOCKDESCRIPTION);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhIBd)(RDS_BHANDLE,RDSINT32,RDS_PBLOCKDESCRIPTION);
typedef RDSINT32 (RDSCALL *RDS_IChCd)(RDS_CHANDLE,RDS_PCONNDESCRIPTION);
typedef RDS_CHANDLE (RDSCALL *RDS_ChBhICd)(RDS_BHANDLE,RDSINT32,RDS_PCONNDESCRIPTION);
typedef RDS_CHANDLE (RDSCALL *RDS_ChChICd)(RDS_CHANDLE,RDSINT32,RDS_PCONNDESCRIPTION);
typedef RDSINT32 (RDSCALL *RDS_IChIPd)(RDS_CHANDLE,RDSINT32,RDS_PPOINTDESCRIPTION);
typedef LPSTR (RDSCALL *RDS_SI)(RDSINT32);
typedef RDSWCSTR (RDSCALL *RDS_WsI)(RDSINT32);
typedef LPSTR (RDSCALL *RDS_SV)(void);
typedef RDSWCSTR (RDSCALL *RDS_WsV)(void);
typedef LPSTR (RDSCALL *RDS_SBhI)(RDS_BHANDLE,RDSINT32);
typedef RDSWSTR (RDSCALL *RDS_WsBhI)(RDS_BHANDLE,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IIS)(RDSINT32,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IIWs)(RDSINT32,RDSWCSTR);
typedef RDSINT32 (RDSCALL *RDS_II)(RDSINT32);
typedef void (RDSCALL *RDS_VIIICrI)(RDSINT32,RDSINT32,RDSINT32,COLORREF,RDSINT32);
typedef void (RDSCALL *RDS_VIICr)(RDSINT32,RDSINT32,COLORREF);
typedef void (RDSCALL *RDS_VIIII)(RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VIIIIII)(RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VIIIIIIII)(RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VISICrIIBBBB)(RDSINT32,RDSCSTR,RDSINT32,COLORREF,RDSINT32,RDSINT32,BOOL,BOOL,BOOL,BOOL);
typedef void (RDSCALL *RDS_VIWsICrIIBBBB)(RDSINT32,RDSWCSTR,RDSINT32,COLORREF,RDSINT32,RDSINT32,BOOL,BOOL,BOOL,BOOL);
typedef void (RDSCALL *RDS_VIWsICrIIBBBB)(RDSINT32,RDSWCSTR,RDSINT32,COLORREF,RDSINT32,RDSINT32,BOOL,BOOL,BOOL,BOOL);
typedef void (RDSCALL *RDS_VpLfCr)(LOGFONTA*,COLORREF);
typedef void (RDSCALL *RDS_VpLfwCr)(LOGFONTW*,COLORREF);
typedef void (RDSCALL *RDS_VIIS)(RDSINT32,RDSINT32,RDSCSTR);
typedef void (RDSCALL *RDS_VIIWs)(RDSINT32,RDSINT32,RDSWCSTR);
typedef void (RDSCALL *RDS_VII)(RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VIDDw)(RDSINT32,double,DWORD);
typedef void (RDSCALL *RDS_VIISpR)(RDSINT32,RDSINT32,RDSCSTR,RECT*);
typedef void (RDSCALL *RDS_VIIWspR)(RDSINT32,RDSINT32,RDSWCSTR,RECT*);
typedef RDS_TIMERID (RDSCALL *RDS_ThThDwDwB)(RDS_TIMERID,DWORD,DWORD,BOOL);
typedef BOOL (RDSCALL *RDS_BpVI)(LPVOID,RDSINT32);
typedef void (RDSCALL *RDS_VpVI)(LPVOID,RDSINT32);
typedef BOOL (RDSCALL *RDS_BV)(void);
typedef void (RDSCALL *RDS_VSB)(RDSCSTR,BOOL);
typedef void (RDSCALL *RDS_VWsB)(RDSWCSTR,BOOL);
typedef void (RDSCALL *RDS_VSpIpI)(RDSCSTR,RDSINT32*,RDSINT32*);
typedef void (RDSCALL *RDS_VWspIpI)(RDSWCSTR,RDSINT32*,RDSINT32*);
typedef RDS_PCOLORREF (RDSCALL *RDS_pCrV)(void);
typedef BOOL (RDSCALL *RDS_BpCr)(RDS_PCOLORREF);
typedef BOOL (RDSCALL *RDS_BBhEd)(RDS_BHANDLE,RDS_PEDITORPARAMETERS);
typedef BOOL (RDSCALL *RDS_BThTd)(RDS_TIMERID,RDS_PTIMERDESCRIPTION);
typedef void (RDSCALL *RDS_VTh)(RDS_TIMERID);
typedef void (RDSCALL *RDS_VThDw)(RDS_TIMERID,DWORD);
typedef LPSTR (RDSCALL *RDS_SSpSpCB)(RDSCSTR,LPSTR*,char*,BOOL);
typedef RDSWSTR (RDSCALL *RDS_WsSpSpCB)(RDSCSTR,LPSTR*,char*,BOOL);
typedef RDSWSTR (RDSCALL *RDS_WsSpSpCB)(RDSCSTR,LPSTR*,char*,BOOL);
typedef void (RDSCALL *RDS_VIB)(RDSINT32,BOOL);
typedef void (RDSCALL *RDS_VSI)(RDSCSTR,RDSINT32);
typedef void (RDSCALL *RDS_VWsI)(RDSWCSTR,RDSINT32);
typedef void (RDSCALL *RDS_VSS)(RDSCSTR,RDSCSTR);
typedef void (RDSCALL *RDS_VWsWs)(RDSWCSTR,RDSWCSTR);
typedef void (RDSCALL *RDS_VSCrB)(RDSCSTR,COLORREF,BOOL);
typedef void (RDSCALL *RDS_VWsCrB)(RDSWCSTR,COLORREF,BOOL);
typedef BOOL (RDSCALL *RDS_BSpSSIpIpCrpIpIpBpBpBpB)(RDSCSTR,LPSTR*,RDSCSTR,RDSINT32,RDSINT32*,
                                                      COLORREF*,RDSINT32*,RDSINT32*,
                                                      BOOL*,BOOL*,BOOL*,BOOL*);
typedef BOOL (RDSCALL *RDS_BSpSWsIpIpCrpIpIpBpBpBpB)(RDSCSTR,LPSTR*,RDSWSTR,RDSINT32,RDSINT32*,
                                                      COLORREF*,RDSINT32*,RDSINT32*,
                                                      BOOL*,BOOL*,BOOL*,BOOL*);
typedef COLORREF (RDSCALL *RDS_CrSpS)(RDSCSTR,LPSTR*);
typedef void (RDSCALL *RDS_VpR)(RECT*);
typedef void (RDSCALL *RDS_VIIDDDB)(RDSINT32,RDSINT32,double,double,double,BOOL);
typedef void (RDSCALL *RDS_VpPI)(POINT *,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IBhS)(RDS_BHANDLE,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IBhWs)(RDS_BHANDLE,RDSWCSTR);
typedef RDSINT32 (RDSCALL *RDS_IBhIpV)(RDS_BHANDLE,RDSINT32,LPVOID);
typedef RDSINT32 (RDSCALL *RDS_IBhSpVB)(RDS_BHANDLE,RDSCSTR,LPVOID,BOOL);
typedef RDS_CHANDLE (RDSCALL *RDS_ChBhChBBPd)(RDS_BHANDLE,RDS_CHANDLE,BOOL,BOOL,RDS_PPOINTDESCRIPTION);
typedef RDS_CHANDLE (RDSCALL *RDS_ChBhChPd)(RDS_BHANDLE,RDS_CHANDLE,RDS_PPOINTDESCRIPTION);
typedef void (RDSCALL *RDS_VChCa)(RDS_CHANDLE,RDS_PCONNAPPEARANCE);
typedef BOOL (RDSCALL *RDS_BSCa)(RDSCSTR,RDS_PCONNAPPEARANCE);
typedef BOOL (RDSCALL *RDS_BWsCa)(RDSWCSTR,RDS_PCONNAPPEARANCE);
typedef RDSINT32 (RDSCALL *RDS_IBhSpV)(RDS_BHANDLE,RDSCSTR,LPVOID);
typedef LPVOID (RDSCALL *RDS_pVISSBS)(RDSINT32,RDSCSTR,RDSCSTR,BOOL,RDSCSTR);
typedef LPVOID (RDSCALL *RDS_pVIWsWsBWs)(RDSINT32,RDSWCSTR,RDSWCSTR,BOOL,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BIS)(RDSINT32,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BIWs)(RDSINT32,RDSWCSTR);
typedef RDS_PDYNVARLINK (RDSCALL *RDS_DvISSB)(RDSINT32,RDSCSTR,RDSCSTR,BOOL);
typedef RDS_PDYNVARLINK (RDSCALL *RDS_DvIWsWsB)(RDSINT32,RDSWCSTR,RDSWCSTR,BOOL);
typedef void (RDSCALL *RDS_VDv)(RDS_PDYNVARLINK);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhSBd)(RDS_BHANDLE,RDSCSTR,RDS_PBLOCKDESCRIPTION);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhWsBd)(RDS_BHANDLE,RDSWCSTR,RDS_PBLOCKDESCRIPTION);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBd)(RDS_PBLOCKDESCRIPTION);
typedef RDS_PDYNVARLINK (RDSCALL *RDS_DvISSBS)(RDSINT32,RDSCSTR,RDSCSTR,BOOL,RDSCSTR);
typedef RDS_PDYNVARLINK (RDSCALL *RDS_DvIWsWsBWs)(RDSINT32,RDSWCSTR,RDSWCSTR,BOOL,RDSWCSTR);
typedef void (RDSCALL *RDS_VBhB)(RDS_BHANDLE,BOOL);
typedef void (RDSCALL *RDS_VBhBB)(RDS_BHANDLE,BOOL,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IBhIB)(RDS_BHANDLE,RDSINT32,BOOL);
typedef void (RDSCALL *RDS_VBhS)(RDS_BHANDLE,RDSCSTR);
typedef void (RDSCALL *RDS_VBhWs)(RDS_BHANDLE,RDSWCSTR);
typedef void (RDSCALL *RDS_VB)(BOOL);
typedef void (RDSCALL *RDS_VBh)(RDS_BHANDLE);
typedef RDSINT32 (RDSCALL *RDS_IChIICa)(RDS_CHANDLE,RDSINT32,RDSINT32,RDS_PCONNAPPEARANCE);
typedef BOOL (RDSCALL *RDS_BBhI)(RDS_BHANDLE,RDSINT32);
typedef BOOL (RDSCALL *RDS_BBhS)(RDS_BHANDLE,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BBhWs)(RDS_BHANDLE,RDSWCSTR);
//stypedef void (RDSCALL *RDS_VBhEt)(RDS_BHANDLE,RDS_PEDITORTOOLBARS);
typedef void (RDSCALL *RDS_VV)(void);
typedef LPVOID (RDSCALL *RDS_pVpVpIpI)(LPVOID,RDSINT32*,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BpVAd)(LPVOID,RDS_PARRAYACCESSDATA);
typedef BOOL (RDSCALL *RDS_BpVIIBAd)(LPVOID,RDSINT32,RDSINT32,BOOL,RDS_PARRAYACCESSDATA);
typedef BOOL (RDSCALL *RDS_BBhpV)(RDS_BHANDLE,LPVOID);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhIBCbpV)(RDS_BHANDLE,RDSINT32,BOOL,RDS_BBhpV,LPVOID);
typedef RDSINT32 (RDSCALL *RDS_IIIB)(RDSINT32,RDSINT32,BOOL);
typedef BOOL (RDSCALL *RDS_BBhpB)(RDS_BHANDLE,BOOL*);
typedef RDSINT32 (RDSCALL *RDS_IBhIBCb2)(RDS_BHANDLE,RDSINT32,BOOL,RDS_BBhpB);
typedef BOOL (RDSCALL *RDS_BICb2)(RDSINT32,RDS_BBhpB);
typedef BOOL (RDSCALL *RDS_BBhIIpIpI)(RDS_BHANDLE,RDSINT32,RDSINT32,RDSINT32*,RDSINT32*);
typedef RDSINT32 (RDSCALL *RDS_IpV)(LPVOID);
typedef RDSINT32 (RDSCALL *RDS_ICb4pV)(RDS_IpV,LPVOID);
typedef RDSINT32 (RDSCALL *RDS_IBhIpVDw)(RDS_BHANDLE,RDSINT32,LPVOID,DWORD);
typedef RDSINT32 (RDSCALL *RDS_IS)(RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IWs)(RDSWCSTR);
typedef void (RDSCALL *RDS_VBhIpVB)(RDS_BHANDLE,RDSINT32,LPVOID,BOOL);
typedef BOOL (RDSCALL *RDS_BhPdPdpV)(RDS_PPOINTDESCRIPTION,RDS_PPOINTDESCRIPTION,LPVOID);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhDwCb1pV)(RDS_BHANDLE,DWORD,RDS_BhPdPdpV,LPVOID);
typedef void (RDSCALL *RDS_VpVII)(LPVOID,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_ISpSpVI)(RDSCSTR,LPSTR*,LPVOID,RDSINT32);
typedef LPSTR (RDSCALL *RDS_SIB)(RDSINT32,BOOL);
typedef RDSWSTR (RDSCALL *RDS_WsIB)(RDSINT32,BOOL);
typedef RDSINT32 (RDSCALL *RDS_ISB)(RDSCSTR,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IWsB)(RDSWCSTR,BOOL);
typedef RDS_MENUITEM (RDSCALL *RDS_MhSDwIDwII)(RDSCSTR,BOOL,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef RDS_MENUITEM (RDSCALL *RDS_MhWsDwIDwII)(RDSWCSTR,BOOL,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VMhBB)(RDS_MENUITEM,BOOL,BOOL);
typedef void (RDSCALL *RDS_VMh)(RDS_MENUITEM);
typedef LPVOID (RDSCALL *RDS_pVDw)(DWORD);
typedef void (RDSCALL *RDS_VpV)(LPVOID);
typedef void (RDSCALL *RDS_VpcV)(RDSPCVOID);
typedef LPSTR (RDSCALL *RDS_SBhpI)(RDS_BHANDLE,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsBhpI)(RDS_BHANDLE,RDSINT32*);
typedef RDS_BHANDLE (RDSCALL *RDS_BhSBd)(RDSCSTR,RDS_PBLOCKDESCRIPTION);
typedef RDS_BHANDLE (RDSCALL *RDS_BhWsBd)(RDSWCSTR,RDS_PBLOCKDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BBh)(RDS_BHANDLE);
typedef void (RDSCALL *RDS_VCh)(RDS_CHANDLE);
typedef RDS_BHANDLE (RDSCALL *RDS_BhSBhIIBd)(RDSCSTR,RDS_BHANDLE,RDSINT32,RDSINT32,RDS_PBLOCKDESCRIPTION);
typedef RDS_BHANDLE (RDSCALL *RDS_BhWsBhIIBd)(RDSWCSTR,RDS_BHANDLE,RDSINT32,RDSINT32,RDS_PBLOCKDESCRIPTION);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhBhIIBd)(RDS_BHANDLE,RDS_BHANDLE,RDSINT32,RDSINT32,RDS_PBLOCKDESCRIPTION);
typedef RDS_VHANDLE (RDSCALL *RDS_VhBhiVd)(RDS_BHANDLE,RDSINT32,RDS_PVARDESCRIPTION);
typedef RDS_VHANDLE (RDSCALL *RDS_VhBhSBVd)(RDS_BHANDLE,RDSCSTR,BOOL,RDS_PVARDESCRIPTION);
typedef RDS_VHANDLE (RDSCALL *RDS_VhBhWsBVd)(RDS_BHANDLE,RDSWCSTR,BOOL,RDS_PVARDESCRIPTION);
typedef RDS_HOBJECT (RDSCALL *RDS_HoV)(void);
typedef RDS_HOBJECT (RDSCALL *RDS_HoB)(BOOL);
typedef void (RDSCALL *RDS_VHo)(RDS_HOBJECT);
typedef RDS_CHANDLE (RDSCALL *RDS_ChHoBhIpI)(RDS_HOBJECT,RDS_BHANDLE,RDSINT32,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BHoChI)(RDS_HOBJECT,RDS_CHANDLE,RDSINT32);
typedef BOOL (RDSCALL *RDS_BHoChpI)(RDS_HOBJECT,RDS_CHANDLE,RDSINT32*);
typedef RDSINT32 (RDSCALL *RDS_IHoII)(RDS_HOBJECT,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoBhSIIB)(RDS_HOBJECT,RDS_BHANDLE,RDSCSTR,RDSINT32,RDSINT32,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IHoBhWsIIB)(RDS_HOBJECT,RDS_BHANDLE,RDSWCSTR,RDSINT32,RDSINT32,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IHoChSBIIB)(RDS_HOBJECT,RDS_CHANDLE,RDSCSTR,BOOL,RDSINT32,RDSINT32,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IHoChWsBIIB)(RDS_HOBJECT,RDS_CHANDLE,RDSWCSTR,BOOL,RDSINT32,RDSINT32,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IHoIIIIII)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BBhBrB)(RDS_BHANDLE,RDS_PBLOCKDIMENSIONS,BOOL);
typedef RDS_HOBJECT (RDSCALL *RDS_HoBhDwB)(RDS_BHANDLE,DWORD,BOOL);
typedef LPVOID (RDSCALL *RDS_pVHoIIpI)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32*);
typedef void (RDSCALL *RDS_VBhII)(RDS_BHANDLE,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VBhSS)(RDS_BHANDLE,RDSCSTR,RDSCSTR);
typedef void (RDSCALL *RDS_VBhWsWs)(RDS_BHANDLE,RDSWCSTR,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BChILdPdPd)(RDS_CHANDLE,RDSINT32,RDS_PLINEDESCRIPTION,
                                       RDS_PPOINTDESCRIPTION,RDS_PPOINTDESCRIPTION);
typedef RDSINT32 (RDSCALL *RDS_IChIILdpI)(RDS_CHANDLE,RDSINT32,RDSINT32,RDS_PLINEDESCRIPTION,RDSINT32*);
typedef void (RDSCALL *RDS_VBhIIIIB)(RDS_BHANDLE,RDSINT32,RDSINT32,RDSINT32,RDSINT32,BOOL);
typedef BOOL (RDSCALL *RDS_BBhIIII)(RDS_BHANDLE,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BBhIII)(RDS_BHANDLE,RDSINT32,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BDv)(RDS_PDYNVARLINK);
typedef BOOL (RDSCALL *RDS_BpVpV)(LPVOID,LPVOID);
typedef BOOL (RDSCALL *RDS_BpVpVD)(LPVOID,LPVOID,double);
typedef BOOL (RDSCALL *RDS_BHopI)(RDS_HOBJECT,RDSINT32*);
typedef RDSINT32 (RDSCALL *RDS_IHoISCSDwIS)(RDS_HOBJECT,RDSINT32,RDSCSTR,char,RDSCSTR,DWORD,RDSINT32,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IHoIWsCWsDwIWs)(RDS_HOBJECT,RDSINT32,RDSWCSTR,char,RDSWCSTR,DWORD,RDSINT32,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_VHoIIS)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSCSTR);
typedef BOOL (RDSCALL *RDS_VHoIIWs)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BHoBhpI)(RDS_HOBJECT,RDS_BHANDLE,RDSINT32*);
typedef RDSINT32 (RDSCALL *RDS_IHoSS)(RDS_HOBJECT,RDSCSTR,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IHoWsWs)(RDS_HOBJECT,RDSWCSTR,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BHoIIpI)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BHoI)(RDS_HOBJECT,RDSINT32);
typedef RDS_VHANDLE (RDSCALL *RDS_VhVhiVd)(RDS_VHANDLE,RDSINT32,RDS_PVARDESCRIPTION);
typedef RDS_VHANDLE (RDSCALL *RDS_VhSVd)(RDSCSTR,RDS_PVARDESCRIPTION);
typedef RDS_VHANDLE (RDSCALL *RDS_VhWsVd)(RDSWCSTR,RDS_PVARDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BHoIVd)(RDS_HOBJECT,RDSINT32,RDS_PVARDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BHoBDwIS)(RDS_HOBJECT,BOOL,DWORD,RDSINT32,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BHoBDwIWs)(RDS_HOBJECT,BOOL,DWORD,RDSINT32,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SHoII)(RDS_HOBJECT,RDSINT32,RDSINT32);
typedef RDSWSTR (RDSCALL *RDS_WsHoII)(RDS_HOBJECT,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VHoIII)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32);
typedef LPSTR (RDSCALL *RDS_SVhBIpI)(RDS_VHANDLE,BOOL,RDSINT32,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsVhBIpI)(RDS_VHANDLE,BOOL,RDSINT32,RDSINT32*);
typedef RDSINT32 (RDSCALL *RDS_IHoIS)(RDS_HOBJECT,RDSINT32,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IHoIWs)(RDS_HOBJECT,RDSINT32,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BHoS)(RDS_HOBJECT,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BHoWs)(RDS_HOBJECT,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BHwSHbHiS)(HWND,RDSCSTR,HBITMAP,HINSTANCE,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BHwWsHbHiWs)(HWND,RDSWCSTR,HBITMAP,HINSTANCE,RDSWCSTR);
typedef void (RDSCALL *RDS_VHw)(HWND);
typedef LPSTR (RDSCALL *RDS_SHoS)(RDS_HOBJECT,RDSCSTR);
typedef RDSWSTR (RDSCALL *RDS_WsHoWs)(RDS_HOBJECT,RDSWCSTR);
typedef RDS_VHANDLE (RDSCALL *RDS_VhIVd)(RDSINT32,RDS_PVARDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BVhS)(RDS_VHANDLE,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BVhWs)(RDS_VHANDLE,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SSSpI)(RDSCSTR,RDSCSTR,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsWsWspI)(RDSWCSTR,RDSWCSTR,RDSINT32*);
typedef void (RDSCALL *RDS_VHwS)(HWND,RDSCSTR);
typedef void (RDSCALL *RDS_VHwWs)(HWND,RDSWCSTR);
typedef RDSINT32 (RDSCALL *RDS_IHoBhB)(RDS_HOBJECT,RDS_BHANDLE,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IHoBhIDw)(RDS_HOBJECT,RDS_BHANDLE,RDSINT32,DWORD);
typedef RDSINT32 (RDSCALL *RDS_IHoChB)(RDS_HOBJECT,RDS_CHANDLE,BOOL);
typedef void (RDSCALL *RDS_VHoDwSB)(RDS_HOBJECT,DWORD,RDSCSTR,BOOL);
typedef void (RDSCALL *RDS_VHoDwWsB)(RDS_HOBJECT,DWORD,RDSWCSTR,BOOL);
typedef RDSINT32 (RDSCALL *RDS_ISSI)(RDSCSTR,RDSCSTR,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IWsWsI)(RDSWCSTR,RDSWCSTR,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoSI)(RDS_HOBJECT,RDSCSTR,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoWsI)(RDS_HOBJECT,RDSWCSTR,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoWsI)(RDS_HOBJECT,RDSWCSTR,RDSINT32);
typedef BOOL (RDSCALL *RDS_BHopSII)(RDS_HOBJECT,RDSCSTR*,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BHopWsII)(RDS_HOBJECT,RDSWCSTR*,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHopSpSpCB)(RDS_HOBJECT,LPSTR*,LPSTR*,char*,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IHopWspWsWsB)(RDS_HOBJECT,RDSWSTR*,RDSWSTR*,RDSWSTR,BOOL);
typedef void (RDSCALL *RDS_VSD)(RDSCSTR,double);
typedef void (RDSCALL *RDS_VWsD)(RDSWCSTR,double);
typedef RDSINT32 (RDSCALL *RDS_ISpS)(RDSCSTR,LPSTR*);
typedef BOOL (RDSCALL *RDS_BBhIS)(RDS_BHANDLE,RDSINT32,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BBhIWs)(RDS_BHANDLE,RDSINT32,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SBhIpI)(RDS_BHANDLE,RDSINT32,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsBhIpI)(RDS_BHANDLE,RDSINT32,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BB)(BOOL);
typedef void (RDSCALL *RDS_VBhPv)(RDS_BHANDLE,LPVOID);
typedef BOOL (RDSCALL *RDS_BChIIIDw)(RDS_CHANDLE,RDSINT32,RDSINT32,RDSINT32,DWORD);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhBd)(RDS_BHANDLE,RDS_PBLOCKDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BBhSBd)(RDS_BHANDLE,RDSCSTR,RDS_PBLOCKDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BBhWsBd)(RDS_BHANDLE,RDSWCSTR,RDS_PBLOCKDESCRIPTION);
typedef LPSTR (RDSCALL *RDS_SHoIpI)(RDS_HOBJECT,RDSINT32,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsHoIpI)(RDS_HOBJECT,RDSINT32,RDSINT32*);
typedef void (RDSCALL *RDS_VBhIII)(RDS_BHANDLE,RDSINT32,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BMhSDwIDwII)(RDS_MENUITEM,RDSCSTR,DWORD,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BMhWsDwIDwII)(RDS_MENUITEM,RDSWCSTR,DWORD,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VHoIID)(RDS_HOBJECT,RDSINT32,RDSINT32,double);
typedef double (RDSCALL *RDS_DHoII)(RDS_HOBJECT,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VHoSI)(RDS_HOBJECT,RDSCSTR,RDSINT32);
typedef void (RDSCALL *RDS_VHoWsI)(RDS_HOBJECT,RDSWCSTR,RDSINT32);
typedef void (RDSCALL *RDS_VHoSD)(RDS_HOBJECT,RDSCSTR,double);
typedef void (RDSCALL *RDS_VHoWsD)(RDS_HOBJECT,RDSWCSTR,double);
typedef double (RDSCALL *RDS_DHoSD)(RDS_HOBJECT,RDSCSTR,double);
typedef double (RDSCALL *RDS_DHoWsD)(RDS_HOBJECT,RDSWCSTR,double);
typedef void (RDSCALL *RDS_VHoSS)(RDS_HOBJECT,RDSCSTR,RDSCSTR);
typedef void (RDSCALL *RDS_VHoWsWs)(RDS_HOBJECT,RDSWCSTR,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SHoSSpI)(RDS_HOBJECT,RDSCSTR,RDSCSTR,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsHoWsWspI)(RDS_HOBJECT,RDSWCSTR,RDSWCSTR,RDSINT32*);
typedef RDSINT32 (RDSCALL *RDS_IBhSSSS)(RDS_BHANDLE,RDSCSTR,RDSCSTR,RDSCSTR,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IBhWsWsWsWs)(RDS_BHANDLE,RDSWCSTR,RDSWCSTR,RDSWCSTR,RDSWCSTR);
typedef RDSINT32 (RDSCALL *RDS_IBh)(RDS_BHANDLE);
typedef DWORD (RDSCALL *RDS_DwBh)(RDS_BHANDLE);
typedef DWORD (RDSCALL *RDS_DwCh)(RDS_CHANDLE);
typedef void (RDSCALL *RDS_VBhDwDw)(RDS_BHANDLE,DWORD,DWORD);
typedef void (RDSCALL *RDS_VChDwDw)(RDS_CHANDLE,DWORD,DWORD);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhIDwCb1pV)(RDS_BHANDLE,RDSINT32,DWORD,RDS_BhPdPdpV,LPVOID);
typedef RDS_HOBJECT (RDSCALL *RDS_HoBIIS)(BOOL,RDSINT32,RDSINT32,RDSCSTR);
typedef RDS_HOBJECT (RDSCALL *RDS_HoBIIWs)(BOOL,RDSINT32,RDSINT32,RDSWCSTR);
typedef void (RDSCALL *RDS_VHoIS)(RDS_HOBJECT,RDSINT32,RDSCSTR);
typedef void (RDSCALL *RDS_VHoIWs)(RDS_HOBJECT,RDSINT32,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_VHoIIDwSI)(RDS_HOBJECT,RDSINT32,RDSINT32,DWORD,RDSCSTR,RDSINT32);
typedef BOOL (RDSCALL *RDS_VHoIIDwWsI)(RDS_HOBJECT,RDSINT32,RDSINT32,DWORD,RDSWCSTR,RDSINT32);
typedef LPSTR (RDSCALL *RDS_SSIpI)(RDSCSTR,RDSINT32,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsWsIpI)(RDSWCSTR,RDSINT32,RDSINT32*);
typedef LPSTR (RDSCALL *RDS_SSSB)(RDSCSTR,RDSCSTR,BOOL);
typedef RDSWSTR (RDSCALL *RDS_WsWsWsB)(RDSWCSTR,RDSWCSTR,BOOL);
typedef LPSTR (RDSCALL *RDS_SSSSB)(RDSCSTR,RDSCSTR,RDSCSTR,BOOL);
typedef BOOL (RDSCALL *RDS_BSI)(RDSCSTR,RDSINT32);
typedef BOOL (RDSCALL *RDS_BWsI)(RDSWCSTR,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IIB)(RDSINT32,BOOL);
typedef BOOL (RDSCALL *RDS_BI)(RDSINT32);
typedef RDS_PFUNCPROVIDERLINK (RDSCALL *RDS_BFl)(RDSINT32);
typedef void (RDSCALL *RDS_VI)(RDSINT32);
typedef BOOL (RDSCALL *RDS_BHoCb3)(RDS_HOBJECT,RDS_VHo);
typedef BOOL (RDSCALL *RDS_BpD)(double*);
typedef BOOL (RDSCALL *RDS_BBhIDwDw)(RDS_BHANDLE,RDSINT32,DWORD,DWORD);
typedef void (RDSCALL *RDS_VIS)(RDSINT32,RDSCSTR);
typedef void (RDSCALL *RDS_VIWs)(RDSINT32,RDSWCSTR);
typedef void (RDSCALL *RDS_VBhSI)(RDS_BHANDLE,RDSCSTR,RDSINT32);
typedef void (RDSCALL *RDS_VBhWsI)(RDS_BHANDLE,RDSWCSTR,RDSINT32);
typedef void (RDSCALL *RDS_VIDwSS)(RDSINT32,DWORD,RDSCSTR,RDSCSTR);
typedef void (RDSCALL *RDS_VIDwWsWs)(RDSINT32,DWORD,RDSWCSTR,RDSWCSTR);
typedef RDS_MENUITEM (RDSCALL *RDS_MhSII)(RDSCSTR,RDSINT32,RDSINT32);
typedef RDS_MENUITEM (RDSCALL *RDS_MhWsII)(RDSWCSTR,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VBhSB)(RDS_BHANDLE,RDSCSTR,BOOL);
typedef void (RDSCALL *RDS_VBhWsB)(RDS_BHANDLE,RDSWCSTR,BOOL);
typedef RDS_HOBJECT (RDSCALL *RDS_HoIS)(RDSINT32,RDSCSTR);
typedef RDS_HOBJECT (RDSCALL *RDS_HoIWs)(RDSINT32,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SSSSI)(RDSCSTR,RDSCSTR,RDSCSTR,RDSINT32);
typedef RDSWSTR (RDSCALL *RDS_WsWsWsWsI)(RDSWCSTR,RDSWCSTR,RDSWCSTR,RDSINT32);
typedef BOOL (RDSCALL *RDS_BCb4pVI)(RDS_IpV,LPVOID,RDSINT32*);
typedef LPVOID (RDSCALL *RDS_pVpVpS)(LPVOID,LPSTR*);
typedef LPVOID (RDSCALL *RDS_pVpVpWs)(LPVOID,RDSWCSTR*);
typedef void (RDSCALL *RDS_VSII)(RDSCSTR,RDSINT32,RDSINT32);
typedef LPVOID (RDSCALL *RDS_pVpVS)(LPVOID,RDSCSTR);
typedef LPVOID (RDSCALL *RDS_pVpVWs)(LPVOID,RDSWCSTR);
typedef HINSTANCE (RDSCALL *RDS_HiV)(void);
typedef void (RDSCALL *RDS_VSBII)(RDSCSTR,BOOL,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VWsBII)(RDSWCSTR,BOOL,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BBhDvpV)(RDS_BHANDLE,RDS_PDYNVARLINK,LPVOID);
typedef RDS_BHANDLE (RDSCALL *RDS_BhDvCb5pV)(RDS_PDYNVARLINK,RDS_BBhDvpV,LPVOID);
typedef BOOL (RDSCALL *RDS_BSSB)(RDSCSTR,RDSCSTR,BOOL);
typedef BOOL (RDSCALL *RDS_BWsWsB)(RDSWCSTR,RDSWCSTR,BOOL);
typedef void (RDSCALL *RDS_VHoIIpD)(RDS_HOBJECT,RDSINT32,RDSINT32,double*);
typedef void (RDSCALL *RDS_VHoSDpD)(RDS_HOBJECT,RDSCSTR,double,double*);
typedef void (RDSCALL *RDS_VHoWsDpD)(RDS_HOBJECT,RDSWCSTR,double,double*);
typedef RDSINT32 (RDSCALL *RDS_ISISB)(RDSCSTR,RDSINT32,RDSCSTR,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IWsIWsB)(RDSWCSTR,RDSINT32,RDSWCSTR,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IISB)(RDSINT32,RDSCSTR,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IIWsB)(RDSINT32,RDSWCSTR,BOOL);
typedef BOOL (RDSCALL *RDS_BIDwISpVDw)(RDSINT32,DWORD,RDSINT32,RDSCSTR,LPVOID,DWORD);
typedef BOOL (RDSCALL *RDS_BIDwIWspVDw)(RDSINT32,DWORD,RDSINT32,RDSWCSTR,LPVOID,DWORD);
typedef BOOL (RDSCALL *RDS_BIDwISpVDwNsNb)(RDSINT32,DWORD,RDSINT32,RDSCSTR,LPVOID,DWORD,RDS_NETSTATION,RDS_NETBLOCK);
typedef BOOL (RDSCALL *RDS_BIDwIWspVDwNsNb)(RDSINT32,DWORD,RDSINT32,RDSWCSTR,LPVOID,DWORD,RDS_NETSTATION,RDS_NETBLOCK);
typedef LPVOID (RDSCALL *RDS_pVBhIpI)(RDS_BHANDLE,RDSINT32,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BBhIpVI)(RDS_BHANDLE,RDSINT32,LPVOID,RDSINT32);
typedef void (RDSCALL *RDS_VIIDw)(RDSINT32,RDSINT32,DWORD);
typedef BOOL (RDSCALL *RDS_BDwpIpI)(DWORD,RDSINT32*,RDSINT32*);
typedef RDSINT32 (RDSCALL *RDS_IBhSSI)(RDS_BHANDLE,RDSCSTR,RDSCSTR,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IBhWsWsI)(RDS_BHANDLE,RDSWCSTR,RDSWCSTR,RDSINT32);
typedef void (RDSCALL *RDS_VHoFsfd)(RDS_HOBJECT,RDS_PFORMSERVFUNCDATA);
typedef BOOL (RDSCALL *RDS_BHoCb6)(RDS_HOBJECT,RDS_VHoFsfd);
typedef void (RDSCALL *RDS_VBhIpVDw)(RDS_BHANDLE,RDSINT32,LPVOID,DWORD);
typedef void (RDSCALL *RDS_VBhIpVDwDw)(RDS_BHANDLE,RDSINT32,LPVOID,DWORD,DWORD);
typedef void (RDSCALL *RDS_VHoII)(RDS_HOBJECT,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BBhB)(RDS_BHANDLE,BOOL);
typedef RDS_HOBJECT (RDSCALL *RDS_HoBhS)(RDS_BHANDLE,RDSCSTR);
typedef RDS_HOBJECT (RDSCALL *RDS_HoBh)(RDS_BHANDLE);
typedef LPSTR (RDSCALL *RDS_SDwS)(DWORD,RDSCSTR);
typedef RDSWSTR (RDSCALL *RDS_WsDwWs)(DWORD,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SVh)(RDS_VHANDLE);
typedef RDSWSTR (RDSCALL *RDS_WsVh)(RDS_VHANDLE);
typedef RDSINT32 (RDSCALL *RDS_IHoISSDwS)(RDS_HOBJECT,RDSINT32,RDSCSTR,RDSCSTR,DWORD,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IHoIWsWsDwWs)(RDS_HOBJECT,RDSINT32,RDSWCSTR,RDSWCSTR,DWORD,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BVhpVVhpV)(RDS_VHANDLE,LPVOID,RDS_VHANDLE,LPVOID);
typedef LPVOID (RDSCALL *RDS_pVBhIBpI)(RDS_BHANDLE,RDSINT32,BOOL,RDSINT32*);
typedef void (RDSCALL *RDS_VHoBhB)(RDS_HOBJECT,RDS_BHANDLE,BOOL);
typedef RDSINT32 (RDSCALL *RDS_ISpI)(RDSCSTR,RDSINT32*);
typedef RDSINT32 (RDSCALL *RDS_IWspI)(RDSWCSTR,RDSINT32*);
typedef DWORD (RDSCALL *RDS_DwSpI)(RDSCSTR,RDSINT32*);
typedef DWORD (RDSCALL *RDS_DwWspI)(RDSWCSTR,RDSINT32*);
typedef LPSTR (RDSCALL *RDS_SIIpI)(RDSINT32,RDSINT32,RDSINT32*);
typedef void (RDSCALL *RDS_VSpD)(RDSCSTR,double*);
typedef void (RDSCALL *RDS_VWspD)(RDSWCSTR,double*);
typedef LPSTR (RDSCALL *RDS_SDIpI)(double,RDSINT32,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsDIpI)(double,RDSINT32,RDSINT32*);
typedef LPSTR (RDSCALL *RDS_SIII)(RDSINT32,RDSINT32,RDSINT32);
typedef RDSWSTR (RDSCALL *RDS_WsIII)(RDSINT32,RDSINT32,RDSINT32);
typedef LPSTR (RDSCALL *RDS_SDwII)(DWORD,RDSINT32,RDSINT32);
typedef RDSWSTR (RDSCALL *RDS_WsDwII)(DWORD,RDSINT32,RDSINT32);
typedef LPSTR (RDSCALL *RDS_SII)(RDSINT32,RDSINT32);
typedef RDSWSTR (RDSCALL *RDS_WsII)(RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BBhSS)(RDS_BHANDLE,RDSCSTR,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BBhWsWs)(RDS_BHANDLE,RDSWCSTR,RDSWCSTR);
typedef RDSINT32 (RDSCALL *RDS_IMd)(RDS_PMOUSEDATA);
typedef void (RDSCALL *RDS_VBhBIIII)(RDS_BHANDLE,BOOL,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BpVIIDwSS)(LPVOID,RDSINT32,RDSINT32,DWORD,RDSCSTR,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BpVIIDwWsWs)(LPVOID,RDSINT32,RDSINT32,DWORD,RDSWCSTR,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BBhIIpBpBpB)(RDS_BHANDLE,RDSINT32,RDSINT32,BOOL*,BOOL*,BOOL*);
typedef BOOL (RDSCALL *RDS_BBhIIBBB)(RDS_BHANDLE,RDSINT32,RDSINT32,BOOL,BOOL,BOOL);
typedef void (RDSCALL *RDS_VBhIIII)(RDS_BHANDLE,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BChBrB)(RDS_CHANDLE,RDS_PBLOCKDIMENSIONS,BOOL);
typedef BOOL (RDSCALL *RDS_BChI)(RDS_CHANDLE Conn,RDSINT32 LayerId);
typedef BOOL (RDSCALL *RDS_BBhDwFbei)(RDS_BHANDLE,DWORD,RDS_PFINDBYEXTIDDATA);
typedef RDS_HOBJECT (RDSCALL *RDS_HoIIIIIIS)(RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSCSTR);
typedef RDS_HOBJECT (RDSCALL *RDS_HoIIIIIIWs)(RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BHoPnd)(RDS_HOBJECT,RDS_PPANDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BBhIpLfDwpI)(RDS_BHANDLE,RDSINT32,LOGFONTA*,DWORD,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BBhIpLfwDwpI)(RDS_BHANDLE,RDSINT32,LOGFONTW*,DWORD,RDSINT32*);
typedef void (RDSCALL *RDS_VpFsD)(RDS_PSERVFONTPARAMS,double);
typedef BOOL (RDSCALL *RDS_BSpSpFs)(RDSCSTR,LPSTR*,RDS_PSERVFONTPARAMS);
typedef LPSTR (RDSCALL *RDS_SpFspI)(RDS_PSERVFONTPARAMS,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WspFspI)(RDS_PSERVFONTPARAMS,RDSINT32*);
typedef void (RDSCALL *RDS_VpSSB)(LPSTR*,RDSCSTR,BOOL);
typedef void (RDSCALL *RDS_VpWsWsB)(RDSWSTR*,RDSWCSTR,BOOL);
typedef void (RDSCALL *RDS_VMhDw)(RDS_MENUITEM,DWORD);
typedef void (RDSCALL *RDS_VSDwII)(RDSCSTR,DWORD,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VWsDwII)(RDSWCSTR,DWORD,RDSINT32,RDSINT32);
typedef RDS_MENUITEM (RDSCALL *RDS_MhSDwII)(RDSCSTR,DWORD,RDSINT32,RDSINT32);
typedef RDS_MENUITEM (RDSCALL *RDS_MhWsDwII)(RDSWCSTR,DWORD,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BBhBrDw)(RDS_BHANDLE,RDS_PBLOCKDIMENSIONS,DWORD);
typedef void (RDSCALL *RDS_VHoIDwDw)(RDS_HOBJECT,RDSINT32,DWORD,DWORD);
typedef LPSTR (RDSCALL *RDS_SBhS)(RDS_BHANDLE,RDSCSTR);
typedef RDSWSTR (RDSCALL *RDS_WsBhWs)(RDS_BHANDLE,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SBh)(RDS_BHANDLE);
typedef RDSWSTR (RDSCALL *RDS_WsBh)(RDS_BHANDLE);
typedef LPSTR (RDSCALL *RDS_SSpSpSIDw)(RDSCSTR,RDSCSTR*,RDSCSTR*,RDSINT32,DWORD);
typedef RDSWSTR (RDSCALL *RDS_WsWspWspWsIDw)(RDSWCSTR,RDSWCSTR*,RDSWCSTR*,RDSINT32,DWORD);
typedef LPSTR (RDSCALL *RDS_SS)(RDSCSTR);
typedef RDSWSTR (RDSCALL *RDS_WsWs)(RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SSDwSSS)(RDSCSTR,DWORD,RDSCSTR,RDSCSTR,RDSCSTR);
typedef RDSWSTR (RDSCALL *RDS_WsWsDwWsWsWs)(RDSWCSTR,DWORD,RDSWCSTR,RDSWCSTR,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SSDwSpI)(RDSCSTR,DWORD,RDSCSTR,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsWsDwWspI)(RDSWCSTR,DWORD,RDSWCSTR,RDSINT32*);
typedef LPSTR (RDSCALL *RDS_SIS)(RDSINT32,RDSCSTR);
typedef RDSWSTR (RDSCALL *RDS_WsIWs)(RDSINT32,RDSWCSTR);
typedef RDSINT32 (RDSCALL *RDS_IBhII)(RDS_BHANDLE,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BHoSCSI)(RDS_HOBJECT,RDSCSTR,char,RDSCSTR,RDSINT32);
typedef BOOL (RDSCALL *RDS_BHoWsCWsI)(RDS_HOBJECT,RDSWCSTR,char,RDSWCSTR,RDSINT32);
typedef BOOL (RDSCALL *RDS_BpBipBtS)(RDSINT32,BITMAPINFO*,BYTE*,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IIEdpV)(RDSINT32,RDS_PTOOLMODULEDATA,LPVOID);
typedef void (RDSCALL *RDS_VDw)(DWORD);
typedef RDSINT32 (RDSCALL *RDS_IDwSSIS)(DWORD,RDSCSTR,RDSCSTR,RDSINT32,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IDwWsWsIWs)(DWORD,RDSWCSTR,RDSWCSTR,RDSINT32,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BS1d)(RDS_PSAVESYSBMPDATA);
typedef BOOL (RDSCALL *RDS_BIDwBr)(RDSINT32,DWORD,RDS_PBLOCKDIMENSIONS);
typedef DWORD (RDSCALL *RDS_DwV)(void);
typedef void (RDSCALL *RDS_VIDw)(RDSINT32,DWORD);
typedef BOOL (RDSCALL *RDS_BHoHoDw)(RDS_HOBJECT,RDS_HOBJECT,DWORD);
typedef void (RDSCALL *RDS_VIIB)(RDSINT32,RDSINT32,BOOL);
typedef BOOL (RDSCALL *RDS_BpVII)(LPVOID,RDSINT32);
typedef BOOL (RDSCALL *RDS_BII)(RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BBhII)(RDS_BHANDLE,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_ISSB)(RDSCSTR,RDSCSTR,BOOL);
typedef RDSINT32 (RDSCALL *RDS_IWsWsB)(RDSWCSTR,RDSWCSTR,BOOL);
typedef RDSINT32 (RDSCALL *RDS_ICh)(RDS_CHANDLE);
typedef RDSINT32 (RDSCALL *RDS_IChIpSpIpIpDpS)(RDS_CHANDLE,RDSINT32,LPSTR*,RDSINT32*,RDSINT32*,double*,LPSTR*);
typedef RDSINT32 (RDSCALL *RDS_IChIpWspIpIpDpWs)(RDS_CHANDLE,RDSINT32,RDSWSTR*,RDSINT32*,RDSINT32*,double*,RDSWSTR*);
typedef RDSINT32 (RDSCALL *RDS_IChIpIpDpS)(RDS_CHANDLE,RDSINT32,RDSINT32*,double*,LPSTR*);
typedef RDSINT32 (RDSCALL *RDS_IChIpIpDpWs)(RDS_CHANDLE,RDSINT32,RDSINT32*,double*,RDSWSTR*);
typedef BOOL (RDSCALL *RDS_BChIIIDS)(RDS_CHANDLE,RDSINT32,RDSINT32,RDSINT32,double,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BChIIIDWs)(RDS_CHANDLE,RDSINT32,RDSINT32,RDSINT32,double,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BSBhBhSpV)(LPSTR,RDS_BHANDLE,RDS_BHANDLE,LPSTR,LPVOID);
typedef BOOL (RDSCALL *RDS_BWsBhBhWspV)(RDSWSTR,RDS_BHANDLE,RDS_BHANDLE,RDSWSTR,LPVOID);
typedef RDSINT32 (RDSCALL *RDS_IBhDwCb7pV)(RDS_BHANDLE,DWORD,RDS_BSBhBhSpV,LPVOID);
typedef RDSINT32 (RDSCALL *RDS_IBhDwCb7wpV)(RDS_BHANDLE,DWORD,RDS_BWsBhBhWspV,LPVOID);
typedef RDSINT32 (RDSCALL *RDS_IChIpSpIpIpDpSpDw)(RDS_CHANDLE,RDSINT32,LPSTR*,RDSINT32*,RDSINT32*,double*,LPSTR*,DWORD*);
typedef RDSINT32 (RDSCALL *RDS_IChIpWspIpIpDpWspDw)(RDS_CHANDLE,RDSINT32,RDSWCSTR*,RDSINT32*,RDSINT32*,double*,RDSWCSTR*,DWORD*);
typedef RDSINT32 (RDSCALL *RDS_IChIpIpDpSpDw)(RDS_CHANDLE,RDSINT32,RDSINT32*,double*,LPSTR*,DWORD*);
typedef RDSINT32 (RDSCALL *RDS_IChIpIpDpWspDw)(RDS_CHANDLE,RDSINT32,RDSINT32*,double*,RDSWSTR*,DWORD*);
typedef BOOL (RDSCALL *RDS_BChIIIDSDw)(RDS_CHANDLE,RDSINT32,RDSINT32,RDSINT32,double,RDSCSTR,DWORD);
typedef BOOL (RDSCALL *RDS_BChIIIDWsDw)(RDS_CHANDLE,RDSINT32,RDSINT32,RDSINT32,double,RDSWCSTR,DWORD);

typedef void (RDSCALL *RDS_VHoISpV)(RDS_HOBJECT,RDSINT32,RDSCSTR,LPVOID);
typedef void (RDSCALL *RDS_VHoIWspV)(RDS_HOBJECT,RDSINT32,RDSWCSTR,LPVOID);
typedef LPVOID (RDSCALL *RDS_pVHoIpS)(RDS_HOBJECT,RDSINT32,LPSTR*);
typedef LPVOID (RDSCALL *RDS_pVHoIpWs)(RDS_HOBJECT,RDSINT32,RDSWSTR*);
typedef LPVOID (RDSCALL *RDS_pVBhpIDw)(RDS_BHANDLE,RDSINT32*,DWORD);
typedef void (RDSCALL *RDS_VChBB)(RDS_CHANDLE,BOOL,BOOL);
typedef BOOL (RDSCALL *RDS_BBhpVIDw)(RDS_BHANDLE,LPVOID,RDSINT32,DWORD);
typedef RDS_HOBJECT (RDSCALL *RDS_HoCh)(RDS_CHANDLE);
typedef void (RDSCALL *RDS_VSDw)(RDSCSTR,DWORD);
typedef void (RDSCALL *RDS_VWsDw)(RDSWCSTR,DWORD);
typedef void (RDSCALL *RDS_VSSISpVDw)(RDSCSTR,RDSCSTR,RDSINT32,RDSCSTR,LPVOID,DWORD);
typedef void (RDSCALL *RDS_VWsWsIWspVDw)(RDSWCSTR,RDSWCSTR,RDSINT32,RDSWCSTR,LPVOID,DWORD);
typedef BOOL (RDSCALL *RDS_BSSpIpSppVpDw)(RDSCSTR,RDSCSTR,RDSINT32*,LPSTR*,LPVOID*,DWORD*);
typedef BOOL (RDSCALL *RDS_BWsWspIpWsppVpDw)(RDSWCSTR,RDSWCSTR,RDSINT32*,RDSWSTR*,LPVOID*,DWORD*);
typedef RDSINT32 (RDSCALL *RDS_IDwSSS2)(DWORD,RDSCSTR,RDSCSTR,RDS_PTOOLEXTCALLDATA);
typedef RDSINT32 (RDSCALL *RDS_IDwWsWsS2)(DWORD,RDSWCSTR,RDSWCSTR,RDS_PTOOLEXTCALLDATA);
typedef void (RDSCALL *RDS_VS2)(RDS_PTOOLEXTCALLDATA);
typedef BOOL (RDSCALL *RDS_BBhpIpI)(RDS_BHANDLE,RDSINT32*,RDSINT32*);
typedef void (RDSCALL *RDS_VHoDwSS)(RDS_HOBJECT,DWORD,RDSCSTR,RDSCSTR);
typedef void (RDSCALL *RDS_VHoDwWsWs)(RDS_HOBJECT,DWORD,RDSWCSTR,RDSWCSTR);
typedef RDSINT32 (RDSCALL *RDS_IBhIpI)(RDS_BHANDLE,RDSINT32,RDSINT32*);
typedef RDSINT32 * (RDSCALL *RDS_pIS)(RDSCSTR);
typedef RDSINT32 * (RDSCALL *RDS_pIWs)(RDSWCSTR);
typedef void (RDSCALL *RDS_VBhDw)(RDS_BHANDLE,DWORD);
typedef BOOL (RDSCALL *RDS_BSIS)(RDSCSTR,RDSINT32,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BWsIWs)(RDSWCSTR,RDSINT32,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BBhpBtrpFs)(RDS_BHANDLE,RDS_PBLOCKTEXTRECTDATA,RDS_PSERVFONTPARAMS);
typedef BOOL (RDSCALL *RDS_BBhpBtrpFsDw)(RDS_BHANDLE,RDS_PBLOCKTEXTRECTDATA,RDS_PSERVFONTPARAMS,DWORD);
typedef void (RDSCALL *RDS_VHoBhDw)(RDS_HOBJECT,RDS_BHANDLE,DWORD);
typedef void (RDSCALL *RDS_VHoChDw)(RDS_HOBJECT,RDS_CHANDLE,DWORD);
typedef void (RDSCALL *RDS_VHoChS)(RDS_HOBJECT,RDS_CHANDLE,RDSCSTR);
typedef void (RDSCALL *RDS_VHoChWs)(RDS_HOBJECT,RDS_CHANDLE,RDSWCSTR);
typedef void (RDSCALL *RDS_VDwSSS)(DWORD,RDSCSTR,RDSCSTR,RDSCSTR);
typedef void (RDSCALL *RDS_VDwWsWsWs)(DWORD,RDSWCSTR,RDSWCSTR,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BBhDw)(RDS_BHANDLE,DWORD);
typedef void (RDSCALL *RDS_VIIHb)(RDSINT32,RDSINT32,HBITMAP);
typedef BOOL (RDSCALL *RDS_BBhpIpIpIpIpIpI)(RDS_BHANDLE,RDSINT32*,RDSINT32*,RDSINT32*,RDSINT32*,RDSINT32*,RDSINT32*);
typedef RDS_HOBJECT (RDSCALL *RDS_HoS)(RDSCSTR);
typedef RDS_HOBJECT (RDSCALL *RDS_HoWs)(RDSWCSTR);
typedef RDS_BHANDLE (RDSCALL *RDS_BhHoI)(RDS_HOBJECT,RDSINT32,BOOL*);
typedef RDSINT32 (RDSCALL *RDS_IHoIpVDw)(RDS_HOBJECT,RDSINT32,LPVOID,DWORD);
typedef void (RDSCALL *RDS_VDcIIDw)(HDC,RDSINT32,RDSINT32,DWORD);
typedef BOOL (RDSCALL *RDS_BBhSDwS)(RDS_BHANDLE,RDSCSTR,DWORD,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BBhWsDwWs)(RDS_BHANDLE,RDSWCSTR,DWORD,RDSWCSTR);
typedef RDS_BHANDLE (RDSCALL *RDS_BhIBh)(RDS_BHANDLE,RDSINT32,RDS_BHANDLE);
typedef RDS_CHANDLE (RDSCALL *RDS_ChICh)(RDS_CHANDLE,RDSINT32,RDS_CHANDLE);
typedef BOOL (RDSCALL *RDS_BChDwSIBII)(RDS_CHANDLE,DWORD,RDSCSTR,RDSINT32,BOOL,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BChDwWsIBII)(RDS_CHANDLE,DWORD,RDSWCSTR,RDSINT32,BOOL,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BSSpSpI)(RDSCSTR,RDSCSTR,LPSTR*,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BWsWspWspI)(RDSWCSTR,RDSWCSTR,RDSWSTR*,RDSINT32*);
typedef LPVOID (RDSCALL *RDS_pVBhpDw)(RDS_BHANDLE,DWORD*);
typedef BOOL (RDSCALL *RDS_BBhpVDw)(RDS_BHANDLE,LPVOID,DWORD);
typedef RDS_PSHAREDMEMPARAMS (RDSCALL *RDS_SmISDw)(RDSINT32,RDSCSTR,DWORD);
typedef RDS_PSHAREDMEMPARAMS (RDSCALL *RDS_SmIWsDw)(RDSINT32,RDSWCSTR,DWORD);
typedef RDS_PSHAREDMEMPARAMS (RDSCALL *RDS_SmISS)(RDSINT32,RDSCSTR,RDSCSTR);
typedef RDS_PSHAREDMEMPARAMS (RDSCALL *RDS_SmIWsWs)(RDSINT32,RDSWCSTR,RDSWCSTR);

typedef void (RDSCALL *RDS_VSm)(RDS_PSHAREDMEMPARAMS);
typedef BOOL (RDSCALL *RDS_BBhSmpV)(RDS_BHANDLE,RDS_PSHAREDMEMPARAMS,LPVOID);
typedef RDS_BHANDLE (RDSCALL *RDS_BhSmCb8pV)(RDS_PSHAREDMEMPARAMS,RDS_BBhSmpV,LPVOID);
typedef LPSTR (RDSCALL *RDS_SSIISpI)(RDSCSTR,RDSINT32,RDSINT32,RDSCSTR,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsWsIIWspI)(RDSWCSTR,RDSINT32,RDSINT32,RDSWCSTR,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BChDwSIBIIB)(RDS_CHANDLE,DWORD,RDSCSTR,RDSINT32,BOOL,RDSINT32,RDSINT32,BOOL);
typedef BOOL (RDSCALL *RDS_BChDwWsIBIIB)(RDS_CHANDLE,DWORD,RDSWCSTR,RDSINT32,BOOL,RDSINT32,RDSINT32,BOOL);
typedef DWORD (RDSCALL *RDS_DwBhI)(RDS_BHANDLE,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IBhDw)(RDS_BHANDLE,DWORD);
typedef void (RDSCALL *RDS_VHoIIIS)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,RDSCSTR);
typedef void (RDSCALL *RDS_VHoIIIWs)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SHoIIIpB)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,BOOL*);
typedef RDSWSTR (RDSCALL *RDS_WsHoIIIpB)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,BOOL*);
typedef void (RDSCALL *RDS_VHoIISDwI)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSCSTR,DWORD,RDSINT32);
typedef void (RDSCALL *RDS_VHoIIWsDwI)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSWCSTR,DWORD,RDSINT32);
typedef void (RDSCALL *RDS_VHoIIII)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoIIIpB)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,BOOL*);
typedef void (RDSCALL *RDS_VHoIIID)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,double);
typedef double (RDSCALL *RDS_DHoIIIpB)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,BOOL*);
typedef BOOL (RDSCALL *RDS_BHoIIIpD)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,double*);
typedef BOOL (RDSCALL *RDS_BHoIII)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhSIIBhDw)(RDS_BHANDLE,RDSCSTR,RDSINT32,RDSINT32,RDS_BHANDLE,DWORD);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhWsIIBhDw)(RDS_BHANDLE,RDSWCSTR,RDSINT32,RDSINT32,RDS_BHANDLE,DWORD);
typedef LPSTR (RDSCALL *RDS_SSI)(RDSCSTR,RDSINT32);
typedef RDSWSTR (RDSCALL *RDS_WsWsI)(RDSWCSTR,RDSINT32);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhISII)(RDS_BHANDLE,RDSINT32,RDSCSTR,RDSINT32,RDSINT32);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhIWsII)(RDS_BHANDLE,RDSINT32,RDSWCSTR,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoIII)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoIBhSIIDwII)(RDS_HOBJECT,RDSINT32,RDS_BHANDLE,RDSCSTR,RDSINT32,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoIBhWsIIDwII)(RDS_HOBJECT,RDSINT32,RDS_BHANDLE,RDSWCSTR,RDSINT32,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoIChSBIIDwII)(RDS_HOBJECT,RDSINT32,RDS_CHANDLE,RDSCSTR,BOOL,RDSINT32,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoIChWsBIIDwII)(RDS_HOBJECT,RDSINT32,RDS_CHANDLE,RDSWCSTR,BOOL,RDSINT32,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoIIIIIII)(RDS_HOBJECT,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BHoCh)(RDS_HOBJECT,RDS_CHANDLE);
typedef BOOL (RDSCALL *RDS_BHoIPd)(RDS_HOBJECT,RDSINT32,RDS_PPOINTDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BHoILd)(RDS_HOBJECT,RDSINT32,RDS_PLINEDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BChpV)(RDS_CHANDLE,LPVOID);
typedef RDS_CHANDLE (RDSCALL *RDS_ChChDwCb9pV)(RDS_CHANDLE,DWORD,RDS_BChpV,LPVOID);
typedef RDSCSTR (RDSCALL *RDS_SChI)(RDS_CHANDLE,RDSINT32);
typedef RDSWCSTR (RDSCALL *RDS_WsChI)(RDS_CHANDLE,RDSINT32);
typedef BOOL (RDSCALL *RDS_BChPdpV)(RDS_CHANDLE,RDS_PPOINTDESCRIPTION,LPVOID);
typedef RDS_CHANDLE (RDSCALL *RDS_ChChIDwCb10pV)(RDS_CHANDLE,RDSINT32,DWORD,RDS_BChPdpV,LPVOID);
typedef BOOL (RDSCALL *RDS_BChIpSpCpSpDwpIpS)(RDS_CHANDLE,RDSINT32,LPSTR*,char*,LPSTR*,DWORD*,RDSINT32*,LPSTR*);
typedef BOOL (RDSCALL *RDS_BChIpWspCpWspDwpIpWs)(RDS_CHANDLE,RDSINT32,RDSWCSTR*,char*,RDSWCSTR*,DWORD*,RDSINT32*,RDSWCSTR*);
typedef LPVOID (RDSCALL *RDS_pVIIpV)(RDSINT32,RDSINT32,LPVOID);
typedef BOOL (RDSCALL *RDS_BVhpVVhpVD)(RDS_VHANDLE,LPVOID,RDS_VHANDLE,LPVOID,double delta);
typedef BOOL (RDSCALL *RDS_BVhSBhBhSpV)(RDS_VHANDLE,LPSTR,RDS_BHANDLE,RDS_BHANDLE,LPSTR,LPVOID);
typedef BOOL (RDSCALL *RDS_BVhWsBhBhWspV)(RDS_VHANDLE,RDSWSTR,RDS_BHANDLE,RDS_BHANDLE,RDSWSTR,LPVOID);
typedef RDSINT32 (RDSCALL *RDS_IBhDwCb11pV)(RDS_BHANDLE,DWORD,RDS_BVhSBhBhSpV,LPVOID);
typedef RDSINT32 (RDSCALL *RDS_IBhDwCb11wpV)(RDS_BHANDLE,DWORD,RDS_BVhWsBhBhWspV,LPVOID);
typedef BOOL (RDSCALL *RDS_BVhpSpCpSpDwpIpS)(RDS_VHANDLE,LPSTR*,char*,LPSTR*,DWORD*,RDSINT32*,LPSTR*);
typedef BOOL (RDSCALL *RDS_BVhpWspCpWspDwpIpWs)(RDS_VHANDLE,RDSWCSTR*,char*,RDSWCSTR*,DWORD*,RDSINT32*,RDSWCSTR*);
typedef LPSTR (RDSCALL *RDS_SCSDwI)(char,RDSCSTR,DWORD,RDSINT32);
typedef RDSWSTR (RDSCALL *RDS_WsCWsDwI)(char,RDSCSTR,DWORD,RDSINT32);
typedef BOOL (RDSCALL *RDS_BSpCpSpDwpI)(RDSCSTR,char*,LPSTR*,DWORD*,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BWspCpWspDwpI)(RDSWCSTR,char*,RDSWSTR*,DWORD*,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BBhIpVID)(RDS_BHANDLE,RDSINT32,LPVOID,RDSINT32,double);
typedef void (RDSCALL *RDS_VHoICb6)(RDS_HOBJECT,RDSINT32,RDS_VHoFsfd);
typedef RDS_HOBJECT (RDSCALL *RDS_HoBhSIICwDw)(RDS_BHANDLE,RDSCSTR,RDSINT32,RDSINT32,RDS_PCWCREATEDATA,DWORD);
typedef RDS_HOBJECT (RDSCALL *RDS_HoBhWsIICwDw)(RDS_BHANDLE,RDSWCSTR,RDSINT32,RDSINT32,RDS_PCWCREATEDATA,DWORD);
typedef BOOL (RDSCALL *RDS_BHoCw)(RDS_HOBJECT,RDS_PCWCREATEDATA);
typedef RDS_HOBJECT (RDSCALL *RDS_HoBhSIIDwHo)(RDS_BHANDLE,RDSCSTR,RDSINT32,RDSINT32,DWORD,RDS_HOBJECT);
typedef RDS_HOBJECT (RDSCALL *RDS_HoBhWsIIDwHo)(RDS_BHANDLE,RDSWCSTR,RDSINT32,RDSINT32,DWORD,RDS_HOBJECT);
typedef BOOL (RDSCALL *RDS_BHoHo)(RDS_HOBJECT,RDS_HOBJECT);
typedef BOOL (RDSCALL *RDS_BSDw)(RDSCSTR,DWORD);
typedef BOOL (RDSCALL *RDS_BWsDw)(RDSWCSTR,DWORD);
typedef BOOL (RDSCALL *RDS_BS)(RDSCSTR);
typedef BOOL (RDSCALL *RDS_BWs)(RDSWCSTR);
typedef void (RDSCALL *RDS_VBhI)(RDS_BHANDLE,RDSINT32);
typedef LPSTR (RDSCALL *RDS_SSFt)(RDSCSTR,FILETIME*);
typedef RDSWCSTR (RDSCALL *RDS_WsWsFt)(RDSWCSTR,FILETIME*);
typedef BOOL (RDSCALL *RDS_BHoSS)(RDS_HOBJECT,RDSCSTR,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BHoWsWs)(RDS_HOBJECT,RDSWCSTR,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SHoSIS)(RDS_HOBJECT,RDSCSTR,RDSINT32,RDSCSTR);
typedef RDSWSTR (RDSCALL *RDS_WsHoWsIWs)(RDS_HOBJECT,RDSWCSTR,RDSINT32,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SHoSIpIS)(RDS_HOBJECT,RDSCSTR,RDSINT32,RDSINT32*,RDSCSTR);
typedef RDSWSTR (RDSCALL *RDS_WsHoWsIpIWs)(RDS_HOBJECT,RDSWCSTR,RDSINT32,RDSINT32*,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SHoSSS)(RDS_HOBJECT,RDSCSTR,RDSCSTR,RDSCSTR);
typedef RDSWSTR (RDSCALL *RDS_WsHoWsWsWs)(RDS_HOBJECT,RDSWCSTR,RDSWCSTR,RDSWCSTR);
typedef void (RDSCALL *RDS_VHoSSS)(RDS_HOBJECT,RDSCSTR,RDSCSTR,RDSCSTR);
typedef void (RDSCALL *RDS_VHoWsWsWs)(RDS_HOBJECT,RDSWCSTR,RDSWCSTR,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BHoSSS)(RDS_HOBJECT,RDSCSTR,RDSCSTR,RDSCSTR);
typedef BOOL (RDSCALL *RDS_BHoWsWsWs)(RDS_HOBJECT,RDSWCSTR,RDSWCSTR,RDSWCSTR);
typedef void (RDSCALL *RDS_VIpVIDw)(RDSINT32,LPVOID,RDSINT32,DWORD);
typedef void (RDSCALL *RDS_VISDw)(RDSINT32,RDSCSTR,DWORD);
typedef BOOL (RDSCALL *RDS_BSgp)(RDS_PSGPDATA);
typedef BOOL (RDSCALL *RDS_BSgpB)(RDS_PSGPDATA,BOOL);
typedef BOOL (RDSCALL *RDS_BISgp)(RDSINT32,RDS_PSGPDATA);
typedef RDSINT32 (RDSCALL *RDS_ISDwIDwII)(RDSCSTR,BOOL,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IWsDwIDwII)(RDSWCSTR,BOOL,RDSINT32,DWORD,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IBhpII)(RDS_BHANDLE,RDSINT32*,RDSINT32);
typedef BOOL (RDSCALL *RDS_BISDwIDw)(RDSINT32,RDSCSTR,DWORD,RDSINT32,DWORD);
typedef BOOL (RDSCALL *RDS_BIWsDwIDw)(RDSINT32,RDSWCSTR,DWORD,RDSINT32,DWORD);
typedef RDSINT32 (RDSCALL *RDS_IIIINgsc)(RDSINT32,RDSINT32,RDSINT32,RDS_PNGSCDATA);
typedef RDSINT32 (RDSCALL *RDS_IINsNgsc)(RDSINT32,RDS_NETSTATION,RDS_PNGSCDATA);
typedef RDSINT32 (RDSCALL *RDS_IBhI)(RDS_BHANDLE,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IChI)(RDS_CHANDLE,RDSINT32);
typedef BOOL (RDSCALL *RDS_BChBhB)(RDS_CHANDLE,RDS_BHANDLE,BOOL);
typedef void (RDSCALL *RDS_VpVIDw)(LPVOID,RDSINT32,DWORD);
typedef void (RDSCALL *RDS_VBhDII)(RDS_BHANDLE,double,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VHoBIS)(RDS_HOBJECT,BOOL,RDSINT32,RDSCSTR);
typedef void (RDSCALL *RDS_VHoBIWs)(RDS_HOBJECT,BOOL,RDSINT32,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BHoIpSpS)(RDS_HOBJECT,RDSINT32,LPSTR*,LPSTR*);
typedef BOOL (RDSCALL *RDS_BHoIpWspWs)(RDS_HOBJECT,RDSINT32,RDSWCSTR*,RDSWCSTR*);
typedef RDS_HOBJECT (RDSCALL *RDS_HoSIII)(RDSCSTR,RDSINT32,RDSINT32,RDSINT32);
typedef RDS_HOBJECT (RDSCALL *RDS_HoWsIII)(RDSWCSTR,RDSINT32,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BHoBDwISCb12Cb12)(RDS_HOBJECT,BOOL,DWORD,RDSINT32,RDSCSTR,RDS_BS,RDS_BS);
typedef BOOL (RDSCALL *RDS_BHoBDwIWsCb12wCb12w)(RDS_HOBJECT,BOOL,DWORD,RDSINT32,RDSWCSTR,RDS_BWs,RDS_BWs);
typedef LPVOID (RDSCALL *RDS_pVVhpVBpI)(RDS_VHANDLE,LPVOID,BOOL,RDSINT32*);
typedef BOOL (RDSCALL *RDS_BVhpVpVI)(RDS_VHANDLE,LPVOID,LPVOID,RDSINT32);
typedef BOOL (RDSCALL *RDS_BHoIpSpCpSpDwpIpS)(RDS_HOBJECT,RDSINT32,LPSTR*,char*,LPSTR*,DWORD*,RDSINT32*,LPSTR*);
typedef BOOL (RDSCALL *RDS_BHoIpWspCpWspDwpIpWs)(RDS_HOBJECT,RDSINT32,RDSWCSTR*,char*,RDSWCSTR*,DWORD*,RDSINT32*,RDSWCSTR*);
typedef RDSINT32 (RDSCALL *RDS_IBhSVdpI)(RDS_BHANDLE,RDSCSTR,RDS_PVARDESCRIPTION,RDSINT32*);
typedef RDSINT32 (RDSCALL *RDS_IBhWsVdpI)(RDS_BHANDLE,RDSWCSTR,RDS_PVARDESCRIPTION,RDSINT32*);
typedef RDS_CHANDLE (RDSCALL *RDS_ChBhIBBPd)(RDS_BHANDLE,RDSINT32,BOOL,BOOL,RDS_PPOINTDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BpVpVIIIII)(LPVOID,LPVOID,RDSINT32,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef BOOL (RDSCALL *RDS_BSIB)(RDSCSTR,RDSINT32,BOOL);
typedef BOOL (RDSCALL *RDS_BWsIB)(RDSWCSTR,RDSINT32,BOOL);
typedef HWND (RDSCALL *RDS_HwIIS)(RDSINT32,RDSINT32,RDSCSTR);
typedef HWND (RDSCALL *RDS_HwIIWs)(RDSINT32,RDSINT32,RDSWCSTR);
typedef RDS_HOBJECT (RDSCALL *RDS_HoDwS)(DWORD,RDSCSTR);
typedef RDS_HOBJECT (RDSCALL *RDS_HoDwWs)(DWORD,RDSWCSTR);
typedef RDSINT32 (RDSCALL *RDS_IHoS)(RDS_HOBJECT,RDSCSTR);
typedef RDSINT32 (RDSCALL *RDS_IHoWs)(RDS_HOBJECT,RDSWCSTR);
typedef LPSTR (RDSCALL *RDS_SHoSpI)(RDS_HOBJECT,RDSCSTR,RDSINT32*);
typedef RDSWSTR (RDSCALL *RDS_WsHoWspI)(RDS_HOBJECT,RDSWCSTR,RDSINT32*);
typedef LPVOID (RDSCALL *RDS_pVHoIS)(RDS_HOBJECT,RDSINT32,RDSCSTR);
typedef LPVOID (RDSCALL *RDS_pVHoIWs)(RDS_HOBJECT,RDSINT32,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BHoBh)(RDS_HOBJECT,RDS_BHANDLE);
typedef DWORD (RDSCALL *RDS_DwBhCh)(RDS_BHANDLE,RDS_CHANDLE);
typedef RDSINT32 (RDSCALL *RDS_IHoIBpIII)(RDS_HOBJECT,RDSINT32,BOOL,RDSINT32*,RDSINT32,RDSINT32);
typedef RDSINT32 (RDSCALL *RDS_IHoBh)(RDS_HOBJECT,RDS_BHANDLE);
typedef RDSINT32 (RDSCALL *RDS_IHoCh)(RDS_HOBJECT,RDS_CHANDLE);
typedef void (RDSCALL *RDS_VHoBhI)(RDS_HOBJECT,RDS_BHANDLE,RDSINT32);
typedef void (RDSCALL *RDS_VHoIBhDw)(RDS_HOBJECT,RDSINT32,RDS_BHANDLE,DWORD);
typedef void (RDSCALL *RDS_VHoIChDw)(RDS_HOBJECT,RDSINT32,RDS_CHANDLE,DWORD);
typedef void (RDSCALL *RDS_VChII)(RDS_CHANDLE,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VBhIIIIDw)(RDS_BHANDLE,RDSINT32,RDSINT32,RDSINT32,RDSINT32,DWORD);
typedef void (RDSCALL *RDS_VHoBIIII)(RDS_HOBJECT,BOOL,RDSINT32,RDSINT32,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VHoBhII)(RDS_HOBJECT,RDS_BHANDLE,RDSINT32,RDSINT32);
typedef void (RDSCALL *RDS_VS3)(RDS_BFM_PWINCONFIGDATA);
typedef void (RDSCALL *RDS_VMhSS)(RDS_MODELHANDLE,RDSCSTR,RDSCSTR);
typedef void (RDSCALL *RDS_VMhWsWs)(RDS_MODELHANDLE,RDSWCSTR,RDSWCSTR);
typedef RDS_PCOMPMODELDATA (RDSCALL *RDS_MdChI)(RDS_COMPHANDLE,int);
typedef RDS_BHANDLE (RDSCALL *RDS_BhMhIBd)(RDS_MODELHANDLE,int,RDS_PBLOCKDESCRIPTION);
typedef BOOL (RDSCALL *RDS_BChSSB)(RDS_COMPHANDLE,RDSCSTR,RDSCSTR,BOOL);
typedef BOOL (RDSCALL *RDS_BChWsWsB)(RDS_COMPHANDLE,RDSWCSTR,RDSWCSTR,BOOL);
typedef RDS_PCOMPMODELDATA (RDSCALL *RDS_MdChS)(RDS_COMPHANDLE,RDSCSTR);
typedef RDS_PCOMPMODELDATA (RDSCALL *RDS_MdChWs)(RDS_COMPHANDLE,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BMhB)(RDS_MODELHANDLE,BOOL);
typedef void (RDSCALL *RDS_VMhS)(RDS_MODELHANDLE,RDSCSTR);
typedef void (RDSCALL *RDS_VMhWs)(RDS_MODELHANDLE,RDSWCSTR);
typedef RDS_PCOMPMODELDATA (RDSCALL *RDS_MdBh)(RDS_BHANDLE);
typedef RDS_PCOMPMODULEDATA (RDSCALL *RDS_CdCh)(RDS_COMPHANDLE);
typedef BOOL (RDSCALL *RDS_BMh)(RDS_MODELHANDLE);
typedef BOOL (RDSCALL *RDS_BLop)(RDS_PCOMPLIBRARYOPDATA);
typedef void (RDSCALL *RDS_VMhB)(RDS_MODELHANDLE,BOOL);
typedef LPSTR (RDSCALL *RDS_SWsB)(RDSWCSTR,BOOL);
typedef RDSWSTR (RDSCALL *RDS_WsSB)(RDSCSTR,BOOL);
typedef void (RDSCALL *RDS_VMhISS)(RDS_MODELHANDLE,RDSINT32,RDSCSTR,RDSCSTR);
typedef void (RDSCALL *RDS_VMhIWsWs)(RDS_MODELHANDLE,RDSINT32,RDSWCSTR,RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BSSSpSpSpS)(RDSCSTR,RDSCSTR,RDSCSTR,LPSTR*,LPSTR*,LPSTR*);
typedef BOOL (RDSCALL *RDS_BWsWsWspWspWspWs)(RDSWCSTR,RDSWCSTR,RDSWCSTR,RDSWCSTR*,RDSWCSTR*,RDSWCSTR*);
typedef void (RDSCALL *RDS_VThpVpB)(RDS_USERAUXTHREAD,LPVOID,BOOL*);
typedef void (RDSCALL *RDS_VThpVpVpB)(RDS_USERAUXTHREAD,LPVOID,LPVOID,BOOL*);
typedef RDS_USERAUXTHREAD (RDSCALL *RDS_ThCb13Cb13pV)(RDS_VThpVpB,RDS_VThpVpB,LPVOID);
typedef void (RDSCALL *RDS_VThCb14pV)(RDS_USERAUXTHREAD,RDS_VThpVpVpB,LPVOID);
typedef void (RDSCALL *RDS_VTh)(RDS_USERAUXTHREAD);
typedef void (RDSCALL *RDS_VHoISB)(RDS_HOBJECT,int,RDSCSTR,BOOL);
typedef void (RDSCALL *RDS_VHoIWsB)(RDS_HOBJECT,int,RDSWCSTR,BOOL);
typedef RDS_HOBJECT (RDSCALL *RDS_HoII)(int,int);
typedef void (RDSCALL *RDS_VBdpV)(RDS_PBMPDRAWDATA,LPVOID);
typedef void (RDSCALL *RDS_VHoCb15pV)(RDS_HOBJECT,RDS_VBdpV,LPVOID);
typedef DWORD (RDSCALL *RDS_DwS)(RDSCSTR);
typedef DWORD (RDSCALL *RDS_DwWs)(RDSWCSTR);
typedef BOOL (RDSCALL *RDS_BDwDw)(DWORD,DWORD);
typedef DWORD (RDSCALL *RDS_DwDwDwB)(DWORD,DWORD,BOOL);
typedef void (RDSCALL *RDS_VpDwDwB)(DWORD*,DWORD,BOOL);
typedef LPVOID (RDSCALL *RDS_pVHopI)(RDS_HOBJECT,int*); // 2021_07_02
typedef BOOL (RDSCALL *RDS_BHopVI)(RDS_HOBJECT,LPVOID,int); // 2021_07_02
typedef LPVOID (RDSCALL *RDS_pVpVIBpI)(LPVOID,int,BOOL,int*); // 2024_01_16
typedef LPVOID (RDSCALL *RDS_pVpVIIBpI)(LPVOID,int,int,BOOL,int*);
typedef void (RDSCALL *RDS_VBhIIDwII)(RDS_BHANDLE,int,int,DWORD,int,int);
typedef void (RDSCALL *RDS_VBhIDwIpV)(RDS_BHANDLE,int,DWORD,int,LPVOID);
typedef RDS_BHANDLE (RDSCALL *RDS_BhBhIPd)(RDS_BHANDLE,RDSINT32,RDS_PPOINTDESCRIPTION);
typedef void (RDSCALL *RDS_VIIpIpI)(int,int,int*,int*);
typedef RDS_BLOCKHOOK (RDSCALL *RDS_BhookICb16pVDw)(int,RDS_BLOCKHOOKFUNCTION,LPVOID,DWORD);
typedef BOOL (RDSCALL *RDS_BBhookCb16pVDw)(RDS_BLOCKHOOK,RDS_BLOCKHOOKFUNCTION,LPVOID,DWORD);
typedef void (RDSCALL *RDS_VBhook)(RDS_BLOCKHOOK);
typedef BOOL (RDSCALL *RDS_BpFs)(RDS_PSERVFONTPARAMS);
typedef BOOL (RDSCALL *RDS_BpFsDwCr)(RDS_PSERVFONTPARAMS,DWORD,COLORREF);
//---------------------------------------------------------------------------

// Возврат выравнивания по умолчанию
#ifndef RDS_NO_PACK
 #include <poppack.h>
#endif
//---------------------------------------------------------------------------

// Описания переменных-указателей на сервисные функции находятся в "RdsFunc.h"
//---------------------------------------------------------------------------
#endif
