#ifndef RdsClassesHPP
#define RdsClassesHPP

#ifndef RdsDefH
  // Для нормальной компиляции необходимы описания из RdsDef.h
  #include "RdsDef.h"
#endif

#ifndef RdsFuncH
  // Для нормальной компиляции необходимы описания из RdsFunc.h
  #include "RdsFunc.h"
#endif


//---------------------------------------------------------------------------
// Класс объекта работы с BMP из файла
//---------------------------------------------------------------------------
class TRdsHelperBitmap
{ protected:
    RDS_HOBJECT Bitmap;
  public:
    inline void LoadA(RDSCSTR filename){rdsSetObjectStrA(Bitmap,RDS_BMP_LOADFROMFILE,0,filename);};
    inline void LoadW(RDSWCSTR filename){rdsSetObjectStrW(Bitmap,RDS_BMP_LOADFROMFILE,0,filename);};
    #ifndef RDS_NO_UTFALIASES
	  #ifdef RDS_UTF16DEFAULT
        inline void Load(RDSWCSTR filename){LoadW(filename);};
	  #else
        inline void Load(RDSCSTR filename){LoadA(filename);};
	  #endif
    #endif

    inline BOOL IsLoaded(void){return rdsGetObjectInt(Bitmap,RDS_BMP_ISLOADED,0)?TRUE:FALSE;};
    inline BOOL IsNotLoaded(void){return rdsGetObjectInt(Bitmap,RDS_BMP_ISLOADED,0)?FALSE:TRUE;};
    inline void Clear(void){rdsCommandObjectEx(Bitmap,RDS_BMP_CLEAR,0,NULL);};

    inline int GetWidth(void){return rdsGetObjectInt(Bitmap,RDS_BMP_GETWIDTH,0);};
    inline int GetHeight(void){return rdsGetObjectInt(Bitmap,RDS_BMP_GETHEIGHT,0);};

    inline void Draw(int left,int top){rdsBMPDraw(Bitmap,left,top);};
    inline void StretchDraw(int left,int top,int right,int bottom){rdsBMPStretchDraw(Bitmap,left,top,right,bottom);};

    TRdsHelperBitmap(void){Bitmap=rdsBMPCreate(NULL);};
    virtual ~TRdsHelperBitmap(){rdsDeleteObject(Bitmap);};
};
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Класс загрузки языка интерфейса одной группы
//---------------------------------------------------------------------------
class TRdsHelperLanguage
{ protected:
    RDS_HOBJECT Object;
    BOOL Loaded;
    RDSSTR binaryfilepath;
  public:
    inline BOOL IsLoaded(void){return Loaded;};
    inline BOOL IsNotLoaded(void){return !Loaded;};
    inline BOOL HasFile(void){return binaryfilepath!=NULL;};
    inline BOOL HasNoFile(void){return binaryfilepath==NULL;};
    inline void Clear(void){rdsCommandObject(Object,RDS_UIMOD_CLEAR);Loaded=FALSE;};
    // Установить тип обработки строк (перед загрузкой данных)
    inline void SetCRLFCorrection(int c)
      { rdsSetObjectInt(Object,RDS_UIMOD_SETCRLFCORR,0,c);};

    // Загрузить группу из файла
    inline void LoadGroup8(RDSCSTR groupname)
      { Clear(); Loaded=rdsUIMODLoadGroupA(Object,binaryfilepath,groupname);};
    inline void LoadGroup16(RDSWCSTR groupname)
      { RDSWSTR fw=rdsUTF8toUTF16(binaryfilepath,TRUE);
	      Clear(); Loaded=rdsUIMODLoadGroupW(Object,fw,groupname);
		    rdsFree(fw);
	    };
    #ifndef RDS_NO_UTFALIASES
	  #ifdef RDS_UTF16DEFAULT
      inline void LoadGroup(RDSWCSTR groupname){LoadGroup16(groupname);};
	  #else
      inline void LoadGroup(RDSCSTR groupname){LoadGroup8(groupname);};
	  #endif
    #endif

    // Загрузить только один объект из файла
    inline void LoadObject8(RDSCSTR groupname,RDSCSTR objectname)
      { Clear(); Loaded=rdsUIMODLoadSingleObjectA(Object,binaryfilepath,groupname,objectname);};
    inline void LoadObject16(RDSWCSTR groupname,RDSWCSTR objectname)
      { RDSWSTR fw=rdsUTF8toUTF16(binaryfilepath,TRUE);
	      Clear(); Loaded=rdsUIMODLoadSingleObjectW(Object,fw,groupname,objectname);
		    rdsFree(fw);
	    };
    #ifndef RDS_NO_UTFALIASES
	  #ifdef RDS_UTF16DEFAULT
      inline void LoadObject(RDSWCSTR groupname,RDSWCSTR objectname){LoadObject16(groupname,objectname);};
	  #else
		  inline void LoadObject(RDSCSTR groupname,RDSCSTR objectname){LoadObject8(groupname,objectname);};
	  #endif
    #endif

    // Запомнить объект для дальнейшего обращения без имени
    inline void SetObject8(RDSCSTR objname)
      { rdsSetObjectStrA(Object,RDS_UIMOD_SETOBJNAME,0,objname);};
    inline void SetObject16(RDSWCSTR objname)
      { rdsSetObjectStrW(Object,RDS_UIMOD_SETOBJNAME,0,objname);};
    #ifndef RDS_NO_UTFALIASES
	  #ifdef RDS_UTF16DEFAULT
        inline void SetObject(RDSWCSTR objname){SetObject16(objname);};
	  #else
        inline void SetObject(RDSCSTR objname){SetObject8(objname);};
	  #endif
    #endif

    // Получить строку последнего объекта по идентификатору
    inline RDSCSTR GetString8(int paramid,RDSCSTR defvalue)
      { return rdsUIMODGetParamStringA(Object,NULL,paramid,defvalue); };
    inline RDSWCSTR GetString16(int paramid,RDSWCSTR defvalue)
      { return rdsUIMODGetParamStringW(Object,NULL,paramid,defvalue); };
    #ifndef RDS_NO_UTFALIASES
	  #ifdef RDS_UTF16DEFAULT
        inline RDSWCSTR GetString(int paramid,RDSWCSTR defvalue){return GetString16(paramid,defvalue);};
	  #else
        inline RDSCSTR GetString(int paramid,RDSCSTR defvalue){return GetString8(paramid,defvalue);};
	  #endif
    #endif

    // Получить строку заданного объекта по идентификатору
    inline RDSCSTR GetString8(RDSCSTR objname,int paramid,RDSCSTR defvalue)
      { return rdsUIMODGetParamStringA(Object,objname,paramid,defvalue); };
    inline RDSCSTR GetListString8(int paramid,RDSCSTR defvalue)
      { return rdsUIMODGetParamListStringA(Object,NULL,paramid,defvalue);  };
    inline RDSCSTR GetListString8(RDSCSTR objname,int paramid,RDSCSTR defvalue)
      { return rdsUIMODGetParamListStringA(Object,objname,paramid,defvalue); };
    inline RDSWCSTR GetString16(RDSWCSTR objname,int paramid,RDSWCSTR defvalue)
      { return rdsUIMODGetParamStringW(Object,objname,paramid,defvalue); };
    inline RDSWCSTR GetListString16(int paramid,RDSWCSTR defvalue)
      { return rdsUIMODGetParamListStringW(Object,NULL,paramid,defvalue);  };
    inline RDSWCSTR GetListString16(RDSWCSTR objname,int paramid,RDSWCSTR defvalue)
      { return rdsUIMODGetParamListStringW(Object,objname,paramid,defvalue); };
    #ifndef RDS_NO_UTFALIASES
	  #ifdef RDS_UTF16DEFAULT
        inline RDSWCSTR GetString(RDSWCSTR objname,int paramid,RDSWCSTR defvalue){return GetString16(objname,paramid,defvalue);};
        inline RDSWCSTR GetListString(int paramid,RDSWCSTR defvalue){return GetListString16(paramid,defvalue);};
        inline RDSWCSTR GetListString(RDSWCSTR objname,int paramid,RDSWCSTR defvalue){return GetListString16(objname,paramid,defvalue);};
	  #else
        inline RDSCSTR GetString(RDSCSTR objname,int paramid,RDSCSTR defvalue){return GetString8(objname,paramid,defvalue);};
        inline RDSCSTR GetListString(int paramid,RDSCSTR defvalue){return GetListString8(paramid,defvalue);};
        inline RDSCSTR GetListString(RDSCSTR objname,int paramid,RDSCSTR defvalue){return GetListString8(objname,paramid,defvalue);};
	  #endif
    #endif

    // Сообщение с переводом
    static inline int MessageBox8(RDSCSTR shortpath,RDSCSTR Msg,RDSCSTR Capt,int Flags,RDSCSTR Object,RDSCSTR Category=NULL)
      { TRdsHelperLanguage data;
        data.SetBinaryFile8(shortpath);
        data.SetCRLFCorrection(RDS_UIMOD_CRLF_LF);
        data.LoadObject8(Category?Category:"Messages",Object);
        return (Object==NULL || data.IsNotLoaded() || data.HasNoFile())?
          rdsMessageBoxA(Msg,Capt,Flags):
          rdsMessageBoxA(data.GetString8(RDS_UIMOD_ANYPARAMID,Msg),Capt,Flags);
      };
    static inline int MessageBox16(RDSWCSTR shortpath,RDSWCSTR Msg,RDSWCSTR Capt,int Flags,RDSWCSTR Object,RDSWCSTR Category=NULL)
      { TRdsHelperLanguage data;
	      RDSCSTR obj=rdsUTF16toUTF8(Object,TRUE),
		            cat=rdsUTF16toUTF8(Category,TRUE);
        data.SetBinaryFile16(shortpath);
        data.SetCRLFCorrection(RDS_UIMOD_CRLF_LF);
        data.LoadObject8(cat?cat:"Messages",obj);
		    rdsFree(cat); rdsFree(obj);
        return (Object==NULL || data.IsNotLoaded() || data.HasNoFile())?
          rdsMessageBoxW(Msg,Capt,Flags):
          rdsMessageBoxW(data.GetString16(RDS_UIMOD_ANYPARAMID,Msg),Capt,Flags);
      };
    #ifndef RDS_NO_UTFALIASES
	  #ifdef RDS_UTF16DEFAULT
        static inline int MessageBox(RDSWCSTR shortpath,RDSWCSTR Msg,RDSWCSTR Capt,int Flags,RDSWCSTR Object,RDSWCSTR Category=NULL)
  		    { return MessageBox16(shortpath,Msg,Capt,Flags,Object,Category);};
	  #else
        static inline int MessageBox(RDSCSTR shortpath,RDSCSTR Msg,RDSCSTR Capt,int Flags,RDSCSTR Object,RDSCSTR Category=NULL)
		      { return MessageBox8(shortpath,Msg,Capt,Flags,Object,Category);};
	  #endif
    #endif

    // Сообщение с переводом с указаним блока
    static inline int BlockMessageBox8(RDS_BHANDLE Block,RDSCSTR shortpath,RDSCSTR Msg,RDSCSTR Capt,int Flags,RDSCSTR Object,RDSCSTR Category=NULL)
      { TRdsHelperLanguage data;
        data.SetBinaryFile8(shortpath);
        data.SetCRLFCorrection(RDS_UIMOD_CRLF_LF);
        data.LoadObject8(Category?Category:"Messages",Object);
        return (Object==NULL || data.HasNoFile() || data.IsNotLoaded())?
          rdsBlockMessageBoxA(Block,Msg,Capt,Flags):
          rdsBlockMessageBoxA(Block,data.GetString8(RDS_UIMOD_ANYPARAMID,Msg),Capt,Flags);
      };
    static inline int BlockMessageBox16(RDS_BHANDLE Block,RDSWCSTR shortpath,RDSWCSTR Msg,RDSWCSTR Capt,int Flags,RDSWCSTR Object,RDSWCSTR Category=NULL)
      { TRdsHelperLanguage data;
 	      RDSCSTR obj=rdsUTF16toUTF8(Object,TRUE),
		            cat=rdsUTF16toUTF8(Category,TRUE);
        data.SetBinaryFile16(shortpath);
        data.SetCRLFCorrection(RDS_UIMOD_CRLF_LF);
        data.LoadObject8(cat?cat:"Messages",obj);
		    rdsFree(cat); rdsFree(obj);
        return (Object==NULL || data.HasNoFile() || data.IsNotLoaded())?
          rdsBlockMessageBoxW(Block,Msg,Capt,Flags):
          rdsBlockMessageBoxW(Block,data.GetString16(RDS_UIMOD_ANYPARAMID,Msg),Capt,Flags);
      };
    #ifndef RDS_NO_UTFALIASES
	  #ifdef RDS_UTF16DEFAULT
      static inline int BlockMessageBox(RDS_BHANDLE Block,RDSWCSTR shortpath,RDSWCSTR Msg,RDSWCSTR Capt,int Flags,RDSWCSTR Object,RDSWCSTR Category=NULL)
		    { return BlockMessageBox16(Block,shortpath,Msg,Capt,Flags,Object,Category);};
	  #else
      static inline int BlockMessageBox(RDS_BHANDLE Block,RDSCSTR shortpath,RDSCSTR Msg,RDSCSTR Capt,int Flags,RDSCSTR Object,RDSCSTR Category=NULL)
		    { return BlockMessageBox8(Block,shortpath,Msg,Capt,Flags,Object,Category);};
	  #endif
    #endif

    // Запомнить имя двоичного файла (передается короткий путь в папке текущего языка, например "Dll\\MyDll.bin")
    inline void SetBinaryFile8(RDSCSTR shortpath)
      { char *curlang=rdsGetUICurrentModA(RDS_UIMODC_LANGUAGE,NULL);
        rdsFree(binaryfilepath);
        binaryfilepath=((*curlang)==0)? // Язык по умолчанию
          NULL:
          rdsDynStrCopyA(shortpath);
        Object=(Object==NULL)?rdsUIMODCreate():Object;
        Clear();
      };
    inline void SetBinaryFile16(RDSWCSTR shortpath)
      { char *curlang=rdsGetUICurrentModA(RDS_UIMODC_LANGUAGE,NULL);
        rdsFree(binaryfilepath);
        binaryfilepath=((*curlang)==0)? // Язык по умолчанию
          NULL:
          rdsUTF16toUTF8(shortpath,TRUE);
        Object=(Object==NULL)?rdsUIMODCreate():Object;
        Clear();
      };
    #ifndef RDS_NO_UTFALIASES
	  #ifdef RDS_UTF16DEFAULT
      inline void SetBinaryFile(RDSWCSTR shortpath){return SetBinaryFile16(shortpath);};
	  #else
      inline void SetBinaryFile(RDSCSTR shortpath){return SetBinaryFile8(shortpath);};
	  #endif
    #endif

    // Конструкторы
    TRdsHelperLanguage(void)
      { binaryfilepath=NULL;
        Object=NULL;
        Loaded=FALSE;
      };
    TRdsHelperLanguage(RDSCSTR shortpath)
      { binaryfilepath=NULL;
        Object=rdsUIMODCreate();
        Loaded=FALSE;
        SetBinaryFile8(shortpath);
      };
    TRdsHelperLanguage(RDSWCSTR shortpath)
      { binaryfilepath=NULL;
        Object=rdsUIMODCreate();
        Loaded=FALSE;
        SetBinaryFile16(shortpath);
      };
    TRdsHelperLanguage(RDSCSTR shortpath,RDSCSTR groupname)
      { binaryfilepath=NULL;
        Object=rdsUIMODCreate();
        SetBinaryFile8(shortpath);
        Loaded=rdsUIMODLoadGroupA(Object,binaryfilepath,groupname);
      };
    TRdsHelperLanguage(RDSWCSTR shortpath,RDSWCSTR groupname)
      { binaryfilepath=NULL;
        Object=rdsUIMODCreate();
        SetBinaryFile16(shortpath);
        LoadGroup16(groupname);
      };
    // Деструктор
    ~TRdsHelperLanguage()
      { rdsDeleteObject(Object);
        rdsFree(binaryfilepath);
      };
};
// Рекомендованные идентификаторы стандартных параметров объектов
#define RDSHELPERLANG_CAPTION   1
#define RDSHELPERLANG_TEXT      2
#define RDSHELPERLANG_HINT      3
#define RDSHELPERLANG_FILTER    4
#define RDSHELPERLANG_TITLE     5
#define RDSHELPERLANG_STRING    6
#define RDSHELPERLANG_LIST      7
//---------------------------------------------------------------------------

#endif
