#ifndef RdsHelperObjectsH
#define RdsHelperObjectsH

//---------------------------------------------------------------------------
// Класс объекта работы с BMP из файла
//---------------------------------------------------------------------------
class TRdsHelperBitmap
{ protected:
    RDS_HOBJECT Bitmap;
  public:
    void Load(char *filename){rdsSetObjectStr(Bitmap,RDS_BMP_LOADFROMFILE,0,filename);};
    BOOL IsLoaded(void){return rdsGetObjectInt(Bitmap,RDS_BMP_ISLOADED,0)?TRUE:FALSE;};
    BOOL IsNotLoaded(void){return rdsGetObjectInt(Bitmap,RDS_BMP_ISLOADED,0)?FALSE:TRUE;};
    void Clear(void){rdsCommandObjectEx(Bitmap,RDS_BMP_CLEAR,0,NULL);};

    int GetWidth(void){return rdsGetObjectInt(Bitmap,RDS_BMP_GETWIDTH,0);};
    int GetHeight(void){return rdsGetObjectInt(Bitmap,RDS_BMP_GETHEIGHT,0);};

    void Draw(int left,int top){rdsBMPDraw(Bitmap,left,top);};
    void StretchDraw(int left,int top,int right,int bottom){rdsBMPStretchDraw(Bitmap,left,top,right,bottom);};

    TRdsHelperBitmap(void){Bitmap=rdsBMPCreate(NULL);};
    virtual ~TRdsHelperBitmap(){rdsDeleteObject(Bitmap);};
};
//---------------------------------------------------------------------------


#endif
