//---------------------------------------------------------------------------

#ifndef MultiTableSaverH
#define MultiTableSaverH
#include <windows.h>
//---------------------------------------------------------------------------
// Вспомогательный класс для потока сохранения/загрузки
// (от него нужно произвести потомка)
class TMultiTableSaver
{ public:
    virtual BOOL  Write(const void *buf,DWORD count)=0;
    virtual BOOL  Read(void *buf,DWORD count)=0;

    // Запись строки
    BOOL  WriteString(const char *str);
    // Чтение строки
    BOOL  ReadString(char **pstr);

    TMultiTableSaver(void){};
    virtual ~TMultiTableSaver(){};
};
//---------------------------------------------------------------------------

// Вспомогательный класс для потока сохранения/загрузки
class TMultiTableSaverHandle : public TMultiTableSaver
{ protected:
    HANDLE h;
  public:
    inline void SetHandle(HANDLE ss){h=ss;};

    BOOL  Write(const void *buf,DWORD count);
    BOOL  Read(void *buf,DWORD count);

    // Вспомогательные - запись и чтение данных
    static BOOL  WindowsWrite(HANDLE h,const void *data,size_t *size);
    static BOOL  WindowsRead(HANDLE h, void *data, size_t *size);


    TMultiTableSaverHandle(void):TMultiTableSaver(){h=INVALID_HANDLE_VALUE;};
    virtual ~TMultiTableSaverHandle(){};
};
//---------------------------------------------------------------------------

// Вспомогательный класс для файла сохранения/загрузки
class TMultiTableSaverFile : public TMultiTableSaverHandle
{ public:
    // Открыть файл на запись
    BOOL  OpenFileWrite(const wchar_t *filename);
    // Открыть файл на чтение
    BOOL  OpenFileRead(const wchar_t *filename);
    // Закрыть файл
    void  CloseFile(void);

    TMultiTableSaverFile(void):TMultiTableSaverHandle(){};
    virtual ~TMultiTableSaverFile(){CloseFile();};
};
//---------------------------------------------------------------------------
#endif
