//---------------------------------------------------------------------------

#ifndef MultiTableFileLibraryH
#define MultiTableFileLibraryH
#include <windows.h>
//---------------------------------------------------------------------------
// Сохранение в библиотеке исходных данных таблицы и сгенерированной таблицы
//---------------------------------------------------------------------------
#if defined(MTFL_TABLE) || defined(MTFL_DEFECTS)
  class TMultiTable;
#endif
#ifdef MTFL_SOURCE
  class TMultiTableSource;
#endif
class TFileLibrary;
//---------------------------------------------------------------------------

// Сохранение
BOOL  mtflSaveLibrary(const wchar_t *filename,
                                #ifdef MTFL_SOURCE
                                  TMultiTableSource *Source,
                                #endif
                                #ifdef MTFL_TABLE
                                  TMultiTable *Result,
                                #endif
                                #ifdef MTFL_DEFECTS
                                  TMultiTable *Defects=NULL,
                                #endif
                                const char *remark=NULL,
                                FILETIME *filetime=NULL);

// Загрузка - начало
BOOL  mtflLoadLibrary_Begin(TFileLibrary *lib,
                                      const wchar_t *filename,
                                      FILETIME *filetime=NULL);
// Загрузка - основные действия (файл открыт)
BOOL  mtflLoadLibrary_End(TFileLibrary *lib,
                                    #ifdef MTFL_SOURCE
                                      TMultiTableSource *Source,
                                    #endif
                                    #ifdef MTFL_TABLE
                                      TMultiTable *Result,
                                    #endif
                                    #ifdef MTFL_DEFECTS
                                      TMultiTable *Defects=NULL,
                                    #endif
                                    char **dynremark=NULL);

// Загрузка - проверка, есть ли в файле данные таблицы
BOOL  mtflLoadLibrary_HasResultTable(TFileLibrary *lib);

// Загрузка
BOOL  mtflLoadLibrary(const wchar_t *filename,
                                #ifdef MTFL_SOURCE
                                  TMultiTableSource *Source,
                                #endif
                                #ifdef MTFL_TABLE
                                  TMultiTable *Result,
                                #endif
                                #ifdef MTFL_DEFECTS
                                  TMultiTable *Defects=NULL,
                                #endif
                                char **dynremark=NULL,
                                FILETIME *filetime=NULL);
//---------------------------------------------------------------------------
#endif
