//---------------------------------------------------------------------------

#ifndef FileLibraryH
#define FileLibraryH
#include <windows.h>
//---------------------------------------------------------------------------
// Библиотека каких-то данных в файле
//---------------------------------------------------------------------------
// Пара DWORD для указателя файла
struct TFileLibraryQWord
{ DWORD High,Low; };
//---------------------------------------------------------------------------
// Элемент библиотеки
class TFileLibraryItem
{ public:
    TFileLibraryItem *Next;     // Следующий элемент
    int Id;                     // Тип (целый идентификатор)
    TFileLibraryQWord Start;    // Положение в файле
    TFileLibraryQWord Length;   // Длина

    // Вычитание двух двухDWORDовых чисел
    static BOOL  SubtractQWORDS(DWORD FromHigh,DWORD FromLow,
                                          DWORD SubHigh,DWORD SubLow,
                                          DWORD &ResHigh,DWORD &ResLow);

    TFileLibraryItem(void){Next=NULL;};
};
//---------------------------------------------------------------------------
// Библиотека
class TFileLibrary
{ private:
    BOOL Waiting;    // Ожидание вызова функции After...

    // Считать оглавление открытого файла
    BOOL  ReadIndex(void);
  public:
    TFileLibraryItem *First; // Первый элемент
    HANDLE File;             // HANDLE открытого файла

    // Очистить все
    void  Clear(void);

    // Добавить элемент
    TFileLibraryItem *  Add(void);

    // Вспомогательные - запись и чтение данных
    static BOOL  WindowsWrite(HANDLE h,const void *data,size_t *size);
    static BOOL  WindowsRead(HANDLE h, void *data, size_t *size);
    BOOL  Write(const void *buf,DWORD count);
    BOOL  Read(void *buf,DWORD count);

    // Открыть файл на запись
    BOOL  OpenFileWrite(const wchar_t *filename,const char *prefix);
    // Открыть файл на чтение и считать индекс
    BOOL  OpenFileRead(const wchar_t *filename,const char *prefix,BOOL *pBadFormat=NULL);
    // Закрыть файл (при чтении, при записи - использовать SaveIndexAndCloseFile)
    void  CloseFile(void);
    // Записать оглавление и закрыть файл
    BOOL  SaveIndexAndCloseFile(void);

    // Получить текущее положение открытого файла
    BOOL  GetFilePos(TFileLibraryQWord &pos);
    // Установить положение открытого файла
    BOOL  SetFilePos(const TFileLibraryQWord &pos);

    // Вызов перед началом записи очередного куска
    BOOL  BeforeWrite(int id);
    // Вызов после записи очередного куска
    BOOL  AfterWrite(void);

    // Найти первый попавшийся кусок по идентификатору
    TFileLibraryItem *  FindItem(int id);

    // Позиционирование для чтения куска
    TFileLibraryItem *  PrepareToRead(int id,BOOL *pNotFound=NULL);

    TFileLibrary(void){First=NULL;File=INVALID_HANDLE_VALUE;Waiting=false;};
    ~TFileLibrary(){Clear();CloseFile();};
};
//---------------------------------------------------------------------------
#endif
