//---------------------------------------------------------------------------
// Описания, необходимые для взаимодействия с блоками из библиотеки
// Common.dll
//---------------------------------------------------------------------------
// Все строки - в кодировке UTF8!
//---------------------------------------------------------------------------
#ifndef CommonBlH
#define CommonBlH

#ifndef RdsDefH
  // Для нормальной компиляции необходимы описания из RdsDef.h
  #include "RdsDef.h"
#endif

#ifndef RDS_NO_PACK
  #include <pshpack1.h> // Установка плотной упаковки структур
#endif

//---------------------------------------------------------------------------
// Имена динамических переменных, управляемых блоком динамического расчета
//---------------------------------------------------------------------------
#define COMBL_V_DYNAMICTIME             "DynTime"       // Значение времени
                                                        // следующего шага (double)
#define COMBL_V_DYNAMICEVERYCYCLE       "DynEveryCl"    // Работать каждый такт
                                                        // (логическая, char)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция, уведомляющая присоединенные блоки об изменении значения органа
// управления
//---------------------------------------------------------------------------
#define COMBL_F_CONTROLCHANGED_NAME "Common.ControlValueChanged"  // Имя функции
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция, сообщающая обработчику ошибок об ошибке в математических блоках
//---------------------------------------------------------------------------
#define COMBL_F_MATHERROR_NAME "Common.MathError"  // Имя функции
// Параметры
typedef struct // COMBL_F_MATHERROR_DATA
{ union
    { DWORD servSize;            // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR MessageText;       // Текст сообщения об ошибке (может быть NULL)
      RDSBIGGESTTYPE align1;
    };
} COMBL_F_MATHERROR_DATA;
typedef COMBL_F_MATHERROR_DATA *COMBL_F_PMATHERROR_DATA;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция, управляющая маркером в интегрированных графиках
//---------------------------------------------------------------------------
#define COMBL_F_SETTIMEMARKER_NAME      "Common.SetTimeGraphMarker"  // Имя функции
// Параметры
typedef struct // COMBL_F_SETTIMEMARKER_DATA
{ union
    { DWORD servSize;           // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Marker;              // TRUE - установить, FALSE - сбросить
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR MarkerName;       // Название маркера
      RDSBIGGESTTYPE align2;
    };
  union
    { double MarkerVal;         // Значение, на которое нужно установить маркер
      RDSBIGGESTTYPE align3;
    };
} COMBL_F_SETTIMEMARKER_DATA;
typedef COMBL_F_SETTIMEMARKER_DATA *COMBL_F_PSETTIMEMARKER_DATA;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция получения матрицы у блока редактирования/индикации матриц
//---------------------------------------------------------------------------
#define COMBL_F_GETMATRFROMBLOCK_NAME      "Common.GetMatrixFromBlock"  // Имя функции
// Параметры
typedef struct // COMBL_F_GETMATRFROMBLOCK_DATA
{ union
    { DWORD servSize;          // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Type;           // Символ типа элемента массива (RDS_VARTYPE_*)
      RDSBIGGESTTYPE align1;
    };
  union
    { BOOL Exists;             // TRUE - матрица существует (т.е. не 0 x 0)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 Rows;           // Размерность матрицы
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 Cols;
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSINT32 ItemSize;       // Размер элемента матрицы
      RDSBIGGESTTYPE align5;
    };
  union
    { LPVOID Data;             // Начало области данных матрицы
      RDSBIGGESTTYPE align6;
    };
} COMBL_F_GETMATRFROMBLOCK_DATA;
typedef COMBL_F_GETMATRFROMBLOCK_DATA *COMBL_F_PGETMATRFROMBLOCK_DATA;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция уведомления сгруппированных кнопок о нажатии одной из них
//---------------------------------------------------------------------------
#define COMBL_F_RADIOBUTTONPRESS_NAME      "Common.RadioButtonPressed"  // Имя функции
// Параметры
typedef struct // COMBL_F_RADIOBUTTONPRESS_DATA
{ union
    { DWORD servSize;             // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDS_BHANDLE BPressed;       // Блок нажатой кнопки
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 Group;             // Номер группы нажатой кнопки
      RDSBIGGESTTYPE align2;
    };
} COMBL_F_RADIOBUTTONPRESS_DATA;
typedef COMBL_F_RADIOBUTTONPRESS_DATA *COMBL_F_PRADIOBUTTONPRESS_DATA;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция, возвращающая не ноль, если блок отмечает подсистему для автокопирования содержимого
//---------------------------------------------------------------------------
#define COMBL_F_CONTENTCOPYTARGET_NAME      "Common.ContentCopyTargetBlock"  // Имя функции
// Параметры:
//    NULL  - отмечает подсистему для любого копирования
//    char* - текстовый идентификатор копирования (возвращает не ноль только если отмечает подсистему
//            для копирования именно с таким идентификатором)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция, возвращающая указатель на имя конфигурации, очищаемой в подсистеме при автокопировании содержимого
// Вызывается у блока, отмечающего точку копирования
#define COMBL_F_CONTENTCOPYTARGETCONF_NAME    "Common.ContentCopyTargetConfig"  // Имя функции
// Параметры
typedef struct // COMBL_F_COPYTARGETCONFIG_DATA
{ union
    { DWORD servSize;           // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR ConfigName;       // Имя конфигурации или NULL, если не используется
      RDSBIGGESTTYPE align1;
    };
} COMBL_F_COPYTARGETCONFIG_DATA;
typedef COMBL_F_COPYTARGETCONFIG_DATA *COMBL_F_PCOPYTARGETCONFIG_DATA;
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Функция, возвращающая не ноль, если блок копирует куда-то содержимое подсистемы (сам в копировании участвовать не будет)
//---------------------------------------------------------------------------
#define COMBL_F_CONTENTCOPYSOURCE_NAME      "Common.ContentCopySourceBlock"  // Имя функции
// Параметров нет
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция синхронизации горизонтальных осей встроенных матричных графиков и ее константы
//---------------------------------------------------------------------------
// Начало имени глобального списка блоков
#define COMBL_F_HORZAXESSYNC_IDS        "Common.MatGraphDisplay.HorzAxisSync"
// Имя функции
#define COMBL_F_HORZAXESSYNC_NAME       "Common.MatGraphDisplay.HorzAxisSync"
// Параметры
typedef struct // COMBL_F_HORZAXESSYNC_DATA
{ union
    { DWORD servSize;         // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Command;       // Команда (константы ниже)
      RDSBIGGESTTYPE align1;
    };
  union
    { double HorzMin;         // Диапазоны
      RDSBIGGESTTYPE align2;
    };
  union
    { double HorzMax;
      RDSBIGGESTTYPE align3;
    };
} COMBL_F_HORZAXESSYNC_DATA;
typedef COMBL_F_HORZAXESSYNC_DATA *COMBL_F_PHORZAXESSYNC_DATA;
// Значения COMBL_F_HORZAXESSYNC_DATA::Command
#define COMBL_F_HORZAXESSYNC_CMDASK 0       // Запросить диапазоны всех графиков
#define COMBL_F_HORZAXESSYNC_CMDRESET 1     // Сбросить масштабирование
#define COMBL_F_HORZAXESSYNC_CMDSET 2       // Принудительно установить диапазон горизонтальной оси
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция внешнего управления параметрами встроенных матричных графиков
//---------------------------------------------------------------------------
// Имя функции
#define COMBL_F_MATGRAPHCONTROL_NAME    "Common.MatGraphDisplay.Control"
// Параметры
typedef struct // COMBL_F_MATGRAPHCONTROL_DATA
{ union
    { DWORD servSize;         // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 Command;       // Команда (константы ниже)
      RDSBIGGESTTYPE align1;
    };
  union
    { double DParam1;         // Параметры (зависят от команды)
      RDSBIGGESTTYPE align2;
    };
  union
    { double DParam2;
      RDSBIGGESTTYPE align3;
    };
  union
    { double DParam3;
      RDSBIGGESTTYPE align4;
    };
  union
    { double DParam4;
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 IParam1;       // Параметры (зависят от команды)
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSINT32 IParam2;
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSINT32 IParam3;
      RDSBIGGESTTYPE align8;
    };
  union
    { RDSINT32 IParam4;
      RDSBIGGESTTYPE align9;
    };
  union
    { RDSPDOUBLE DArr1;       // Массивы данных (зависят от команды)
      RDSBIGGESTTYPE align10;
    };
  union
    { RDSPDOUBLE DArr2;
      RDSBIGGESTTYPE align11;
    };
} COMBL_F_MATGRAPHCONTROL_DATA;
typedef COMBL_F_MATGRAPHCONTROL_DATA *COMBL_F_PMATGRAPHCONTROL_DATA;
// Значения COMBL_F_MATGRAPHCONTROL_DATA::Command
#define COMBL_F_MATGRAPHCONTROL_CNONE       0       // Нет команды (специальная константа)
#define COMBL_F_MATGRAPHCONTROL_CRESET      1       // Вернуться к прежним осям (без параметра)
#define COMBL_F_MATGRAPHCONTROL_CZOOMIN     2       // Увеличить масштаб (DParam1 - %)
#define COMBL_F_MATGRAPHCONTROL_CZOOMOUT    3       // Уменьшить масштаб (DParam1 - %)
#define COMBL_F_MATGRAPHCONTROL_CLEFT       4       // Сдвинуть видимую область влево (DParam1 - % диапазона)
#define COMBL_F_MATGRAPHCONTROL_CRIGHT      5       // Сдвинуть видимую область вправо (DParam1 - % диапазона)
#define COMBL_F_MATGRAPHCONTROL_CUP         6       // Сдвинуть видимую область вверх (DParam1 - % диапазона)
#define COMBL_F_MATGRAPHCONTROL_CDOWN       7       // Сдвинуть видимую область вниз (DParam1 - % диапазона)
#define COMBL_F_MATGRAPHCONTROL_CZOOMIN_H   8       // Увеличить масштаб по горизонтали (DParam1 - %)
#define COMBL_F_MATGRAPHCONTROL_CZOOMOUT_H  9       // Уменьшить масштаб по горизонтали (DParam1 - %)
#define COMBL_F_MATGRAPHCONTROL_CZOOMIN_V   10      // Увеличить масштаб по вертикали (DParam1 - %)
#define COMBL_F_MATGRAPHCONTROL_CZOOMOUT_V  11      // Уменьшить масштаб по вертикали (DParam1 - %)
#define COMBL_F_MATGRAPHCONTROL_CSET        12      // Установить границы диапазона (DParam1 - xmin,DParam2 - xmax,DParam3 - ymin,DParam4 - ymax)
#define COMBL_F_MATGRAPHCONTROL_CSETX       13      // Установить границы горизонтального диапазона (DParam1 - xmin,DParam2 - xmax)
#define COMBL_F_MATGRAPHCONTROL_CSETY       14      // Установить границы вертикального диапазона (DParam3 - ymin,DParam4 - ymax)
#define COMBL_F_MATGRAPHCONTROL_POLYGON     15      // Задать рисуемый на фоне многоугольник (IParam1 - номер многоугольника, IParam2 - индекс цвета,
                                                    // IParam3 - число точек, DArr1,DArr2 - x и у соответствено)
// Служебные команды
#define COMBL_F_MATGRAPHCONTROL_SGET        10000   // Вернуть текущие границы диапазона (DParam1 - xmin,DParam2 - xmax,DParam3 - ymin,DParam4 - ymax)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция взаимодействия с редактором матриц
//---------------------------------------------------------------------------
#define COMBL_F_MATEDCMDFUNCTION_NAME   "Common.MatEditCommand"  // Имя функции
// Параметры
typedef struct // COMBL_F_MATEDCMDFUNCTION_DATA
{ union
    { DWORD servSize;           // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { int Command;              // Команда (COMBL_F_MATEDCMD_*)
      RDSBIGGESTTYPE align1;
    };
  union
    { DWORD Flags;              // Флаги команды
      RDSBIGGESTTYPE align2;
    };
  union
    { int Row;                  // Строка
      RDSBIGGESTTYPE align3;
    };
  union
    { int Col;                  // Столбец
      RDSBIGGESTTYPE align4;
    };
  union
    { RDSCSTR StrParam;         // Строковый параметр команды
      RDSBIGGESTTYPE align5;
    };
  union
    { double DParam;            // Параметры (зависят от команды)
      RDSBIGGESTTYPE align6;
    };
  union
    { int IParam;
      RDSBIGGESTTYPE align7;
    };
  union
    { BOOL Update;              // Обновить внешний вид
      RDSBIGGESTTYPE align8;
    };
  union
    { RDS_BHANDLE BParam;
      RDSBIGGESTTYPE align9;
    };
} COMBL_F_MATEDCMDFUNCTION_DATA;
typedef COMBL_F_MATEDCMDFUNCTION_DATA *COMBL_F_PMATEDCMDFUNCTION_DATA;
// Макрос очистки параметров
#define COMBL_F_MATEDCMD_CLEAR(s) s.servSize=sizeof(s); s.DParam=s.Row=s.Col=s.Command=s.IParam=0; s.BParam=NULL; s.StrParam=NULL; s.Flags=0; s.Update=FALSE;
// Команды
#define COMBL_F_MATEDCMD_SETREPORTFUNC      1       // Установить имя функции (StrParam), в ответ на которую блок будет возвращать 1
#define COMBL_F_MATEDCMD_SETEDITFLAGS       2       // Установить флаги редактирования (Flags)
#define COMBL_F_MATEDCMD_WINDOW             3       // Открыть (Flags!=0) или закрыть (Flags==0) окно
#define COMBL_F_MATEDCMD_WINDOWCAPTION      4       // Установить заголовок окна (StrParam)
#define COMBL_F_MATEDCMD_INFORMBLOCK        5       // Добавить в список информируемых (Flags!=0) или удалить из списка (Flags==0) блок BParam
#define COMBL_F_MATEDCMD_RESIZE             6       // Задать размер (Row x Col), при Flags!=0 информировать всех об изменениях
#define COMBL_F_MATEDCMD_UPDATE             7       // Обновить внешний вид (независимо от Update), при Flags!=0 информировать всех об изменениях
#define COMBL_F_MATEDCMD_ROWHEADERS         8       // Установить заголовки строк: IParam==0 - числа, 1 - CSV в StrParam, 2 - из входного массива
#define COMBL_F_MATEDCMD_COLHEADERS         9       // Установить заголовки столбцов: IParam==0 - числа, 1 - CSV в StrParam, 2 - из входного массива
// Флаги разрешения/запрещения функций редактирования
#define COMBL_F_MATEDCTRL_PLOT              1       // Разрешение показа графика
#define COMBL_F_MATEDCTRL_STORED            2       // Разрешение запоминания матриц
#define COMBL_F_MATEDCTRL_PROP              4       // Разрешение вызова настройки
#define COMBL_F_MATEDCTRL_SETROWCOUNT       8       // Разрешение установки числа строк
#define COMBL_F_MATEDCTRL_SETCOLCOUNT       16      // Разрешение установки числа столбцов
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция установки параметров сетевого блока
//---------------------------------------------------------------------------
#define COMBL_F_NETBLOCKSET_NAME        "Common.NetworkBlockSetup"  // Имя функции
// Параметры
typedef struct // COMBL_F_NETBLOCKSET_DATA
{ union
    { DWORD servSize;            // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { BOOL Server;               // Сервер/клиент
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR Host;              // Имя сервера или NULL для сервера по умолчанию
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSINT32 Port;             // Номер порта или -1 для порта по умолчанию
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSCSTR Channel;           // Имя канала
      RDSBIGGESTTYPE align4;
    };
  union
    { BOOL UDP;                  // Использовать UDP
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 TimerDelay;       // Минимальная задержка передачи (<=0 - без задержки)
      RDSBIGGESTTYPE align6;
    };
  union
    { BOOL InputPrec;            // Зона нечувствительности (только для передачи одиночных double)
      RDSBIGGESTTYPE align7;
    };
  union
    { double Prec;               // Размер зоны нечувствительности
      RDSBIGGESTTYPE align8;
    };
} COMBL_F_NETBLOCKSET_DATA;
typedef COMBL_F_NETBLOCKSET_DATA *COMBL_F_PNETBLOCKSET_DATA;
// Аналогичная функция получения параметров
#define COMBL_F_NETBLOCKGET_NAME        "Common.NetworkBlockGetParams"  // Имя функции
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция установки параметров блока работы с динамической переменной
//---------------------------------------------------------------------------
#define COMBL_F_DVBLOCKSET_NAME        "Common.DynVarCtrlBlockSetup"  // Имя функции
// Параметры
typedef struct // COMBL_F_DVBLOCKSET_DATA
{ union
    { DWORD servSize;             // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR VarName;            // Имя переменной
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSINT32 BaseVarType;       // Базовый тип переменной (это поле и следующие два - как в rdsGetVarParams)
      RDSBIGGESTTYPE align2;
    };
  union
    { RDSCSTR StructType;         // Имя структуры (если нужно)
      RDSBIGGESTTYPE align3;
    };
  union
    { RDSINT32 ArrayDepth;        // Глубина вложенности массива
      RDSBIGGESTTYPE align4;
    };
  union
    { BOOL OneIndex;              // TRUE для массивов, FALSE для матриц
      RDSBIGGESTTYPE align5;
    };
  union
    { RDSINT32 Operation;         // Создание/подписка (COMBL_F_DVBLOCKSET_*)
      RDSBIGGESTTYPE align6;
    };
  union
    { RDSCSTR DefValue;           // Значение по умолчанию (только в функции установки)
      RDSBIGGESTTYPE align7;
    };
  union
    { RDSCSTR VarType;            // Строка типа переменной (только в функции возврата)
      RDSBIGGESTTYPE align8;
    };
} COMBL_F_DVBLOCKSET_DATA;
typedef COMBL_F_DVBLOCKSET_DATA *COMBL_F_PDVBLOCKSET_DATA;
// Значения COMBL_F_DVBLOCKSET_DATA::Operation
#define COMBL_F_DVBLOCKSET_CREATE   0       // Создать в родительской подсистеме блока
#define COMBL_F_DVBLOCKSET_CRROOT   1       // Создать в корневой подсистеме
#define COMBL_F_DVBLOCKSET_SUBROOT  2       // Подписаться в корневой подсистеме
#define COMBL_F_DVBLOCKSET_SUBOWN   3       // Подписаться только в своей подсистеме
#define COMBL_F_DVBLOCKSET_SUBSRCH  4       // Подписаться в своей подсистеме и выше (с поиском)
// Аналогичная функция получения параметров
#define COMBL_F_DVBLOCKGET_NAME        "Common.DynVarCtrlBlockGetParams"  // Имя функции
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция активации поля ввода или проверки возможности такой активации
//---------------------------------------------------------------------------
#define COMBL_F_EDITFUNCTION_NAME        "Common.EditCheckAndActivateFunction"  // Имя функции
// Параметры
typedef struct // COMBL_F_EDITFUNCTION_DATA
{ union
    { DWORD servSize;              // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSINT32 EditFunction;       // Функция (константы ниже)
      RDSBIGGESTTYPE align1;
    };
  union
    { BOOL CanBeActivated;         // Можно активировать (поле не запрещено)
      RDSBIGGESTTYPE align2;
    };
} COMBL_F_EDITFUNCTION_DATA;
typedef COMBL_F_EDITFUNCTION_DATA *COMBL_F_PEDITFUNCTION_DATA;
// Значения COMBL_F_EDITFUNCTION_DATA::EditFunction
#define COMBL_F_EDITFUNCTION_CHECK  1       // Просто проверка
#define COMBL_F_EDITFUNCTION_OPEN   2       // Активация
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция замены констант в строке имени канала для сетевого блока
//---------------------------------------------------------------------------
#define COMBL_F_REPLACENETCONST_NAME        "Common.RepalceNetConst"  // Имя функции
// Параметры
typedef struct // COMBL_F_REPLACENETCONST_DATA
{ union
    { DWORD servSize;         // Размер этой структуры в байтах (необходимо присвоить перед вызовом)
      RDSBIGGESTTYPE align0;
    };
  union
    { RDSCSTR Input;          // Входная строка
      RDSBIGGESTTYPE align1;
    };
  union
    { RDSCSTR Output;         // Сформированная строка (необходимо освободить при помощи rdsFree)
      RDSBIGGESTTYPE align2;
    };
} COMBL_F_REPLACENETCONST_DATA;
typedef COMBL_F_REPLACENETCONST_DATA *COMBL_F_PREPLACENETCONST_DATA;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Функция информирования сетевых блоков об изменении констант для имен каналов
//---------------------------------------------------------------------------
#define COMBL_F_NETCONSTCHANGED_NAME        "Common.NetConstsChanged"  // Имя функции
// Параметров нет
//---------------------------------------------------------------------------

// Возврат выравнивания по умолчанию
#ifndef RDS_NO_PACK
 #include <poppack.h>
#endif

//---------------------------------------------------------------------------
#endif
